/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.contractorbill;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.utils.WebUtils;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.contractorbill.service.ContractorBillRegisterService;
import org.egov.works.mb.entity.MBDetails;
import org.egov.works.mb.service.MBDetailsService;
import org.egov.works.models.contractorBill.ContractorBillCertificateInfo;
import org.egov.works.models.tender.OfflineStatus;
import org.egov.works.offlinestatus.service.OfflineStatusService;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderActivity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/contractorbill"})
public class CompletionCertificatePDFController {
    @Autowired
    private ReportService reportService;
    @Autowired
    private ContractorBillRegisterService contractorBillRegisterService;
    @Autowired
    private OfflineStatusService offlineStatusService;
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private MBDetailsService mbDetailsService;
    @Autowired
    private WorksUtils worksUtils;
    public static final String CONTRACTORCOMPLETIONBILLPDF = "completionCertificate";

    @RequestMapping(value={"/completioncertificatepdf/{contractorBillId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateContractorBillPDF(HttpServletRequest request, @PathVariable(value="contractorBillId") Long id, HttpSession session) throws IOException {
        ContractorBillRegister contractorBillRegister = this.contractorBillRegisterService.getContractorBillById(id);
        return this.generateReport(contractorBillRegister, request, session);
    }

    private ResponseEntity<byte[]> generateReport(ContractorBillRegister contractorBillRegister, HttpServletRequest request, HttpSession session) {
        HashMap<String, String> reportParams = new HashMap<String, String>();
        ReportRequest reportInput = null;
        ReportOutput reportOutput = null;
        if (contractorBillRegister != null) {
            DecimalFormat df = new DecimalFormat("0.00");
            String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
            OfflineStatus offlineStatusses = this.offlineStatusService.getOfflineStatusByObjectIdAndObjectTypeAndStatus(contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getId(), "WorkOrder", WorkOrder.OfflineStatuses.WORK_COMMENCED.toString().toUpperCase());
            reportParams.put("nameOfWork", contractorBillRegister.getWorkOrderEstimate().getEstimate().getName() != null ? contractorBillRegister.getWorkOrderEstimate().getEstimate().getName() : "");
            if (contractorBillRegister.getWorkOrderEstimate().getEstimate().getLineEstimateDetails() != null) {
                reportParams.put("estimateNumber", contractorBillRegister.getWorkOrderEstimate().getEstimate().getLineEstimateDetails().getEstimateNumber());
                reportParams.put("winCode", contractorBillRegister.getWorkOrderEstimate().getEstimate().getLineEstimateDetails().getProjectCode().getCode());
            } else {
                reportParams.put("estimateNumber", "NA");
                reportParams.put("winCode", "NA");
            }
            reportParams.put("estimateValue", df.format(contractorBillRegister.getWorkOrderEstimate().getEstimate().getEstimateValue()));
            reportParams.put("contractorName", contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getContractor().getName() != null ? contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getContractor().getName() : "");
            reportParams.put("contractorCode", contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getContractor().getCode() != null ? contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getContractor().getCode() : "");
            reportParams.put("workOrderAmount", df.format(contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getWorkOrderAmount()));
            reportParams.put("workOrderNumber", contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getWorkOrderNumber());
            reportParams.put("workCommencedOn", DateUtils.getFormattedDate((Date)offlineStatusses.getStatusDate(), (String)"dd/MM/yyyy"));
            reportParams.put("workCompletedDate", DateUtils.getFormattedDate((Date)contractorBillRegister.getWorkOrderEstimate().getWorkCompletionDate(), (String)"dd/MM/yyyy"));
            reportParams.put("crearedBy", this.worksUtils.getUserDesignation(contractorBillRegister.getCreatedBy()));
            reportParams.put("approvedBy", this.worksUtils.getUserDesignation(contractorBillRegister.getApprovedBy()));
            reportParams.put("ward", contractorBillRegister.getWorkOrderEstimate().getEstimate().getWard().getName());
            reportParams.put("cityLogo", url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo")));
            reportParams.put("cityName", ApplicationThreadLocals.getMunicipalityName());
            reportParams.put("reportRunDate", DateUtils.getFormattedDate((Date)new Date(), (String)"dd/MM/yyyy hh:mm a"));
            double totalAsPerTender = 0.0;
            double totalAsPerExecution = 0.0;
            double totalDifference = 0.0;
            ArrayList<ContractorBillCertificateInfo> contractorBillCertificateInfoList = new ArrayList<ContractorBillCertificateInfo>();
            for (WorkOrderActivity woa : contractorBillRegister.getWorkOrderEstimate().getWorkOrderActivities()) {
                Activity act = woa.getActivity();
                List activities = this.estimateService.getActivitiesByParent(act.getId());
                activities.add(act);
                double quantity = 0.0;
                for (Activity activity : activities) {
                    ContractorBillCertificateInfo contractorBillCertificateInfo = new ContractorBillCertificateInfo();
                    List detailsList = this.mbDetailsService.getMBDetailsByWorkOrderActivity(woa.getId());
                    for (MBDetails mbDetails : detailsList) {
                        quantity += mbDetails.getQuantity();
                    }
                    contractorBillCertificateInfo.setExecutionQuantity(quantity);
                    contractorBillCertificateInfo.setTenderQuantity(activity.getQuantity());
                    contractorBillCertificateInfo.setTenderAmount(activity.getAmount().getValue());
                    contractorBillCertificateInfo.setTenderRate(activity.getEstimateRate());
                    contractorBillCertificateInfo.setExecutionRate(activity.getEstimateRate());
                    contractorBillCertificateInfo.setExecutionAmount(quantity * activity.getRate());
                    contractorBillCertificateInfo.setWorkOrderActivity(woa);
                    contractorBillCertificateInfo.setTotalAsPerTender(totalAsPerTender += activity.getEstimateRate() * activity.getQuantity());
                    contractorBillCertificateInfo.setTotalAsPerExecution(totalAsPerExecution += activity.getEstimateRate() * quantity);
                    totalDifference = totalAsPerTender - totalAsPerExecution;
                    contractorBillCertificateInfo.setTotalDifference(totalDifference);
                    contractorBillCertificateInfoList.add(contractorBillCertificateInfo);
                }
            }
            reportInput = new ReportRequest(CONTRACTORCOMPLETIONBILLPDF, contractorBillCertificateInfoList, reportParams);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=CompletionCertificate_" + contractorBillRegister.getBillnumber() + ".pdf");
        reportOutput = this.reportService.createReport(reportInput);
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

