/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.contractorbill;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.contractorbill.entity.SearchRequestContractorBill;
import org.egov.works.contractorbill.service.ContractorBillRegisterService;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/contractorbill"})
public class CancelContractorBillController
extends GenericWorkFlowController {
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private ContractorBillRegisterService contractorBillRegisterService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;

    @RequestMapping(value={"/cancel/search"}, method={RequestMethod.GET})
    public String showSearchContractorBillForm(@ModelAttribute SearchRequestContractorBill searchRequestContractorBill, Model model) throws ApplicationException {
        model.addAttribute("departments", (Object)this.departmentService.getAllDepartments());
        List departments = this.lineEstimateService.getUserDepartments(this.securityUtils.getCurrentUser());
        if (departments != null && !departments.isEmpty()) {
            searchRequestContractorBill.setDepartment(((Department)departments.get(0)).getId());
        }
        model.addAttribute("searchRequestContractorBill", (Object)searchRequestContractorBill);
        return "searchcontractorbill-cancel";
    }

    @RequestMapping(value={"/cancel"}, method={RequestMethod.POST})
    public String cancelContractorBill(HttpServletRequest request, Model model) throws ApplicationException {
        Long contractorId = Long.parseLong(request.getParameter("id"));
        String cancellationReason = request.getParameter("cancellationReason");
        String cancellationRemarks = request.getParameter("cancellationRemarks");
        ContractorBillRegister contractorBillRegister = this.contractorBillRegisterService.getContractorBillById(contractorId);
        if (contractorBillRegister.getEgBillregistermis() != null && contractorBillRegister.getEgBillregistermis().getVoucherHeader() != null && contractorBillRegister.getEgBillregistermis().getVoucherHeader().getStatus() != 4) {
            model.addAttribute("errorMessage", (Object)(this.messageSource.getMessage("error.contractorbill.voucher.created", (Object[])new String[0], null) + " " + contractorBillRegister.getEgBillregistermis().getVoucherHeader().getVoucherNumber()));
            return "contractorBill-success";
        }
        contractorBillRegister.setCancellationReason(cancellationReason);
        contractorBillRegister.setCancellationRemarks(cancellationRemarks);
        contractorBillRegister = this.contractorBillRegisterService.cancel(contractorBillRegister);
        model.addAttribute("contractorBillRegister", (Object)contractorBillRegister);
        model.addAttribute("message", (Object)this.messageSource.getMessage("msg.contractorbill.cancel", (Object[])new String[]{contractorBillRegister.getBillnumber()}, null));
        return "contractorBill-success";
    }
}

