/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.abstractestimate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.eis.service.DesignationService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.matrix.service.CustomizedWorkFlowService;
import org.egov.pims.commons.Designation;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.abstractestimate.entity.EstimateTechnicalSanction;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.lineestimate.entity.LineEstimate;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.service.LineEstimateDetailService;
import org.egov.works.master.service.ScheduleOfRateService;
import org.egov.works.utils.WorksConstants;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/abstractestimate"})
public class CreateAbstractEstimateController
extends GenericWorkFlowController {
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private LineEstimateDetailService lineEstimateDetailService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    protected CustomizedWorkFlowService customizedWorkFlowService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private ScheduleOfRateService scheduleOfRateService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private AppConfigValueService appConfigValuesService;

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String showAbstractEstimateForm(@ModelAttribute(value="abstractEstimate") AbstractEstimate abstractEstimate, @RequestParam Long lineEstimateDetailId, Model model) {
        LineEstimateDetails lineEstimateDetails = this.lineEstimateDetailService.getById(lineEstimateDetailId);
        this.populateDataForAbstractEstimate(lineEstimateDetails, model, abstractEstimate);
        abstractEstimate.setEstimateDate(new Date());
        this.loadViewData(model, abstractEstimate, lineEstimateDetails);
        return "newAbstractEstimate-form";
    }

    private void loadViewData(Model model, AbstractEstimate abstractEstimate, LineEstimateDetails lineEstimateDetails) {
        this.estimateService.setDropDownValues(model);
        if (abstractEstimate.getLineEstimateDetails() != null && abstractEstimate.getLineEstimateDetails().getLineEstimate().isAbstractEstimateCreated()) {
            ArrayList<Designation> designations = new ArrayList<Designation>();
            List configValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "DESIGNATION_TECHSANCTION_AUTHORITY");
            for (AppConfigValues valuesFordesignation : configValues) {
                designations.add(this.designationService.getDesignationByName(valuesFordesignation.getValue()));
            }
            model.addAttribute("designations", designations);
        } else {
            WorkflowContainer workflowContainer = new WorkflowContainer();
            workflowContainer.setAmountRule(abstractEstimate.getEstimateValue());
            this.prepareWorkflow(model, (StateAware)abstractEstimate, workflowContainer);
            List validActions = Collections.emptyList();
            validActions = this.customizedWorkFlowService.getNextValidActions(abstractEstimate.getStateType(), workflowContainer.getWorkFlowDepartment(), workflowContainer.getAmountRule(), workflowContainer.getAdditionalRule(), "NEW", workflowContainer.getPendingActions(), abstractEstimate.getCreatedDate());
            if (abstractEstimate.getState() != null && abstractEstimate.getState().getNextAction() != null) {
                model.addAttribute("nextAction", (Object)abstractEstimate.getState().getNextAction());
                model.addAttribute("pendingActions", (Object)abstractEstimate.getState().getNextAction());
            }
            model.addAttribute("validActionList", (Object)validActions);
            model.addAttribute("mode", null);
            model.addAttribute("stateType", (Object)abstractEstimate.getClass().getSimpleName());
        }
        model.addAttribute("documentDetails", (Object)abstractEstimate.getDocumentDetails());
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String saveAbstractEstimate(@ModelAttribute AbstractEstimate abstractEstimate, RedirectAttributes redirectAttributes, Model model, BindingResult bindErrors, @RequestParam(value="file") MultipartFile[] files, HttpServletRequest request, @RequestParam String workFlowAction) throws IOException {
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComment") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        this.estimateService.validateMultiYearEstimates(abstractEstimate, bindErrors);
        this.estimateService.validateMandatory(abstractEstimate, bindErrors);
        this.estimateService.validateAssetDetails(abstractEstimate, bindErrors);
        this.estimateService.validateActivities(abstractEstimate, bindErrors);
        this.estimateService.validateOverheads(abstractEstimate, bindErrors);
        if (abstractEstimate.getLineEstimateDetails() != null && abstractEstimate.getLineEstimateDetails().getLineEstimate().isAbstractEstimateCreated()) {
            this.estimateService.validateTechnicalSanctionDetail(abstractEstimate, bindErrors);
            if (!this.estimateService.checkForDuplicateAccountCodesInEstimateDeductions(abstractEstimate)) {
                bindErrors.reject("error.abstractestimate.duplicate.accountcodes", "error.abstractestimate.duplicate.accountcodes");
            }
            this.estimateService.setTechnicalSanctionDetails(abstractEstimate);
        }
        if (!"Save".equals(workFlowAction)) {
            if (abstractEstimate.getSorActivities().isEmpty() && abstractEstimate.getNonSorActivities().isEmpty()) {
                bindErrors.reject("error.sor.nonsor.required", "error.sor.nonsor.required");
            }
            this.estimateService.validateLocationDetails(abstractEstimate, bindErrors);
        }
        if (bindErrors.hasErrors()) {
            for (Activity activity : abstractEstimate.getSorActivities()) {
                activity.setSchedule(this.scheduleOfRateService.getScheduleOfRateById(activity.getSchedule().getId()));
            }
            this.estimateService.loadModelValues(abstractEstimate.getLineEstimateDetails(), model, abstractEstimate);
            abstractEstimate.setProjectCode(abstractEstimate.getLineEstimateDetails().getProjectCode());
            this.loadViewData(model, abstractEstimate, abstractEstimate.getLineEstimateDetails());
            model.addAttribute("approvalDesignation", (Object)request.getParameter("approvalDesignation"));
            model.addAttribute("approvalPosition", (Object)request.getParameter("approvalPosition"));
            model.addAttribute("designation", (Object)request.getParameter("designation"));
            model.addAttribute("technicalSanctionBy", (Object)request.getParameter("estimateTechnicalSanctions[0].technicalSanctionBy"));
            model.addAttribute("approvedByValue", (Object)request.getParameter("approvedBy"));
            return "newAbstractEstimate-form";
        }
        if (abstractEstimate.getState() == null) {
            if (WorksConstants.FORWARD_ACTION.equals(workFlowAction)) {
                abstractEstimate.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("AbstractEstimate", AbstractEstimate.EstimateStatus.CREATED.toString()));
            } else {
                abstractEstimate.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("AbstractEstimate", AbstractEstimate.EstimateStatus.NEW.toString()));
            }
        }
        AbstractEstimate savedAbstractEstimate = this.estimateService.createAbstractEstimate(abstractEstimate, files, approvalPosition, approvalComment, null, workFlowAction);
        if (AbstractEstimate.EstimateStatus.NEW.toString().equals(savedAbstractEstimate.getEgwStatus().getCode())) {
            return "redirect:/abstractestimate/update/" + savedAbstractEstimate.getId() + "?mode=save";
        }
        if (abstractEstimate.getLineEstimateDetails() != null && abstractEstimate.getLineEstimateDetails().getLineEstimate().isAbstractEstimateCreated()) {
            return "redirect:/abstractestimate/abstractestimate-success?estimate=" + savedAbstractEstimate.getId() + "&approvalPosition=";
        }
        return "redirect:/abstractestimate/abstractestimate-success?estimate=" + savedAbstractEstimate.getId() + "&approvalPosition=" + approvalPosition;
    }

    @RequestMapping(value={"/abstractestimate-success"}, method={RequestMethod.GET})
    public ModelAndView successView(@ModelAttribute AbstractEstimate abstractEstimate, @RequestParam(value="estimate") Long id, @RequestParam(value="approvalPosition") Long approvalPosition, HttpServletRequest request, Model model) {
        if (id != null) {
            abstractEstimate = this.estimateService.getAbstractEstimateById(id);
        }
        String pathVars = this.worksUtils.getPathVars(abstractEstimate.getEgwStatus(), abstractEstimate.getState(), abstractEstimate.getId(), approvalPosition);
        String[] keyNameArray = pathVars.split(",");
        String approverName = "";
        String currentUserDesgn = "";
        String nextDesign = "";
        if (keyNameArray.length != 0 && keyNameArray.length > 0) {
            if (keyNameArray.length == 1 && keyNameArray[0] != null) {
                id = Long.parseLong(keyNameArray[0]);
            } else if (keyNameArray.length == 3) {
                if (keyNameArray[0] != null) {
                    id = Long.parseLong(keyNameArray[0]);
                }
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
            } else {
                if (keyNameArray[0] != null) {
                    id = Long.parseLong(keyNameArray[0]);
                }
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
                nextDesign = keyNameArray[3];
            }
        }
        model.addAttribute("approverName", (Object)approverName);
        model.addAttribute("currentUserDesgn", (Object)currentUserDesgn);
        model.addAttribute("nextDesign", (Object)nextDesign);
        String message = this.getMessageByStatus(abstractEstimate, approverName, nextDesign);
        model.addAttribute("message", (Object)message);
        return new ModelAndView("abstractEstimate-success", "abstractEstimate", (Object)abstractEstimate);
    }

    private String getMessageByStatus(AbstractEstimate abstractEstimate, String approverName, String nextDesign) {
        String message = "";
        if (abstractEstimate.getLineEstimateDetails() != null && abstractEstimate.getLineEstimateDetails().getLineEstimate().isAbstractEstimateCreated()) {
            message = this.messageSource.getMessage("msg.estimate.spilladminsanctioned", (Object[])new String[]{abstractEstimate.getEstimateNumber()}, null);
        } else if (AbstractEstimate.EstimateStatus.NEW.toString().equals(abstractEstimate.getEgwStatus().getCode())) {
            message = this.messageSource.getMessage("msg.estimate.saved", (Object[])new String[]{abstractEstimate.getEstimateNumber()}, null);
        } else if (AbstractEstimate.EstimateStatus.CREATED.toString().equals(abstractEstimate.getEgwStatus().getCode()) && !"Rejected".equals(abstractEstimate.getState().getValue())) {
            message = this.messageSource.getMessage("msg.estimate.created", (Object[])new String[]{approverName, nextDesign, abstractEstimate.getEstimateNumber()}, null);
        } else if (AbstractEstimate.EstimateStatus.RESUBMITTED.toString().equals(abstractEstimate.getEgwStatus().getCode()) && !"Rejected".equals(abstractEstimate.getState().getValue())) {
            message = this.messageSource.getMessage("msg.estimate.resubmitted", (Object[])new String[]{approverName, nextDesign, abstractEstimate.getEstimateNumber()}, null);
        } else if (AbstractEstimate.EstimateStatus.APPROVED.toString().equals(abstractEstimate.getEgwStatus().getCode()) && !"Rejected".equals(abstractEstimate.getState().getValue())) {
            message = this.messageSource.getMessage("msg.estimate.techsanctioned", (Object[])new String[]{abstractEstimate.getEstimateNumber(), ((EstimateTechnicalSanction)abstractEstimate.getEstimateTechnicalSanctions().get(abstractEstimate.getEstimateTechnicalSanctions().size() - 1)).getTechnicalSanctionNumber()}, null);
        } else if (abstractEstimate.getState() != null && "Rejected".equals(abstractEstimate.getState().getValue())) {
            message = this.messageSource.getMessage("msg.estimate.rejected", (Object[])new String[]{abstractEstimate.getEstimateNumber(), approverName, nextDesign}, null);
        } else if (AbstractEstimate.EstimateStatus.CANCELLED.toString().equals(abstractEstimate.getEgwStatus().getCode())) {
            message = this.messageSource.getMessage("msg.estimate.cancelled", (Object[])new String[]{abstractEstimate.getEstimateNumber()}, null);
        } else if (AbstractEstimate.EstimateStatus.CHECKED.toString().equals(abstractEstimate.getEgwStatus().getCode()) && !"Rejected".equals(abstractEstimate.getState().getValue())) {
            message = this.messageSource.getMessage("msg.abstractestimate.check.success", (Object[])new String[]{abstractEstimate.getEstimateNumber(), approverName, nextDesign}, null);
        }
        return message;
    }

    public void populateDataForAbstractEstimate(LineEstimateDetails lineEstimateDetails, Model model, AbstractEstimate abstractEstimate) {
        LineEstimate lineEstimate = lineEstimateDetails.getLineEstimate();
        abstractEstimate.setLineEstimateDetails(lineEstimateDetails);
        abstractEstimate.setExecutingDepartment(lineEstimateDetails.getLineEstimate().getExecutingDepartment());
        abstractEstimate.setWard(lineEstimateDetails.getLineEstimate().getWard());
        abstractEstimate.setNatureOfWork(lineEstimate.getNatureOfWork());
        abstractEstimate.setParentCategory(lineEstimate.getTypeOfWork());
        abstractEstimate.setCategory(lineEstimate.getSubTypeOfWork());
        abstractEstimate.setProjectCode(lineEstimateDetails.getProjectCode());
        abstractEstimate.addMultiYearEstimate(this.estimateService.populateMultiYearEstimate(abstractEstimate));
        abstractEstimate.addFinancialDetails(this.estimateService.populateEstimateFinancialDetails(abstractEstimate));
        this.estimateService.loadModelValues(lineEstimateDetails, model, abstractEstimate);
    }
}

