/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.abstractestimate;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.service.ChartOfAccountsService;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.web.support.json.adapter.UserAdaptor;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.AbstractEstimateForLoaSearchRequest;
import org.egov.works.abstractestimate.entity.SearchRequestCancelEstimate;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.master.service.EstimateTemplateService;
import org.egov.works.master.service.OverheadService;
import org.egov.works.master.service.ScheduleOfRateService;
import org.egov.works.models.masters.EstimateTemplate;
import org.egov.works.models.masters.EstimateTemplateActivity;
import org.egov.works.models.masters.Overhead;
import org.egov.works.models.masters.OverheadRate;
import org.egov.works.models.masters.ScheduleOfRate;
import org.egov.works.web.adaptor.AbstractEstimateForLOAJsonAdaptor;
import org.egov.works.web.adaptor.AbstractEstimateForOfflineStatusJsonAdaptor;
import org.egov.works.web.adaptor.EstimateTemplateJsonAdaptor;
import org.egov.works.web.adaptor.SearchEstimatesToCancelJson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/abstractestimate"})
public class AjaxAbstractEstimateController {
    @Autowired
    private OverheadService overheadService;
    @Autowired
    private ScheduleOfRateService scheduleOfRateService;
    @Autowired
    private EstimateTemplateService estimateTemplateService;
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private UserService userService;
    @Autowired
    private SearchEstimatesToCancelJson searchEstimatesToCancelJson;
    @Autowired
    private AbstractEstimateForOfflineStatusJsonAdaptor abstractEstimateForOfflineStatusJsonAdaptor;
    @Autowired
    private EstimateTemplateJsonAdaptor estimateTemplateJsonAdaptor;
    @Autowired
    @Qualifier(value="chartOfAccountsService")
    private ChartOfAccountsService chartOfAccountsService;

    public Object toSearchAbstractEstimateForLOAResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(AbstractEstimate.class, (Object)new AbstractEstimateForLOAJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/getpercentageorlumpsumbyoverheadid"}, method={RequestMethod.GET})
    @ResponseBody
    public OverheadRate getPercentageOrLumpsumByOverhead(@RequestParam(value="overheadId") Long overheadId) {
        Overhead overhead = new Overhead();
        OverheadRate overheadRate = new OverheadRate();
        Date estDate = new Date();
        if (overheadId != null) {
            overhead = this.overheadService.getOverheadById(overheadId);
        }
        if (overhead != null && overhead.getOverheadRates() != null && overhead.getOverheadRates().size() > 0) {
            for (OverheadRate obj : overhead.getOverheadRates()) {
                Date startDate = obj.getValidity().getStartDate();
                Date endDate = obj.getValidity().getEndDate();
                if (estDate.compareTo(startDate) < 0 || endDate != null && endDate.compareTo(estDate) < 0) continue;
                overheadRate = obj;
            }
        }
        return overheadRate;
    }

    @RequestMapping(value={"/ajaxsor-byschedulecategories"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public List<ScheduleOfRate> findSorByScheduleCategories(@RequestParam(value="code") String code, @RequestParam(value="scheduleCategories") String scheduleCategories, @RequestParam(value="estimateDate") Date estimateDate) {
        if (!scheduleCategories.equals("null")) {
            return this.scheduleOfRateService.getScheduleOfRatesByCodeAndScheduleOfCategories(code, scheduleCategories, estimateDate);
        }
        return null;
    }

    @RequestMapping(value={"/ajaxsor-byschedulecategoriesandestimateid"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public List<ScheduleOfRate> findSorByScheduleCategoriesAndEstimateId(@RequestParam(value="code") String code, @RequestParam(value="scheduleCategories") String scheduleCategories, @RequestParam(value="estimateDate") Date estimateDate, @RequestParam(value="estimateId") Long estimateId) {
        if (!scheduleCategories.equals("null")) {
            return this.scheduleOfRateService.getScheduleOfRatesByCodeAndScheduleOfCategoriesAndEstimateId(code, scheduleCategories, estimateDate, estimateId);
        }
        return null;
    }

    @RequestMapping(value={"/ajaxestimatetemplatebycode"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<EstimateTemplate> getEstimateTemplateByCodeIgnoreCase(@RequestParam String code) {
        return this.estimateTemplateService.getEstimateTemplateByCodeIgnoreCase(code);
    }

    @RequestMapping(value={"/ajaxgetestimatetemplatebyid"}, method={RequestMethod.GET})
    @ResponseBody
    public String populateMilestoneTemplateActivity(@RequestParam String id, Model model, @RequestParam Date estimateDate) throws ApplicationException {
        List activities = this.estimateTemplateService.getEstimateTemplateById(Long.valueOf(id)).getEstimateTemplateActivities();
        for (EstimateTemplateActivity estimateTemplateActivitys : activities) {
            estimateTemplateActivitys.setEstimateDate(estimateDate);
        }
        String result = this.estimateTemplateToJson((Object)activities);
        return result;
    }

    public String estimateTemplateToJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(EstimateTemplateActivity.class, (Object)this.estimateTemplateJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/getabstractestimatesbynumber"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> findAbstractEstimateNumbersForAbstractEstimate(@RequestParam String estimateNumber) {
        return this.estimateService.getAbstractEstimateByEstimateNumberLike(estimateNumber);
    }

    @RequestMapping(value={"/ajaxsearchabstractestimatesforloa"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxSearchAbstractEstimatesForLOA(Model model, @ModelAttribute AbstractEstimateForLoaSearchRequest abstractEstimateForLoaSearchRequest) {
        List searchResultList = this.estimateService.searchAbstractEstimatesForLOA(abstractEstimateForLoaSearchRequest);
        String result = "{ \"data\":" + this.toSearchAbstractEstimateForLOAResultJson((Object)searchResultList) + "}";
        return result;
    }

    @RequestMapping(value={"/ajax-assignmentByDesignation"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getAssignmentByDesignation(@RequestParam(value="approvalDesignation") Long approvalDesignation) throws JsonGenerationException, JsonMappingException, IOException, NumberFormatException, ApplicationException {
        ArrayList<User> users = new ArrayList<User>();
        List assignments = new ArrayList();
        if (approvalDesignation != null && approvalDesignation != 0L && approvalDesignation != -1L) {
            assignments = this.assignmentService.getAllActiveAssignments(approvalDesignation);
        }
        for (Assignment assignment : assignments) {
            users.add(this.userService.getUserById(assignment.getEmployee().getId()));
        }
        Gson jsonCreator = new GsonBuilder().registerTypeAdapter(User.class, (Object)new UserAdaptor()).create();
        return jsonCreator.toJson(users, new /* Unavailable Anonymous Inner Class!! */.getType());
    }

    @RequestMapping(value={"/cancel/ajax-search"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchEstimatesToCancel(Model model, @ModelAttribute SearchRequestCancelEstimate searchRequestCancelEstimate) {
        List abstractEstimates = this.estimateService.searchEstimatesToCancel(searchRequestCancelEstimate);
        String result = "{ \"data\":" + this.toSearchEstimatesToCancelJson((Object)abstractEstimates) + "}";
        return result;
    }

    public Object toSearchEstimatesToCancelJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(AbstractEstimate.class, (Object)this.searchEstimatesToCancelJson).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajaxsearchabstractestimatesforofflinestatus"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxSearchAbstractEstimatesForOfflineStatus(Model model, @ModelAttribute AbstractEstimateForLoaSearchRequest abstractEstimateForLoaSearchRequest) {
        List searchResultList = this.estimateService.searchAbstractEstimatesForOfflineStatus(abstractEstimateForLoaSearchRequest);
        String result = "{ \"data\":" + this.toSearchAbstractEstimateForOfflineStatusJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchAbstractEstimateForOfflineStatusJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(AbstractEstimate.class, (Object)this.abstractEstimateForOfflineStatusJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajaxestimatenumbers-estimatetocancel"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findEstimateNumbersToCancelEstimate(@RequestParam String code) {
        return this.estimateService.findEstimateNumbersToCancelEstimate(code);
    }

    @RequestMapping(value={"/ajaxestimatenumbers-forofflinestatus"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> getAbstractEstimateNumbersToSetOfflineStatus(@RequestParam String code) {
        return this.estimateService.getAbstractEstimateNumbersToSetOfflineStatus(code);
    }

    @RequestMapping(value={"/ajaxestimatenumbers-tocreateloa"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findApprovedEstimateNumbersForCreateLOA(@RequestParam String estimateNumber) {
        return this.estimateService.getApprovedEstimateNumbersForCreateLOA(estimateNumber);
    }

    @RequestMapping(value={"/ajaxadminsanctionnumbers-tocreateloa"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findApprovedAdminSanctionNumbersForCreateLOA(@RequestParam String adminSanctionNumber) {
        return this.estimateService.getApprovedAdminSanctionNumbersForCreateLOA(adminSanctionNumber);
    }

    @RequestMapping(value={"/ajaxworkidentificationnumbers-tocreateloa"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findApprovedWorkIdentificationNumbersForCreateLOA(@RequestParam String workIdentificationNumber) {
        return this.estimateService.getApprovedWorkIdentificationNumbersForCreateLOA(workIdentificationNumber);
    }

    @RequestMapping(value={"/ajaxdeduction-coa"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<CChartOfAccounts> findDeductionAccountCodesAndAccountHeadByGlcodeLike(@RequestParam String searchQuery) {
        String[] purposeNames = new String[3];
        purposeNames[0] = "Creditors-Contractor Payable";
        return this.chartOfAccountsService.findOtherDeductionAccountCodesByGlcodeOrNameLike(searchQuery, purposeNames);
    }
}

