/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchLetterOfAcceptanceJsonAdaptor
implements JsonSerializer<WorkOrder> {
    @Autowired
    private WorksUtils worksUtils;

    public JsonElement serialize(WorkOrder workOrder, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (workOrder != null) {
            if (workOrder.getWorkOrderNumber() != null) {
                jsonObject.addProperty("workOrderNumber", workOrder.getWorkOrderNumber());
            } else {
                jsonObject.addProperty("workOrderNumber", "");
            }
            if (workOrder.getWorkOrderDate() != null) {
                jsonObject.addProperty("workOrderDate", workOrder.getWorkOrderDate().toString());
            } else {
                jsonObject.addProperty("workOrderDate", "");
            }
            if (workOrder.getContractor() != null) {
                jsonObject.addProperty("contractor", workOrder.getContractor().getName());
            } else {
                jsonObject.addProperty("contractor", "");
            }
            if (workOrder.getEgwStatus() != null) {
                jsonObject.addProperty("status", workOrder.getEgwStatus().getCode());
            } else {
                jsonObject.addProperty("status", "");
            }
            if (((WorkOrderEstimate)workOrder.getWorkOrderEstimates().get(0)).getEstimate() != null) {
                jsonObject.addProperty("estimateNumber", ((WorkOrderEstimate)workOrder.getWorkOrderEstimates().get(0)).getEstimate().getEstimateNumber());
            } else {
                jsonObject.addProperty("estimateNumber", "");
            }
            if (((WorkOrderEstimate)workOrder.getWorkOrderEstimates().get(0)).getEstimate() != null) {
                jsonObject.addProperty("nameOfWork", ((WorkOrderEstimate)workOrder.getWorkOrderEstimates().get(0)).getEstimate().getName());
            } else {
                jsonObject.addProperty("nameOfWork", "");
            }
            if (((WorkOrderEstimate)workOrder.getWorkOrderEstimates().get(0)).getEstimate().getLineEstimateDetails() != null) {
                jsonObject.addProperty("lineEstimateId", (Number)((WorkOrderEstimate)workOrder.getWorkOrderEstimates().get(0)).getEstimate().getLineEstimateDetails().getLineEstimate().getId());
            } else {
                jsonObject.addProperty("lineEstimateId", "");
            }
            jsonObject.addProperty("workOrderAmount", (Number)workOrder.getWorkOrderAmount());
            jsonObject.addProperty("id", (Number)workOrder.getId());
            if (((WorkOrderEstimate)workOrder.getWorkOrderEstimates().get(0)).getEstimate().getLineEstimateDetails() != null) {
                jsonObject.addProperty("workOrderCreated", Boolean.valueOf(((WorkOrderEstimate)workOrder.getWorkOrderEstimates().get(0)).getEstimate().getLineEstimateDetails().getLineEstimate().isWorkOrderCreated()));
            }
            jsonObject.addProperty("abstractEstimateId", (Number)((WorkOrderEstimate)workOrder.getWorkOrderEstimates().get(0)).getEstimate().getId());
            if (workOrder.getState() != null) {
                if (workOrder.getEgwStatus() != null && (workOrder.getEgwStatus().getCode().equalsIgnoreCase("APPROVED") || workOrder.getEgwStatus().getCode().equalsIgnoreCase("CANCELLED"))) {
                    jsonObject.addProperty("currentowner", "NA");
                } else {
                    jsonObject.addProperty("currentowner", this.worksUtils.getApproverName(workOrder.getState().getOwnerPosition().getId()));
                }
            } else {
                jsonObject.addProperty("currentowner", "NA");
            }
        }
        return jsonObject;
    }
}

