/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.List;
import org.egov.works.models.tender.OfflineStatus;
import org.egov.works.offlinestatus.service.OfflineStatusService;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchLetterOfAcceptanceForOfflineStatusJsonAdaptor
implements JsonSerializer<WorkOrderEstimate> {
    @Autowired
    private OfflineStatusService offlineStatusService;

    public JsonElement serialize(WorkOrderEstimate workOrderEstimate, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (workOrderEstimate != null) {
            if (workOrderEstimate.getWorkOrder().getWorkOrderNumber() != null) {
                jsonObject.addProperty("workOrderNumber", workOrderEstimate.getWorkOrder().getWorkOrderNumber());
            } else {
                jsonObject.addProperty("workOrderNumber", "");
            }
            if (workOrderEstimate.getWorkOrder().getWorkOrderDate() != null) {
                jsonObject.addProperty("workOrderDate", workOrderEstimate.getWorkOrder().getWorkOrderDate().toString());
            } else {
                jsonObject.addProperty("workOrderDate", "");
            }
            if (workOrderEstimate.getWorkOrder().getContractor() != null) {
                jsonObject.addProperty("contractor", workOrderEstimate.getWorkOrder().getContractor().getName());
            } else {
                jsonObject.addProperty("contractor", "");
            }
            if (workOrderEstimate.getWorkOrder().getEgwStatus() != null) {
                OfflineStatus offlineStatusses = this.offlineStatusService.getLastOfflineStatusByObjectIdAndObjectType(workOrderEstimate.getWorkOrder().getId(), "WorkOrder");
                if (offlineStatusses != null) {
                    jsonObject.addProperty("status", offlineStatusses.getEgwStatus().getDescription());
                } else {
                    jsonObject.addProperty("status", workOrderEstimate.getWorkOrder().getEgwStatus().getDescription());
                }
            } else {
                jsonObject.addProperty("status", "");
            }
            if (((WorkOrderEstimate)workOrderEstimate.getWorkOrder().getWorkOrderEstimates().get(0)).getEstimate().getLineEstimateDetails() != null) {
                jsonObject.addProperty("estimateNumber", ((WorkOrderEstimate)workOrderEstimate.getWorkOrder().getWorkOrderEstimates().get(0)).getEstimate().getLineEstimateDetails().getEstimateNumber());
            } else {
                jsonObject.addProperty("estimateNumber", ((WorkOrderEstimate)workOrderEstimate.getWorkOrder().getWorkOrderEstimates().get(0)).getEstimate().getLineEstimateDetails().getEstimateNumber());
            }
            if (((WorkOrderEstimate)workOrderEstimate.getWorkOrder().getWorkOrderEstimates().get(0)).getEstimate().getLineEstimateDetails() != null) {
                jsonObject.addProperty("nameOfWork", ((WorkOrderEstimate)workOrderEstimate.getWorkOrder().getWorkOrderEstimates().get(0)).getEstimate().getLineEstimateDetails().getNameOfWork());
            } else {
                jsonObject.addProperty("nameOfWork", ((WorkOrderEstimate)workOrderEstimate.getWorkOrder().getWorkOrderEstimates().get(0)).getEstimate().getLineEstimateDetails().getNameOfWork());
            }
            List offlinestatusses = this.offlineStatusService.getOfflineStatusByObjectIdAndType(workOrderEstimate.getWorkOrder().getId(), "WorkOrder");
            jsonObject.addProperty("lineEstimateId", (Number)((WorkOrderEstimate)workOrderEstimate.getWorkOrder().getWorkOrderEstimates().get(0)).getEstimate().getLineEstimateDetails().getLineEstimate().getId());
            jsonObject.addProperty("workOrderAmount", (Number)workOrderEstimate.getWorkOrder().getWorkOrderAmount());
            jsonObject.addProperty("id", (Number)workOrderEstimate.getWorkOrder().getId());
            jsonObject.addProperty("statusSize", (Number)offlinestatusses.size());
        }
        return jsonObject;
    }
}

