/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.List;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.egov.works.workorder.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchEstimatesToCancelJson
implements JsonSerializer<AbstractEstimate> {
    final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;

    public JsonElement serialize(AbstractEstimate abstractEstimate, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (abstractEstimate != null) {
            List workOrderEstimates;
            jsonObject.addProperty("id", (Number)abstractEstimate.getId());
            jsonObject.addProperty("estimateNumber", abstractEstimate.getEstimateNumber());
            jsonObject.addProperty("estimateId", (Number)abstractEstimate.getId());
            jsonObject.addProperty("estimateDate", this.sdf.format(abstractEstimate.getEstimateDate()));
            jsonObject.addProperty("estimateValue", (Number)abstractEstimate.getEstimateValue());
            jsonObject.addProperty("winCode", abstractEstimate.getProjectCode().getCode());
            if (abstractEstimate.getLineEstimateDetails() != null) {
                jsonObject.addProperty("lineEstimateNumber", abstractEstimate.getLineEstimateDetails().getLineEstimate().getLineEstimateNumber());
                jsonObject.addProperty("lineEstimateId", (Number)abstractEstimate.getLineEstimateDetails().getLineEstimate().getId());
            }
            if ((workOrderEstimates = this.workOrderEstimateService.getWorkOrderEstimatesToCancelEstimates(abstractEstimate.getEstimateNumber())).isEmpty()) {
                jsonObject.addProperty("loaNumber", "");
            } else {
                jsonObject.addProperty("loaNumber", ((WorkOrderEstimate)workOrderEstimates.get(0)).getWorkOrder().getWorkOrderNumber());
            }
        } else {
            jsonObject.addProperty("id", "");
            jsonObject.addProperty("estimateNumber", "");
            jsonObject.addProperty("estimateId", "");
            jsonObject.addProperty("estimateDate", "");
            jsonObject.addProperty("estimateValue", "");
            jsonObject.addProperty("winCode", "");
            jsonObject.addProperty("lineEstimateNumber", "");
            jsonObject.addProperty("lineEstimateId", "");
            jsonObject.addProperty("loaNumber", "");
        }
        return jsonObject;
    }
}

