/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.springframework.stereotype.Component;

@Component
public class LetterOfAcceptanceForMilestoneJSONAdaptor
implements JsonSerializer<WorkOrderEstimate> {
    public JsonElement serialize(WorkOrderEstimate workOrderEstimate, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (workOrderEstimate != null && workOrderEstimate.getWorkOrder().getEstimateNumber() != null) {
            jsonObject.addProperty("estimateNumber", workOrderEstimate.getEstimate().getEstimateNumber());
            jsonObject.addProperty("typeOfWork", workOrderEstimate.getEstimate().getLineEstimateDetails().getLineEstimate().getTypeOfWork().getDescription());
            if (workOrderEstimate.getEstimate().getLineEstimateDetails().getLineEstimate().getSubTypeOfWork() != null) {
                jsonObject.addProperty("subTypeOfWork", workOrderEstimate.getEstimate().getLineEstimateDetails().getLineEstimate().getSubTypeOfWork().getDescription());
            } else {
                jsonObject.addProperty("subTypeOfWork", "");
            }
            jsonObject.addProperty("estimateDate", workOrderEstimate.getEstimate().getLineEstimateDetails().getLineEstimate().getLineEstimateDate().toString());
            jsonObject.addProperty("nameOfTheWork", workOrderEstimate.getEstimate().getLineEstimateDetails().getNameOfWork());
            jsonObject.addProperty("workIdentificationNumber", workOrderEstimate.getEstimate().getLineEstimateDetails().getProjectCode().getCode());
            jsonObject.addProperty("workOrderNumber", workOrderEstimate.getWorkOrder().getWorkOrderNumber());
            jsonObject.addProperty("workOrderAmount", (Number)workOrderEstimate.getWorkOrder().getWorkOrderAmount());
            jsonObject.addProperty("workOrderDate", workOrderEstimate.getWorkOrder().getWorkOrderDate().toString());
            jsonObject.addProperty("workOrderId", (Number)workOrderEstimate.getWorkOrder().getId());
            jsonObject.addProperty("workOrderEstimateId", (Number)workOrderEstimate.getId());
        }
        return jsonObject;
    }
}

