/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.works.abstractestimate.entity.NonSor;
import org.egov.works.models.masters.EstimateTemplateActivity;
import org.egov.works.models.masters.ScheduleOfRate;
import org.springframework.stereotype.Component;

@Component
public class EstimateTemplateJsonAdaptor
implements JsonSerializer<EstimateTemplateActivity> {
    public JsonElement serialize(EstimateTemplateActivity estimateTemplateActivity, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        if (estimateTemplateActivity != null) {
            if (estimateTemplateActivity.getSchedule() != null) {
                ScheduleOfRate schedule = estimateTemplateActivity.getSchedule();
                jsonObject.addProperty("scheduleId", (Number)schedule.getId());
                jsonObject.addProperty("scheduleCategoryCode", schedule.getScheduleCategory().getCode());
                jsonObject.addProperty("scheduleCode", schedule.getCode());
                jsonObject.addProperty("scheduleSummary", schedule.getSummary());
                jsonObject.addProperty("scheduleDescription", schedule.getSummary());
                jsonObject.addProperty("scheduleUom", schedule.getUom().getUom());
                jsonObject.addProperty("scheduleUomId", (Number)schedule.getUom().getId());
                schedule.setSorRateValue(Double.valueOf(schedule.getRateOn(estimateTemplateActivity.getEstimateDate()).getRate().getValue()));
                jsonObject.addProperty("scheduleRate", schedule.getSorRate());
            } else {
                NonSor nonSor = estimateTemplateActivity.getNonSor();
                jsonObject.addProperty("nonSorDescription", nonSor.getDescription());
                jsonObject.addProperty("nonSorUomId", (Number)estimateTemplateActivity.getUom().getId());
                jsonObject.addProperty("nonSorUom", estimateTemplateActivity.getUom().getUom());
                jsonObject.addProperty("nonSorRate", (Number)estimateTemplateActivity.getRate().getValue());
            }
        }
        return jsonObject;
    }
}

