/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.revisionEstimate;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.egov.commons.EgwStatus;
import org.egov.commons.EgwTypeOfWork;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQueryHQL;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.model.PersonalInformation;
import org.egov.pims.service.EmployeeServiceOld;
import org.egov.pims.service.PersonalInformationService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.mb.entity.MBDetails;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.models.contractoradvance.ContractorAdvanceRequisition;
import org.egov.works.models.masters.NatureOfWork;
import org.egov.works.revisionestimate.entity.RevisionAbstractEstimate;
import org.egov.works.revisionestimate.entity.RevisionWorkOrder;
import org.egov.works.revisionestimate.entity.enums.RevisionType;
import org.egov.works.services.MeasurementBookService;
import org.egov.works.services.RevisionEstimateService;
import org.egov.works.services.WorksService;
import org.egov.works.services.contractoradvance.ContractorAdvanceService;
import org.egov.works.web.actions.estimate.AjaxEstimateAction;
import org.egov.works.workorder.entity.WorkOrderActivity;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Result(name={"search"}, location="searchRevisionEstimate-search.jsp")
public class SearchRevisionEstimateAction
extends SearchFormAction {
    private static final long serialVersionUID = -4526273645489797831L;
    private static final Logger LOGGER = Logger.getLogger(SearchRevisionEstimateAction.class);
    private AbstractEstimate estimates = new AbstractEstimate();
    private RevisionEstimateService revisionEstimateService;
    private Date fromDate;
    private Date toDate;
    @Autowired
    private EmployeeServiceOld employeeServiceOld;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    public static final String SEARCH = "search";
    public static final Locale LOCALE = new Locale("en", "IN");
    public static final SimpleDateFormat DDMMYYYYFORMATS = new SimpleDateFormat("dd/MM/yyyy", LOCALE);
    private List<RevisionAbstractEstimate> revEstimateList;
    private WorksService worksService;
    private WorkOrderEstimate workOrderEstimate;
    private String estimateNumber;
    private String workOrderNumber;
    private Integer execDept = -1;
    private Integer reStatus;
    private Long revWOId;
    private String source;
    private PersistenceService<RevisionAbstractEstimate, Long> revisionAbstractEstimateService;
    private PersistenceService<RevisionWorkOrder, Long> revisionWorkOrderService;
    private String messageKey;
    private String revisionEstimateNumber;
    private String cancelRemarks;
    private String cancellationReason;
    public static final String UNCHECKED = "unchecked";
    public static final String CANCEL_RE = "cancelRE";
    private MeasurementBookService measurementBookService;
    private ContractorAdvanceService contractorAdvanceService;

    public SearchRevisionEstimateAction() {
        this.addRelatedEntity("category", EgwTypeOfWork.class);
        this.addRelatedEntity("parentCategory", EgwTypeOfWork.class);
        this.addRelatedEntity("executingDepartment", Department.class);
        this.addRelatedEntity("natureOfWork", NatureOfWork.class);
        this.addRelatedEntity("egwStatus", EgwStatus.class);
    }

    public Object getModel() {
        return this.estimates;
    }

    public void prepare() {
        super.prepare();
        AjaxEstimateAction ajaxEstimateAction = new AjaxEstimateAction();
        ajaxEstimateAction.setPersistenceService(this.getPersistenceService());
        ajaxEstimateAction.setAssignmentService(this.assignmentService);
        this.addDropdownData("statusList", this.persistenceService.findAllBy("from EgwStatus s where moduletype=? and code in ('CREATED','REJECTED','RESUBMITTED','CANCELLED','BUDGETARY_APPR_CHECKED','BUDGETARY_APPROPRIATION_DONE','BUDGETARY_APPR_VALIDATED','APPROVED') order by orderId", new Object[]{AbstractEstimate.class.getSimpleName()}));
        this.addDropdownData("executingDepartmentList", this.persistenceService.findAllBy("from Department dt", new Object[0]));
        this.addDropdownData("typeList", this.persistenceService.findAllBy("from NatureOfWork", new Object[0]));
        this.addDropdownData("parentCategoryList", this.getPersistenceService().findAllBy("from EgwTypeOfWork etw1 where etw1.parentid is null", new Object[0]));
        this.addDropdownData("categoryList", Collections.emptyList());
        this.populateCategoryList(ajaxEstimateAction, this.estimates.getParentCategory() != null);
        if (CANCEL_RE.equals(this.source)) {
            EgwStatus egwstat = (EgwStatus)this.persistenceService.find("from EgwStatus where moduletype=? and code = 'APPROVED' order by orderId", new Object[]{AbstractEstimate.class.getSimpleName()});
            this.setReStatus(egwstat.getId());
        }
    }

    @Action(value="/revisionEstimate/searchRevisionEstimate-beforeSearch")
    public String beforeSearch() {
        return SEARCH;
    }

    public String searchRE() {
        return SEARCH;
    }

    public SearchQuery prepareQuery(String sortField, String sortOrder) {
        StringBuffer query = new StringBuffer(300);
        ArrayList<Object> paramList = new ArrayList<Object>();
        query.append("from WorkOrderEstimate woeP, WorkOrderEstimate woeC where woeP.estimate.id= woeC.estimate.parent.id and woeC.estimate.egwStatus.code!='NEW' ");
        if (this.reStatus != null && this.reStatus != -1) {
            query.append(" and woeC.estimate.egwStatus.id = ?");
            paramList.add(this.reStatus);
        }
        if (this.getExecDept() != null && this.getExecDept() != -1) {
            query.append(" and woeC.estimate.executingDepartment.id = ?");
            paramList.add(this.getExecDept());
        }
        if (null != this.estimates.getEstimateNumber() && StringUtils.isNotEmpty((String)this.estimates.getEstimateNumber())) {
            query.append(" and woeC.estimate.estimateNumber like '%'||?||'%'");
            paramList.add(this.estimates.getEstimateNumber());
        }
        if (this.estimates.getNatureOfWork() != null) {
            query.append(" and woeP.estimate.natureOfWork.id = ?");
            paramList.add(this.estimates.getNatureOfWork().getId());
        }
        if (null != this.fromDate && this.getFieldErrors().isEmpty()) {
            query.append(" and woeC.estimate.estimateDate >= ?");
            paramList.add(this.fromDate);
        }
        if (null != this.toDate && this.getFieldErrors().isEmpty()) {
            query.append(" and woeC.estimate.estimateDate <= ?");
            paramList.add(this.toDate);
        }
        if (this.estimates.getCategory() != null) {
            query.append(" and woeP.estimate.category.id = ?");
            paramList.add(this.estimates.getCategory().getId());
        }
        if (this.estimates.getParentCategory() != null) {
            query.append(" and woeP.estimate.parentCategory.id = ?");
            paramList.add(this.estimates.getParentCategory().getId());
        }
        if (null != this.workOrderNumber && StringUtils.isNotEmpty((String)this.workOrderNumber)) {
            query.append(" and woeC.workOrder.parent.workOrderNumber like '%'||?||'%'");
            paramList.add(this.workOrderNumber);
        }
        if (this.source != null && this.source.equalsIgnoreCase(CANCEL_RE)) {
            query.append(" and woeC.estimate.id = (select max(absEst.id) from AbstractEstimate absEst where absEst.parent.id = woeP.estimate.id and   absEst.egwStatus.code!= ? ) ");
            paramList.add("CANCELLED");
        }
        LOGGER.debug((Object)("SearchRevisionEstimate | prepareQuery | query >>>> " + query.toString()));
        return new SearchQueryHQL("select woeC " + query.toString(), "select count(distinct woeC.id) " + query.toString(), paramList);
    }

    public String list() {
        boolean isError = false;
        if (this.fromDate != null && this.toDate == null) {
            this.addFieldError("enddate", this.getText("search.endDate.null"));
            isError = true;
        }
        if (this.toDate != null && this.fromDate == null) {
            this.addFieldError("startdate", this.getText("search.startDate.null"));
            isError = true;
        }
        if (!DateUtils.compareDates((Date)this.getToDate(), (Date)this.getFromDate())) {
            this.addFieldError("enddate", this.getText("greaterthan.endDate.fromDate"));
            isError = true;
        }
        if (isError) {
            return SEARCH;
        }
        this.setPageSize(30);
        this.search();
        this.showOwnerName();
        return SEARCH;
    }

    public List<String> getActionsList() {
        String actions = this.worksService.getWorksConfigValue("RE_SHOW_ACTIONS");
        if (actions != null) {
            return Arrays.asList(actions.split(","));
        }
        return new ArrayList<String>();
    }

    protected void populateCategoryList(AjaxEstimateAction ajaxEstimateAction, boolean categoryPopulated) {
        if (categoryPopulated) {
            ajaxEstimateAction.setCategory(this.estimates.getParentCategory().getId());
            ajaxEstimateAction.subcategories();
            this.addDropdownData("categoryList", ajaxEstimateAction.getSubCategories());
        } else {
            this.addDropdownData("categoryList", Collections.emptyList());
        }
    }

    @ValidationErrorPage(value="search")
    public String cancelApprovedRE() {
        RevisionAbstractEstimate re;
        RevisionWorkOrder revWorkOrder = (RevisionWorkOrder)this.revisionWorkOrderService.findById((Serializable)this.revWOId, false);
        if (!this.validateRECancellation(revWorkOrder, re = (RevisionAbstractEstimate)this.revisionAbstractEstimateService.findById((Serializable)((WorkOrderEstimate)revWorkOrder.getWorkOrderEstimates().get(0)).getEstimate().getId(), false))) {
            return this.list();
        }
        this.validateARFForRE(re);
        revWorkOrder.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("WorkOrder", "CANCELLED"));
        PersonalInformation prsnlInfo = this.employeeServiceOld.getEmpForUserId(this.worksService.getCurrentLoggedInUserId());
        String empName = "";
        re.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("AbstractEstimate", "CANCELLED"));
        if (prsnlInfo.getEmployeeFirstName() != null) {
            empName = prsnlInfo.getEmployeeFirstName();
        }
        if (prsnlInfo.getEmployeeLastName() != null) {
            empName = empName.concat(" ").concat(prsnlInfo.getEmployeeLastName());
        }
        if (this.cancelRemarks == null || StringUtils.isNotBlank((String)this.cancelRemarks)) {
            // empty if block
        }
        this.revisionEstimateService.releaseBudget(re);
        this.revisionEstimateNumber = re.getEstimateNumber();
        this.messageKey = this.revisionEstimateNumber + ": " + this.getText("revisionEstimate.Cancel");
        return "success";
    }

    private boolean validateRECancellation(RevisionWorkOrder revWorkOrder, RevisionAbstractEstimate revEstimate) {
        List revWoaList = this.persistenceService.findAllBy("from WorkOrderActivity where workOrderEstimate.workOrder.id=?", new Object[]{revWorkOrder.getId()});
        ArrayList<Long> activtityIdList = new ArrayList<Long>();
        if (revWoaList != null && revWoaList.size() > 0) {
            List mbheaderlist = new ArrayList();
            for (WorkOrderActivity revWoa : revWoaList) {
                if (revWoa.getActivity().getRevisionType() == null || !revWoa.getActivity().getRevisionType().equals((Object)RevisionType.LUMP_SUM_ITEM) && !revWoa.getActivity().getRevisionType().equals((Object)RevisionType.NON_TENDERED_ITEM) || (mbheaderlist = this.measurementBookService.findAllBy("select distinct mbd.mbHeader from MBDetails mbd where mbd.workOrderActivity.workOrderEstimate.estimate.id=? and mbd.workOrderActivity.workOrderEstimate.workOrder.id=? and  mbd.workOrderActivity.activity.id=? and mbd.mbHeader.egwStatus.code<>'CANCELLED'", new Object[]{revEstimate.getId(), revWorkOrder.getId(), revWoa.getActivity().getId()})) == null || mbheaderlist.isEmpty()) continue;
                StringBuffer mbNos = new StringBuffer();
                for (MBHeader mbHdr : mbheaderlist) {
                    mbNos.append(mbHdr.getMbRefNo() + ", ");
                }
                String errorMessage = this.getText("cancelRE.MB.created.message") + mbNos.toString().substring(0, mbNos.length() - 2) + ". " + this.getText("cancelRE.MB.created.message.part2");
                this.addActionError(errorMessage);
                return false;
            }
            for (WorkOrderActivity revWoa : revWoaList) {
                if (revWoa.getActivity().getRevisionType() == null || !revWoa.getActivity().getRevisionType().equals((Object)RevisionType.ADDITIONAL_QUANTITY)) continue;
                activtityIdList.add(revWoa.getActivity().getParent().getId());
            }
            if (activtityIdList != null && activtityIdList.size() > 0) {
                Query qry = this.getPersistenceService().getSession().createQuery(" select workOrderActivity.activity.id, nvl(sum(quantity),0)  from MBDetails where mbHeader.egwStatus.code!='CANCELLED' and workOrderActivity.activity.id in (:activtityIdList) group by workOrderActivity.activity.id ");
                qry.setParameterList("activtityIdList", activtityIdList);
                List activityIdQuantityList = qry.list();
                if (activityIdQuantityList != null && activityIdQuantityList.size() > 0) {
                    for (WorkOrderActivity revWoa : revWoaList) {
                        if (revWoa.getActivity().getRevisionType() != null && !revWoa.getActivity().getRevisionType().equals((Object)RevisionType.ADDITIONAL_QUANTITY)) continue;
                        for (Object[] activityIdQuantity : activityIdQuantityList) {
                            double revEstQuantity;
                            if (Long.parseLong(activityIdQuantity[0].toString()) != revWoa.getActivity().getParent().getId()) continue;
                            Long activityId = null;
                            activityId = revWoa.getActivity().getParent() == null ? revWoa.getActivity().getId() : revWoa.getActivity().getParent().getId();
                            double originalQuantity = (Double)this.persistenceService.find("select sum(woa.approvedQuantity) from WorkOrderActivity woa  group by woa,woa.activity having activity.id = ?", new Object[]{activityId});
                            Object revEstQuantityObj = this.persistenceService.find(" select sum(woa.approvedQuantity*nvl(decode(woa.activity.revisionType,'REDUCED_QUANTITY',-1,'ADDITIONAL_QUANTITY',1,'NON_TENDERED_ITEM',1,'LUMP_SUM_ITEM',1),1)) from WorkOrderActivity woa where woa.activity.abstractEstimate.egwStatus.code = 'APPROVED'  and woa.activity.abstractEstimate.id != ? group by woa.activity.parent having (woa.activity.parent is not null and woa.activity.parent.id = ? )  ", new Object[]{revEstimate.getId(), revWoa.getActivity().getParent().getId()});
                            double d = revEstQuantity = revEstQuantityObj == null ? 0.0 : (Double)revEstQuantityObj;
                            if (originalQuantity + revEstQuantity >= Double.parseDouble(activityIdQuantity[1].toString())) continue;
                            MBDetails mbDetails = (MBDetails)this.persistenceService.find(" from MBDetails mbd where mbd.mbHeader.egwStatus.code != 'CANCELLED' and mbd.workOrderActivity.activity.id = ? and (mbdetailsDate is not null or OrderNumber is not null) ", new Object[]{revWoa.getActivity().getParent().getId()});
                            if (mbDetails != null) {
                                Double maxPercent = this.worksService.getConfigval();
                                maxPercent = maxPercent != null ? Double.valueOf(maxPercent + 100.0) : Double.valueOf(100.0);
                                Double maxAllowedQuantity = maxPercent * (originalQuantity + revEstQuantity) / 100.0;
                                if (maxAllowedQuantity >= Double.parseDouble(activityIdQuantity[1].toString())) continue;
                                this.addActionError(this.getText("cancelRE.MBs.present.message"));
                                return false;
                            }
                            this.addActionError(this.getText("cancelRE.MBs.present.message"));
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    private void validateARFForRE(RevisionAbstractEstimate revisionEstimate) {
        BigDecimal totalEstimateValueIncludingRE;
        String arfNo = "";
        BigDecimal advanceAmount = new BigDecimal(0);
        List woeList = this.persistenceService.findAllBy(" from WorkOrderEstimate woe where woe.workOrder.egwStatus.code = 'APPROVED' and woe.estimate=?", new Object[]{revisionEstimate.getParent()});
        if (woeList != null && !woeList.isEmpty()) {
            for (WorkOrderEstimate woe : woeList) {
                for (ContractorAdvanceRequisition arf : woe.getContractorAdvanceRequisitions()) {
                    if (arf.getStatus().getCode().equalsIgnoreCase(ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.CANCELLED.toString())) continue;
                    advanceAmount = advanceAmount.add(arf.getAdvanceRequisitionAmount());
                    if (!arfNo.equals("")) {
                        arfNo = arfNo.concat(", ").concat(arf.getAdvanceRequisitionNumber());
                        continue;
                    }
                    arfNo = arfNo.concat(arf.getAdvanceRequisitionNumber());
                }
            }
        }
        if (!arfNo.equals("") && (totalEstimateValueIncludingRE = this.contractorAdvanceService.getTotalEstimateValueIncludingRE(revisionEstimate.getParent())).subtract(new BigDecimal(revisionEstimate.getTotalAmount().getValue())).longValue() < advanceAmount.longValue()) {
            throw new ValidationException(Arrays.asList(new ValidationError("cancelRE.arf.created.message", this.getText("cancelRE.arf.created.message", new String[]{arfNo}))));
        }
    }

    private void showOwnerName() {
        LinkedList<WorkOrderEstimate> woEstimateList = new LinkedList<WorkOrderEstimate>();
        for (Object row : this.searchResult.getList()) {
            PersonalInformation emp;
            WorkOrderEstimate woe = (WorkOrderEstimate)row;
            if (!woe.getEstimate().getEgwStatus().getCode().equalsIgnoreCase("APPROVED") && !woe.getEstimate().getEgwStatus().getCode().equalsIgnoreCase("CANCELLED") && (emp = this.employeeServiceOld.getEmployeeforPosition(woe.getEstimate().getState().getOwnerPosition())) != null && emp.getUserMaster() != null) {
                woe.getEstimate().setPositionAndUserName(emp.getUserMaster().getName());
            }
            woEstimateList.add(woe);
        }
        this.searchResult.getList().clear();
        HashSet uniqueWOEstimateList = new HashSet(woEstimateList);
        this.searchResult.getList().addAll(uniqueWOEstimateList);
    }

    public AbstractEstimate getEstimates() {
        return this.estimates;
    }

    public void setEstimates(AbstractEstimate estimates) {
        this.estimates = estimates;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public void setPersonalInformationService(PersonalInformationService personalInformationService) {
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public List<RevisionAbstractEstimate> getRevEstimateList() {
        return this.revEstimateList;
    }

    public void setRevEstimateList(List<RevisionAbstractEstimate> revEstimateList) {
        this.revEstimateList = revEstimateList;
    }

    public WorkOrderEstimate getWorkOrderEstimate() {
        return this.workOrderEstimate;
    }

    public void setWorkOrderEstimate(WorkOrderEstimate workOrderEstimate) {
        this.workOrderEstimate = workOrderEstimate;
    }

    public String getEstimateNumber() {
        return this.estimateNumber;
    }

    public void setEstimateNumber(String estimateNumber) {
        this.estimateNumber = estimateNumber;
    }

    public Integer getExecDept() {
        return this.execDept;
    }

    public void setExecDept(Integer execDept) {
        this.execDept = execDept;
    }

    public Integer getReStatus() {
        return this.reStatus;
    }

    public void setReStatus(Integer reStatus) {
        this.reStatus = reStatus;
    }

    public String getWorkOrderNumber() {
        return this.workOrderNumber;
    }

    public void setWorkOrderNumber(String workOrderNumber) {
        this.workOrderNumber = workOrderNumber;
    }

    public Long getRevWOId() {
        return this.revWOId;
    }

    public void setRevWOId(Long revWOId) {
        this.revWOId = revWOId;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public void setRevisionAbstractEstimateService(PersistenceService<RevisionAbstractEstimate, Long> revisionAbstractEstimateService) {
        this.revisionAbstractEstimateService = revisionAbstractEstimateService;
    }

    public void setRevisionWorkOrderService(PersistenceService<RevisionWorkOrder, Long> revisionWorkOrderService) {
        this.revisionWorkOrderService = revisionWorkOrderService;
    }

    public String getRevisionEstimateNumber() {
        return this.revisionEstimateNumber;
    }

    public void setRevisionEstimateNumber(String revisionEstimateNumber) {
        this.revisionEstimateNumber = revisionEstimateNumber;
    }

    public String getCancelRemarks() {
        return this.cancelRemarks;
    }

    public void setCancelRemarks(String cancelRemarks) {
        this.cancelRemarks = cancelRemarks;
    }

    public String getCancellationReason() {
        return this.cancellationReason;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public void setRevisionEstimateService(RevisionEstimateService revisionEstimateService) {
        this.revisionEstimateService = revisionEstimateService;
    }

    public void setMeasurementBookService(MeasurementBookService measurementBookService) {
        this.measurementBookService = measurementBookService;
    }

    public void setContractorAdvanceService(ContractorAdvanceService contractorAdvanceService) {
        this.contractorAdvanceService = contractorAdvanceService;
    }
}

