/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.revisionEstimate;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.mb.entity.MBDetails;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.revisionestimate.entity.enums.RevisionType;
import org.egov.works.services.MeasurementBookService;
import org.egov.works.services.WorksService;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderActivity;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.hibernate.Query;

public class AjaxRevisionEstimateAction
extends BaseFormAction {
    private static final long serialVersionUID = -6192212773360994495L;
    private static final Logger logger = Logger.getLogger(AjaxRevisionEstimateAction.class);
    private static final String ACTIVITY_DETAILS = "activityDetails";
    private String query = "";
    private List<AbstractEstimate> estimateList = new LinkedList();
    private List<AbstractEstimate> estimateNoList = new LinkedList();
    private List<WorkOrder> workOrderList = new LinkedList();
    private WorksService worksService;
    private Long reWOEstId;
    private Long revEstId;
    private static final String CANCEL_REVISIONESTIMATE = "cancelRE";
    private static final String REV_ESTIMATE_LIST = "revisionEstList";
    private List<MBHeader> approvedMBList = new ArrayList();
    private MeasurementBookService measurementBookService;
    private Double prevCulmEntry;
    private WorkOrderActivity workOrderActivity;
    private Long woActivityId;
    private Double totalEstQuantity;
    private Long estimateId;
    private String errorMessage;
    private static final String VALIDATE_CANCEL = "validateCancel";

    public Object getModel() {
        return null;
    }

    public String searchEstimateNumber() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = "select woe.estimate from WorkOrderEstimate woe where woe.workOrder.parent is null and woe.workOrder.egwStatus.code<>? and woe.workOrder.egwStatus.code = ? and woe.estimate.parent is null and woe.estimate.estimateNumber like '%'||?||'%'  and woe.id not in (select distinct mbh.workOrderEstimate.id from MBHeader mbh where mbh.egwStatus.code = ? and (mbh.egBillregister.billstatus <> ? and mbh.egBillregister.billtype = ?) and mbh.workOrderEstimate.workOrder.egwStatus.code='APPROVED' and mbh.workOrderEstimate.estimate.egwStatus.code=?)";
            params.add("NEW");
            params.add("APPROVED");
            params.add(this.query.toUpperCase());
            params.add(MBHeader.MeasurementBookStatus.APPROVED.toString());
            params.add(MBHeader.MeasurementBookStatus.CANCELLED.toString());
            params.add(this.getFinalBillTypeConfigValue());
            params.add(AbstractEstimate.EstimateStatus.ADMIN_SANCTIONED.toString());
            this.estimateList = this.getPersistenceService().findAllBy(strquery, params.toArray());
        }
        return "estimateNoSearchResults";
    }

    public String activityDetails() {
        this.prevCulmEntry = null;
        try {
            this.workOrderActivity = (WorkOrderActivity)this.persistenceService.find("from WorkOrderActivity where id=?", new Object[]{this.woActivityId});
            this.prevCulmEntry = this.measurementBookService.prevCumulativeQuantityIncludingCQ(this.woActivityId, null, this.workOrderActivity.getActivity().getId(), this.workOrderActivity.getWorkOrderEstimate().getWorkOrder());
            this.totalEstQuantity = this.measurementBookService.totalEstimatedQuantityForRE(this.woActivityId, null, this.workOrderActivity.getActivity().getId(), this.workOrderActivity.getWorkOrderEstimate().getWorkOrder());
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("activity.find.error", (Throwable)e);
        }
        return ACTIVITY_DETAILS;
    }

    public String searchWorkOrderNumber() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = "select distinct woe.workOrder from WorkOrderEstimate woe where woe.workOrder.parent is null and woe.workOrder.egwStatus.code<>? and woe.workOrder.egwStatus.code = ? and woe.estimate.parent is null and woe.workOrder.workOrderNumber like '%'||?||'%' and woe.id not in (select distinct mbh.workOrderEstimate.id from MBHeader mbh where mbh.egwStatus.code = ? and (mbh.egBillregister.billstatus <> ? and mbh.egBillregister.billtype = ?) and mbh.workOrderEstimate.workOrder.egwStatus.code='APPROVED' and mbh.workOrderEstimate.estimate.egwStatus.code=?)";
            params.add("NEW");
            params.add("APPROVED");
            params.add(this.query.toUpperCase());
            params.add(MBHeader.MeasurementBookStatus.APPROVED.toString());
            params.add(MBHeader.MeasurementBookStatus.CANCELLED.toString());
            params.add(this.getFinalBillTypeConfigValue());
            params.add(AbstractEstimate.EstimateStatus.ADMIN_SANCTIONED.toString());
            this.workOrderList = this.getPersistenceService().findAllBy(strquery, params.toArray());
        }
        return "workOrderNoSearchResults";
    }

    public String searchRevisionEstimateNumber() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = " from AbstractEstimate ae where ae.parent is not null and ae.egwStatus.code<>? and ae.estimateNumber like '%'||?||'%'";
            params.add("NEW");
            params.add(this.query.toUpperCase());
            this.estimateList = this.getPersistenceService().findAllBy(strquery, params.toArray());
        }
        return "estimateNoSearchResults";
    }

    public String searchREWorkOrderNumber() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = "select distinct woe.workOrder.parent from WorkOrderEstimate woe where woe.workOrder.parent is not null and woe.estimate.egwStatus.code<>? and woe.workOrder.parent.workOrderNumber like '%'||?||'%' ";
            params.add("NEW");
            params.add(this.query.toUpperCase());
            this.workOrderList = this.getPersistenceService().findAllBy(strquery, params.toArray());
        }
        return "workOrderNoSearchResults";
    }

    public String searchApprovedWONumberForRE() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = "select distinct woe.workOrder.parent from WorkOrderEstimate woe where woe.workOrder.parent is not null and woe.estimate.egwStatus.code=? and woe.workOrder.parent.workOrderNumber like '%'||?||'%' ";
            params.add("APPROVED");
            params.add(this.query.toUpperCase());
            this.workOrderList = this.getPersistenceService().findAllBy(strquery, params.toArray());
        }
        return "workOrderNoSearchResults";
    }

    public String getMBDetailsForRE() throws Exception {
        List mbheaderlist = new ArrayList();
        mbheaderlist = this.measurementBookService.findAllBy("select distinct mbd.mbHeader from MBDetails mbd where mbd.workOrderActivity.workOrderEstimate.id=? and mbd.mbHeader.egwStatus.code<>'CANCELLED'", new Object[]{this.reWOEstId});
        if (mbheaderlist != null && !mbheaderlist.isEmpty()) {
            this.approvedMBList.addAll(mbheaderlist);
        }
        return CANCEL_REVISIONESTIMATE;
    }

    public String validateCancellation() {
        this.errorMessage = "";
        if (this.reWOEstId != null) {
            WorkOrderEstimate revWOEst = (WorkOrderEstimate)this.persistenceService.find(" from WorkOrderEstimate where id = ? ", new Object[]{this.reWOEstId});
            WorkOrder revWorkOrder = revWOEst.getWorkOrder();
            AbstractEstimate revEstimate = revWOEst.getEstimate();
            List revWoaList = this.persistenceService.findAllBy("from WorkOrderActivity where workOrderEstimate.workOrder.id=?", new Object[]{revWorkOrder.getId()});
            ArrayList<Long> activtityIdList = new ArrayList<Long>();
            List mbheaderlist = new ArrayList();
            for (WorkOrderActivity revWoa : revWoaList) {
                if (revWoa.getActivity().getRevisionType() == null || !revWoa.getActivity().getRevisionType().equals((Object)RevisionType.LUMP_SUM_ITEM) && !revWoa.getActivity().getRevisionType().equals((Object)RevisionType.NON_TENDERED_ITEM) || (mbheaderlist = this.measurementBookService.findAllBy("select distinct mbd.mbHeader from MBDetails mbd where mbd.workOrderActivity.workOrderEstimate.estimate.id=? and mbd.workOrderActivity.workOrderEstimate.workOrder.id=? and  mbd.workOrderActivity.activity.id=? and mbd.mbHeader.egwStatus.code<>'CANCELLED'", new Object[]{revEstimate.getId(), revWorkOrder.getId(), revWoa.getActivity().getId()})) == null || mbheaderlist.isEmpty()) continue;
                StringBuffer mbNos = new StringBuffer();
                for (MBHeader mbHdr : mbheaderlist) {
                    mbNos.append(mbHdr.getMbRefNo() + ", ");
                }
                this.errorMessage = this.getText("cancelRE.MB.created.message") + mbNos.toString().substring(0, mbNos.length() - 2) + ". " + this.getText("cancelRE.MB.created.message.part2");
                return VALIDATE_CANCEL;
            }
            if (revWoaList != null && revWoaList.size() > 0) {
                for (WorkOrderActivity revWoa : revWoaList) {
                    if (revWoa.getActivity().getRevisionType() == null || !revWoa.getActivity().getRevisionType().equals((Object)RevisionType.ADDITIONAL_QUANTITY)) continue;
                    activtityIdList.add(revWoa.getActivity().getParent().getId());
                }
                if (activtityIdList != null && activtityIdList.size() > 0) {
                    Query qry = this.getPersistenceService().getSession().createQuery(" select workOrderActivity.activity.id, nvl(sum(quantity),0)  from MBDetails where mbHeader.egwStatus.code!='CANCELLED' and workOrderActivity.activity.id in (:activtityIdList) group by workOrderActivity.activity.id ");
                    qry.setParameterList("activtityIdList", activtityIdList);
                    List activityIdQuantityList = qry.list();
                    if (activityIdQuantityList != null && activityIdQuantityList.size() > 0) {
                        for (WorkOrderActivity revWoa : revWoaList) {
                            if (revWoa.getActivity().getRevisionType() != null && !revWoa.getActivity().getRevisionType().equals((Object)RevisionType.ADDITIONAL_QUANTITY)) continue;
                            for (Object[] activityIdQuantity : activityIdQuantityList) {
                                double revEstQuantity;
                                if (Long.parseLong(activityIdQuantity[0].toString()) != revWoa.getActivity().getParent().getId()) continue;
                                Long activityId = null;
                                activityId = revWoa.getActivity().getParent() == null ? revWoa.getActivity().getId() : revWoa.getActivity().getParent().getId();
                                double originalQuantity = (Double)this.persistenceService.find("select sum(woa.approvedQuantity) from WorkOrderActivity woa  group by woa,woa.activity having activity.id = ?", new Object[]{activityId});
                                Object revEstQuantityObj = this.persistenceService.find(" select sum(woa.approvedQuantity*nvl(decode(woa.activity.revisionType,'REDUCED_QUANTITY',-1,'ADDITIONAL_QUANTITY',1,'NON_TENDERED_ITEM',1,'LUMP_SUM_ITEM',1),1)) from WorkOrderActivity woa where woa.activity.abstractEstimate.egwStatus.code = 'APPROVED'  and woa.activity.abstractEstimate.id != ? group by woa.activity.parent having (woa.activity.parent is not null and woa.activity.parent.id = ? )  ", new Object[]{revEstimate.getId(), revWoa.getActivity().getParent().getId()});
                                double d = revEstQuantity = revEstQuantityObj == null ? 0.0 : (Double)revEstQuantityObj;
                                if (originalQuantity + revEstQuantity >= Double.parseDouble(activityIdQuantity[1].toString())) continue;
                                MBDetails mbDetails = (MBDetails)this.persistenceService.find(" from MBDetails mbd where mbd.mbHeader.egwStatus.code != 'CANCELLED' and mbd.workOrderActivity.activity.id = ? and (mbdetailsDate is not null or OrderNumber is not null) ", new Object[]{revWoa.getActivity().getParent().getId()});
                                if (mbDetails != null) {
                                    Double maxPercent = this.worksService.getConfigval();
                                    maxPercent = maxPercent != null ? Double.valueOf(maxPercent + 100.0) : Double.valueOf(100.0);
                                    Double maxAllowedQuantity = maxPercent * (originalQuantity + revEstQuantity) / 100.0;
                                    if (maxAllowedQuantity >= Double.parseDouble(activityIdQuantity[1].toString())) continue;
                                    this.errorMessage = this.getText("cancelRE.MBs.present.message");
                                    return VALIDATE_CANCEL;
                                }
                                this.errorMessage = this.getText("cancelRE.MBs.present.message");
                                return VALIDATE_CANCEL;
                            }
                        }
                    }
                }
            }
        }
        return VALIDATE_CANCEL;
    }

    public String getListOfREsForParent() throws Exception {
        this.estimateNoList = this.getPersistenceService().findAllBy("select distinct abs.estimateNumber from AbstractEstimate abs where abs.parent.id=? and abs.egwStatus.code<>'CANCELLED' order by abs.estimateNumber ", new Object[]{this.estimateId});
        return REV_ESTIMATE_LIST;
    }

    public String getFinalBillTypeConfigValue() {
        return this.worksService.getWorksConfigValue("FinalBillType");
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public List<AbstractEstimate> getEstimateList() {
        return this.estimateList;
    }

    public void setEstimateList(List<AbstractEstimate> estimateList) {
        this.estimateList = estimateList;
    }

    public List<WorkOrder> getWorkOrderList() {
        return this.workOrderList;
    }

    public void setWorkOrderList(List<WorkOrder> workOrderList) {
        this.workOrderList = workOrderList;
    }

    public Long getReWOEstId() {
        return this.reWOEstId;
    }

    public void setReWOEstId(Long reWOEstId) {
        this.reWOEstId = reWOEstId;
    }

    public List<MBHeader> getApprovedMBList() {
        return this.approvedMBList;
    }

    public void setApprovedMBList(List<MBHeader> approvedMBList) {
        this.approvedMBList = approvedMBList;
    }

    public void setMeasurementBookService(MeasurementBookService measurementBookService) {
        this.measurementBookService = measurementBookService;
    }

    public Double getPrevCulmEntry() {
        return this.prevCulmEntry;
    }

    public Long getWoActivityId() {
        return this.woActivityId;
    }

    public Double getTotalEstQuantity() {
        return this.totalEstQuantity;
    }

    public void setWoActivityId(Long woActivityId) {
        this.woActivityId = woActivityId;
    }

    public WorkOrderActivity getWorkOrderActivity() {
        return this.workOrderActivity;
    }

    public void setWorkOrderActivity(WorkOrderActivity workOrderActivity) {
        this.workOrderActivity = workOrderActivity;
    }

    public void setEstimateId(Long estimateId) {
        this.estimateId = estimateId;
    }

    public List<AbstractEstimate> getEstimateNoList() {
        return this.estimateNoList;
    }

    public Long getRevEstId() {
        return this.revEstId;
    }

    public void setRevEstId(Long revEstId) {
        this.revEstId = revEstId;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

