/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.masters;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.ContractorGrade;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infstr.search.SearchQuery;
import org.egov.works.master.service.ContractorGradeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name={"new"}, location="contractorGrade-new.jsp"), @Result(name={"edit"}, location="contractorGrade-edit.jsp"), @Result(name={"searchPage"}, location="contractorGrade-searchPage.jsp"), @Result(name={"index"}, location="contractorGrade-index.jsp")})
@ParentPackage(value="egov")
public class ContractorGradeAction
extends SearchFormAction {
    private static final long serialVersionUID = 4500128509093695097L;
    private ContractorGrade contractorGrade = new ContractorGrade();
    @Autowired
    @Qualifier(value="contractorGradeService")
    private ContractorGradeService contractorGradeService;
    private List<ContractorGrade> contractorGradeList = null;
    public static final String SEARCH = "searchPage";
    public static final String INDEX = "index";
    public static final String EDIT = "edit";
    private Long id;
    private String grade;
    private double minAmount = -1.0;
    private double maxAmount = -1.0;
    private String displData;
    private String mode;
    private List<String> maxAmountList;
    private List<String> minAmountList;
    private Map<String, Object> criteriaMap = null;

    @Action(value="/masters/contractorGrade-save")
    public String save() {
        if (this.contractorGrade.getMaxAmount().compareTo(this.contractorGrade.getMinAmount()) != 1) {
            this.addActionMessage(this.getText("contractor.grade.maxamount.invalid"));
            return "new";
        }
        this.persistenceService.validate((Object)this.contractorGrade);
        this.contractorGrade.validate();
        this.contractorGrade = this.contractorGradeService.save(this.contractorGrade);
        if (!this.mode.equals(EDIT)) {
            this.addActionMessage(this.getText("contractor.grade.save.success"));
        } else {
            this.addActionMessage(this.getText("contractor.grade.modify.success"));
        }
        this.contractorGradeList = new ArrayList();
        this.contractorGradeList.add(this.contractorGrade);
        return INDEX;
    }

    @Action(value="/masters/contractorGrade-newform")
    public String newform() {
        this.mode = "new";
        return "new";
    }

    @Action(value="/masters/contractorGrade-viewContractorGrade")
    public String viewContractorGrade() {
        return SEARCH;
    }

    public void prepare() {
        if (this.id != null) {
            this.contractorGrade = this.contractorGradeService.getContractorGradeById(this.id);
        }
        List tempMaxAmountList = this.persistenceService.findAllByNamedQuery("getContractorGradeMaxAmountList", new Object[0]);
        List tempMinAmountList = this.persistenceService.findAllByNamedQuery("getContractorGradeMinAmountList", new Object[0]);
        this.maxAmountList = new ArrayList();
        this.minAmountList = new ArrayList();
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setGroupingUsed(false);
        for (BigDecimal maxValue : tempMaxAmountList) {
            String max = numberFormat.format(maxValue.doubleValue());
            this.getMaxAmountList().add(max);
        }
        for (BigDecimal minValue : tempMinAmountList) {
            String min = numberFormat.format(minValue.doubleValue());
            this.getMinAmountList().add(min);
        }
        super.prepare();
    }

    public String list() {
        this.contractorGradeList = this.contractorGradeService.getAllContractorGrades();
        return INDEX;
    }

    @Action(value="/masters/contractorGrade-edit")
    public String edit() {
        this.contractorGrade = this.contractorGradeService.getContractorGradeById(this.contractorGrade.getId());
        if (this.mode.equals(EDIT)) {
            return EDIT;
        }
        return INDEX;
    }

    public String execute() {
        return this.list();
    }

    @Action(value="/masters/contractorGrade-searchGradeDetails")
    public String searchGradeDetails() {
        boolean hasNoErrors = true;
        this.contractorGrade = (ContractorGrade)this.getModel();
        String s = this.contractorGrade.getMinAmountString();
        String s1 = this.contractorGrade.getMaxAmountString();
        if (this.contractorGrade.getMaxAmountString() == null) {
            this.setMinAmount(-1.0);
        } else {
            this.setMinAmount(Double.parseDouble(s));
        }
        if (this.contractorGrade.getMaxAmountString() == null) {
            this.setMaxAmount(-1.0);
        } else {
            this.setMaxAmount(Double.parseDouble(s1));
        }
        if (this.grade != null && !this.grade.equals("") && !(hasNoErrors = Pattern.matches("[0-9a-zA-Z ]+", this.grade))) {
            this.addActionError(this.getText("contractorGrade.grade.alphaNumeric"));
        }
        if (this.minAmount != -1.0 && this.maxAmount != -1.0 && this.minAmount >= this.maxAmount) {
            this.addActionError(this.getText("contractor.grade.maxamount.invalid"));
            return SEARCH;
        }
        if (!hasNoErrors) {
            return SEARCH;
        }
        this.setPageSize(30);
        this.search();
        if (this.searchResult != null && this.searchResult.getFullListSize() == 0) {
            this.setDisplData("noData");
        } else {
            this.setDisplData("yes");
        }
        return SEARCH;
    }

    public String getDisplData() {
        return this.displData;
    }

    public void setDisplData(String displData) {
        this.displData = displData;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getGrade() {
        return this.grade;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    public double getMinAmount() {
        return this.minAmount;
    }

    public void setMinAmount(double minAmount) {
        this.minAmount = minAmount;
    }

    public double getMaxAmount() {
        return this.maxAmount;
    }

    public void setMaxAmount(double maxAmount) {
        this.maxAmount = maxAmount;
    }

    public ContractorGrade getContractorGrade() {
        return this.contractorGrade;
    }

    public Object getModel() {
        return this.contractorGrade;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public List<ContractorGrade> getContractorGradeList() {
        return this.contractorGradeList;
    }

    public SearchQuery prepareQuery(String sortField, String sortOrder) {
        return this.contractorGradeService.prepareSearchQuery(this.createCriteriaMap());
    }

    public List<String> getMaxAmountList() {
        return this.maxAmountList;
    }

    public void setMaxAmountList(List<String> maxAmountList) {
        this.maxAmountList = maxAmountList;
    }

    public List<String> getMinAmountList() {
        return this.minAmountList;
    }

    public void setMinAmountList(List<String> minAmountList) {
        this.minAmountList = minAmountList;
    }

    private Map<String, Object> createCriteriaMap() {
        this.criteriaMap = new HashMap();
        this.criteriaMap.put("grade", this.grade);
        this.criteriaMap.put("minAmount", this.minAmount);
        this.criteriaMap.put("maxAmount", this.maxAmount);
        return this.criteriaMap;
    }
}

