/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.contractoradvance;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQueryHQL;
import org.egov.infstr.services.PersistenceService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.models.contractoradvance.ContractorAdvanceRequisition;
import org.egov.works.models.masters.Contractor;
import org.egov.works.models.tender.TenderResponse;
import org.egov.works.services.TenderResponseService;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.hibernate.FlushMode;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Result(name={"search"}, location="searchEstimateForContractorAdvance-search.jsp")
public class SearchEstimateForContractorAdvanceAction
extends SearchFormAction {
    private static final long serialVersionUID = 9140665581257254905L;
    @Autowired
    private DepartmentService departmentService;
    public static final Locale LOCALE = new Locale("en", "IN");
    public static final String SEARCH = "search";
    public static final SimpleDateFormat DDMMYYYYFORMATS = new SimpleDateFormat("dd/MM/yyyy", LOCALE);
    private PersistenceService<Contractor, Long> contractorService;
    private TenderResponseService tenderResponseService;
    private String estimateStatus;
    private String estimateNumber;
    private Date fromDate;
    private Date toDate;
    private Long contractorId;
    private String wpNumber;
    private String tenderNegotiationNumber;
    private int executingDepartmentId;
    private String workOrderNumber;

    public Object getModel() {
        return null;
    }

    public void prepare() {
        super.prepare();
        this.addDropdownData("executingDepartmentList", this.departmentService.getAllDepartments());
        this.estimateStatus = AbstractEstimate.EstimateStatus.ADMIN_SANCTIONED.toString();
    }

    @Action(value="/contractoradvance/searchEstimateForContractorAdvance-beforeSearch")
    public String beforeSearch() {
        return SEARCH;
    }

    private Map getQuery() {
        StringBuffer query = new StringBuffer(700);
        ArrayList<Object> paramList = new ArrayList<Object>();
        HashMap<String, Object> queryAndParams = new HashMap<String, Object>();
        query.append("from WorkOrderEstimate woe where woe.workOrder.parent is null and woe.workOrder.egwStatus.code = ? ");
        paramList.add("APPROVED");
        query.append(" and NOT EXISTS (select 1 from ContractorAdvanceRequisition arf where arf.workOrderEstimate.id = woe.id  and arf.status.code not in(?,?)) ");
        paramList.add(ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.CANCELLED.toString());
        paramList.add(ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.APPROVED.toString());
        query.append("and NOT EXISTS (select 1 from MBHeader mbh where mbh.workOrderEstimate.id = woe.id and  mbh.egwStatus.code = ? and (mbh.egBillregister is not null and mbh.egBillregister.billstatus <> ?))");
        paramList.add(MBHeader.MeasurementBookStatus.APPROVED.toString());
        paramList.add(ContractorBillRegister.BillStatus.CANCELLED.toString());
        if (StringUtils.isNotBlank((String)this.estimateNumber)) {
            query.append(" and UPPER(woe.estimate.estimateNumber) like '%'||?||'%'");
            paramList.add(StringUtils.trim((String)this.estimateNumber).toUpperCase());
        }
        if (this.fromDate != null && this.toDate != null && this.getFieldErrors().isEmpty()) {
            query.append(" and woe.workOrder.approvedDate between ? and ? ");
            paramList.add(this.fromDate);
            paramList.add(this.toDate);
        }
        if (this.contractorId != 0L && this.contractorId != -1L) {
            query.append(" and woe.workOrder.contractor.id = ? ");
            paramList.add(this.contractorId);
        }
        if (StringUtils.isNotBlank((String)this.wpNumber)) {
            query.append(" and UPPER(woe.workOrder.packageNumber) like '%'||?||'%'");
            paramList.add(StringUtils.trim((String)this.wpNumber).toUpperCase());
        }
        if (StringUtils.isNotBlank((String)this.tenderNegotiationNumber)) {
            query.append(" and UPPER(woe.workOrder.negotiationNumber) like '%'||?||'%'");
            paramList.add(StringUtils.trim((String)this.tenderNegotiationNumber).toUpperCase());
        }
        if (this.executingDepartmentId != 0 && this.executingDepartmentId != -1) {
            query.append(" and woe.estimate.executingDepartment.id = ? ");
            paramList.add(this.executingDepartmentId);
        }
        if (StringUtils.isNotBlank((String)this.workOrderNumber)) {
            query.append(" and UPPER(woe.workOrder.workOrderNumber) like '%'||?||'%'");
            paramList.add(StringUtils.trim((String)this.workOrderNumber).toUpperCase());
        }
        queryAndParams.put("query", query.toString());
        queryAndParams.put("params", paramList);
        return queryAndParams;
    }

    public SearchQuery prepareQuery(String sortField, String sortOrder) {
        String query = null;
        String countQuery = null;
        Map queryAndParms = null;
        List paramList = new ArrayList();
        queryAndParms = this.getQuery();
        paramList = (List)queryAndParms.get("params");
        query = (String)queryAndParms.get("query");
        countQuery = "select count(distinct woe.id) " + query;
        query = "select distinct woe " + query;
        return new SearchQueryHQL(query, countQuery, paramList);
    }

    public String search() {
        return SEARCH;
    }

    public String searchList() {
        this.getPersistenceService().getSession().setDefaultReadOnly(true);
        this.getPersistenceService().getSession().setFlushMode(FlushMode.MANUAL);
        boolean isError = false;
        if (this.fromDate != null && this.toDate == null) {
            this.addFieldError("enddate", this.getText("search.endDate.null"));
            isError = true;
        }
        if (this.toDate != null && this.fromDate == null) {
            this.addFieldError("startdate", this.getText("search.startDate.null"));
            isError = true;
        }
        if (!DateUtils.compareDates((Date)this.toDate, (Date)this.fromDate)) {
            this.addFieldError("enddate", this.getText("greaterthan.endDate.fromDate"));
            isError = true;
        }
        if (isError) {
            return SEARCH;
        }
        this.setPageSize(30);
        super.search();
        if (this.searchResult != null && this.searchResult.getList() != null && !this.searchResult.getList().isEmpty()) {
            this.setTenderType();
        }
        return SEARCH;
    }

    protected void setTenderType() {
        ArrayList<WorkOrderEstimate> woeList = new ArrayList<WorkOrderEstimate>();
        for (WorkOrderEstimate woe : this.searchResult.getList()) {
            TenderResponse tenderResponse = (TenderResponse)this.tenderResponseService.find("from TenderResponse tr where tr.negotiationNumber =? and tr.egwStatus.code = ?", new Object[]{woe.getWorkOrder().getNegotiationNumber(), TenderResponse.TenderResponseStatus.APPROVED.toString()});
            woe.getWorkOrder().setTenderType(tenderResponse.getTenderEstimate().getTenderType());
            woeList.add(woe);
        }
        this.searchResult.getList().clear();
        this.searchResult.getList().addAll(woeList);
    }

    public Map<String, Object> getContractorForApprovedWorkOrder() {
        LinkedHashMap<String, Object> contractorsWithWOList = new LinkedHashMap<String, Object>();
        List approvedContractorList = this.contractorService.findAllByNamedQuery("getApprovedContractorsWithWO", new Object[0]);
        if (approvedContractorList != null) {
            for (Contractor contractor : approvedContractorList) {
                contractorsWithWOList.put(contractor.getId() + "", contractor.getCode() + " - " + contractor.getName());
            }
        }
        return contractorsWithWOList;
    }

    public void setDepartmentService(DepartmentService departmentService) {
        this.departmentService = departmentService;
    }

    public void setContractorService(PersistenceService<Contractor, Long> contractorService) {
        this.contractorService = contractorService;
    }

    public String getEstimateStatus() {
        return this.estimateStatus;
    }

    public void setEstimateStatus(String estimateStatus) {
        this.estimateStatus = estimateStatus;
    }

    public String getEstimateNumber() {
        return this.estimateNumber;
    }

    public void setEstimateNumber(String estimateNumber) {
        this.estimateNumber = estimateNumber;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Long getContractorId() {
        return this.contractorId;
    }

    public void setContractorId(Long contractorId) {
        this.contractorId = contractorId;
    }

    public String getWpNumber() {
        return this.wpNumber;
    }

    public void setWpNumber(String wpNumber) {
        this.wpNumber = wpNumber;
    }

    public String getTenderNegotiationNumber() {
        return this.tenderNegotiationNumber;
    }

    public void setTenderNegotiationNumber(String tenderNegotiationNumber) {
        this.tenderNegotiationNumber = tenderNegotiationNumber;
    }

    public int getExecutingDepartmentId() {
        return this.executingDepartmentId;
    }

    public void setExecutingDepartmentId(int executingDepartmentId) {
        this.executingDepartmentId = executingDepartmentId;
    }

    public String getWorkOrderNumber() {
        return this.workOrderNumber;
    }

    public void setWorkOrderNumber(String workOrderNumber) {
        this.workOrderNumber = workOrderNumber;
    }

    public void setTenderResponseService(TenderResponseService tenderResponseService) {
        this.tenderResponseService = tenderResponseService;
    }
}

