/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.contractoradvance;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.DrawingOfficer;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.WorkflowAction;
import org.egov.infra.workflow.service.WorkflowService;
import org.egov.model.advance.EgAdvanceRequisitionDetails;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.models.contractoradvance.ContractorAdvanceRequisition;
import org.egov.works.services.AbstractEstimateService;
import org.egov.works.services.WorksService;
import org.egov.works.services.contractoradvance.ContractorAdvanceService;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Result(name={"new"}, location="contractorAdvanceRequisition-new.jsp")
public class ContractorAdvanceRequisitionAction
extends BaseFormAction {
    private static final Logger LOGGER = Logger.getLogger(ContractorAdvanceRequisitionAction.class);
    private static final long serialVersionUID = 1L;
    private ContractorAdvanceRequisition contractorAdvanceRequisition = new ContractorAdvanceRequisition();
    private Long workOrderEstimateId;
    private Long id;
    private WorkOrderEstimate workOrderEstimate = new WorkOrderEstimate();
    private BigDecimal advancePaid = BigDecimal.ZERO;
    private WorksService worksService;
    private ContractorAdvanceService contractorAdvanceService;
    private static final String ADVANCE_COA_LIST = "advanceAccountCodeList";
    private static final String ARF_TYPE = "Contractor";
    private Long advanceAccountCode;
    private static final String CANCEL_ACTION = "cancel";
    private static final Object REJECT_ACTION = "reject";
    private static final String SAVE_ACTION = "save";
    private static final String SOURCE_INBOX = "inbox";
    private static final String ACTION_NAME = "actionName";
    private Integer logedInUserDept = -1;
    private AbstractEstimateService abstractEstimateService;
    private WorkflowService<ContractorAdvanceRequisition> workflowService;
    @Autowired
    private UserService userService;
    private String sourcepage = "";
    private Integer workflowFunctionaryId;
    @Autowired
    private DepartmentService departmentService;
    private String messageKey;
    private String nextEmployeeName;
    private String nextDesignation;
    private String drawingOfficerName;

    public ContractorAdvanceRequisitionAction() {
        this.addRelatedEntity("drawingOfficer", DrawingOfficer.class);
    }

    public StateAware getModel() {
        return this.contractorAdvanceRequisition;
    }

    public void prepare() {
        if (this.workOrderEstimateId != null) {
            this.contractorAdvanceRequisition.setWorkOrderEstimate((WorkOrderEstimate)this.persistenceService.find("from WorkOrderEstimate where id = ?", new Object[]{this.workOrderEstimateId}));
            if (this.id == null) {
                this.advancePaid = this.contractorAdvanceService.getAdvancePaidByWOEstimateId(this.workOrderEstimateId);
            }
        }
        this.addDropdownData(ADVANCE_COA_LIST, this.contractorAdvanceService.getContractorAdvanceAccountcodes());
        if (this.id != null) {
            this.contractorAdvanceRequisition = this.contractorAdvanceService.getContractorAdvanceRequisitionById(this.id);
            for (EgAdvanceRequisitionDetails advanceRequisitionDetails : this.contractorAdvanceRequisition.getEgAdvanceReqDetailses()) {
                this.advanceAccountCode = advanceRequisitionDetails.getChartofaccounts().getId();
            }
            this.workOrderEstimateId = this.contractorAdvanceRequisition.getWorkOrderEstimate().getId();
            if (StringUtils.isBlank((String)this.drawingOfficerName)) {
                this.drawingOfficerName = this.contractorAdvanceRequisition.getDrawingOfficer().getCode() + " - " + this.contractorAdvanceRequisition.getDrawingOfficer().getName();
            }
        }
        if (this.workOrderEstimateId != null && this.id != null) {
            this.advancePaid = this.contractorAdvanceService.getAdvancePaidByWOEstIdForView(this.workOrderEstimateId, this.id);
        }
        if (this.advancePaid == null) {
            this.advancePaid = new BigDecimal(0.0);
        }
        super.prepare();
        this.addDropdownData("executingDepartmentList", this.departmentService.getAllDepartments());
        Assignment loggedInUserAssignment = this.abstractEstimateService.getLatestAssignmentForCurrentLoginUser();
        if (loggedInUserAssignment != null) {
            this.contractorAdvanceRequisition.setWorkflowDepartmentId(loggedInUserAssignment.getDepartment().getId());
        }
        this.workflowFunctionaryId = this.contractorAdvanceService.getFunctionaryForWorkflow(this.contractorAdvanceRequisition);
    }

    @SkipValidation
    @Action(value="/contractoradvance/contractorAdvanceRequisition-newform")
    public String newform() {
        return "new";
    }

    @SkipValidation
    public String edit() throws Exception {
        if (SOURCE_INBOX.equalsIgnoreCase(this.sourcepage)) {
            User user = this.userService.getUserById(this.worksService.getCurrentLoggedInUserId());
            boolean isValidUser = this.worksService.validateWorkflowForUser((StateAware)this.contractorAdvanceRequisition, user);
            if (isValidUser) {
                throw new ApplicationRuntimeException("Error: Invalid Owner - No permission to view this page.");
            }
        } else if (StringUtils.isEmpty((String)this.sourcepage)) {
            this.sourcepage = "search";
        }
        return "edit";
    }

    public String save() {
        String actionName;
        block7: {
            actionName = "";
            try {
                if (this.parameters.get(ACTION_NAME) != null && ((String[])this.parameters.get(ACTION_NAME))[0] != null) {
                    actionName = ((String[])this.parameters.get(ACTION_NAME))[0];
                }
                if (!CANCEL_ACTION.equals(actionName) && !REJECT_ACTION.equals(actionName)) {
                    BigDecimal totalEstimateValueIncludingREValue = this.contractorAdvanceService.getTotalEstimateValueIncludingRE(this.contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate());
                    if (this.advancePaid.add(this.contractorAdvanceRequisition.getAdvanceRequisitionAmount()).longValue() > totalEstimateValueIncludingREValue.longValue()) {
                        throw new ValidationException(Arrays.asList(new ValidationError("advancerequisition.validate.advancepaid.estimatevalue", "advancerequisition.validate.advancepaid.estimatevalue")));
                    }
                }
                this.contractorAdvanceRequisition.setArftype(ARF_TYPE);
                this.contractorAdvanceService.save(this.contractorAdvanceRequisition, actionName, this.advanceAccountCode);
            }
            catch (ValidationException validationException) {
                List errorList = validationException.getErrors();
                Iterator iterator = errorList.iterator();
                if (!iterator.hasNext()) break block7;
                ValidationError error = (ValidationError)iterator.next();
                if (error.getMessage().contains("DatabaseSequenceFirstTimeException")) {
                    this.prepare();
                    throw new ValidationException(Arrays.asList(new ValidationError("error", error.getMessage())));
                }
                throw new ValidationException(validationException.getErrors());
            }
        }
        this.messageKey = SAVE_ACTION.equals(actionName) ? "advancerequisition.save.success" : "advancerequisition." + actionName;
        this.addActionMessage(this.getText(this.messageKey, this.messageKey));
        this.getDesignation(this.contractorAdvanceRequisition);
        if (SAVE_ACTION.equals(actionName)) {
            this.sourcepage = SOURCE_INBOX;
        }
        return SAVE_ACTION.equals(actionName) ? "edit" : "success";
    }

    public String cancel() {
        String actionName = ((String[])this.parameters.get(ACTION_NAME))[0];
        this.contractorAdvanceService.cancelContractorAdvanceRequisition(this.contractorAdvanceRequisition, actionName);
        this.messageKey = "advancerequisition.cancel";
        this.getDesignation(this.contractorAdvanceRequisition);
        return "success";
    }

    private void getDesignation(ContractorAdvanceRequisition contractorAdvanceRequisition) {
        String result;
        if (contractorAdvanceRequisition.getCurrentState() != null && !"NEW".equalsIgnoreCase(contractorAdvanceRequisition.getCurrentState().getValue()) && (result = this.worksService.getEmpNameDesignation(contractorAdvanceRequisition.getState().getOwnerPosition(), contractorAdvanceRequisition.getState().getCreatedDate())) != null && !"@".equalsIgnoreCase(result)) {
            String empName = result.substring(0, result.lastIndexOf(64));
            String designation = result.substring(result.lastIndexOf(64) + 1, result.length());
            this.setNextEmployeeName(empName);
            this.setNextDesignation(designation);
        }
    }

    public List<WorkflowAction> getValidActions() {
        return this.workflowService.getValidActions((StateAware)this.contractorAdvanceRequisition);
    }

    public void validate() {
        String actionName = "";
        if (this.parameters.get(ACTION_NAME) != null && ((String[])this.parameters.get(ACTION_NAME))[0] != null) {
            actionName = ((String[])this.parameters.get(ACTION_NAME))[0];
        }
        if (!actionName.equalsIgnoreCase("reject") && !actionName.equalsIgnoreCase(CANCEL_ACTION)) {
            if (this.contractorAdvanceRequisition.getAdvanceRequisitionDate() == null) {
                this.addFieldError("advanceRequisitionDate", this.getText("advancerequisition.date.required"));
            }
            if (!DateUtils.compareDates((Date)this.contractorAdvanceRequisition.getAdvanceRequisitionDate(), (Date)this.contractorAdvanceRequisition.getWorkOrderEstimate().getWorkOrder().getApprovedDate())) {
                this.addFieldError("advanceRequisitionDate", this.getText("advancerequisition.date.lessthan.workorder.approveddate"));
            }
            if (!DateUtils.compareDates((Date)new Date(), (Date)this.contractorAdvanceRequisition.getAdvanceRequisitionDate())) {
                this.addFieldError("advanceRequisitionDate", this.getText("advancerequisition.validate.date.greaterthan.currentDate"));
            }
            if (this.advanceAccountCode == null || this.advanceAccountCode == -1L || this.advanceAccountCode == 0L) {
                this.addFieldError("advanceAccountCode", this.getText("advancerequisition.advanceaccountcode.required"));
            }
            if (this.contractorAdvanceRequisition.getDrawingOfficer() == null || this.contractorAdvanceRequisition.getDrawingOfficer().getId() == null || this.contractorAdvanceRequisition.getDrawingOfficer().getId() == -1L || this.contractorAdvanceRequisition.getDrawingOfficer().getId() == 0L) {
                this.addFieldError("drawingOfficer", this.getText("advancerequisition.drawingofficer.required"));
            }
            if (!this.worksService.checkBigDecimalValue(this.contractorAdvanceRequisition.getAdvanceRequisitionAmount(), BigDecimal.valueOf(0.0))) {
                this.addFieldError("advanceRequisitionAmount", this.getText("advancerequisition.valid.amount.greaterthan.zero"));
            }
            if (!this.sourcepage.equals("search")) {
                this.checkForBills();
                if (this.id == null) {
                    this.checkARFInWorkflowForEstimate();
                }
            }
        }
    }

    protected void checkForBills() {
        Long billCount = (Long)this.persistenceService.find("select count(*) from MBHeader mbh where mbh.workOrderEstimate.id = ? and mbh.egwStatus.code = ? and (mbh.egBillregister is not null and mbh.egBillregister.billstatus <> ?)", new Object[]{this.contractorAdvanceRequisition.getWorkOrderEstimate().getId(), MBHeader.MeasurementBookStatus.APPROVED.toString(), ContractorBillRegister.BillStatus.CANCELLED.toString()});
        if (billCount != null && billCount > 0L) {
            this.addActionError(this.getText("advancerequisition.validate.billcreated.message"));
        }
    }

    protected void checkARFInWorkflowForEstimate() {
        ContractorAdvanceRequisition arf = (ContractorAdvanceRequisition)this.persistenceService.find(" from ContractorAdvanceRequisition arf where arf.workOrderEstimate.id = ? and arf.status.code not in(?, ?) ", new Object[]{this.contractorAdvanceRequisition.getWorkOrderEstimate().getId(), ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.APPROVED.toString(), ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.CANCELLED.toString()});
        if (arf != null) {
            this.addActionError(this.getText("advancerequisition.validate.arf.in.workflow.message", new String[]{arf.getAdvanceRequisitionNumber()}));
        }
    }

    public ContractorAdvanceRequisition getContractorAdvanceRequisition() {
        return this.contractorAdvanceRequisition;
    }

    public void setContractorAdvanceRequisition(ContractorAdvanceRequisition contractorAdvanceRequisition) {
        this.contractorAdvanceRequisition = contractorAdvanceRequisition;
    }

    public Long getWorkOrderEstimateId() {
        return this.workOrderEstimateId;
    }

    public void setWorkOrderEstimateId(Long workOrderEstimateId) {
        this.workOrderEstimateId = workOrderEstimateId;
    }

    public WorkOrderEstimate getWorkOrderEstimate() {
        return this.workOrderEstimate;
    }

    public void setWorkOrderEstimate(WorkOrderEstimate workOrderEstimate) {
        this.workOrderEstimate = workOrderEstimate;
    }

    public BigDecimal getAdvancePaid() {
        return this.advancePaid;
    }

    public void setAdvancePaid(BigDecimal advancePaid) {
        this.advancePaid = advancePaid;
    }

    public WorksService getWorksService() {
        return this.worksService;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public Long getAdvanceAccountCode() {
        return this.advanceAccountCode;
    }

    public void setAdvanceAccountCode(Long advanceAccountCode) {
        this.advanceAccountCode = advanceAccountCode;
    }

    public void setContractorAdvanceService(ContractorAdvanceService contractorAdvanceService) {
        this.contractorAdvanceService = contractorAdvanceService;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getLogedInUserDept() {
        return this.logedInUserDept;
    }

    public void setLogedInUserDept(Integer logedInUserDept) {
        this.logedInUserDept = logedInUserDept;
    }

    public AbstractEstimateService getAbstractEstimateService() {
        return this.abstractEstimateService;
    }

    public void setAbstractEstimateService(AbstractEstimateService abstractEstimateService) {
        this.abstractEstimateService = abstractEstimateService;
    }

    public String getSourcepage() {
        return this.sourcepage;
    }

    public void setSourcepage(String sourcepage) {
        this.sourcepage = sourcepage;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public Integer getWorkflowFunctionaryId() {
        return this.workflowFunctionaryId;
    }

    public void setWorkflowFunctionaryId(Integer workflowFunctionaryId) {
        this.workflowFunctionaryId = workflowFunctionaryId;
    }

    public void setDepartmentService(DepartmentService departmentService) {
        this.departmentService = departmentService;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public String getNextEmployeeName() {
        return this.nextEmployeeName;
    }

    public void setNextEmployeeName(String nextEmployeeName) {
        this.nextEmployeeName = nextEmployeeName;
    }

    public String getNextDesignation() {
        return this.nextDesignation;
    }

    public void setNextDesignation(String nextDesignation) {
        this.nextDesignation = nextDesignation;
    }

    public void setContractorAdvanceWorkflowService(WorkflowService<ContractorAdvanceRequisition> workflow) {
        this.workflowService = workflow;
    }

    public String getDrawingOfficerName() {
        return this.drawingOfficerName;
    }

    public void setDrawingOfficerName(String drawingOfficerName) {
        this.drawingOfficerName = drawingOfficerName;
    }
}

