/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.milestone;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import org.egov.works.contractorbill.entity.enums.BillTypes;
import org.egov.works.master.service.MilestoneTemplateService;
import org.egov.works.milestone.entity.Milestone;
import org.egov.works.milestone.entity.SearchRequestMilestone;
import org.egov.works.milestone.entity.SearchRequestMilestoneTemplate;
import org.egov.works.milestone.entity.TrackMilestone;
import org.egov.works.milestone.service.MilestoneService;
import org.egov.works.milestone.service.TrackMilestoneService;
import org.egov.works.models.masters.MilestoneTemplate;
import org.egov.works.web.adaptor.SearchCancelMilestoneJsonAdaptor;
import org.egov.works.web.adaptor.SearchMilestoneJsonAdaptor;
import org.egov.works.web.adaptor.SearchMilestoneTemplateJsonAdaptor;
import org.egov.works.web.adaptor.SearchTrackMilestoneJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/milestone"})
public class AjaxMilestoneController {
    @Autowired
    private MilestoneService milestoneService;
    @Autowired
    private SearchMilestoneJsonAdaptor searchMilestoneJsonAdaptor;
    @Autowired
    private MilestoneTemplateService milestoneTemplateService;
    @Autowired
    private SearchMilestoneTemplateJsonAdaptor searchMilestoneTemplateJsonAdaptor;
    @Autowired
    private TrackMilestoneService trackMilestoneService;
    @Autowired
    private SearchTrackMilestoneJsonAdaptor searchTrackMilestoneJsonAdaptor;
    @Autowired
    private SearchCancelMilestoneJsonAdaptor searchCancelMilestoneJsonAdaptor;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;

    @RequestMapping(value={"/ajax-search"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchMilestones(@ModelAttribute SearchRequestMilestone searchRequestMilestone) {
        List searchMilestoneList = this.milestoneService.searchMilestone(searchRequestMilestone);
        String result = "{ \"data\":" + this.toSearchMilestone((Object)searchMilestoneList) + "}";
        return result;
    }

    public Object toSearchMilestone(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(Milestone.class, (Object)this.searchMilestoneJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajaxmilestonetemplatecode-milestone"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<MilestoneTemplate> findMilestoneTemplateCodeForMilestone(@RequestParam String code) {
        return this.milestoneTemplateService.findMilestoneTemplateCodeForMilestone(code);
    }

    @RequestMapping(value={"/ajaxsearchmilestonetemplate"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxMilestoneTemplateSearch(Model model, @ModelAttribute SearchRequestMilestoneTemplate searchRequestMilestoneTemplate) {
        List searchMilestoneTemplateList = this.milestoneTemplateService.searchMilestoneTemplate(searchRequestMilestoneTemplate);
        String result = "{ \"data\":" + this.toSearchMilestoneTemplateJson((Object)searchMilestoneTemplateList) + "}";
        return result;
    }

    public Object toSearchMilestoneTemplateJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(MilestoneTemplate.class, (Object)this.searchMilestoneTemplateJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajaxtrackmilestone-search"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchTrackMilestones(Model model, @ModelAttribute SearchRequestMilestone searchRequestMilestone) {
        List searchTrackMilestoneList = this.trackMilestoneService.searchTrackMilestone(searchRequestMilestone);
        String result = "{ \"data\":" + this.toSearchTrackMilestone((Object)searchTrackMilestoneList) + "}";
        return result;
    }

    public Object toSearchTrackMilestone(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(TrackMilestone.class, (Object)this.searchTrackMilestoneJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajaxworkidentificationnumbers-trackmilestone"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findWorkIdNumbersToTrackMilestone(@RequestParam String code) {
        return this.trackMilestoneService.findWorkIdentificationNumbersTrackMilestone(code);
    }

    @RequestMapping(value={"/cancel/ajax-search"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchMilestonesToCancel(Model model, @ModelAttribute SearchRequestMilestone searchRequestMilestone) {
        List milestones = this.milestoneService.searchMilestonesToCancel(searchRequestMilestone);
        String result = "{ \"data\":" + this.toSearchMilestonesToCancelJson((Object)milestones) + "}";
        return result;
    }

    public Object toSearchMilestonesToCancelJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(Milestone.class, (Object)this.searchCancelMilestoneJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajaxloanumbers-milestonetocancel"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findLOAsToCancelMilestone(@RequestParam String code) {
        return this.milestoneService.findLoaNumbersToCancelMilestone(code);
    }

    @RequestMapping(value={"/ajaxcontractors-milestonetocancel"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findContractorsToCancelMilestone(@RequestParam String code) {
        return this.milestoneService.findContractorsToCancelMilestone(code);
    }

    @RequestMapping(value={"/ajax-searchmilestoneforview"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchMilestonesForView(@ModelAttribute SearchRequestMilestone searchRequestMilestone) {
        List searchMilestoneList = this.milestoneService.searchMilestoneForView(searchRequestMilestone);
        String result = "{ \"data\":" + this.toSearchMilestone((Object)searchMilestoneList) + "}";
        return result;
    }

    @RequestMapping(value={"/validate-milestonepercentagetocreatecontractorbill"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public String validateCreateContractorPartBill(@RequestParam(value="workOrderEstimateId") Long workOrderEstimateId, @RequestParam(value="billType") String billType) {
        String message = "";
        TrackMilestone trackMileStone = null;
        if (billType.equalsIgnoreCase(BillTypes.Final_Bill.toString())) {
            trackMileStone = this.trackMilestoneService.getCompletionPercentageToCreateContractorFinalBill(workOrderEstimateId);
            if (trackMileStone == null) {
                message = this.messageSource.getMessage("error.contractor.finalbill.milestonepercentage", null, null);
            }
        } else {
            trackMileStone = this.trackMilestoneService.getMinimumPercentageToCreateContractorBill(workOrderEstimateId);
            if (trackMileStone == null) {
                message = this.messageSource.getMessage("error.contractorbil.milestone.percentage", null, null);
            }
        }
        return message;
    }
}

