/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.lineestimate;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.NumberUtil;
import org.egov.infra.web.utils.WebUtils;
import org.egov.works.lineestimate.entity.LineEstimate;
import org.egov.works.lineestimate.entity.LineEstimateAppropriation;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/lineestimate"})
public class LineEstimatePDFController {
    @Autowired
    private ReportService reportService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private LineEstimateService lineEstimateService;
    public static final String LINEESTIMATEPDF = "lineEstimatePDF";

    @RequestMapping(value={"/lineEstimatePDF/{lineEstimateId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateLineEstimatePDF(HttpServletRequest request, @PathVariable(value="lineEstimateId") Long id, HttpSession session) throws IOException {
        LineEstimate lineEstimate = this.lineEstimateService.getLineEstimateById(id);
        return this.generateReport(lineEstimate, request, session);
    }

    private ResponseEntity<byte[]> generateReport(LineEstimate lineEstimate, HttpServletRequest request, HttpSession session) {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        ReportRequest reportInput = null;
        ReportOutput reportOutput = null;
        if (lineEstimate != null) {
            String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
            reportParams.put("cityLogo", url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo")));
            reportParams.put("cityName", ApplicationThreadLocals.getMunicipalityName());
            reportParams.put("proNo", lineEstimate.getAdminSanctionNumber() != null ? lineEstimate.getAdminSanctionNumber() : "");
            reportParams.put("sub", lineEstimate.getSubject());
            reportParams.put("ref", lineEstimate.getReference());
            reportParams.put("dated", lineEstimate.getAdminSanctionDate() != null ? DateUtils.getFormattedDate((Date)lineEstimate.getAdminSanctionDate(), (String)"dd/MM/yyyy") : "");
            reportParams.put("scheme", lineEstimate.getScheme() != null ? lineEstimate.getScheme().getName() : "");
            reportParams.put("function", lineEstimate.getFunction() != null ? lineEstimate.getFunction().getName() : "");
            reportParams.put("account", lineEstimate.getBudgetHead() != null ? lineEstimate.getBudgetHead().getName() : "");
            reportParams.put("modeOfAllotment", lineEstimate.getModeOfAllotment());
            reportParams.put("workCategory", lineEstimate.getWorkCategory().toString().replace("_", " ") + " - " + lineEstimate.getBeneficiary().toString().replaceAll("_C", "/C").replace("_", " "));
            reportParams.put("present", lineEstimate.getAdminSanctionBy() != null ? lineEstimate.getAdminSanctionBy().getName() : "");
            String zonalCommissioner = this.worksUtils.getUserDesignation(lineEstimate.getAdminSanctionBy());
            reportParams.put("zonalCommissioner", zonalCommissioner);
            reportParams.put("zonalCommissionerCapital", zonalCommissioner != null ? zonalCommissioner.toUpperCase() : "");
            reportParams.put("beneficiary", lineEstimate.getBeneficiary() != null ? lineEstimate.getBeneficiary().toString() : "");
            String basNos = "";
            BigDecimal totalAmount = BigDecimal.ZERO;
            for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
                List leas = led.getLineEstimateAppropriations();
                for (LineEstimateAppropriation lea : leas) {
                    basNos = basNos + lea.getBudgetUsage().getAppropriationnumber() + ", ";
                }
                totalAmount = totalAmount.add(led.getEstimateAmount());
            }
            if (basNos.endsWith(", ")) {
                basNos = basNos.substring(0, basNos.length() - 2);
            }
            reportParams.put("basNos", basNos);
            reportParams.put("totalAmount", totalAmount.setScale(2, 6));
            reportParams.put("totalAmountWords", NumberUtil.amountInWords((BigDecimal)totalAmount));
            reportInput = new ReportRequest(LINEESTIMATEPDF, (Collection)lineEstimate.getLineEstimateDetails(), reportParams);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=LineEstimate.pdf");
        reportOutput = this.reportService.createReport(reportInput);
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

