/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.lineestimate;

import javax.servlet.http.HttpServletRequest;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationException;
import org.egov.works.lineestimate.entity.LineEstimate;
import org.egov.works.lineestimate.entity.LineEstimateSearchRequest;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/lineestimate"})
public class CancelLineEstimateController {
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;

    @RequestMapping(value={"/cancel/search"}, method={RequestMethod.GET})
    public String showSearchLetterOfAcceptanceForm(@ModelAttribute LineEstimateSearchRequest lineEstimateSearchRequest, Model model) throws ApplicationException {
        model.addAttribute("departments", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("lineEstimateSearchRequest", (Object)lineEstimateSearchRequest);
        return "searchlineestimate-cancel";
    }

    @RequestMapping(value={"/cancel"}, method={RequestMethod.POST})
    public String cancelLineEstimate(HttpServletRequest request, Model model) throws ApplicationException {
        Long lineEstimateId = Long.parseLong(request.getParameter("id"));
        String cancellationReason = request.getParameter("cancellationReason");
        String cancellationRemarks = request.getParameter("cancellationRemarks");
        LineEstimate lineEstimate = this.lineEstimateService.getLineEstimateById(lineEstimateId);
        String loaNumbers = this.lineEstimateService.checkIfLOAsCreated(lineEstimate.getId());
        if (!loaNumbers.equals("")) {
            String message = this.messageSource.getMessage("error.lineestimate.loa.created", (Object[])new String[]{loaNumbers}, null);
            model.addAttribute("errorMessage", (Object)message);
            return "letterofacceptance-success";
        }
        lineEstimate.setCancellationReason(cancellationReason);
        lineEstimate.setCancellationRemarks(cancellationRemarks);
        lineEstimate = this.lineEstimateService.cancel(lineEstimate);
        model.addAttribute("lineEstimate", (Object)lineEstimate);
        model.addAttribute("mode", (Object)"cancel");
        return "lineestimate-success";
    }
}

