/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.letterofacceptance;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.web.utils.WebUtils;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.models.workorder.WorkOrder;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/letterofacceptance"})
public class LetterOfAcceptancePDFController {
    @Autowired
    private ReportService reportService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;
    public static final String LETTEROFACCEPTANCEPDF = "letterOfAcceptancePDF";
    private final Map<String, Object> reportParams = new HashMap();
    private ReportRequest reportInput = null;
    private ReportOutput reportOutput = null;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;

    @RequestMapping(value={"/letterOfAcceptancePDF/{letterOfAcceptanceId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateLineEstimatePDF(HttpServletRequest request, @PathVariable(value="letterOfAcceptanceId") Long id, HttpSession session) throws IOException {
        WorkOrder workOrder = this.letterOfAcceptanceService.getWorkOrderById(id);
        return this.generateReport(workOrder, request, session);
    }

    private ResponseEntity<byte[]> generateReport(WorkOrder workOrder, HttpServletRequest request, HttpSession session) {
        if (workOrder != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            DecimalFormat df = new DecimalFormat("0.00");
            LineEstimateDetails lineEstimateDetails = this.lineEstimateService.findByEstimateNumber(workOrder.getEstimateNumber());
            String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
            this.reportParams.put("cityLogo", url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo")));
            String cityName = (String)request.getSession().getAttribute("citymunicipalityname");
            this.reportParams.put("cityName", cityName);
            this.reportParams.put("workOrderNumber", workOrder.getWorkOrderNumber() != null ? workOrder.getWorkOrderNumber() : "");
            this.reportParams.put("workOrderDate", workOrder.getWorkOrderDate() != null ? formatter.format(workOrder.getWorkOrderDate()) : "");
            this.reportParams.put("contractorName", workOrder.getContractor().getName() != null ? workOrder.getContractor().getName() : "");
            this.reportParams.put("contractorAddress", workOrder.getContractor().getBankaccount() != null ? workOrder.getContractor().getCorrespondenceAddress() : "");
            this.reportParams.put("panNo", workOrder.getContractor().getPanNumber() != null ? workOrder.getContractor().getPanNumber() : "");
            this.reportParams.put("bank", workOrder.getContractor().getBank() != null ? workOrder.getContractor().getBank().getName() : "");
            this.reportParams.put("accountNo", workOrder.getContractor().getBankaccount() != null ? workOrder.getContractor().getBankaccount() : "");
            this.reportParams.put("subject", lineEstimateDetails.getNameOfWork());
            this.reportParams.put("modeOfAllotment", lineEstimateDetails.getLineEstimate().getModeOfAllotment());
            this.reportParams.put("agreementAmount", df.format(workOrder.getWorkOrderAmount()));
            this.reportParams.put("emd", df.format(workOrder.getEmdAmountDeposited()));
            this.reportParams.put("asd", df.format(workOrder.getSecurityDeposit()));
            this.reportParams.put("WINCode", lineEstimateDetails.getProjectCode().getCode());
            this.reportParams.put("amountOfEstimate", lineEstimateDetails.getActualEstimateAmount().setScale(2, 6));
            this.reportParams.put("headOfAccount", lineEstimateDetails.getLineEstimate().getBudgetHead().getName());
            this.reportParams.put("ward", lineEstimateDetails.getLineEstimate().getWard().getName());
            String technicalSanctionByDesignation = this.worksUtils.getUserDesignation(lineEstimateDetails.getLineEstimate().getTechnicalSanctionBy());
            this.reportParams.put("technicalSanctionByDesignation", technicalSanctionByDesignation);
            this.reportInput = new ReportRequest(LETTEROFACCEPTANCEPDF, (Object)workOrder.getContractor(), this.reportParams);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=LetterOfAcceptance.pdf");
        this.reportOutput = this.reportService.createReport(this.reportInput);
        return new ResponseEntity((Object)this.reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

