/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.dashboard;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.egov.works.elasticsearch.model.WorksIndexsRequest;
import org.egov.works.elasticsearch.model.WorksMilestoneIndexResponse;
import org.egov.works.elasticsearch.service.WorksMilestoneIndexService;
import org.egov.works.elasticsearch.service.WorksTransactionIndexService;
import org.egov.works.web.adaptor.WorksMilestoneIndexJsonAdaptor;
import org.egov.works.web.adaptor.WorksTransactionIndexJsonAdaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/public/worksdashboard"})
public class StateLevelDashboardController {
    private static final Logger LOGGER = LoggerFactory.getLogger(StateLevelDashboardController.class);
    @Autowired
    private WorksMilestoneIndexService worksMilestoneIndexService;
    @Autowired
    private WorksTransactionIndexService worksTransactionIndexService;
    @Autowired
    private WorksMilestoneIndexJsonAdaptor worksMilestoneIndexJsonAdaptor;
    @Autowired
    private WorksTransactionIndexJsonAdaptor worksTransactionIndexJsonAdaptor;

    @RequestMapping(value={"/statewisetypeofwork"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getStateWiseTypeOfWorkDetails() throws IOException {
        WorksIndexsRequest worksIndexsRequest = new WorksIndexsRequest();
        Long startTime = System.currentTimeMillis();
        worksIndexsRequest.setReportType("SECTOR");
        List resultList = this.worksMilestoneIndexService.getAggregationResults(worksIndexsRequest, "lineestimatetypeofworkname");
        String result = "{ \"data\":" + this.toMilestoneJson((Object)resultList) + "}";
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve getStateWiseTypeOfWorkDetails is : " + timeTaken + " (millisecs)");
        }
        return result;
    }

    @RequestMapping(value={"/districtwise-bytypeofwork"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getDistrictWiseByTypeOfWork(@RequestParam(value="typeofwork") String typeofwork) throws IOException {
        WorksIndexsRequest worksIndexsRequest = new WorksIndexsRequest();
        worksIndexsRequest.setTypeofwork(typeofwork);
        worksIndexsRequest.setReportType("District Name");
        Long startTime = System.currentTimeMillis();
        List resultList = this.worksMilestoneIndexService.getAggregationResults(worksIndexsRequest, "distname");
        String result = "{ \"data\":" + this.toMilestoneJson((Object)resultList) + "}";
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve getDistrictWiseDistrictDetails is : " + timeTaken + " (millisecs)");
        }
        return result;
    }

    @RequestMapping(value={"/ulbwise-bytypeofwork"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getUlbWiseByTypeOfWork(@RequestParam(value="typeofwork") String typeofwork) throws IOException {
        WorksIndexsRequest worksIndexsRequest = new WorksIndexsRequest();
        worksIndexsRequest.setTypeofwork(typeofwork);
        worksIndexsRequest.setReportType("ULB Name");
        Long startTime = System.currentTimeMillis();
        List resultList = this.worksMilestoneIndexService.getAggregationResults(worksIndexsRequest, "ulbname");
        String result = "{ \"data\":" + this.toMilestoneJson((Object)resultList) + "}";
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve getUlbWiseDistrictDetails is : " + timeTaken + " (millisecs)");
        }
        return result;
    }

    @RequestMapping(value={"/ulbwise-bydistrictandtypeofwork"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getUlbWiseByDistrictAndTypeOfWork(@RequestParam(value="typeofwork") String typeofwork, @RequestParam(value="districtname") String districtname) throws IOException {
        WorksIndexsRequest worksIndexsRequest = new WorksIndexsRequest();
        worksIndexsRequest.setTypeofwork(typeofwork);
        worksIndexsRequest.setDistname(districtname);
        worksIndexsRequest.setReportType("ULB Name");
        Long startTime = System.currentTimeMillis();
        List resultList = this.worksMilestoneIndexService.getAggregationResults(worksIndexsRequest, "ulbname");
        String result = "{ \"data\":" + this.toMilestoneJson((Object)resultList) + "}";
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve getUlbWiseByDistrictAndTypeOfWork is : " + timeTaken + " (millisecs)");
        }
        return result;
    }

    @RequestMapping(value={"/ulbwise-bytypeofworkandulbs"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getUlbWiseByTypeOfWorkAndUlbs(@RequestParam(value="typeofwork") String typeofwork, @RequestParam(value="ulbcodes") String ulbcodes) throws IOException {
        WorksIndexsRequest worksIndexsRequest = new WorksIndexsRequest();
        worksIndexsRequest.setTypeofwork(typeofwork);
        worksIndexsRequest.setUlbcodes(Arrays.asList(ulbcodes.split(",")));
        worksIndexsRequest.setReportType("ULB Name");
        Long startTime = System.currentTimeMillis();
        List resultList = this.worksMilestoneIndexService.getAggregationResults(worksIndexsRequest, "ulbname");
        String result = "{ \"data\":" + this.toMilestoneJson((Object)resultList) + "}";
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve getUlbWiseByTypeOfWorkAndUlbs is : " + timeTaken + " (millisecs)");
        }
        return result;
    }

    @RequestMapping(value={"/statewiseulb"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getStateWiseULBDetails(@RequestParam(value="typeofwork") String typeofwork, @RequestParam(value="ulbname") String ulbname) throws IOException {
        WorksIndexsRequest worksIndexsRequest = new WorksIndexsRequest();
        Long startTime = System.currentTimeMillis();
        worksIndexsRequest.setTypeofwork(typeofwork);
        worksIndexsRequest.setUlbname(ulbname);
        List resultList = this.worksTransactionIndexService.getWorksTransactionDetails(worksIndexsRequest);
        for (WorksMilestoneIndexResponse response : resultList) {
            worksIndexsRequest = new WorksIndexsRequest();
            worksIndexsRequest.setUlbname(ulbname);
            worksIndexsRequest.setLineestimatedetailid(response.getLineestimatedetailid());
            this.worksTransactionIndexService.getAggregationResults(worksIndexsRequest, response, "lineestimatedetailid");
            this.worksMilestoneIndexService.getAggregationResultsForUlb(worksIndexsRequest, response, "lineestimatedetailid");
        }
        String result = "{ \"data\":" + this.toTransactionJson((Object)resultList) + "}";
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve getStateWiseULBDetails is : " + timeTaken + " (millisecs)");
        }
        return result;
    }

    public Object toMilestoneJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(WorksMilestoneIndexResponse.class, (Object)this.worksMilestoneIndexJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    public Object toTransactionJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(WorksMilestoneIndexResponse.class, (Object)this.worksTransactionIndexJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }
}

