/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.contractorbill;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.model.bills.EgBilldetails;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.contractorbill.entity.enums.BillTypes;
import org.egov.works.contractorbill.service.ContractorBillRegisterService;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.mb.service.MBHeaderService;
import org.egov.works.models.measurementbook.MBHeader;
import org.egov.works.models.workorder.WorkOrder;
import org.egov.works.utils.WorksConstants;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/contractorbill"})
public class UpdateContractorBillController
extends GenericWorkFlowController {
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private ContractorBillRegisterService contractorBillRegisterService;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    @Autowired
    private MBHeaderService mbHeaderService;

    @ModelAttribute
    public ContractorBillRegister getContractorBillRegister(@PathVariable String contractorBillRegisterId) {
        ContractorBillRegister contractorBillRegister = this.contractorBillRegisterService.getContractorBillById(Long.valueOf(Long.parseLong(contractorBillRegisterId)));
        return contractorBillRegister;
    }

    @RequestMapping(value={"/update/{contractorBillRegisterId}"}, method={RequestMethod.GET})
    public String updateContractorBillRegister(Model model, @PathVariable String contractorBillRegisterId, HttpServletRequest request) throws ApplicationException {
        ContractorBillRegister contractorBillRegister = this.getContractorBillRegister(contractorBillRegisterId);
        this.setDropDownValues(model);
        model.addAttribute("createdbybydesignation", (Object)this.worksUtils.getUserDesignation(contractorBillRegister.getCreatedBy()));
        return this.loadViewData(model, request, contractorBillRegister);
    }

    @RequestMapping(value={"/update/{contractorBillRegisterId}"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute(value="contractorBillRegister") ContractorBillRegister contractorBillRegister, BindingResult errors, RedirectAttributes redirectAttributes, Model model, HttpServletRequest request, @RequestParam(value="file") MultipartFile[] files) throws ApplicationException, IOException {
        String mode = "";
        String workFlowAction = "";
        ContractorBillRegister updatedContractorBillRegister = null;
        if (request.getParameter("mode") != null) {
            mode = request.getParameter("mode");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if (approvalPosition == null || approvalPosition.equals(0L)) {
            approvalPosition = this.contractorBillRegisterService.getApprovalPositionByMatrixDesignation(contractorBillRegister, approvalPosition, null, mode, workFlowAction);
        }
        if ((approvalPosition == null || approvalPosition.equals(0L)) && request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        try {
            if (contractorBillRegister.getStatus().getCode().equals(ContractorBillRegister.BillStatus.REJECTED.toString()) && workFlowAction.equals(WorksConstants.FORWARD_ACTION)) {
                this.contractorBillRegisterService.checkBudgetAndGenerateBANumber(contractorBillRegister);
            }
        }
        catch (ValidationException e) {
            throw new ApplicationRuntimeException("error.contractorbill.budgetcheck.insufficient.amount");
        }
        if (contractorBillRegister.getStatus().getCode().equals(ContractorBillRegister.BillStatus.REJECTED.toString()) && workFlowAction.equals(WorksConstants.FORWARD_ACTION) && mode.equals("edit")) {
            WorkOrder workOrder = contractorBillRegister.getWorkOrder();
            LineEstimateDetails lineEstimateDetails = this.lineEstimateService.findByEstimateNumber(workOrder.getEstimateNumber());
            this.validateInput(contractorBillRegister, lineEstimateDetails, errors, request);
            contractorBillRegister.getEgBilldetailes().clear();
            contractorBillRegister = this.addBillDetails(contractorBillRegister, lineEstimateDetails, errors, request);
            contractorBillRegister.setPassedamount(contractorBillRegister.getBillamount());
            if (!this.contractorBillRegisterService.checkForDuplicateAccountCodes(contractorBillRegister)) {
                errors.reject("error.contractorbill.duplicate.accountcodes", "error.contractorbill.duplicate.accountcodes");
            }
            if (!this.contractorBillRegisterService.validateDuplicateRefundAccountCodes(contractorBillRegister)) {
                errors.reject("error.contractorbill.duplicate.refund.accountcodes", "error.contractorbill.duplicate.refund.accountcodes");
            }
            this.contractorBillRegisterService.validateTotalDebitAndCreditAmount(contractorBillRegister, errors);
            this.contractorBillRegisterService.validateRefundAmount(contractorBillRegister, errors);
            this.contractorBillRegisterService.validateMileStonePercentage(contractorBillRegister, errors);
        }
        if (errors.hasErrors()) {
            this.setDropDownValues(model);
            return this.loadViewData(model, request, contractorBillRegister);
        }
        if (null != workFlowAction) {
            updatedContractorBillRegister = this.contractorBillRegisterService.updateContractorBillRegister(contractorBillRegister, approvalPosition, approvalComment, null, workFlowAction, mode, files);
        }
        redirectAttributes.addFlashAttribute("contractorBillRegister", updatedContractorBillRegister);
        String pathVars = this.worksUtils.getPathVars(updatedContractorBillRegister.getStatus(), updatedContractorBillRegister.getState(), updatedContractorBillRegister.getId(), approvalPosition);
        return "redirect:/contractorbill/contractorbill-success?pathVars=" + pathVars + "&billNumber=" + updatedContractorBillRegister.getBillnumber();
    }

    private void validateInput(ContractorBillRegister contractorBillRegister, LineEstimateDetails lineEstimateDetails, BindingResult resultBinder, HttpServletRequest request) {
        BigDecimal totalBillAmountIncludingCurrentBill = contractorBillRegister.getBillamount();
        BigDecimal totalBillAmount = this.contractorBillRegisterService.getTotalBillAmountByWorkOrderAndNotContractorBillRegister(contractorBillRegister.getWorkOrder(), contractorBillRegister.getId());
        if (totalBillAmount != null) {
            totalBillAmountIncludingCurrentBill = totalBillAmountIncludingCurrentBill.add(totalBillAmount);
        }
        if (lineEstimateDetails.getLineEstimate().isBillsCreated() && lineEstimateDetails.getGrossAmountBilled() != null) {
            totalBillAmountIncludingCurrentBill = totalBillAmountIncludingCurrentBill.add(lineEstimateDetails.getGrossAmountBilled());
        }
        if (totalBillAmountIncludingCurrentBill.doubleValue() > contractorBillRegister.getWorkOrder().getWorkOrderAmount()) {
            resultBinder.reject("error.contractorbill.totalbillamount.exceeds.workorderamount", (Object[])new String[]{String.valueOf(totalBillAmountIncludingCurrentBill), String.valueOf(contractorBillRegister.getWorkOrder().getWorkOrderAmount())}, null);
        }
        if (StringUtils.isBlank((CharSequence)contractorBillRegister.getBilltype())) {
            resultBinder.rejectValue("billtype", "error.billtype.required");
        }
        if (contractorBillRegister.getEgBillregistermis() != null && contractorBillRegister.getEgBillregistermis().getPartyBillDate() != null && contractorBillRegister.getEgBillregistermis().getPartyBillDate().before(contractorBillRegister.getWorkOrder().getWorkOrderDate())) {
            resultBinder.rejectValue("egBillregistermis.partyBillDate", "error.validate.partybilldate.lessthan.loadate");
        }
        if (contractorBillRegister.getMbHeader() != null) {
            if (StringUtils.isBlank((CharSequence)contractorBillRegister.getMbHeader().getMbRefNo())) {
                resultBinder.rejectValue("mbHeader.mbRefNo", "error.mbrefno.required");
            }
            if (contractorBillRegister.getMbHeader().getMbDate() == null) {
                resultBinder.rejectValue("mbHeader.mbDate", "error.mbdate.required");
            }
            if (contractorBillRegister.getMbHeader().getFromPageNo() == null) {
                resultBinder.rejectValue("mbHeader.fromPageNo", "error.frompageno.required");
            }
            if (contractorBillRegister.getMbHeader().getToPageNo() == null) {
                resultBinder.rejectValue("mbHeader.toPageNo", "error.topageno.required");
            }
            if (contractorBillRegister.getMbHeader().getFromPageNo() == 0 || contractorBillRegister.getMbHeader().getToPageNo() == 0) {
                resultBinder.reject("error.validate.mb.pagenumbers.zero", "error.validate.mb.pagenumbers.zero");
            }
            if (contractorBillRegister.getMbHeader().getFromPageNo() != null && contractorBillRegister.getMbHeader().getToPageNo() != null && contractorBillRegister.getMbHeader().getFromPageNo() > contractorBillRegister.getMbHeader().getToPageNo()) {
                resultBinder.reject("error.validate.mb.frompagenumber.greaterthan.topagenumber", "error.validate.mb.frompagenumber.greaterthan.topagenumber");
            }
            if (contractorBillRegister.getMbHeader().getMbDate() != null && contractorBillRegister.getMbHeader().getMbDate().before(contractorBillRegister.getWorkOrder().getWorkOrderDate())) {
                resultBinder.rejectValue("mbHeader.mbDate", "error.validate.mbdate.lessthan.loadate");
            }
        }
        if (StringUtils.isBlank((CharSequence)request.getParameter("netPayableAccountCode"))) {
            resultBinder.reject("error.netpayable.accountcode.required", "error.netpayable.accountcode.required");
        }
        if (StringUtils.isBlank((CharSequence)request.getParameter("netPayableAmount")) || Double.valueOf(request.getParameter("netPayableAmount").toString()) <= 0.0) {
            resultBinder.reject("error.netpayable.amount.required", "error.netpayable.amount.required");
        }
        if (contractorBillRegister.getBilltype().equals(BillTypes.Final_Bill.toString()) && contractorBillRegister.getWorkOrderEstimate().getWorkCompletionDate() == null) {
            resultBinder.rejectValue("workOrderEstimate.workCompletionDate", "error.workcompletiondate.required");
        }
        Date currentDate = new Date();
        Date workCompletionDate = contractorBillRegister.getWorkOrderEstimate().getWorkCompletionDate();
        if (workCompletionDate != null) {
            if (workCompletionDate.after(currentDate)) {
                resultBinder.rejectValue("workOrderEstimate.workCompletionDate", "error.workcompletiondate.futuredate");
            }
            if (workCompletionDate.before(contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getWorkOrderDate())) {
                resultBinder.rejectValue("workOrderEstimate.workCompletionDate", "error.workcompletiondate.workorderdate");
            }
            if (workCompletionDate.after(contractorBillRegister.getBilldate())) {
                resultBinder.rejectValue("workOrderEstimate.workCompletionDate", "error.workcompletiondate.billdate");
            }
        }
    }

    private void setDropDownValues(Model model) {
        List contractorPayableAccountList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurposeName("Creditors-Contractor Payable");
        List contractorRefundAccountList = this.chartOfAccountsHibernateDAO.getAccountCodeByListOfPurposeName(WorksConstants.CONTRACTOR_REFUND_PURPOSE);
        model.addAttribute("netPayableAccounCodes", (Object)contractorPayableAccountList);
        model.addAttribute("refundAccounCodes", (Object)contractorRefundAccountList);
        model.addAttribute("billTypes", (Object)BillTypes.values());
    }

    private String loadViewData(Model model, HttpServletRequest request, ContractorBillRegister contractorBillRegister) {
        model.addAttribute("stateType", (Object)contractorBillRegister.getClass().getSimpleName());
        if (contractorBillRegister.getState() != null) {
            model.addAttribute("currentState", (Object)contractorBillRegister.getState().getValue());
        }
        this.prepareWorkflow(model, (StateAware)contractorBillRegister, new WorkflowContainer());
        if (contractorBillRegister.getState() != null && contractorBillRegister.getState().getValue().equals("Rejected")) {
            model.addAttribute("mode", (Object)"edit");
        } else {
            model.addAttribute("mode", (Object)"view");
        }
        model.addAttribute("billDetailsMap", (Object)this.contractorBillRegisterService.getBillDetailsMap(contractorBillRegister, model));
        model.addAttribute("workflowHistory", (Object)this.lineEstimateService.getHistory(contractorBillRegister.getState(), contractorBillRegister.getStateHistory()));
        model.addAttribute("approvalDepartmentList", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("approvalDesignation", (Object)request.getParameter("approvalDesignation"));
        model.addAttribute("approvalPosition", (Object)request.getParameter("approvalPosition"));
        WorkOrder workOrder = contractorBillRegister.getWorkOrder();
        LineEstimateDetails lineEstimateDetails = this.lineEstimateService.findByEstimateNumber(workOrder.getEstimateNumber());
        model.addAttribute("lineEstimateDetails", (Object)lineEstimateDetails);
        model.addAttribute("workOrder", (Object)workOrder);
        ContractorBillRegister newcontractorBillRegister = this.getContractorBillDocuments(contractorBillRegister);
        model.addAttribute("contractorBillRegister", (Object)newcontractorBillRegister);
        List mbHeaders = this.mbHeaderService.getMBHeadersByContractorBill(newcontractorBillRegister);
        if (mbHeaders != null && !mbHeaders.isEmpty()) {
            newcontractorBillRegister.setMbHeader((MBHeader)mbHeaders.get(0));
        }
        return "contractorBill-update";
    }

    private ContractorBillRegister getContractorBillDocuments(ContractorBillRegister contractorBillRegister) {
        List documentDetailsList = new ArrayList();
        documentDetailsList = this.worksUtils.findByObjectIdAndObjectType(contractorBillRegister.getId(), "CONTRACTORBILL");
        contractorBillRegister.setDocumentDetails(documentDetailsList);
        return contractorBillRegister;
    }

    @RequestMapping(value={"/view/{contractorBillRegisterId}"}, method={RequestMethod.GET})
    public String viewContractorBillRegister(Model model, @PathVariable String contractorBillRegisterId, HttpServletRequest request) throws ApplicationException {
        ContractorBillRegister contractorBillRegister = this.getContractorBillRegister(contractorBillRegisterId);
        String responsePage = this.loadViewData(model, request, contractorBillRegister);
        model.addAttribute("createdbybydesignation", (Object)this.worksUtils.getUserDesignation(contractorBillRegister.getCreatedBy()));
        model.addAttribute("mode", (Object)"readOnly");
        return responsePage;
    }

    private ContractorBillRegister addBillDetails(ContractorBillRegister contractorBillRegister, LineEstimateDetails lineEstimateDetails, BindingResult resultBinder, HttpServletRequest request) {
        if (contractorBillRegister.getBillDetailes() == null || contractorBillRegister.getBillDetailes().isEmpty()) {
            resultBinder.reject("error.contractorbill.accountdetails.required", "error.contractorbill.accountdetails.required");
        }
        for (EgBilldetails egBilldetails : contractorBillRegister.getBillDetailes()) {
            if (!contractorBillRegister.getEgBilldetailes().isEmpty() && contractorBillRegister.getEgBilldetailes().size() == 1) {
                for (EgBilldetails refundBill : contractorBillRegister.getRefundBillDetails()) {
                    if (refundBill.getGlcodeid() == null) continue;
                    contractorBillRegister.addEgBilldetailes(this.contractorBillRegisterService.getBillDetails(contractorBillRegister, refundBill, lineEstimateDetails, resultBinder, request));
                }
                if (egBilldetails.getGlcodeid() == null) continue;
                contractorBillRegister.addEgBilldetailes(this.contractorBillRegisterService.getBillDetails(contractorBillRegister, egBilldetails, lineEstimateDetails, resultBinder, request));
                continue;
            }
            if (egBilldetails.getGlcodeid() == null) continue;
            contractorBillRegister.addEgBilldetailes(this.contractorBillRegisterService.getBillDetails(contractorBillRegister, egBilldetails, lineEstimateDetails, resultBinder, request));
        }
        this.contractorBillRegisterService.validateZeroCreditAndDebitAmount(contractorBillRegister, resultBinder);
        String netPayableAccountId = request.getParameter("netPayableAccountId");
        String netPayableAccountCodeId = request.getParameter("netPayableAccountCode");
        String netPayableAmount = request.getParameter("netPayableAmount");
        if (StringUtils.isNotBlank((CharSequence)netPayableAccountCodeId) && StringUtils.isNotBlank((CharSequence)netPayableAccountCodeId) && StringUtils.isNotBlank((CharSequence)netPayableAmount)) {
            EgBilldetails billdetails = new EgBilldetails();
            billdetails.setId(new Integer(netPayableAccountId));
            billdetails.setGlcodeid(new BigDecimal(netPayableAccountCodeId));
            billdetails.setCreditamount(new BigDecimal(netPayableAmount));
            contractorBillRegister.addEgBilldetailes(this.contractorBillRegisterService.getBillDetails(contractorBillRegister, billdetails, lineEstimateDetails, resultBinder, request));
        }
        return contractorBillRegister;
    }
}

