/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.contractorbill;

import java.util.List;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.contractorbill.entity.SearchRequestContractorBill;
import org.egov.works.contractorbill.entity.enums.BillTypes;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/contractorbill"})
public class SearchContractorBillController {
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private SecurityUtils securityUtils;

    @RequestMapping(value={"/searchcontractorform"}, method={RequestMethod.GET})
    public String showSearchContractorBill(@ModelAttribute SearchRequestContractorBill searchRequestContractorBill, Model model) throws ApplicationException {
        this.setDropDownValues(model);
        List departments = this.lineEstimateService.getUserDepartments(this.securityUtils.getCurrentUser());
        if (departments != null && !departments.isEmpty()) {
            searchRequestContractorBill.setDepartment(((Department)departments.get(0)).getId());
        }
        model.addAttribute("searchRequestContractorBill", (Object)searchRequestContractorBill);
        return "searchcontractorbill-search";
    }

    private void setDropDownValues(Model model) {
        model.addAttribute("billTypes", (Object)BillTypes.values());
        model.addAttribute("billStatus", (Object)ContractorBillRegister.BillStatus.values());
        model.addAttribute("departments", (Object)this.departmentService.getAllDepartments());
    }
}

