/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.contractorbill;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.NumberUtil;
import org.egov.infra.web.utils.WebUtils;
import org.egov.model.bills.EgBilldetails;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.contractorbill.service.ContractorBillRegisterService;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.mb.service.MBHeaderService;
import org.egov.works.models.measurementbook.MBHeader;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/contractorbill"})
public class ContractorBillPDFController {
    @Autowired
    private ReportService reportService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private ContractorBillRegisterService contractorBillRegisterService;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    @Autowired
    private MBHeaderService mbHeaderService;
    public static final String CONTRACTORBILLPDF = "ContractorBillPDF";
    private final Map<String, Object> reportParams = new HashMap();
    private ReportRequest reportInput = null;
    private ReportOutput reportOutput = null;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;

    @RequestMapping(value={"/contractorbillPDF/{contractorBillId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateContractorBillPDF(HttpServletRequest request, @PathVariable(value="contractorBillId") Long id, HttpSession session) throws IOException {
        ContractorBillRegister contractorBillRegister = this.contractorBillRegisterService.getContractorBillById(id);
        return this.generateReport(contractorBillRegister, request, session);
    }

    private ResponseEntity<byte[]> generateReport(ContractorBillRegister contractorBillRegister, HttpServletRequest request, HttpSession session) {
        if (contractorBillRegister != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm a");
            new DecimalFormat("#.##");
            LineEstimateDetails lineEstimateDetails = this.lineEstimateService.findByEstimateNumber(contractorBillRegister.getWorkOrder().getEstimateNumber());
            String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
            this.reportParams.put("cityLogo", url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo")));
            String cityName = (String)request.getSession().getAttribute("citymunicipalityname");
            this.reportParams.put("cityName", cityName);
            this.reportParams.put("contractorName", contractorBillRegister.getWorkOrder().getContractor().getName() != null ? contractorBillRegister.getWorkOrder().getContractor().getName() : "");
            this.reportParams.put("contractorCode", contractorBillRegister.getWorkOrder().getContractor().getCode() != null ? contractorBillRegister.getWorkOrder().getContractor().getCode() : "");
            this.reportParams.put("bankAcc", contractorBillRegister.getWorkOrder().getContractor().getBank() != null ? contractorBillRegister.getWorkOrder().getContractor().getBankaccount() : "N/A");
            this.reportParams.put("panNo", !contractorBillRegister.getWorkOrder().getContractor().getPanNumber().isEmpty() ? contractorBillRegister.getWorkOrder().getContractor().getPanNumber() : "N/A");
            this.reportParams.put("billType", contractorBillRegister.getBilltype());
            this.reportParams.put("win", lineEstimateDetails.getProjectCode().getCode());
            this.reportParams.put("billNumber", contractorBillRegister.getBillnumber());
            this.reportParams.put("billDate", formatter.format(contractorBillRegister.getBilldate()));
            this.reportParams.put("billAmount", contractorBillRegister.getBillamount());
            this.reportParams.put("nameOfTheWork", lineEstimateDetails.getNameOfWork());
            this.reportParams.put("ward", lineEstimateDetails.getLineEstimate().getWard().getName());
            this.reportParams.put("department", lineEstimateDetails.getLineEstimate().getExecutingDepartment().getName());
            this.reportParams.put("reportRunDate", sdf.format(new Date()));
            this.reportParams.put("creatorName", contractorBillRegister.getCreatedBy().getName());
            this.reportParams.put("creatorDesignation", this.worksUtils.getUserDesignation(contractorBillRegister.getCreatedBy()));
            this.reportParams.put("approverDesignation", this.worksUtils.getUserDesignation(contractorBillRegister.getApprovedBy()));
            this.reportParams.put("approverName", contractorBillRegister.getApprovedBy().getName());
            List mbHeaders = this.mbHeaderService.getApprovedMBHeadersByContractorBill(contractorBillRegister);
            this.reportParams.put("mbRefNo", mbHeaders != null && !mbHeaders.isEmpty() ? ((MBHeader)mbHeaders.get(0)).getMbRefNo() : "");
            this.reportInput = new ReportRequest(CONTRACTORBILLPDF, (Collection)this.getBillDetailsMap(contractorBillRegister, this.reportParams), this.reportParams);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=ContractorBill.pdf");
        this.reportOutput = this.reportService.createReport(this.reportInput);
        return new ResponseEntity((Object)this.reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    public List<Map<String, Object>> getBillDetailsMap(ContractorBillRegister contractorBillRegister, Map<String, Object> reportParams) {
        ArrayList<Map<String, Object>> billDetailsList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> billDetails = new HashMap<String, Object>();
        BigDecimal creditSum = BigDecimal.ZERO;
        BigDecimal debitSum = BigDecimal.ZERO;
        List contractorPayableAccountList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurposeName("Creditors-Contractor Payable");
        for (EgBilldetails egBilldetails : contractorBillRegister.getEgBilldetailes()) {
            CChartOfAccounts coa;
            if (egBilldetails.getDebitamount() != null) {
                billDetails = new HashMap();
                coa = this.chartOfAccountsHibernateDAO.findById((Number)egBilldetails.getGlcodeid().longValue(), false);
                billDetails.put("glcodeId", coa.getId());
                billDetails.put("glcode", coa.getGlcode());
                billDetails.put("accountHead", coa.getName());
                billDetails.put("amount", egBilldetails.getDebitamount());
                debitSum = debitSum.add(egBilldetails.getDebitamount());
                billDetails.put("isDebit", true);
                billDetails.put("isNetPayable", false);
            } else if (egBilldetails.getCreditamount() != null) {
                billDetails = new HashMap();
                coa = this.chartOfAccountsHibernateDAO.findById((Number)egBilldetails.getGlcodeid().longValue(), false);
                billDetails.put("glcodeId", coa.getId());
                billDetails.put("glcode", coa.getGlcode());
                billDetails.put("accountHead", coa.getName());
                billDetails.put("amount", egBilldetails.getCreditamount());
                billDetails.put("isDebit", false);
                if (contractorPayableAccountList != null && !contractorPayableAccountList.isEmpty() && contractorPayableAccountList.contains(coa)) {
                    billDetails.put("isNetPayable", true);
                } else {
                    billDetails.put("isNetPayable", false);
                    creditSum = creditSum.add(egBilldetails.getCreditamount());
                }
            }
            reportParams.put("debitSum", debitSum);
            reportParams.put("creditSum", creditSum);
            BigDecimal netpayable = BigDecimal.ZERO;
            netpayable = debitSum.subtract(creditSum);
            reportParams.put("netPayable", netpayable);
            reportParams.put("netpayable", netpayable.setScale(2, 6));
            reportParams.put("totalAmountWords", NumberUtil.amountInWords((BigDecimal)netpayable));
            billDetailsList.add(billDetails);
        }
        return billDetailsList;
    }
}

