/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Date;
import org.egov.infra.utils.DateUtils;
import org.egov.works.elasticsearch.model.WorksMilestoneIndexResponse;
import org.joda.time.DateTime;
import org.springframework.stereotype.Component;

@Component
public class WorksTransactionIndexJsonAdaptor
implements JsonSerializer<WorksMilestoneIndexResponse> {
    public JsonElement serialize(WorksMilestoneIndexResponse response, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (response != null) {
            jsonObject.addProperty("Fund", response.getFund());
            if (response.getScheme() != null) {
                jsonObject.addProperty("Scheme", response.getScheme());
            } else {
                jsonObject.addProperty("Scheme", "NA");
            }
            if (response.getSubscheme() != null) {
                jsonObject.addProperty("Sub Scheme", response.getSubscheme());
            } else {
                jsonObject.addProperty("Sub Scheme", "NA");
            }
            jsonObject.addProperty("Ward", response.getWard());
            jsonObject.addProperty("Estimate Number", response.getEstimatenumber());
            jsonObject.addProperty("Work Identification Number", response.getWin());
            jsonObject.addProperty("Name of the work", response.getNameofthework());
            jsonObject.addProperty("Estimated cost in lakhs", BigDecimal.valueOf(response.getTotalestimatedcostinlakhs() / 100000.0).setScale(2, 6).toString());
            jsonObject.addProperty("Agreement Number", response.getAgreementnumber());
            jsonObject.addProperty("Agreement Date", response.getAgreementdate() != null ? DateUtils.getDefaultFormattedDate((Date)response.getAgreementdate()) : "");
            jsonObject.addProperty("Contract Period(in days)", (Number)response.getContractperiod());
            jsonObject.addProperty("Work order value in lakhs", BigDecimal.valueOf(response.getTotalworkordervalueinlakhs() / 100000.0).setScale(2, 6).toString());
            jsonObject.addProperty("Total bill amount in lakhs", BigDecimal.valueOf(response.getTotalbillamountinlakhs() / 100000.0).setScale(2, 6).toString());
            jsonObject.addProperty("Total paid amount in lakhs", BigDecimal.valueOf(response.getTotalpaidamountinlakhs() / 100000.0).setScale(2, 6).toString());
            DateTime currentDate = new DateTime();
            switch (currentDate.getMonthOfYear()) {
                case 1: {
                    this.prepareOctoberData(jsonObject, response);
                    this.prepareNovemberData(jsonObject, response);
                    this.prepareDecemberData(jsonObject, response);
                    if (response.getJan01to15target() != null && !response.getJan01to15target().isNaN()) {
                        jsonObject.addProperty("Jan 01 to 15 target", BigDecimal.valueOf(response.getJan01to15target()).setScale(2, 6).toString());
                    }
                    if (response.getJan01to15actual() != null && !response.getJan01to15actual().isNaN()) {
                        jsonObject.addProperty("Jan 01 to 15 actual", BigDecimal.valueOf(response.getJan01to15actual()).setScale(2, 6).toString());
                    }
                    if (response.getJan01to15variance() != null) {
                        jsonObject.addProperty("Jan 01 to 15 variance", BigDecimal.valueOf(response.getJan01to15variance()).setScale(2, 6).toString());
                    }
                    if (currentDate.getDayOfMonth() > 15) {
                        if (response.getJan16to31target() != null && !response.getJan16to31target().isNaN()) {
                            jsonObject.addProperty("Jan 16 to 31 target", BigDecimal.valueOf(response.getJan16to31target()).setScale(2, 6).toString());
                        }
                        if (response.getJan16to31actual() != null && !response.getJan16to31actual().isNaN()) {
                            jsonObject.addProperty("Jan 16 to 31 actual", BigDecimal.valueOf(response.getJan16to31actual()).setScale(2, 6).toString());
                        }
                        if (response.getJan16to31variance() != null) {
                            jsonObject.addProperty("Jan 16 to 31 variance", BigDecimal.valueOf(response.getJan16to31variance()).setScale(2, 6).toString());
                        }
                        if (response.getJan16to31actual() != null && !response.getJan16to31actual().isNaN()) {
                            if (response.getJan16to31target() != null && !response.getJan16to31target().isNaN() && response.getJan16to31target().compareTo(0.0) == 0) {
                                jsonObject.addProperty("Total % of Balance work", "0.00");
                                break;
                            }
                            jsonObject.addProperty("Total % of Balance work", BigDecimal.valueOf(100.0 - response.getJan16to31actual()).setScale(2, 6).toString());
                            break;
                        }
                        jsonObject.addProperty("Total % of Balance work", "0.00");
                        break;
                    }
                    if (response.getJan01to15actual() != null && !response.getJan01to15actual().isNaN()) {
                        if (response.getJan01to15target() != null && !response.getJan01to15target().isNaN() && response.getJan01to15target().compareTo(0.0) == 0) {
                            jsonObject.addProperty("Total % of Balance work", "0.00");
                            break;
                        }
                        jsonObject.addProperty("Total % of Balance work", BigDecimal.valueOf(100.0 - response.getJan01to15actual()).setScale(2, 6).toString());
                        break;
                    }
                    jsonObject.addProperty("Total % of Balance work", "0.00");
                    break;
                }
                case 2: {
                    this.prepareNovemberData(jsonObject, response);
                    this.prepareDecemberData(jsonObject, response);
                    this.prepareJanuaryData(jsonObject, response);
                    if (response.getFeb01to15target() != null && !response.getFeb01to15target().isNaN()) {
                        jsonObject.addProperty("Feb 01 to 15 target", BigDecimal.valueOf(response.getFeb01to15target()).setScale(2, 6).toString());
                    }
                    if (response.getFeb01to15actual() != null && !response.getFeb01to15actual().isNaN()) {
                        jsonObject.addProperty("Feb 01 to 15 actual", BigDecimal.valueOf(response.getFeb01to15actual()).setScale(2, 6).toString());
                    }
                    if (response.getFeb01to15variance() != null) {
                        jsonObject.addProperty("Feb 01 to 15 variance", BigDecimal.valueOf(response.getFeb01to15variance()).setScale(2, 6).toString());
                    }
                    if (currentDate.getDayOfMonth() > 15) {
                        if (response.getFeb16to28or29target() != null && !response.getFeb16to28or29target().isNaN()) {
                            jsonObject.addProperty("Feb 16 to 28 or 29 target", BigDecimal.valueOf(response.getFeb16to28or29target()).setScale(2, 6).toString());
                        }
                        if (response.getFeb16to28or29actual() != null && !response.getFeb16to28or29actual().isNaN()) {
                            jsonObject.addProperty("Feb 16 to 28 or 29 actual", BigDecimal.valueOf(response.getFeb16to28or29actual()).setScale(2, 6).toString());
                        }
                        if (response.getFeb16to28or29variance() != null) {
                            jsonObject.addProperty("Feb 16 to 28 or 29 variance", BigDecimal.valueOf(response.getFeb16to28or29variance()).setScale(2, 6).toString());
                        }
                        if (response.getFeb16to28or29actual() != null && !response.getFeb16to28or29actual().isNaN()) {
                            if (response.getFeb16to28or29target() != null && !response.getFeb16to28or29target().isNaN() && response.getFeb16to28or29target().compareTo(0.0) == 0) {
                                jsonObject.addProperty("Total % of Balance work", "0.00");
                                break;
                            }
                            jsonObject.addProperty("Total % of Balance work", BigDecimal.valueOf(100.0 - response.getFeb16to28or29actual()).setScale(2, 6).toString());
                            break;
                        }
                        jsonObject.addProperty("Total % of Balance work", "0.00");
                        break;
                    }
                    if (response.getFeb01to15actual() != null && !response.getFeb01to15actual().isNaN()) {
                        if (response.getFeb01to15target() != null && !response.getFeb01to15target().isNaN() && response.getFeb01to15target().compareTo(0.0) == 0) {
                            jsonObject.addProperty("Total % of Balance work", "0.00");
                            break;
                        }
                        jsonObject.addProperty("Total % of Balance work", BigDecimal.valueOf(100.0 - response.getFeb01to15actual()).setScale(2, 6).toString());
                        break;
                    }
                    jsonObject.addProperty("Total % of Balance work", "0.00");
                    break;
                }
                case 3: {
                    this.prepareDecemberData(jsonObject, response);
                    this.prepareJanuaryData(jsonObject, response);
                    this.prepareFebruaryData(jsonObject, response);
                    if (response.getMar01to15target() != null && !response.getMar01to15target().isNaN()) {
                        jsonObject.addProperty("Mar 01 to 15 target", BigDecimal.valueOf(response.getMar01to15target()).setScale(2, 6).toString());
                    }
                    if (response.getMar01to15actual() != null && !response.getMar01to15actual().isNaN()) {
                        jsonObject.addProperty("Mar 01 to 15 actual", BigDecimal.valueOf(response.getMar01to15actual()).setScale(2, 6).toString());
                    }
                    if (response.getMar01to15variance() != null) {
                        jsonObject.addProperty("Mar 01 to 15 variance", BigDecimal.valueOf(response.getMar01to15variance()).setScale(2, 6).toString());
                    }
                    if (currentDate.getDayOfMonth() > 15) {
                        if (response.getMar16to31target() != null && !response.getMar16to31target().isNaN()) {
                            jsonObject.addProperty("Mar 16 to 31 target", BigDecimal.valueOf(response.getMar16to31target()).setScale(2, 6).toString());
                        }
                        if (response.getMar16to31actual() != null && !response.getMar16to31actual().isNaN()) {
                            jsonObject.addProperty("Mar 16 to 31 actual", BigDecimal.valueOf(response.getMar16to31actual()).setScale(2, 6).toString());
                        }
                        if (response.getMar16to31variance() != null) {
                            jsonObject.addProperty("Mar 16 to 31 variance", BigDecimal.valueOf(response.getMar16to31variance()).setScale(2, 6).toString());
                        }
                        if (response.getMar16to31actual() != null && !response.getMar16to31actual().isNaN()) {
                            if (response.getMar16to31target() != null && !response.getMar16to31target().isNaN() && response.getMar16to31target().compareTo(0.0) == 0) {
                                jsonObject.addProperty("Total % of Balance work", "0.00");
                                break;
                            }
                            jsonObject.addProperty("Total % of Balance work", BigDecimal.valueOf(100.0 - response.getMar16to31actual()).setScale(2, 6).toString());
                            break;
                        }
                        jsonObject.addProperty("Total % of Balance work", "0.00");
                        break;
                    }
                    if (response.getMar01to15actual() != null && !response.getMar01to15actual().isNaN()) {
                        if (response.getMar01to15target() != null && !response.getMar01to15target().isNaN() && response.getMar01to15target().compareTo(0.0) == 0) {
                            jsonObject.addProperty("Total % of Balance work", "0.00");
                            break;
                        }
                        jsonObject.addProperty("Total % of Balance work", BigDecimal.valueOf(100.0 - response.getMar01to15actual()).setScale(2, 6).toString());
                        break;
                    }
                    jsonObject.addProperty("Total % of Balance work", "0.00");
                    break;
                }
                case 4: {
                    this.prepareJanuaryData(jsonObject, response);
                    this.prepareFebruaryData(jsonObject, response);
                    this.prepareMarchData(jsonObject, response);
                    if (response.getApr01to15target() != null && !response.getApr01to15target().isNaN()) {
                        jsonObject.addProperty("Apr 01 to 15 target", BigDecimal.valueOf(response.getApr01to15target()).setScale(2, 6).toString());
                    }
                    if (response.getApr01to15actual() != null && !response.getApr01to15actual().isNaN()) {
                        jsonObject.addProperty("Apr 01 to 15 actual", BigDecimal.valueOf(response.getApr01to15actual()).setScale(2, 6).toString());
                    }
                    if (response.getApr01to15variance() != null) {
                        jsonObject.addProperty("Apr 01 to 15 variance", BigDecimal.valueOf(response.getApr01to15variance()).setScale(2, 6).toString());
                    }
                    if (currentDate.getDayOfMonth() > 15) {
                        if (response.getApr16to30target() != null && !response.getApr16to30target().isNaN()) {
                            jsonObject.addProperty("Apr 16 to 30 target", BigDecimal.valueOf(response.getApr16to30target()).setScale(2, 6).toString());
                        }
                        if (response.getApr16to30actual() != null && !response.getApr16to30actual().isNaN()) {
                            jsonObject.addProperty("Apr 16 to 30 actual", BigDecimal.valueOf(response.getApr16to30actual()).setScale(2, 6).toString());
                        }
                        if (response.getApr16to30variance() != null) {
                            jsonObject.addProperty("Apr 16 to 30 variance", BigDecimal.valueOf(response.getApr16to30variance()).setScale(2, 6).toString());
                        }
                        if (response.getApr16to30actual() != null && !response.getApr16to30actual().isNaN()) {
                            if (response.getApr16to30target() != null && !response.getApr16to30target().isNaN() && response.getApr16to30target().compareTo(0.0) == 0) {
                                jsonObject.addProperty("Total % of Balance work", "0.00");
                                break;
                            }
                            jsonObject.addProperty("Total % of Balance work", BigDecimal.valueOf(100.0 - response.getApr16to30actual()).setScale(2, 6).toString());
                            break;
                        }
                        jsonObject.addProperty("Total % of Balance work", "0.00");
                        break;
                    }
                    if (response.getApr01to15actual() != null && !response.getApr01to15actual().isNaN()) {
                        if (response.getApr01to15target() != null && !response.getApr01to15target().isNaN() && response.getApr01to15target().compareTo(0.0) == 0) {
                            jsonObject.addProperty("Total % of Balance work", "0.00");
                            break;
                        }
                        jsonObject.addProperty("Total % of Balance work", BigDecimal.valueOf(100.0 - response.getApr01to15actual()).setScale(2, 6).toString());
                        break;
                    }
                    jsonObject.addProperty("Total % of Balance work", "0.00");
                    break;
                }
                case 5: {
                    this.prepareFebruaryData(jsonObject, response);
                    this.prepareMarchData(jsonObject, response);
                    this.prepareAprilData(jsonObject, response);
                    if (response.getMay01to15target() != null && !response.getMay01to15target().isNaN()) {
                        jsonObject.addProperty("May 01 to 15 target", BigDecimal.valueOf(response.getMay01to15target()).setScale(2, 6).toString());
                    }
                    if (response.getMay01to15actual() != null && !response.getMay01to15actual().isNaN()) {
                        jsonObject.addProperty("May 01 to 15 actual", BigDecimal.valueOf(response.getMay01to15actual()).setScale(2, 6).toString());
                    }
                    if (response.getMay01to15variance() != null) {
                        jsonObject.addProperty("May 01 to 15 variance", BigDecimal.valueOf(response.getMay01to15variance()).setScale(2, 6).toString());
                    }
                    if (currentDate.getDayOfMonth() > 15) {
                        if (response.getMay16to31target() != null && !response.getMay16to31target().isNaN()) {
                            jsonObject.addProperty("May 16 to 31 target", BigDecimal.valueOf(response.getMay16to31target()).setScale(2, 6).toString());
                        }
                        if (response.getMay16to31actual() != null && !response.getMay16to31actual().isNaN()) {
                            jsonObject.addProperty("May 16 to 31 actual", BigDecimal.valueOf(response.getMay16to31actual()).setScale(2, 6).toString());
                        }
                        if (response.getMay16to31variance() != null) {
                            jsonObject.addProperty("May 16 to 31 variance", BigDecimal.valueOf(response.getMay16to31variance()).setScale(2, 6).toString());
                        }
                        if (response.getMay16to31actual() != null && !response.getMay16to31actual().isNaN()) {
                            if (response.getMay16to31target() != null && !response.getMay16to31target().isNaN() && response.getMay16to31target().compareTo(0.0) == 0) {
                                jsonObject.addProperty("Total % of Balance work", "0.00");
                                break;
                            }
                            jsonObject.addProperty("Total % of Balance work", BigDecimal.valueOf(100.0 - response.getMay16to31actual()).setScale(2, 6).toString());
                            break;
                        }
                        jsonObject.addProperty("Total % of Balance work", "0.00");
                        break;
                    }
                    if (response.getMay01to15actual() != null && !response.getMay01to15actual().isNaN()) {
                        if (response.getMay01to15target() != null && !response.getMay01to15target().isNaN() && response.getMay01to15target().compareTo(0.0) == 0) {
                            jsonObject.addProperty("Total % of Balance work", "0.00");
                            break;
                        }
                        jsonObject.addProperty("Total % of Balance work", BigDecimal.valueOf(100.0 - response.getMay01to15actual()).setScale(2, 6).toString());
                        break;
                    }
                    jsonObject.addProperty("Total % of Balance work", "0.00");
                    break;
                }
                case 6: {
                    this.prepareMarchData(jsonObject, response);
                    this.prepareAprilData(jsonObject, response);
                    this.prepareMayData(jsonObject, response);
                    if (response.getJun01to15target() != null && !response.getJun01to15target().isNaN()) {
                        jsonObject.addProperty("Jun 01 to 15 target", BigDecimal.valueOf(response.getJun01to15target()).setScale(2, 6).toString());
                    }
                    if (response.getJun01to15actual() != null && !response.getJun01to15actual().isNaN()) {
                        jsonObject.addProperty("Jun 01 to 15 actual", BigDecimal.valueOf(response.getJun01to15actual()).setScale(2, 6).toString());
                    }
                    if (response.getJun01to15variance() != null) {
                        jsonObject.addProperty("Jun 01 to 15 variance", BigDecimal.valueOf(response.getJun01to15variance()).setScale(2, 6).toString());
                    }
                    if (currentDate.getDayOfMonth() > 15) {
                        if (response.getJun16to30target() != null && !response.getJun16to30target().isNaN()) {
                            jsonObject.addProperty("Jun 16 to 30 target", BigDecimal.valueOf(response.getJun16to30target()).setScale(2, 6).toString());
                        }
                        if (response.getJun16to30actual() != null && !response.getJun16to30actual().isNaN()) {
                            jsonObject.addProperty("Jun 16 to 30 actual", BigDecimal.valueOf(response.getJun16to30actual()).setScale(2, 6).toString());
                        }
                        if (response.getJun16to30variance() != null) {
                            jsonObject.addProperty("Jun 16 to 30 variance", BigDecimal.valueOf(response.getJun16to30variance()).setScale(2, 6).toString());
                        }
                        if (response.getJun16to30actual() != null && !response.getJun16to30actual().isNaN()) {
                            if (response.getJun16to30target() != null && !response.getJun16to30target().isNaN() && response.getJun16to30target().compareTo(0.0) == 0) {
                                jsonObject.addProperty("Total % of Balance work", "0.00");
                                break;
                            }
                            jsonObject.addProperty("Total % of Balance work", BigDecimal.valueOf(100.0 - response.getJun16to30actual()).setScale(2, 6).toString());
                            break;
                        }
                        jsonObject.addProperty("Total % of Balance work", "0.00");
                        break;
                    }
                    if (response.getJun01to15actual() != null && !response.getJun01to15actual().isNaN()) {
                        if (response.getJun01to15target() != null && !response.getJun01to15target().isNaN() && response.getJun01to15target().compareTo(0.0) == 0) {
                            jsonObject.addProperty("Total % of Balance work", "0.00");
                            break;
                        }
                        jsonObject.addProperty("Total % of Balance work", BigDecimal.valueOf(100.0 - response.getJun01to15actual()).setScale(2, 6).toString());
                        break;
                    }
                    jsonObject.addProperty("Total % of Balance work", "0.00");
                    break;
                }
                case 7: {
                    this.prepareAprilData(jsonObject, response);
                    this.prepareMayData(jsonObject, response);
                    this.prepareJuneData(jsonObject, response);
                    if (response.getJul01to15target() != null && !response.getJul01to15target().isNaN()) {
                        jsonObject.addProperty("Jul 01 to 15 target", BigDecimal.valueOf(response.getJul01to15target()).setScale(2, 6).toString());
                    }
                    if (response.getJul01to15actual() != null && !response.getJul01to15actual().isNaN()) {
                        jsonObject.addProperty("Jul 01 to 15 actual", BigDecimal.valueOf(response.getJul01to15actual()).setScale(2, 6).toString());
                    }
                    if (response.getJul01to15variance() != null) {
                        jsonObject.addProperty("Jul 01 to 15 variance", BigDecimal.valueOf(response.getJul01to15variance()).setScale(2, 6).toString());
                    }
                    if (currentDate.getDayOfMonth() > 15) {
                        if (response.getJul16to31target() != null && !response.getJul16to31target().isNaN()) {
                            jsonObject.addProperty("Jul 16 to 31 target", BigDecimal.valueOf(response.getJul16to31target()).setScale(2, 6).toString());
                        }
                        if (response.getJul16to31actual() != null && !response.getJul16to31actual().isNaN()) {
                            jsonObject.addProperty("Jul 16 to 31 actual", BigDecimal.valueOf(response.getJul16to31actual()).setScale(2, 6).toString());
                        }
                        if (response.getJul16to31variance() != null) {
                            jsonObject.addProperty("Jul 16 to 31 variance", BigDecimal.valueOf(response.getJul16to31variance()).setScale(2, 6).toString());
                        }
                        if (response.getJul16to31actual() != null && !response.getJul16to31actual().isNaN()) {
                            if (response.getJul16to31target() != null && !response.getJul16to31target().isNaN() && response.getJul16to31target().compareTo(0.0) == 0) {
                                jsonObject.addProperty("Total % of Balance work", "0.00");
                                break;
                            }
                            jsonObject.addProperty("Total % of Balance work", BigDecimal.valueOf(100.0 - response.getJul16to31actual()).setScale(2, 6).toString());
                            break;
                        }
                        jsonObject.addProperty("Total % of Balance work", "0.00");
                        break;
                    }
                    if (response.getJun01to15actual() != null && !response.getJul01to15actual().isNaN()) {
                        if (response.getJul01to15target() != null && !response.getJul01to15target().isNaN() && response.getJul01to15target().compareTo(0.0) == 0) {
                            jsonObject.addProperty("Total % of Balance work", "0.00");
                            break;
                        }
                        jsonObject.addProperty("Total % of Balance work", BigDecimal.valueOf(100.0 - response.getJul01to15actual()).setScale(2, 6).toString());
                        break;
                    }
                    jsonObject.addProperty("Total % of Balance work", "0.00");
                    break;
                }
                case 8: {
                    this.prepareMayData(jsonObject, response);
                    this.prepareJuneData(jsonObject, response);
                    this.prepareJulyData(jsonObject, response);
                    if (response.getAug01to15target() != null && !response.getAug01to15target().isNaN()) {
                        jsonObject.addProperty("Aug 01 to 15 target", BigDecimal.valueOf(response.getAug01to15target()).setScale(2, 6).toString());
                    }
                    if (response.getAug01to15actual() != null && !response.getAug01to15actual().isNaN()) {
                        jsonObject.addProperty("Aug 01 to 15 actual", BigDecimal.valueOf(response.getAug01to15actual()).setScale(2, 6).toString());
                    }
                    if (response.getAug01to15variance() != null) {
                        jsonObject.addProperty("Aug 01 to 15 variance", BigDecimal.valueOf(response.getAug01to15variance()).setScale(2, 6).toString());
                    }
                    if (currentDate.getDayOfMonth() > 15) {
                        if (response.getAug16to31target() != null && !response.getAug16to31target().isNaN()) {
                            jsonObject.addProperty("Aug 16 to 31 target", BigDecimal.valueOf(response.getAug16to31target()).setScale(2, 6).toString());
                        }
                        if (response.getAug16to31actual() != null && !response.getAug16to31actual().isNaN()) {
                            jsonObject.addProperty("Aug 16 to 31 actual", BigDecimal.valueOf(response.getAug16to31actual()).setScale(2, 6).toString());
                        }
                        if (response.getAug16to31variance() != null) {
                            jsonObject.addProperty("Aug 16 to 31 variance", BigDecimal.valueOf(response.getAug16to31variance()).setScale(2, 6).toString());
                        }
                        if (response.getAug16to31actual() != null && !response.getAug16to31actual().isNaN()) {
                            if (response.getAug16to31target() != null && !response.getAug16to31target().isNaN() && response.getAug16to31target().compareTo(0.0) == 0) {
                                jsonObject.addProperty("Total % of Balance work", "0.00");
                                break;
                            }
                            jsonObject.addProperty("Total % of Balance work", BigDecimal.valueOf(100.0 - response.getAug16to31actual()).setScale(2, 6).toString());
                            break;
                        }
                        jsonObject.addProperty("Total % of Balance work", "0.00");
                        break;
                    }
                    if (response.getAug01to15actual() != null && !response.getAug01to15actual().isNaN()) {
                        if (response.getAug01to15target() != null && !response.getAug01to15target().isNaN() && response.getAug01to15target().compareTo(0.0) == 0) {
                            jsonObject.addProperty("Total % of Balance work", "0.00");
                            break;
                        }
                        jsonObject.addProperty("Total % of Balance work", BigDecimal.valueOf(100.0 - response.getAug01to15actual()).setScale(2, 6).toString());
                        break;
                    }
                    jsonObject.addProperty("Total % of Balance work", "0.00");
                    break;
                }
                case 9: {
                    this.prepareJuneData(jsonObject, response);
                    this.prepareJulyData(jsonObject, response);
                    this.prepareAugustData(jsonObject, response);
                    if (response.getSep01to15target() != null && !response.getSep01to15target().isNaN()) {
                        jsonObject.addProperty("Sep 01 to 15 target", BigDecimal.valueOf(response.getSep01to15target()).setScale(2, 6).toString());
                    }
                    if (response.getSep01to15actual() != null && !response.getSep01to15actual().isNaN()) {
                        jsonObject.addProperty("Sep 01 to 15 actual", BigDecimal.valueOf(response.getSep01to15actual()).setScale(2, 6).toString());
                    }
                    if (response.getSep01to15variance() != null) {
                        jsonObject.addProperty("Sep 01 to 15 variance", BigDecimal.valueOf(response.getSep01to15variance()).setScale(2, 6).toString());
                    }
                    if (currentDate.getDayOfMonth() > 15) {
                        if (response.getSep16to30target() != null && !response.getSep16to30target().isNaN()) {
                            jsonObject.addProperty("Sep 16 to 30 target", BigDecimal.valueOf(response.getSep16to30target()).setScale(2, 6).toString());
                        }
                        if (response.getSep16to30actual() != null && !response.getSep16to30actual().isNaN()) {
                            jsonObject.addProperty("Sep 16 to 30 actual", BigDecimal.valueOf(response.getSep16to30actual()).setScale(2, 6).toString());
                        }
                        if (response.getSep16to30variance() != null) {
                            jsonObject.addProperty("Sep 16 to 30 variance", BigDecimal.valueOf(response.getSep16to30variance()).setScale(2, 6).toString());
                        }
                        if (response.getSep16to30actual() != null && !response.getSep16to30actual().isNaN()) {
                            if (response.getSep16to30target() != null && !response.getSep16to30target().isNaN() && response.getSep16to30target().compareTo(0.0) == 0) {
                                jsonObject.addProperty("Total % of Balance work", "0.00");
                                break;
                            }
                            jsonObject.addProperty("Total % of Balance work", BigDecimal.valueOf(100.0 - response.getSep16to30actual()).setScale(2, 6).toString());
                            break;
                        }
                        jsonObject.addProperty("Total % of Balance work", "0.00");
                        break;
                    }
                    if (response.getSep01to15actual() != null && !response.getSep01to15actual().isNaN()) {
                        if (response.getSep01to15target() != null && !response.getSep01to15target().isNaN() && response.getSep01to15target().compareTo(0.0) == 0) {
                            jsonObject.addProperty("Total % of Balance work", "0.00");
                            break;
                        }
                        jsonObject.addProperty("Total % of Balance work", BigDecimal.valueOf(100.0 - response.getSep01to15actual()).setScale(2, 6).toString());
                        break;
                    }
                    jsonObject.addProperty("Total % of Balance work", "0.00");
                    break;
                }
                case 10: {
                    this.prepareJulyData(jsonObject, response);
                    this.prepareAugustData(jsonObject, response);
                    this.prepareSeptemberData(jsonObject, response);
                    if (response.getOct01to15target() != null && !response.getOct01to15target().isNaN()) {
                        jsonObject.addProperty("Oct 01 to 15 target", BigDecimal.valueOf(response.getOct01to15target()).setScale(2, 6).toString());
                    }
                    if (response.getOct01to15actual() != null && !response.getOct01to15actual().isNaN()) {
                        jsonObject.addProperty("Oct 01 to 15 actual", BigDecimal.valueOf(response.getOct01to15actual()).setScale(2, 6).toString());
                    }
                    if (response.getOct01to15variance() != null) {
                        jsonObject.addProperty("Oct 01 to 15 variance", BigDecimal.valueOf(response.getOct01to15variance()).setScale(2, 6).toString());
                    }
                    if (currentDate.getDayOfMonth() > 15) {
                        if (response.getOct16to31target() != null && !response.getOct16to31target().isNaN()) {
                            jsonObject.addProperty("Oct 16 to 31 target", BigDecimal.valueOf(response.getOct16to31target()).setScale(2, 6).toString());
                        } else {
                            jsonObject.addProperty("Oct 16 to 31 target", "0.00");
                        }
                        if (response.getOct16to31actual() != null && !response.getOct16to31actual().isNaN()) {
                            jsonObject.addProperty("Oct 16 to 31 actual", BigDecimal.valueOf(response.getOct16to31actual()).setScale(2, 6).toString());
                        } else {
                            jsonObject.addProperty("Oct 16 to 31 actual", "0.00");
                        }
                        if (response.getOct16to31variance() != null) {
                            jsonObject.addProperty("Oct 16 to 31 variance", BigDecimal.valueOf(response.getOct16to31variance()).setScale(2, 6).toString());
                        } else {
                            jsonObject.addProperty("Oct 16 to 31 variance", "0.00");
                        }
                        if (response.getOct16to31actual() != null && !response.getOct16to31actual().isNaN()) {
                            if (response.getOct16to31target() != null && !response.getOct16to31target().isNaN() && response.getOct16to31target().compareTo(0.0) == 0) {
                                jsonObject.addProperty("Total % of Balance work", "0.00");
                                break;
                            }
                            jsonObject.addProperty("Total % of Balance work", BigDecimal.valueOf(100.0 - response.getOct16to31actual()).setScale(2, 6).toString());
                            break;
                        }
                        jsonObject.addProperty("Total % of Balance work", "0.00");
                        break;
                    }
                    if (response.getOct01to15actual() != null && !response.getOct01to15actual().isNaN()) {
                        if (response.getOct01to15target() != null && !response.getOct01to15target().isNaN() && response.getOct01to15target().compareTo(0.0) == 0) {
                            jsonObject.addProperty("Total % of Balance work", "0.00");
                            break;
                        }
                        jsonObject.addProperty("Total % of Balance work", BigDecimal.valueOf(100.0 - response.getOct01to15actual()).setScale(2, 6).toString());
                        break;
                    }
                    jsonObject.addProperty("Total % of Balance work", "0.00");
                    break;
                }
                case 11: {
                    this.prepareAugustData(jsonObject, response);
                    this.prepareSeptemberData(jsonObject, response);
                    this.prepareOctoberData(jsonObject, response);
                    if (response.getNov01to15target() != null && !response.getNov01to15target().isNaN()) {
                        jsonObject.addProperty("Nov 01 to 15 target", BigDecimal.valueOf(response.getNov01to15target()).setScale(2, 6).toString());
                    } else {
                        jsonObject.addProperty("Nov 01 to 15 target", "0.00");
                    }
                    if (response.getNov01to15actual() != null && !response.getNov01to15actual().isNaN()) {
                        jsonObject.addProperty("Nov 01 to 15 actual", BigDecimal.valueOf(response.getNov01to15actual()).setScale(2, 6).toString());
                    } else {
                        jsonObject.addProperty("Nov 01 to 15 actual", "0.00");
                    }
                    if (response.getNov01to15variance() != null) {
                        jsonObject.addProperty("Nov 01 to 15 variance", BigDecimal.valueOf(response.getNov01to15variance()).setScale(2, 6).toString());
                    } else {
                        jsonObject.addProperty("Nov 01 to 15 variance", "0.00");
                    }
                    if (currentDate.getDayOfMonth() > 15) {
                        if (response.getNov16to30target() != null && !response.getNov16to30target().isNaN()) {
                            jsonObject.addProperty("Nov 16 to 30 target", BigDecimal.valueOf(response.getNov16to30target()).setScale(2, 6).toString());
                        } else {
                            jsonObject.addProperty("Nov 16 to 30 target", "0.00");
                        }
                        if (response.getNov16to30actual() != null && !response.getNov16to30actual().isNaN()) {
                            jsonObject.addProperty("Nov 16 to 30 actual", BigDecimal.valueOf(response.getNov16to30actual()).setScale(2, 6).toString());
                        } else {
                            jsonObject.addProperty("Nov 16 to 30 actual", "0.00");
                        }
                        if (response.getNov16to30variance() != null) {
                            jsonObject.addProperty("Nov 16 to 30 variance", BigDecimal.valueOf(response.getNov16to30variance()).setScale(2, 6).toString());
                        } else {
                            jsonObject.addProperty("Nov 16 to 30 variance", "0.00");
                        }
                        if (response.getNov16to30actual() != null && !response.getNov16to30actual().isNaN()) {
                            if (response.getNov16to30target() != null && !response.getNov16to30target().isNaN() && response.getNov16to30target().compareTo(0.0) == 0) {
                                jsonObject.addProperty("Total % of Balance work", "0.00");
                                break;
                            }
                            jsonObject.addProperty("Total % of Balance work", BigDecimal.valueOf(100.0 - response.getNov16to30actual()).setScale(2, 6).toString());
                            break;
                        }
                        jsonObject.addProperty("Total % of Balance work", "0.00");
                        break;
                    }
                    if (response.getNov01to15actual() != null && !response.getNov01to15actual().isNaN()) {
                        if (response.getNov01to15target() != null && !response.getNov01to15target().isNaN() && response.getNov01to15target().compareTo(0.0) == 0) {
                            jsonObject.addProperty("Total % of Balance work", "0.00");
                            break;
                        }
                        jsonObject.addProperty("Total % of Balance work", BigDecimal.valueOf(100.0 - response.getNov01to15actual()).setScale(2, 6).toString());
                        break;
                    }
                    jsonObject.addProperty("Total % of Balance work", "0.00");
                    break;
                }
                case 12: {
                    this.prepareSeptemberData(jsonObject, response);
                    this.prepareOctoberData(jsonObject, response);
                    this.prepareNovemberData(jsonObject, response);
                    if (response.getDec01to15target() != null && !response.getDec01to15target().isNaN()) {
                        jsonObject.addProperty("Dec 01 to 15 target", BigDecimal.valueOf(response.getDec01to15target()).setScale(2, 6).toString());
                    }
                    if (response.getDec01to15actual() != null && !response.getDec01to15actual().isNaN()) {
                        jsonObject.addProperty("Dec 01 to 15 actual", BigDecimal.valueOf(response.getDec01to15actual()).setScale(2, 6).toString());
                    }
                    if (response.getDec01to15variance() != null) {
                        jsonObject.addProperty("Dec 01 to 15 variance", BigDecimal.valueOf(response.getDec01to15variance()).setScale(2, 6).toString());
                    }
                    if (currentDate.getDayOfMonth() > 15) {
                        if (response.getDec16to31target() != null && !response.getDec16to31target().isNaN()) {
                            jsonObject.addProperty("Dec 16 to 31 target", BigDecimal.valueOf(response.getDec16to31target()).setScale(2, 6).toString());
                        }
                        if (response.getDec16to31actual() != null && !response.getDec16to31actual().isNaN()) {
                            jsonObject.addProperty("Dec 16 to 31 actual", BigDecimal.valueOf(response.getDec16to31actual()).setScale(2, 6).toString());
                        }
                        if (response.getDec16to31variance() != null) {
                            jsonObject.addProperty("Dec 16 to 31 variance", BigDecimal.valueOf(response.getDec16to31variance()).setScale(2, 6).toString());
                        }
                        if (response.getDec16to31actual() != null && !response.getDec16to31actual().isNaN()) {
                            if (response.getDec16to31target() != null && !response.getDec16to31target().isNaN() && response.getDec16to31target().compareTo(0.0) == 0) {
                                jsonObject.addProperty("Total % of Balance work", "0.00");
                                break;
                            }
                            jsonObject.addProperty("Total % of Balance work", BigDecimal.valueOf(100.0 - response.getDec16to31actual()).setScale(2, 6).toString());
                            break;
                        }
                        jsonObject.addProperty("Total % of Balance work", "0.00");
                        break;
                    }
                    if (response.getDec01to15actual() != null && !response.getDec01to15actual().isNaN()) {
                        if (response.getDec01to15target() != null && !response.getDec01to15target().isNaN() && response.getDec01to15target().compareTo(0.0) == 0) {
                            jsonObject.addProperty("Total % of Balance work", "0.00");
                            break;
                        }
                        jsonObject.addProperty("Total % of Balance work", BigDecimal.valueOf(100.0 - response.getDec01to15actual()).setScale(2, 6).toString());
                        break;
                    }
                    jsonObject.addProperty("Total % of Balance work", "0.00");
                    break;
                }
            }
            jsonObject.addProperty("Financial progress %", BigDecimal.valueOf(response.getFinancialprogress()).setScale(2, 6).toString());
        }
        return jsonObject;
    }

    private void prepareJanuaryData(JsonObject jsonObject, WorksMilestoneIndexResponse response) {
        if (response.getJan01to15target() != null && !response.getJan01to15target().isNaN()) {
            jsonObject.addProperty("Jan 01 to 15 target", BigDecimal.valueOf(response.getJan01to15target()).setScale(2, 6).toString());
        }
        if (response.getJan01to15actual() != null && !response.getJan01to15actual().isNaN()) {
            jsonObject.addProperty("Jan 01 to 15 actual", BigDecimal.valueOf(response.getJan01to15actual()).setScale(2, 6).toString());
        }
        if (response.getJan01to15variance() != null) {
            jsonObject.addProperty("Jan 01 to 15 variance", BigDecimal.valueOf(response.getJan01to15variance()).setScale(2, 6).toString());
        }
        if (response.getJan16to31target() != null && !response.getJan16to31target().isNaN()) {
            jsonObject.addProperty("Jan 16 to 31 target", BigDecimal.valueOf(response.getJan16to31target()).setScale(2, 6).toString());
        }
        if (response.getJan16to31actual() != null && !response.getJan16to31actual().isNaN()) {
            jsonObject.addProperty("Jan 16 to 31 actual", BigDecimal.valueOf(response.getJan16to31actual()).setScale(2, 6).toString());
        }
        if (response.getJan16to31variance() != null) {
            jsonObject.addProperty("Jan 16 to 31 variance", BigDecimal.valueOf(response.getJan16to31variance()).setScale(2, 6).toString());
        }
    }

    private void prepareFebruaryData(JsonObject jsonObject, WorksMilestoneIndexResponse response) {
        if (response.getFeb01to15target() != null && !response.getFeb01to15target().isNaN()) {
            jsonObject.addProperty("Feb 01 to 15 target", BigDecimal.valueOf(response.getFeb01to15target()).setScale(2, 6).toString());
        }
        if (response.getFeb01to15actual() != null && !response.getFeb01to15actual().isNaN()) {
            jsonObject.addProperty("Feb 01 to 15 actual", BigDecimal.valueOf(response.getFeb01to15actual()).setScale(2, 6).toString());
        }
        if (response.getFeb01to15variance() != null) {
            jsonObject.addProperty("Feb 01 to 15 variance", BigDecimal.valueOf(response.getFeb01to15variance()).setScale(2, 6).toString());
        }
        if (response.getFeb16to28or29target() != null && !response.getFeb16to28or29target().isNaN()) {
            jsonObject.addProperty("Feb 16 to 28 or 29 target", BigDecimal.valueOf(response.getFeb16to28or29target()).setScale(2, 6).toString());
        }
        if (response.getFeb16to28or29actual() != null && !response.getFeb16to28or29actual().isNaN()) {
            jsonObject.addProperty("Feb 16 to 28 or 29 actual", BigDecimal.valueOf(response.getFeb16to28or29actual()).setScale(2, 6).toString());
        }
        if (response.getFeb16to28or29variance() != null) {
            jsonObject.addProperty("Feb 16 to 28 or 29 variance", BigDecimal.valueOf(response.getFeb16to28or29variance()).setScale(2, 6).toString());
        }
    }

    private void prepareMarchData(JsonObject jsonObject, WorksMilestoneIndexResponse response) {
        if (response.getMar01to15target() != null && !response.getMar01to15target().isNaN()) {
            jsonObject.addProperty("Mar 01 to 15 target", BigDecimal.valueOf(response.getMar01to15target()).setScale(2, 6).toString());
        }
        if (response.getMar01to15actual() != null && !response.getMar01to15actual().isNaN()) {
            jsonObject.addProperty("Mar 01 to 15 actual", BigDecimal.valueOf(response.getMar01to15actual()).setScale(2, 6).toString());
        }
        if (response.getMar01to15variance() != null) {
            jsonObject.addProperty("Mar 01 to 15 variance", BigDecimal.valueOf(response.getMar01to15variance()).setScale(2, 6).toString());
        }
        if (response.getMar16to31target() != null && !response.getMar16to31target().isNaN()) {
            jsonObject.addProperty("Mar 16 to 31 target", BigDecimal.valueOf(response.getMar16to31target()).setScale(2, 6).toString());
        }
        if (response.getMar16to31actual() != null && !response.getMar16to31actual().isNaN()) {
            jsonObject.addProperty("Mar 16 to 31 actual", BigDecimal.valueOf(response.getMar16to31actual()).setScale(2, 6).toString());
        }
        if (response.getMar16to31variance() != null) {
            jsonObject.addProperty("Mar 16 to 31 variance", BigDecimal.valueOf(response.getMar16to31variance()).setScale(2, 6).toString());
        }
    }

    private void prepareAprilData(JsonObject jsonObject, WorksMilestoneIndexResponse response) {
        if (response.getApr01to15target() != null && !response.getApr01to15target().isNaN()) {
            jsonObject.addProperty("Apr 01 to 15 target", BigDecimal.valueOf(response.getApr01to15target()).setScale(2, 6).toString());
        }
        if (response.getApr01to15actual() != null && !response.getApr01to15actual().isNaN()) {
            jsonObject.addProperty("Apr 01 to 15 actual", BigDecimal.valueOf(response.getApr01to15actual()).setScale(2, 6).toString());
        }
        if (response.getApr01to15variance() != null) {
            jsonObject.addProperty("Apr 01 to 15 variance", BigDecimal.valueOf(response.getApr01to15variance()).setScale(2, 6).toString());
        }
        if (response.getApr16to30target() != null && !response.getApr16to30target().isNaN()) {
            jsonObject.addProperty("Apr 16 to 30 target", BigDecimal.valueOf(response.getApr16to30target()).setScale(2, 6).toString());
        }
        if (response.getApr16to30actual() != null && !response.getApr16to30actual().isNaN()) {
            jsonObject.addProperty("Apr 16 to 30 actual", BigDecimal.valueOf(response.getApr16to30actual()).setScale(2, 6).toString());
        }
        if (response.getApr16to30variance() != null) {
            jsonObject.addProperty("Apr 16 to 30 variance", BigDecimal.valueOf(response.getApr16to30variance()).setScale(2, 6).toString());
        }
    }

    private void prepareMayData(JsonObject jsonObject, WorksMilestoneIndexResponse response) {
        if (response.getMay01to15target() != null && !response.getMay01to15target().isNaN()) {
            jsonObject.addProperty("May 01 to 15 target", BigDecimal.valueOf(response.getMay01to15target()).setScale(2, 6).toString());
        }
        if (response.getMay01to15actual() != null && !response.getMay01to15actual().isNaN()) {
            jsonObject.addProperty("May 01 to 15 actual", BigDecimal.valueOf(response.getMay01to15actual()).setScale(2, 6).toString());
        }
        if (response.getMay01to15variance() != null) {
            jsonObject.addProperty("May 01 to 15 variance", BigDecimal.valueOf(response.getMay01to15variance()).setScale(2, 6).toString());
        }
        if (response.getMay16to31target() != null && !response.getMay16to31target().isNaN()) {
            jsonObject.addProperty("May 16 to 31 target", BigDecimal.valueOf(response.getMay16to31target()).setScale(2, 6).toString());
        }
        if (response.getMay16to31actual() != null && !response.getMay16to31actual().isNaN()) {
            jsonObject.addProperty("May 16 to 31 actual", BigDecimal.valueOf(response.getMay16to31actual()).setScale(2, 6).toString());
        }
        if (response.getMay16to31variance() != null) {
            jsonObject.addProperty("May 16 to 31 variance", BigDecimal.valueOf(response.getMay16to31variance()).setScale(2, 6).toString());
        }
    }

    private void prepareJuneData(JsonObject jsonObject, WorksMilestoneIndexResponse response) {
        if (response.getJun01to15target() != null && !response.getJun01to15target().isNaN()) {
            jsonObject.addProperty("Jun 01 to 15 target", BigDecimal.valueOf(response.getJun01to15target()).setScale(2, 6).toString());
        }
        if (response.getJun01to15actual() != null && !response.getJun01to15actual().isNaN()) {
            jsonObject.addProperty("Jun 01 to 15 actual", BigDecimal.valueOf(response.getJun01to15actual()).setScale(2, 6).toString());
        }
        if (response.getJun01to15variance() != null) {
            jsonObject.addProperty("Jun 01 to 15 variance", BigDecimal.valueOf(response.getJun01to15variance()).setScale(2, 6).toString());
        }
        if (response.getJun16to30target() != null && !response.getJun16to30target().isNaN()) {
            jsonObject.addProperty("Jun 16 to 30 target", BigDecimal.valueOf(response.getJun16to30target()).setScale(2, 6).toString());
        }
        if (response.getJun16to30actual() != null && !response.getJun16to30actual().isNaN()) {
            jsonObject.addProperty("Jun 16 to 30 actual", BigDecimal.valueOf(response.getJun16to30actual()).setScale(2, 6).toString());
        }
        if (response.getJun16to30variance() != null) {
            jsonObject.addProperty("Jun 16 to 30 variance", BigDecimal.valueOf(response.getJun16to30variance()).setScale(2, 6).toString());
        }
    }

    private void prepareJulyData(JsonObject jsonObject, WorksMilestoneIndexResponse response) {
        if (response.getJul01to15target() != null && !response.getJul01to15target().isNaN()) {
            jsonObject.addProperty("Jul 01 to 15 target", BigDecimal.valueOf(response.getJul01to15target()).setScale(2, 6).toString());
        }
        if (response.getJul01to15actual() != null && !response.getJul01to15actual().isNaN()) {
            jsonObject.addProperty("Jul 01 to 15 actual", BigDecimal.valueOf(response.getJul01to15actual()).setScale(2, 6).toString());
        }
        if (response.getJul01to15variance() != null) {
            jsonObject.addProperty("Jul 01 to 15 variance", BigDecimal.valueOf(response.getJul01to15variance()).setScale(2, 6).toString());
        }
        if (response.getJul16to31target() != null && !response.getJul16to31target().isNaN()) {
            jsonObject.addProperty("Jul 16 to 31 target", BigDecimal.valueOf(response.getJul16to31target()).setScale(2, 6).toString());
        }
        if (response.getJul16to31actual() != null && !response.getJul16to31actual().isNaN()) {
            jsonObject.addProperty("Jul 16 to 31 actual", BigDecimal.valueOf(response.getJul16to31actual()).setScale(2, 6).toString());
        }
        if (response.getJul16to31variance() != null) {
            jsonObject.addProperty("Jul 16 to 31 variance", BigDecimal.valueOf(response.getJul16to31variance()).setScale(2, 6).toString());
        }
    }

    private void prepareAugustData(JsonObject jsonObject, WorksMilestoneIndexResponse response) {
        if (response.getAug01to15target() != null && !response.getAug01to15target().isNaN()) {
            jsonObject.addProperty("Aug 01 to 15 target", BigDecimal.valueOf(response.getAug01to15target()).setScale(2, 6).toString());
        }
        if (response.getAug01to15actual() != null && !response.getAug01to15actual().isNaN()) {
            jsonObject.addProperty("Aug 01 to 15 actual", BigDecimal.valueOf(response.getAug01to15actual()).setScale(2, 6).toString());
        }
        if (response.getAug01to15variance() != null) {
            jsonObject.addProperty("Aug 01 to 15 variance", BigDecimal.valueOf(response.getAug01to15variance()).setScale(2, 6).toString());
        }
        if (response.getAug16to31target() != null && !response.getAug16to31target().isNaN()) {
            jsonObject.addProperty("Aug 16 to 31 target", BigDecimal.valueOf(response.getAug16to31target()).setScale(2, 6).toString());
        }
        if (response.getAug16to31actual() != null && !response.getAug16to31actual().isNaN()) {
            jsonObject.addProperty("Aug 16 to 31 actual", BigDecimal.valueOf(response.getAug16to31actual()).setScale(2, 6).toString());
        }
        if (response.getAug16to31variance() != null) {
            jsonObject.addProperty("Aug 16 to 31 variance", BigDecimal.valueOf(response.getAug16to31variance()).setScale(2, 6).toString());
        }
    }

    private void prepareSeptemberData(JsonObject jsonObject, WorksMilestoneIndexResponse response) {
        if (response.getSep01to15target() != null && !response.getSep01to15target().isNaN()) {
            jsonObject.addProperty("Sep 01 to 15 target", BigDecimal.valueOf(response.getSep01to15target()).setScale(2, 6).toString());
        }
        if (response.getSep01to15actual() != null && !response.getSep01to15actual().isNaN()) {
            jsonObject.addProperty("Sep 01 to 15 actual", BigDecimal.valueOf(response.getSep01to15actual()).setScale(2, 6).toString());
        }
        if (response.getSep01to15variance() != null) {
            jsonObject.addProperty("Sep 01 to 15 variance", BigDecimal.valueOf(response.getSep01to15variance()).setScale(2, 6).toString());
        }
        if (response.getSep16to30target() != null && !response.getSep16to30target().isNaN()) {
            jsonObject.addProperty("Sep 16 to 30 target", BigDecimal.valueOf(response.getSep16to30target()).setScale(2, 6).toString());
        }
        if (response.getSep16to30actual() != null && !response.getSep16to30actual().isNaN()) {
            jsonObject.addProperty("Sep 16 to 30 actual", BigDecimal.valueOf(response.getSep16to30actual()).setScale(2, 6).toString());
        }
        if (response.getSep16to30variance() != null) {
            jsonObject.addProperty("Sep 16 to 30 variance", BigDecimal.valueOf(response.getSep16to30variance()).setScale(2, 6).toString());
        }
    }

    private void prepareOctoberData(JsonObject jsonObject, WorksMilestoneIndexResponse response) {
        if (response.getOct01to15target() != null && !response.getOct01to15target().isNaN()) {
            jsonObject.addProperty("Oct 01 to 15 target", BigDecimal.valueOf(response.getOct01to15target()).setScale(2, 6).toString());
        }
        if (response.getOct01to15actual() != null && !response.getOct01to15actual().isNaN()) {
            jsonObject.addProperty("Oct 01 to 15 actual", BigDecimal.valueOf(response.getOct01to15actual()).setScale(2, 6).toString());
        }
        if (response.getOct01to15variance() != null) {
            jsonObject.addProperty("Oct 01 to 15 variance", BigDecimal.valueOf(response.getOct01to15variance()).setScale(2, 6).toString());
        }
        if (response.getOct16to31target() != null && !response.getOct16to31target().isNaN()) {
            jsonObject.addProperty("Oct 16 to 31 target", BigDecimal.valueOf(response.getOct16to31target()).setScale(2, 6).toString());
        } else {
            jsonObject.addProperty("Oct 16 to 31 target", "0.00");
        }
        if (response.getOct16to31actual() != null && !response.getOct16to31actual().isNaN()) {
            jsonObject.addProperty("Oct 16 to 31 actual", BigDecimal.valueOf(response.getOct16to31actual()).setScale(2, 6).toString());
        } else {
            jsonObject.addProperty("Oct 16 to 31 actual", "0.00");
        }
        if (response.getOct16to31variance() != null) {
            jsonObject.addProperty("Oct 16 to 31 variance", BigDecimal.valueOf(response.getOct16to31variance()).setScale(2, 6).toString());
        } else {
            jsonObject.addProperty("Oct 16 to 31 variance", "0.00");
        }
    }

    private void prepareNovemberData(JsonObject jsonObject, WorksMilestoneIndexResponse response) {
        if (response.getNov01to15target() != null && !response.getNov01to15target().isNaN()) {
            jsonObject.addProperty("Nov 01 to 15 target", BigDecimal.valueOf(response.getNov01to15target()).setScale(2, 6).toString());
        }
        if (response.getNov01to15actual() != null && !response.getNov01to15actual().isNaN()) {
            jsonObject.addProperty("Nov 01 to 15 actual", BigDecimal.valueOf(response.getNov01to15actual()).setScale(2, 6).toString());
        }
        if (response.getNov01to15variance() != null) {
            jsonObject.addProperty("Nov 01 to 15 variance", BigDecimal.valueOf(response.getNov01to15variance()).setScale(2, 6).toString());
        }
        if (response.getNov16to30target() != null && !response.getNov16to30target().isNaN()) {
            jsonObject.addProperty("Nov 16 to 30 target", BigDecimal.valueOf(response.getNov16to30target()).setScale(2, 6).toString());
        }
        if (response.getNov16to30actual() != null && !response.getNov16to30actual().isNaN()) {
            jsonObject.addProperty("Nov 16 to 30 actual", BigDecimal.valueOf(response.getNov16to30actual()).setScale(2, 6).toString());
        }
        if (response.getNov16to30variance() != null) {
            jsonObject.addProperty("Nov 16 to 30 variance", BigDecimal.valueOf(response.getNov16to30variance()).setScale(2, 6).toString());
        }
    }

    private void prepareDecemberData(JsonObject jsonObject, WorksMilestoneIndexResponse response) {
        if (response.getDec01to15target() != null && !response.getDec01to15target().isNaN()) {
            jsonObject.addProperty("Dec 01 to 15 target", BigDecimal.valueOf(response.getDec01to15target()).setScale(2, 6).toString());
        }
        if (response.getDec01to15actual() != null && !response.getDec01to15actual().isNaN()) {
            jsonObject.addProperty("Dec 01 to 15 actual", BigDecimal.valueOf(response.getDec01to15actual()).setScale(2, 6).toString());
        }
        if (response.getDec01to15variance() != null) {
            jsonObject.addProperty("Dec 01 to 15 variance", BigDecimal.valueOf(response.getDec01to15variance()).setScale(2, 6).toString());
        }
        if (response.getDec16to31target() != null && !response.getDec16to31target().isNaN()) {
            jsonObject.addProperty("Dec 16 to 31 target", BigDecimal.valueOf(response.getDec16to31target()).setScale(2, 6).toString());
        }
        if (response.getDec16to31actual() != null && !response.getDec16to31actual().isNaN()) {
            jsonObject.addProperty("Dec 16 to 31 actual", BigDecimal.valueOf(response.getDec16to31actual()).setScale(2, 6).toString());
        }
        if (response.getDec16to31variance() != null) {
            jsonObject.addProperty("Dec 16 to 31 variance", BigDecimal.valueOf(response.getDec16to31variance()).setScale(2, 6).toString());
        }
    }
}

