/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.tender;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.pims.service.PersonalInformationService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.models.estimate.ProjectCode;
import org.egov.works.models.masters.MarketRate;
import org.egov.works.models.masters.ScheduleOfRate;
import org.egov.works.models.tender.EstimateLineItemsForWP;
import org.egov.works.models.tender.TenderResponse;
import org.egov.works.models.tender.WorksPackage;
import org.egov.works.models.workorder.WorkOrder;
import org.egov.works.services.AbstractEstimateService;
import org.egov.works.services.WorkOrderService;
import org.egov.works.services.WorksPackageService;
import org.egov.works.services.WorksService;
import org.springframework.beans.factory.annotation.Autowired;

public class AjaxTenderNegotiationAction
extends BaseFormAction {
    private static final long serialVersionUID = -9058467908860158263L;
    private static final String MARKETVALUE = "marketValue";
    private AbstractEstimateService abstractEstimateService;
    private WorksService worksService;
    private Long estimateId;
    private Long packageId;
    private Date asOnDate;
    private double marketRateAmount = 0.0;
    private WorksPackageService workspackageService;
    @Autowired
    private AssignmentService assignmentService;
    private TenderResponse tenderResp = new TenderResponse();
    private static final String USERS_IN_DEPT = "usersInDept";
    private static final String DESIGN_FOR_EMP = "designForEmp";
    private Integer executingDepartment;
    private Long empID;
    private List usersInExecutingDepartment;
    private Assignment assignment;
    private String tenderNo;
    private Long checkId;
    private Long id;
    private static final String TENDERNUMBERUNIQUECHECK = "tenderNumberUniqueCheck";
    private PersonalInformationService personalInformationService;
    private static final String GET_WORKORDERS_TN = "getWorkOrdersForTN";
    private List<WorkOrder> workOrderList = new ArrayList();
    private WorkOrderService workOrderService;
    private String tenderNegotiationNo;
    private String query = "";
    private List<AbstractEstimate> estimateList = new LinkedList();
    private List<ProjectCode> projectCodeList = new LinkedList();
    private List<String> negotiationNumberList = new LinkedList();
    private List<WorksPackage> wpNumberList = new LinkedList();
    private List<WorksPackage> tenderFileNumberList = new LinkedList();

    public String getMarketValue() {
        if (this.estimateId != null) {
            this.getMarketValueForEstimate(this.estimateId);
        }
        if (this.packageId != null) {
            this.getMarketValueForPackage(this.packageId);
        }
        return MARKETVALUE;
    }

    public double getMarketValueForEstimate(Long estimateId) {
        AbstractEstimate abstractEstimate = (AbstractEstimate)this.abstractEstimateService.findById((Serializable)estimateId, false);
        Collection sorActivities = abstractEstimate.getSORActivities();
        Map exceptionaSorMap = this.worksService.getExceptionSOR();
        for (Activity activity : sorActivities) {
            double marketrate = 0.0;
            double marketrateAmt = 0.0;
            ScheduleOfRate scheduleOfRate = activity.getSchedule();
            if (scheduleOfRate.hasValidMarketRateFor(this.asOnDate)) {
                double result = 1.0;
                MarketRate marketRate = scheduleOfRate.getMarketRateOn(this.asOnDate);
                if (activity.getUom() != null && StringUtils.isNotBlank((String)activity.getUom().getUom()) && exceptionaSorMap.containsKey(activity.getUom().getUom())) {
                    result = ((Integer)exceptionaSorMap.get(activity.getUom().getUom())).intValue();
                }
                marketrate = marketRate.getMarketRate().getValue() / result;
            }
            marketrateAmt = marketrate == 0.0 ? activity.getAmount().getValue() : activity.getQuantity() * marketrate;
            this.marketRateAmount += marketrateAmt;
        }
        Collection nonSorActivities = abstractEstimate.getNonSORActivities();
        for (Activity activity : nonSorActivities) {
            this.marketRateAmount += activity.getAmount().getValue();
        }
        return this.marketRateAmount;
    }

    public double getMarketValueForPackage(Long packageId) {
        WorksPackage workspackage = (WorksPackage)this.workspackageService.findById((Serializable)packageId, false);
        for (EstimateLineItemsForWP estlineItem : workspackage.getActivitiesForEstimate()) {
            double marketrate = 0.0;
            double marketrateAmt = 0.0;
            Map exceptionaSorMap = this.worksService.getExceptionSOR();
            if (StringUtils.isNotBlank((String)estlineItem.getCode())) {
                ScheduleOfRate scheduleOfRate = estlineItem.getActivity().getSchedule();
                if (scheduleOfRate.hasValidMarketRateFor(this.asOnDate)) {
                    double result = 1.0;
                    MarketRate marketRate = scheduleOfRate.getMarketRateOn(this.asOnDate);
                    if (exceptionaSorMap.containsKey(estlineItem.getUom())) {
                        result = ((Integer)exceptionaSorMap.get(estlineItem.getUom())).intValue();
                    }
                    marketrate = marketRate.getMarketRate().getValue() / result;
                }
                marketrateAmt = marketrate == 0.0 ? estlineItem.getAmt() : estlineItem.getQuantity() * marketrate;
                this.marketRateAmount += marketrateAmt;
                continue;
            }
            this.marketRateAmount += estlineItem.getActivity().getAmount().getValue();
        }
        return this.marketRateAmount;
    }

    public double getMarketRateWithTax(double marketrate, Activity activity) {
        double marketrateAmt = 0.0;
        if (marketrate == 0.0) {
            marketrateAmt = activity.getAmountIncludingTax().getValue();
        } else {
            marketrateAmt = activity.getQuantity() * marketrate;
            marketrateAmt += activity.getServiceTaxPerc() * marketrateAmt / 100.0;
        }
        return marketrateAmt;
    }

    public String tenderNumberUniqueCheck() {
        return TENDERNUMBERUNIQUECHECK;
    }

    public String designationForUser() {
        try {
            this.assignment = this.assignmentService.getPrimaryAssignmentForEmployee(this.empID);
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("user.find.error", (Throwable)e);
        }
        return DESIGN_FOR_EMP;
    }

    public boolean getTendernoCheck() {
        boolean tenderNoexistsOrNot = false;
        TenderResponse tenderResponseObj = null;
        if (this.id == null) {
            tenderResponseObj = (TenderResponse)this.getPersistenceService().findByNamedQuery("TenderNumberUniqueCheck", new Object[]{this.tenderNo});
            if (tenderResponseObj != null) {
                tenderNoexistsOrNot = true;
            }
        } else if (this.getPersistenceService().findByNamedQuery("TenderNumberUniqueCheckForEdit", new Object[]{this.tenderNo, this.id}) != null) {
            tenderNoexistsOrNot = true;
        }
        return tenderNoexistsOrNot;
    }

    public String usersInExecutingDepartment() {
        try {
            HashMap<String, Object> criteriaParams = new HashMap<String, Object>();
            criteriaParams.put("departmentId", this.executingDepartment);
            criteriaParams.put("isPrimary", "Y");
            this.usersInExecutingDepartment = this.executingDepartment == null || this.executingDepartment == -1 ? Collections.EMPTY_LIST : this.personalInformationService.getListOfEmployeeViewBasedOnCriteria(criteriaParams, Integer.valueOf(-1), Integer.valueOf(-1));
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("user.find.error", (Throwable)e);
        }
        return USERS_IN_DEPT;
    }

    public String getWODetailsForTN() throws Exception {
        List woList = new ArrayList();
        woList = this.workOrderService.findAllBy("select distinct wo from WorkOrder wo where wo.egwStatus.code<>'CANCELLED' and wo.negotiationNumber=? ", new Object[]{this.tenderNegotiationNo});
        if (woList != null && !woList.isEmpty()) {
            this.workOrderList.addAll(woList);
        }
        return GET_WORKORDERS_TN;
    }

    public String searchNegotiationNumber() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = " select distinct tr.negotiationNumber from TenderResponse tr where upper(tr.negotiationNumber) like '%'||?||'%' and tr.egwStatus.code <> ? ";
            params.add(this.query.toUpperCase());
            params.add("NEW");
            this.negotiationNumberList = this.getPersistenceService().findAllBy(strquery, params.toArray());
        }
        return "negotiationNumberSearchResults";
    }

    public String searchWorksPackageNumber() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = "select distinct tr.tenderEstimate.worksPackage from TenderResponse tr where upper(tr.tenderEstimate.worksPackage.wpNumber) like '%'||?||'%' and tr.egwStatus.code <> ? ";
            params.add(this.query.toUpperCase());
            params.add("NEW");
            this.wpNumberList = this.getPersistenceService().findAllBy(strquery, params.toArray());
        }
        return "worksPackageNumberSearchResults";
    }

    public String searchTenderFileNumber() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = "select distinct tr.tenderEstimate.worksPackage from TenderResponse tr where upper(tr.tenderEstimate.worksPackage.tenderFileNumber) like '%'||?||'%' and tr.egwStatus.code <> ? ";
            params.add(this.query.toUpperCase());
            params.add("NEW");
            this.tenderFileNumberList = this.getPersistenceService().findAllBy(strquery, params.toArray());
        }
        return "tenderFileNumberSearchResults";
    }

    public String searchProjectCode() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = "select distinct wpd.estimate.projectCode from WorksPackageDetails wpd where upper(wpd.estimate.projectCode.code) like '%'||?||'%'  and wpd.worksPackage.id in (select distinct tr.tenderEstimate.worksPackage.id from TenderResponse tr where tr.egwStatus.code <> ? )";
            params.add(this.query.toUpperCase());
            params.add("NEW");
            this.projectCodeList = this.getPersistenceService().findAllBy(strquery, params.toArray());
        }
        return "projectCodeSearchResults";
    }

    public String searchEstimateNumber() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = "select wpd.estimate from WorksPackageDetails wpd where upper(wpd.estimate.estimateNumber) like '%'||?||'%'  and wpd.worksPackage.id in (select distinct tr.tenderEstimate.worksPackage.id from TenderResponse tr where tr.egwStatus.code <> ? )";
            params.add(this.query.toUpperCase());
            params.add("NEW");
            this.estimateList = this.getPersistenceService().findAllBy(strquery, params.toArray());
        }
        return "estimateNoSearchResults";
    }

    public Object getModel() {
        return this.tenderResp;
    }

    public String execute() {
        return "success";
    }

    public void setAssignmentService(AssignmentService assignmentService) {
        this.assignmentService = assignmentService;
    }

    public void setAbstractEstimateService(AbstractEstimateService abstractEstimateService) {
        this.abstractEstimateService = abstractEstimateService;
    }

    public void setEstimateId(Long estimateId) {
        this.estimateId = estimateId;
    }

    public void setAsOnDate(Date asOnDate) {
        this.asOnDate = asOnDate;
    }

    public double getMarketRateAmount() {
        return this.marketRateAmount;
    }

    public void setMarketRateAmount(double marketRateAmount) {
        this.marketRateAmount = marketRateAmount;
    }

    public void setEmpID(Long empID) {
        this.empID = empID;
    }

    public List getUsersInExecutingDepartment() {
        return this.usersInExecutingDepartment;
    }

    public void setExecutingDepartment(Integer executingDepartment) {
        this.executingDepartment = executingDepartment;
    }

    public Assignment getAssignment() {
        return this.assignment;
    }

    public Long getPackageId() {
        return this.packageId;
    }

    public void setPackageId(Long packageId) {
        this.packageId = packageId;
    }

    public void setWorkspackageService(WorksPackageService workspackageService) {
        this.workspackageService = workspackageService;
    }

    public String getTenderNo() {
        return this.tenderNo;
    }

    public void setTenderNo(String tenderNo) {
        this.tenderNo = tenderNo;
    }

    public Long getCheckId() {
        return this.checkId;
    }

    public void setCheckId(Long checkId) {
        this.checkId = checkId;
    }

    public TenderResponse getTenderResp() {
        return this.tenderResp;
    }

    public void setTenderResp(TenderResponse tenderResp) {
        this.tenderResp = tenderResp;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public void setPersonalInformationService(PersonalInformationService personalInformationService) {
        this.personalInformationService = personalInformationService;
    }

    public List<WorkOrder> getWorkOrderList() {
        return this.workOrderList;
    }

    public void setWorkOrderList(List<WorkOrder> workOrderList) {
        this.workOrderList = workOrderList;
    }

    public String getTenderNegotiationNo() {
        return this.tenderNegotiationNo;
    }

    public void setTenderNegotiationNo(String tenderNegotiationNo) {
        this.tenderNegotiationNo = tenderNegotiationNo;
    }

    public void setWorkOrderService(WorkOrderService workOrderService) {
        this.workOrderService = workOrderService;
    }

    public List<AbstractEstimate> getEstimateList() {
        return this.estimateList;
    }

    public void setEstimateList(List<AbstractEstimate> estimateList) {
        this.estimateList = estimateList;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public List<ProjectCode> getProjectCodeList() {
        return this.projectCodeList;
    }

    public void setProjectCodeList(List<ProjectCode> projectCodeList) {
        this.projectCodeList = projectCodeList;
    }

    public List<String> getNegotiationNumberList() {
        return this.negotiationNumberList;
    }

    public List<WorksPackage> getWpNumberList() {
        return this.wpNumberList;
    }

    public void setWpNumberList(List<WorksPackage> wpNumberList) {
        this.wpNumberList = wpNumberList;
    }

    public List<WorksPackage> getTenderFileNumberList() {
        return this.tenderFileNumberList;
    }

    public void setTenderFileNumberList(List<WorksPackage> tenderFileNumberList) {
        this.tenderFileNumberList = tenderFileNumberList;
    }
}

