/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.revisionEstimate;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.script.ScriptContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.egov.common.entity.UOM;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.component.Money;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.workflow.GenericWorkFlowAction;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.service.WorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Position;
import org.egov.pims.service.EmployeeServiceOld;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.abstractestimate.entity.NonSor;
import org.egov.works.models.masters.ScheduleOfRate;
import org.egov.works.models.tender.TenderResponse;
import org.egov.works.models.workorder.WorkOrder;
import org.egov.works.models.workorder.WorkOrderActivity;
import org.egov.works.models.workorder.WorkOrderEstimate;
import org.egov.works.revisionestimate.entity.RevisionAbstractEstimate;
import org.egov.works.revisionestimate.entity.RevisionWorkOrder;
import org.egov.works.revisionestimate.entity.enums.RevisionType;
import org.egov.works.services.AbstractEstimateService;
import org.egov.works.services.RevisionEstimateService;
import org.egov.works.services.WorkOrderService;
import org.egov.works.services.WorksService;
import org.egov.works.web.actions.estimate.AjaxEstimateAction;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Result(name={"new"}, location="revisionEstimate-new.jsp")
public class RevisionEstimateAction
extends GenericWorkFlowAction {
    private static final long serialVersionUID = 7691992958619463320L;
    private static final Logger LOGGER = Logger.getLogger(RevisionEstimateAction.class);
    private RevisionAbstractEstimate revisionEstimate = new RevisionAbstractEstimate();
    private RevisionWorkOrder revisionWorkOrder = new RevisionWorkOrder();
    private WorkflowService<RevisionAbstractEstimate> workflowService;
    private PersistenceService<RevisionAbstractEstimate, Long> revisionAbstractEstimateService;
    private PersistenceService<RevisionWorkOrder, Long> revisionWorkOrderService;
    private AbstractEstimateService abstractEstimateService;
    private String messageKey;
    private WorksService worksService;
    private String employeeName;
    private String designation;
    private String additionalRuleValue;
    private String departmentName;
    private Long id;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private EmployeeServiceOld employeeService;
    private Integer approverPositionId;
    private WorkOrderService workOrderService;
    private List<Activity> originalRevisedActivityList = new LinkedList();
    private double originalTotalAmount = 0.0;
    private double originalTotalTax = 0.0;
    private double originalWorkValueIncludingTax = 0.0;
    private String sourcepage = "";
    private Long originalEstimateId;
    private Long originalWOId;
    private double revisionEstimatesValue = 0.0;
    private double revisionWOValue = 0.0;
    private List<RevisionAbstractEstimate> reList = new LinkedList();
    private AbstractEstimate abstractEstimate = new AbstractEstimate();
    private WorkOrder workOrder = new WorkOrder();
    private List<Activity> sorActivities = new LinkedList();
    private List<Activity> nonSorActivities = new LinkedList();
    private static final String CANCEL_ACTION = "cancel";
    private static final String SAVE_ACTION = "save";
    private static final Object REJECT_ACTION = "reject";
    private static final String SOURCE_INBOX = "inbox";
    private static final String ACTION_NAME = "actionName";
    private PersistenceService<NonSor, Long> nonSorService;
    private String estimateValue;
    private int reCount = 1;
    @Autowired
    private UserService userService;
    private Long logedInUserDept;
    private static final String ACTIVITY_SEARCH = "activitySearch";
    private String activityCode;
    private String activityDesc;
    private List<WorkOrderActivity> activityList;
    private String workorderNo;
    private List<WorkOrderActivity> changeQuantityActivities = new LinkedList();
    private RevisionEstimateService revisionEstimateService;
    private boolean isBudgetRejectionNoPresent;
    private BigDecimal amountRuleValue;
    @Autowired
    private ScriptService scriptService;

    public RevisionEstimateAction() {
        this.addRelatedEntity("executingDepartment", Department.class);
    }

    public StateAware getModel() {
        return this.revisionEstimate;
    }

    public String edit() {
        if (SOURCE_INBOX.equalsIgnoreCase(this.sourcepage)) {
            User user = this.userService.getUserById(this.worksService.getCurrentLoggedInUserId());
            boolean isValidUser = this.worksService.validateWorkflowForUser((StateAware)this.revisionEstimate, user);
            if (isValidUser) {
                throw new ApplicationRuntimeException("Error: Invalid Owner - No permission to view this page.");
            }
        } else if (StringUtils.isEmpty((String)this.sourcepage)) {
            this.sourcepage = "search";
        }
        for (Activity activity : this.revisionEstimate.getSORActivities()) {
            double sorRate = 0.0;
            Date workOrderDate = new Date();
            workOrderDate = this.workOrder.getWorkOrderDate();
            if (activity.getRevisionType() != null && (activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.NON_TENDERED_ITEM.toString()) || activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.LUMP_SUM_ITEM.toString()))) {
                sorRate = activity.getSORRateForDate(workOrderDate).getValue();
            } else if (activity.getAbstractEstimate().getParent() != null && activity.getRevisionType() != null && (activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.ADDITIONAL_QUANTITY.toString()) || activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.REDUCED_QUANTITY.toString()))) {
                sorRate = activity.getParent() != null && activity.getParent().getRevisionType() != null && activity.getParent().getRevisionType().toString().equalsIgnoreCase(RevisionType.NON_TENDERED_ITEM.toString()) ? activity.getSORRateForDate(workOrderDate).getValue() : activity.getSORRateForDate(activity.getAbstractEstimate().getParent().getEstimateDate()).getValue();
            }
            activity.setSORCurrentRate(new Money(sorRate));
        }
        return "new";
    }

    @Action(value="/revisionEstimate/revisionEstimate-newform")
    public String newform() {
        LOGGER.debug((Object)"RevisionEstimateAction | newform | Start");
        return "new";
    }

    public void prepare() {
        AjaxEstimateAction ajaxEstimateAction = new AjaxEstimateAction();
        ajaxEstimateAction.setPersistenceService(this.getPersistenceService());
        if (this.id != null) {
            this.revisionEstimate = (RevisionAbstractEstimate)this.revisionAbstractEstimateService.findById((Serializable)this.id, false);
            this.revisionEstimate = (RevisionAbstractEstimate)this.revisionAbstractEstimateService.merge((Object)this.revisionEstimate);
            this.originalEstimateId = this.revisionEstimate.getParent().getId();
            this.abstractEstimate = (AbstractEstimate)this.persistenceService.find(" from AbstractEstimate where id=?", new Object[]{this.originalEstimateId});
            WorkOrderEstimate revWorkOrderEstimate = null;
            revWorkOrderEstimate = "CANCELLED".equals(this.revisionEstimate.getEgwStatus().getCode()) ? (WorkOrderEstimate)this.persistenceService.find(" from WorkOrderEstimate where estimate.id=? and workOrder.egwStatus.code='CANCELLED'", new Object[]{this.id}) : (WorkOrderEstimate)this.persistenceService.find(" from WorkOrderEstimate where estimate.id=? and workOrder.egwStatus.code!='CANCELLED'", new Object[]{this.id});
            this.originalWOId = revWorkOrderEstimate.getWorkOrder().getParent().getId();
            this.revisionWorkOrder = (RevisionWorkOrder)this.revisionWorkOrderService.findById((Serializable)revWorkOrderEstimate.getWorkOrder().getId(), false);
            this.reList = this.revisionAbstractEstimateService.findAllByNamedQuery("REVISION_ESTIMATES_BY_ESTID_WOID", new Object[]{this.abstractEstimate.getId(), this.originalWOId});
            this.workOrderService.calculateCumulativeDetailsForRE(revWorkOrderEstimate);
            ((WorkOrderEstimate)this.revisionWorkOrder.getWorkOrderEstimates().get(0)).setWorkOrderActivities(revWorkOrderEstimate.getWorkOrderActivities());
        } else {
            this.abstractEstimate = (AbstractEstimate)this.persistenceService.find(" from AbstractEstimate where id=?", new Object[]{this.originalEstimateId});
            this.reList = this.revisionAbstractEstimateService.findAllByNamedQuery("REVISION_ESTIMATES_BY_ESTID_WOID", new Object[]{this.abstractEstimate.getId(), this.originalWOId});
        }
        this.workOrder = (WorkOrder)this.persistenceService.find(" from WorkOrder where id=?", new Object[]{this.originalWOId});
        double amnt = 0.0;
        if (this.reList != null && !this.reList.isEmpty()) {
            for (RevisionAbstractEstimate re : this.reList) {
                if (this.revisionEstimate != null && this.revisionEstimate.getCreatedDate() != null && (this.revisionEstimate == null || this.revisionEstimate.getCreatedDate() == null || !re.getCreatedDate().before(this.revisionEstimate.getCreatedDate()))) continue;
                amnt += re.getTotalAmount().getValue();
            }
            amnt += this.abstractEstimate.getTotalAmount().getValue();
        } else {
            amnt += this.abstractEstimate.getTotalAmount().getValue();
        }
        this.revisionEstimatesValue = amnt;
        if (this.abstractEstimate != null) {
            LinkedList<AbstractEstimate> originalRevisedEstimateList = new LinkedList<AbstractEstimate>();
            originalRevisedEstimateList.add(this.abstractEstimate);
            originalRevisedEstimateList.addAll(this.reList);
            for (AbstractEstimate ae : originalRevisedEstimateList) {
                if (this.revisionEstimate != null && this.revisionEstimate.getCreatedDate() != null && (this.revisionEstimate == null || this.revisionEstimate.getCreatedDate() == null || !ae.getCreatedDate().before(this.revisionEstimate.getCreatedDate()))) continue;
                this.originalRevisedActivityList.addAll(ae.getActivities());
                this.originalTotalAmount += ae.getWorkValue();
                this.originalTotalTax += ae.getTotalTax().getValue();
                this.originalWorkValueIncludingTax += ae.getWorkValueIncludingTaxes().getValue();
            }
        }
        super.prepare();
        this.setupDropdownDataExcluding(new String[]{""});
        List uomList = this.getPersistenceService().findAllBy("from UOM order by upper(uom)", new Object[0]);
        if ("createRE".equals(this.sourcepage) || !"search".equals(this.sourcepage) && this.revisionEstimate.getEgwStatus() != null && this.revisionEstimate.getEgwStatus().getCode().equals("REJECTED")) {
            uomList = this.abstractEstimateService.prepareUomListByExcludingSpecialUoms(uomList);
        }
        this.addDropdownData("uomList", uomList);
        this.addDropdownData("scheduleCategoryList", this.getPersistenceService().findAllBy("from ScheduleCategory order by upper(code)", new Object[0]));
        if (this.abstractEstimateService.getLatestAssignmentForCurrentLoginUser() != null) {
            this.logedInUserDept = this.abstractEstimateService.getLatestAssignmentForCurrentLoginUser().getDepartment().getId();
        }
    }

    protected String getAdditionalRule() {
        ScriptContext scriptContext = ScriptService.createContext((Object[])new Object[]{"estimate", this.revisionEstimate});
        return this.scriptService.executeScript("works.estimate.department.type", scriptContext).toString();
    }

    protected BigDecimal getAmountRule() {
        return new BigDecimal(this.revisionEstimate.getWorkValue());
    }

    public String save() {
        String actionName = ((String[])this.parameters.get(ACTION_NAME))[0];
        if (!(actionName == null || actionName.equals("Reject") || actionName.equals("Cancel") || actionName.equals("Forward"))) {
            this.validateNonSorActivities();
        }
        if (actionName != null && actionName.equals("Reject")) {
            this.isBudgetRejectionNoPresent = true;
            if (this.revisionEstimate.getEgwStatus() != null && (this.revisionEstimate.getEgwStatus().getCode().equalsIgnoreCase("CREATED") || this.revisionEstimate.getEgwStatus().getCode().equalsIgnoreCase("RESUBMITTED"))) {
                this.isBudgetRejectionNoPresent = false;
            }
        }
        String deptName = this.getWorkFlowDepartment();
        String curStatus = this.revisionEstimate.getEgwStatus() != null ? this.revisionEstimate.getEgwStatus().getCode() : "NEW";
        if (this.revisionWorkOrder != null && (curStatus.equals("NEW") || curStatus.equals("REJECTED"))) {
            this.revisionWorkOrder.getWorkOrderEstimates().clear();
        }
        if (curStatus.equals("NEW") || curStatus.equals("REJECTED")) {
            this.saveREstimate(actionName);
        }
        if ((actionName.equalsIgnoreCase("Forward") || actionName.equalsIgnoreCase("Approve")) && this.customizedWorkFlowService.getWfMatrix(this.getModel().getStateType(), deptName, this.getAmountRule(), this.getAdditionalRule(), curStatus, this.getPendingActions()) == null) {
            throw new ValidationException(Arrays.asList(new ValidationError("revisionEstimate.workflow.notdefined", this.getText("revisionEstimate.workflow.notdefined", new String[]{deptName}))));
        }
        if (!SAVE_ACTION.equalsIgnoreCase(actionName) && !CANCEL_ACTION.equalsIgnoreCase(actionName) && !REJECT_ACTION.equals(actionName) && this.revisionEstimate.getActivities().isEmpty()) {
            throw new ValidationException(Arrays.asList(new ValidationError("revisionEstimate.activities.empty", "revisionEstimate.activities.empty")));
        }
        this.revisionEstimate = (RevisionAbstractEstimate)this.revisionAbstractEstimateService.persist((Object)this.revisionEstimate);
        if (actionName.equalsIgnoreCase(SAVE_ACTION)) {
            this.revisionEstimate.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("AbstractEstimate", "NEW"));
            if (this.id == null) {
                Position pos = this.employeeService.getPositionforEmp(this.employeeService.getEmpForUserId(this.worksService.getCurrentLoggedInUserId()).getIdPersonalInformation());
                this.revisionEstimate = (RevisionAbstractEstimate)this.revisionEstimate.transition().start().withOwner(pos).withComments("Revision Estimate created.");
            }
            this.addActionMessage(this.getText(this.messageKey, "The Revision Estimate was saved successfully"));
            this.revisionEstimate = (RevisionAbstractEstimate)this.revisionAbstractEstimateService.persist((Object)this.revisionEstimate);
        } else {
            if (this.id == null) {
                this.revisionEstimate.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("AbstractEstimate", "NEW"));
                Position pos = this.employeeService.getPositionforEmp(this.employeeService.getEmpForUserId(this.worksService.getCurrentLoggedInUserId()).getIdPersonalInformation());
                this.revisionEstimate = (RevisionAbstractEstimate)this.revisionEstimate.transition().start().withOwner(pos).withComments("Revision Estimate created.");
                this.revisionEstimate = (RevisionAbstractEstimate)this.revisionAbstractEstimateService.persist((Object)this.revisionEstimate);
            }
            this.revisionEstimate.setAmountRule(this.getAmountRule());
            this.revisionEstimate.setAdditionalRule(this.getAdditionalRule());
            this.workflowService.transition(actionName, (StateAware)this.revisionEstimate, this.approverComments);
            this.revisionEstimate = (RevisionAbstractEstimate)this.revisionAbstractEstimateService.persist((Object)this.revisionEstimate);
        }
        this.revisionWorkOrder = this.createRevisionWO(curStatus);
        this.revisionWorkOrder = (RevisionWorkOrder)this.revisionWorkOrderService.persist((Object)this.revisionWorkOrder);
        this.messageKey = "revisionEstimate." + actionName;
        this.getDesignation(this.revisionEstimate);
        return SAVE_ACTION.equalsIgnoreCase(actionName) ? "edit" : "success";
    }

    private void saveREstimate(String actionName) {
        this.createRevisionEstimate();
    }

    protected void createRevisionEstimate() {
        List revisionEstimates = this.abstractEstimateService.findAllBy("from AbstractEstimate where parent.id=?", new Object[]{this.originalEstimateId});
        this.reCount += revisionEstimates.size();
        if (this.revisionEstimate.getId() != null) {
            --this.reCount;
        }
        if (this.id == null) {
            this.revisionEstimate.setParent(this.abstractEstimate);
            this.revisionEstimate.setEstimateDate(new Date());
            this.revisionEstimate.setEstimateNumber(this.abstractEstimate.getEstimateNumber() + "/RE".concat(Integer.toString(this.reCount)));
            this.revisionEstimate.setName("Revision Estimate for: " + this.abstractEstimate.getName());
            this.revisionEstimate.setDescription("Revision Estimate for: " + this.abstractEstimate.getDescription());
            this.revisionEstimate.setNatureOfWork(this.abstractEstimate.getNatureOfWork());
            this.revisionEstimate.setExecutingDepartment(this.abstractEstimate.getExecutingDepartment());
            this.revisionEstimate.setUserDepartment(this.abstractEstimate.getUserDepartment());
            this.revisionEstimate.setWard(this.abstractEstimate.getWard());
            this.revisionEstimate.setDepositCode(this.abstractEstimate.getDepositCode());
            this.revisionEstimate.setFundSource(this.abstractEstimate.getFundSource());
        }
        this.revisionEstimate.deleteNonSORActivities();
        this.revisionEstimate.getActivities().clear();
        this.populateSorActivities((AbstractEstimate)this.revisionEstimate);
        this.populateNonSorActivities((AbstractEstimate)this.revisionEstimate);
        this.populateActivities((AbstractEstimate)this.revisionEstimate);
        this.populateChangeQuantityItems();
    }

    public boolean getShowBudgetFolio() {
        return this.revisionEstimateService.getShowBudgetFolio((AbstractEstimate)this.revisionEstimate);
    }

    public boolean getShowDepositFolio() {
        return this.revisionEstimateService.getShowDepositFolio((AbstractEstimate)this.revisionEstimate);
    }

    protected void populateChangeQuantityItems() {
        for (WorkOrderActivity woa : this.changeQuantityActivities) {
            if (woa == null) continue;
            WorkOrderActivity parentWOA = (WorkOrderActivity)this.getPersistenceService().find("from WorkOrderActivity where id=?", new Object[]{woa.getId()});
            TenderResponse tenderResponse = (TenderResponse)this.persistenceService.find("from TenderResponse tr where tr.egwStatus.code = 'APPROVED' and tr.negotiationNumber = ?", new Object[]{this.workOrder.getNegotiationNumber()});
            woa.getActivity().setAbstractEstimate((AbstractEstimate)this.revisionEstimate);
            if ("-".equals(woa.getActivity().getSignValue())) {
                woa.getActivity().setRevisionType(RevisionType.REDUCED_QUANTITY);
            } else {
                woa.getActivity().setRevisionType(RevisionType.ADDITIONAL_QUANTITY);
            }
            woa.getActivity().setParent(parentWOA.getActivity());
            woa.getActivity().setUom(parentWOA.getActivity().getUom());
            if (tenderResponse.getTenderEstimate().getTenderType().equalsIgnoreCase("Percentage-Tender")) {
                woa.getActivity().setRate(parentWOA.getActivity().getRate());
            } else if (this.revisionEstimate.getId() == null) {
                if (parentWOA.getActivity() != null && parentWOA.getActivity().getRevisionType() != null && parentWOA.getActivity().getRevisionType().toString().equalsIgnoreCase(RevisionType.NON_TENDERED_ITEM.toString())) {
                    woa.getActivity().setRate(woa.getActivity().getRate() * parentWOA.getActivity().getConversionFactorForRE(this.workOrder.getWorkOrderDate()));
                } else {
                    woa.getActivity().setRate(woa.getActivity().getRate() * parentWOA.getActivity().getConversionFactor());
                }
            } else {
                woa.getActivity().setRate(woa.getActivity().getRate());
            }
            if (parentWOA.getActivity().getNonSor() == null) {
                woa.getActivity().setSchedule(parentWOA.getActivity().getSchedule());
            } else {
                woa.getActivity().setNonSor(parentWOA.getActivity().getNonSor());
            }
            this.revisionEstimate.addActivity(woa.getActivity());
        }
    }

    public String searchActivitiesForRE() {
        HashMap<String, Object> criteriaMap = new HashMap<String, Object>();
        if (this.originalWOId != null) {
            criteriaMap.put("WORKORDER_ID", this.originalWOId);
        }
        if (this.originalEstimateId != null) {
            criteriaMap.put("WORKORDER_ESTIMATE_ID", this.originalEstimateId);
        }
        if (this.activityCode != null && !"".equalsIgnoreCase(this.activityCode)) {
            criteriaMap.put("ACTIVITY_CODE", this.activityCode);
        }
        if (this.activityDesc != null && !"".equalsIgnoreCase(this.activityDesc)) {
            criteriaMap.put("ACTIVITY_DESC", this.activityDesc);
        }
        List tempActivityList = this.workOrderService.searchWOActivitiesForChangeQuantity(criteriaMap);
        this.activityList = new ArrayList();
        for (WorkOrderActivity woa : tempActivityList) {
            if (woa.getActivity() != null && woa.getActivity().getRevisionType() != null && (woa.getActivity().getRevisionType().toString().equalsIgnoreCase(RevisionType.ADDITIONAL_QUANTITY.toString()) || woa.getActivity().getRevisionType().toString().equalsIgnoreCase(RevisionType.REDUCED_QUANTITY.toString()))) continue;
            this.activityList.add(woa);
        }
        return ACTIVITY_SEARCH;
    }

    protected RevisionWorkOrder createRevisionWO(String curStatus) {
        RevisionWorkOrder revisionWO = new RevisionWorkOrder();
        if (this.revisionWorkOrder != null && this.revisionWorkOrder.getId() != null) {
            revisionWO = this.revisionWorkOrder;
        } else {
            revisionWO.setParent(this.workOrder);
            revisionWO.setWorkOrderDate(this.revisionEstimate.getEstimateDate());
            revisionWO.setWorkOrderNumber(this.workOrder.getWorkOrderNumber() + "/RW".concat(Integer.toString(this.reCount)));
            revisionWO.setContractor(this.workOrder.getContractor());
            revisionWO.setEngineerIncharge(this.workOrder.getEngineerIncharge());
            revisionWO.setEmdAmountDeposited(1.0E-5);
            revisionWO.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("WorkOrder", "NEW"));
        }
        if (((String[])this.parameters.get(ACTION_NAME))[0].equalsIgnoreCase("Approve")) {
            revisionWO.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("WorkOrder", "APPROVED"));
        }
        if (((String[])this.parameters.get(ACTION_NAME))[0].equalsIgnoreCase("Cancel")) {
            revisionWO.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("WorkOrder", "CANCELLED"));
        }
        if (curStatus.equals("NEW") || curStatus.equals("REJECTED")) {
            this.populateWorkOrderActivities(revisionWO);
        }
        return revisionWO;
    }

    protected void populateWorkOrderActivities(RevisionWorkOrder revisionWO) {
        WorkOrderEstimate workOrderEstimate = new WorkOrderEstimate();
        workOrderEstimate.setEstimate((AbstractEstimate)this.revisionEstimate);
        workOrderEstimate.setWorkOrder((WorkOrder)revisionWO);
        this.addWorkOrderEstimateActivities(workOrderEstimate, revisionWO);
        revisionWO.addWorkOrderEstimate(workOrderEstimate);
    }

    private void addWorkOrderEstimateActivities(WorkOrderEstimate workOrderEstimate, RevisionWorkOrder revisionWO) {
        double woTotalAmount = 0.0;
        double approvedAmount = 0.0;
        TenderResponse tenderResponse = (TenderResponse)this.persistenceService.find("from TenderResponse tr where tr.egwStatus.code = 'APPROVED' and tr.negotiationNumber = ?", new Object[]{revisionWO.getParent().getNegotiationNumber()});
        for (Activity activity : this.revisionEstimate.getActivities()) {
            WorkOrderActivity workOrderActivity = new WorkOrderActivity();
            workOrderActivity.setActivity(activity);
            approvedAmount = 0.0;
            if (activity != null && activity.getRevisionType() != null && (activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.NON_TENDERED_ITEM.toString()) || activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.LUMP_SUM_ITEM.toString()))) {
                workOrderActivity.setApprovedRate(activity.getRate() / activity.getConversionFactorForRE(this.workOrder.getWorkOrderDate()));
            } else if (activity != null && activity.getRevisionType() != null && (activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.ADDITIONAL_QUANTITY.toString()) || activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.REDUCED_QUANTITY.toString()))) {
                if (tenderResponse.getTenderEstimate().getTenderType().equalsIgnoreCase("Percentage-Tender")) {
                    workOrderActivity.setApprovedRate(activity.getRate() / activity.getConversionFactorForRE(this.revisionEstimate.getParent().getEstimateDate()));
                } else {
                    WorkOrderActivity parentWOA = (WorkOrderActivity)this.persistenceService.find("from WorkOrderActivity woa where woa.workOrderEstimate.workOrder.egwStatus.code = ? and woa.activity.id = ? ", new Object[]{"APPROVED", activity.getParent().getId()});
                    workOrderActivity.setApprovedRate(parentWOA.getApprovedRate());
                }
            }
            workOrderActivity.setApprovedQuantity(activity.getQuantity());
            approvedAmount = new Money(activity.getRate() * workOrderActivity.getApprovedQuantity()).getValue();
            if (activity.getRevisionType() != null && activity.getRevisionType().equals((Object)RevisionType.REDUCED_QUANTITY)) {
                approvedAmount *= -1.0;
            }
            if (activity != null && activity.getRevisionType() != null && (activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.ADDITIONAL_QUANTITY.toString()) || activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.REDUCED_QUANTITY.toString())) && tenderResponse.getTenderEstimate().getTenderType().equalsIgnoreCase("Percentage-Tender")) {
                approvedAmount += approvedAmount * tenderResponse.getPercNegotiatedAmountRate() / 100.0;
            }
            woTotalAmount += approvedAmount;
            workOrderActivity.setApprovedAmount(approvedAmount);
            workOrderActivity.setWorkOrderEstimate(workOrderEstimate);
            workOrderEstimate.addWorkOrderActivity(workOrderActivity);
        }
        workOrderEstimate.getWorkOrder().setWorkOrderAmount(woTotalAmount);
    }

    public String loadSearchForActivity() {
        return ACTIVITY_SEARCH;
    }

    protected void populateSorActivities(AbstractEstimate abstractEstimate) {
        for (Activity activity : this.sorActivities) {
            if (!this.validSorActivity(activity)) continue;
            activity.setSchedule((ScheduleOfRate)this.getPersistenceService().find("from ScheduleOfRate where id = ?", new Object[]{activity.getSchedule().getId()}));
            activity.setUom(activity.getSchedule().getUom());
            abstractEstimate.addActivity(activity);
        }
    }

    protected boolean validSorActivity(Activity activity) {
        return activity != null && activity.getSchedule() != null && activity.getSchedule().getId() != null;
    }

    protected void populateNonSorActivities(AbstractEstimate abstractEstimate) {
        for (Activity activity : this.nonSorActivities) {
            if (activity == null) continue;
            activity.setUom(activity.getNonSor().getUom());
            if (activity.getNonSor().getId() != null && activity.getNonSor().getId() != 0L && activity.getNonSor().getId() != 1L) {
                NonSor nonsor = (NonSor)this.getPersistenceService().find("from NonSor where id = ?", new Object[]{activity.getNonSor().getId()});
                if (nonsor == null) {
                    activity.getNonSor().setId(null);
                    this.nonSorService.persist((Object)activity.getNonSor());
                } else {
                    activity.setNonSor(nonsor);
                }
            } else if (activity.getNonSor() != null) {
                this.nonSorService.persist((Object)activity.getNonSor());
            }
            abstractEstimate.addActivity(activity);
        }
    }

    private void populateActivities(AbstractEstimate abstractEstimate) {
        int count = 1;
        for (Activity activity : abstractEstimate.getActivities()) {
            activity.setAbstractEstimate(abstractEstimate);
            if (activity.getSchedule() != null) {
                activity.setRevisionType(RevisionType.NON_TENDERED_ITEM);
            } else {
                activity.setRevisionType(RevisionType.LUMP_SUM_ITEM);
            }
            if (activity.getSrlNo() == null) continue;
            activity.setSrlNo(Integer.valueOf(count++));
        }
    }

    public void getDesignation(RevisionAbstractEstimate revisionEstimate) {
        String result;
        if (revisionEstimate.getEgwStatus() != null && !"NEW".equalsIgnoreCase(revisionEstimate.getEgwStatus().getCode()) && (result = this.worksService.getEmpNameDesignation(revisionEstimate.getState().getOwnerPosition(), revisionEstimate.getState().getCreatedDate())) != null && !"@".equalsIgnoreCase(result)) {
            String empName = result.substring(0, result.lastIndexOf(64));
            String designation = result.substring(result.lastIndexOf(64) + 1, result.length());
            this.setEmployeeName(empName);
            this.setDesignation(designation);
        }
    }

    private void validateNonSorActivities() {
        Set exceptionSor = this.worksService.getExceptionSOR().keySet();
        for (Activity activity : this.nonSorActivities) {
            UOM nonSorUom;
            if (activity == null || activity.getNonSor().getUom() == null || (nonSorUom = (UOM)this.getPersistenceService().find("from UOM where id = ?", new Object[]{activity.getNonSor().getUom().getId()})) == null || !exceptionSor.contains(nonSorUom.getUom())) continue;
            throw new ValidationException(Arrays.asList(new ValidationError("validate.nonSor.uom", "validate.nonSor.uom")));
        }
    }

    public AbstractEstimate getAbstractEstimate() {
        return this.abstractEstimate;
    }

    public RevisionAbstractEstimate getRevisionEstimate() {
        return this.revisionEstimate;
    }

    public void setRevisionEstimate(RevisionAbstractEstimate revisionEstimate) {
        this.revisionEstimate = revisionEstimate;
    }

    protected String getPendingActions() {
        return this.getModel().getState() != null ? this.getModel().getState().getNextAction() : "";
    }

    public void setRevisionEstimateWorkflowService(WorkflowService<RevisionAbstractEstimate> workflowService) {
        this.workflowService = workflowService;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public String getEmployeeName() {
        return this.employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getDesignation() {
        return this.designation;
    }

    public void setDesignation(String designation) {
        this.designation = designation;
    }

    public String getAdditionalRuleValue() {
        this.additionalRuleValue = this.getAdditionalRule();
        return this.additionalRuleValue;
    }

    public void setAdditionalRuleValue(String additionalRuleValue) {
        this.additionalRuleValue = additionalRuleValue;
    }

    public String getDepartmentName() {
        return this.departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setEmployeeService(EmployeeServiceOld employeeService) {
        this.employeeService = employeeService;
    }

    public AbstractEstimateService getAbstractEstimateService() {
        return this.abstractEstimateService;
    }

    public void setAbstractEstimateService(AbstractEstimateService abstractEstimateService) {
        this.abstractEstimateService = abstractEstimateService;
    }

    public void setRevisionAbstractEstimateService(PersistenceService<RevisionAbstractEstimate, Long> revisionAbstractEstimateService) {
        this.revisionAbstractEstimateService = revisionAbstractEstimateService;
    }

    public void setWorkOrderService(WorkOrderService workOrderService) {
        this.workOrderService = workOrderService;
    }

    public WorkOrderService getWorkOrderService() {
        return this.workOrderService;
    }

    public List<Activity> getOriginalRevisedActivityList() {
        return this.originalRevisedActivityList;
    }

    public void setOriginalRevisedActivityList(List<Activity> originalRevisedActivityList) {
        this.originalRevisedActivityList = originalRevisedActivityList;
    }

    public double getOriginalTotalAmount() {
        return this.originalTotalAmount;
    }

    public void setOriginalTotalAmount(double originalTotalAmount) {
        this.originalTotalAmount = originalTotalAmount;
    }

    public double getOriginalTotalTax() {
        return this.originalTotalTax;
    }

    public void setOriginalTotalTax(double originalTotalTax) {
        this.originalTotalTax = originalTotalTax;
    }

    public double getOriginalWorkValueIncludingTax() {
        return this.originalWorkValueIncludingTax;
    }

    public void setOriginalWorkValueIncludingTax(double originalWorkValueIncludingTax) {
        this.originalWorkValueIncludingTax = originalWorkValueIncludingTax;
    }

    public String getSourcepage() {
        return this.sourcepage;
    }

    public void setSourcepage(String sourcepage) {
        this.sourcepage = sourcepage;
    }

    public Long getOriginalEstimateId() {
        return this.originalEstimateId;
    }

    public void setOriginalEstimateId(Long originalEstimateId) {
        this.originalEstimateId = originalEstimateId;
    }

    public double getRevisionEstimatesValue() {
        return this.revisionEstimatesValue;
    }

    public void setRevisionEstimatesValue(double revisionEstimatesValue) {
        this.revisionEstimatesValue = revisionEstimatesValue;
    }

    public double getRevisionWOValue() {
        return this.revisionWOValue;
    }

    public void setRevisionWOValue(double revisionWOValue) {
        this.revisionWOValue = revisionWOValue;
    }

    public List<RevisionAbstractEstimate> getReList() {
        return this.reList;
    }

    public void setReList(List<RevisionAbstractEstimate> reList) {
        this.reList = reList;
    }

    public void setAbstractEstimate(AbstractEstimate abstractEstimate) {
        this.abstractEstimate = abstractEstimate;
    }

    public WorkOrder getWorkOrder() {
        return this.workOrder;
    }

    public void setWorkOrder(WorkOrder workOrder) {
        this.workOrder = workOrder;
    }

    public Long getOriginalWOId() {
        return this.originalWOId;
    }

    public void setOriginalWOId(Long originalWOId) {
        this.originalWOId = originalWOId;
    }

    public List<Activity> getSorActivities() {
        return this.sorActivities;
    }

    public void setSorActivities(List<Activity> sorActivities) {
        this.sorActivities = sorActivities;
    }

    public List<Activity> getNonSorActivities() {
        return this.nonSorActivities;
    }

    public void setNonSorActivities(List<Activity> nonSorActivities) {
        this.nonSorActivities = nonSorActivities;
    }

    public PersistenceService<NonSor, Long> getNonSorService() {
        return this.nonSorService;
    }

    public void setNonSorService(PersistenceService<NonSor, Long> nonSorService) {
        this.nonSorService = nonSorService;
    }

    public String getEstimateValue() {
        return this.estimateValue;
    }

    public void setEstimateValue(String estimateValue) {
        this.estimateValue = estimateValue;
    }

    public RevisionWorkOrder getRevisionWorkOrder() {
        return this.revisionWorkOrder;
    }

    public void setRevisionWorkOrder(RevisionWorkOrder revisionWorkOrder) {
        this.revisionWorkOrder = revisionWorkOrder;
    }

    public void setRevisionWorkOrderService(PersistenceService<RevisionWorkOrder, Long> revisionWorkOrderService) {
        this.revisionWorkOrderService = revisionWorkOrderService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public Integer getApproverPositionId() {
        return this.approverPositionId;
    }

    public void setApproverPositionId(Integer approverPositionId) {
        this.approverPositionId = approverPositionId;
    }

    public Long getLogedInUserDept() {
        return this.logedInUserDept;
    }

    public void setLogedInUserDept(Long logedInUserDept) {
        this.logedInUserDept = logedInUserDept;
    }

    public String getActivityCode() {
        return this.activityCode;
    }

    public String getActivityDesc() {
        return this.activityDesc;
    }

    public List<WorkOrderActivity> getActivityList() {
        return this.activityList;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    public void setActivityDesc(String activityDesc) {
        this.activityDesc = activityDesc;
    }

    public void setActivityList(List<WorkOrderActivity> activityList) {
        this.activityList = activityList;
    }

    public String getWorkorderNo() {
        return this.workorderNo;
    }

    public void setWorkorderNo(String workorderNo) {
        this.workorderNo = workorderNo;
    }

    public List<WorkOrderActivity> getChangeQuantityActivities() {
        return this.changeQuantityActivities;
    }

    public void setChangeQuantityActivities(List<WorkOrderActivity> changeQuantityActivities) {
        this.changeQuantityActivities = changeQuantityActivities;
    }

    public void setRevisionEstimateService(RevisionEstimateService revisionEstimateService) {
        this.revisionEstimateService = revisionEstimateService;
    }

    public boolean getIsBudgetRejectionNoPresent() {
        return this.isBudgetRejectionNoPresent;
    }

    public BigDecimal getAmountRuleValue() {
        this.amountRuleValue = this.getAmountRule();
        return this.amountRuleValue;
    }

    public void setAmountRuleValue(BigDecimal amountRuleValue) {
        this.amountRuleValue = amountRuleValue;
    }
}

