/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.reports;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CFunction;
import org.egov.commons.EgwStatus;
import org.egov.commons.EgwTypeOfWork;
import org.egov.commons.Fund;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.commons.dao.FunctionHibernateDAO;
import org.egov.commons.dao.FundHibernateDAO;
import org.egov.egf.commons.EgovCommon;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.NumberUtil;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQueryHQL;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.budget.BudgetGroup;
import org.egov.pims.model.PersonalInformation;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.AbstractEstimateAppropriation;
import org.egov.works.abstractestimate.entity.FinancialDetail;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.milestone.entity.Milestone;
import org.egov.works.milestone.entity.MilestoneActivity;
import org.egov.works.milestone.entity.PaymentDetail;
import org.egov.works.milestone.entity.TrackMilestone;
import org.egov.works.milestone.entity.TrackMilestoneActivity;
import org.egov.works.milestone.entity.WorkProgressRegister;
import org.egov.works.models.masters.Contractor;
import org.egov.works.models.masters.NatureOfWork;
import org.egov.works.models.measurementbook.MBHeader;
import org.egov.works.models.tender.OfflineStatus;
import org.egov.works.models.tender.TenderResponse;
import org.egov.works.models.tender.TenderResponseContractors;
import org.egov.works.models.tender.WorksPackage;
import org.egov.works.models.workorder.WorkOrder;
import org.egov.works.models.workorder.WorkOrderEstimate;
import org.egov.works.services.ContractorBillService;
import org.egov.works.web.actions.estimate.AjaxEstimateAction;
import org.egov.works.web.actions.reports.AjaxWorkProgressAction;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name={"printPDF"}, type="stream", location="workProgressRegisterStream", params={"inputName", "workProgressRegisterStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=WorkProgressRegisterReport.pdf"}), @Result(name={"printExcel"}, type="stream", location="workProgressRegisterStream", params={"inputName", "workProgressRegisterStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=WorkProgressRegisterReport.xls"})})
public class WorkProgressRegisterAction
extends SearchFormAction {
    private static final long serialVersionUID = -30571718037168928L;
    private static final Logger logger = Logger.getLogger(WorkProgressRegisterAction.class);
    private static final String ASSIGNED_USER_LIST1 = "assignedUserList1";
    private static final String ASSIGNED_USER_LIST2 = "assignedUserList2";
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private BoundaryService boundaryService;
    private EgovCommon egovCommon;
    private ContractorBillService contractorBillService;
    ReportService reportService;
    private final Map<String, String> milestoneStatuses = new LinkedHashMap();
    public static final String dateFormat = "dd/MM/yyyy";
    private Long parentCategory;
    private Long category;
    private String workOrderStatus;
    private String milestoneStatus;
    @Autowired
    private FundHibernateDAO fundDao;
    @Autowired
    private FunctionHibernateDAO functionHibDao;
    private Long expenditureType;
    private Integer fund;
    private Long function;
    private Long budgetHead;
    private Date toDate;
    private Date fromDate;
    private Long execDept;
    private Integer preparedBy;
    private Integer engineerIncharge;
    private Integer engineerIncharge2;
    private static final String TENDER_NOTICE_STATUS = "Noticeinvitingtenderreleased";
    private static final String TENDER_FINALIZATION_STATUS = "L1 tender finalised";
    private static final String BUDGET_HEAD_EMPTY_MSG = "Not Applicable";
    private static final String TENDER_AGGREEMENT_ORDER = "Agreement Order signed";
    private String exportType;
    private InputStream workProgressRegisterStream;
    public static final String PRINT_PDF = "printPDF";
    public static final String PRINT_EXCEL = "printExcel";
    private Integer woId;
    private String sourcePage = "";
    private Integer scheme;
    private Integer subScheme;
    private PersistenceService<OfflineStatus, Long> worksStatusService;
    private static final String STATUS_OBJECTID = "getStatusDateByObjectId_Type_Desc";
    private static final String WO_OBJECT_TYPE = "WorkOrder";
    private static final String WORK_COMMENCED = "Work commenced";
    @Autowired
    private FinancialYearHibernateDAO finHibernateDao;
    private List<WorkProgressRegister> workProgressList = new ArrayList();
    private Integer estId;
    private String contractorName = "";
    private Long contractorId;
    private String searchCriteria = "";
    private Long wardId;
    private String wardName = "";

    public void prepare() {
        AjaxEstimateAction ajaxEstimateAction = new AjaxEstimateAction();
        ajaxEstimateAction.setPersistenceService(this.getPersistenceService());
        this.populateCategoryList(ajaxEstimateAction, this.parentCategory != null);
        this.addDropdownData("parentCategoryList", this.getPersistenceService().findAllBy("from EgwTypeOfWork etw where etw.parentid is null", new Object[0]));
        this.addDropdownData(ASSIGNED_USER_LIST1, this.getPersistenceService().findAllBy("select distinct wo.engineerIncharge from  WorkOrder wo where wo.engineerIncharge.employeeName is not null", new Object[0]));
        this.addDropdownData(ASSIGNED_USER_LIST2, this.getPersistenceService().findAllBy("select distinct wo.engineerIncharge2 from  WorkOrder wo where wo.engineerIncharge2.employeeName is not null", new Object[0]));
        this.addDropdownData("typeList", this.getPersistenceService().findAllBy("from NatureOfWork dt", new Object[0]));
        this.addDropdownData("executingDepartmentList", this.getPersistenceService().findAllBy("from Department order by upper(ame)", new Object[0]));
        List workOrdStatusList = this.getPersistenceService().findAllBy("from EgwStatus st where st.moduletype=? and st.code in (?,?,?,?)", new Object[]{WO_OBJECT_TYPE, "APPROVED", "Work Order acknowledged", "Site handed over", WORK_COMMENCED});
        this.addDropdownData("workOrderStatuses", workOrdStatusList);
        this.addDropdownData("fundList", this.fundDao.findAll());
        this.addDropdownData("budgetGroupList", this.getPersistenceService().findAllBy("from BudgetGroup order by name", new Object[0]));
        this.addDropdownData("functionList", this.functionHibDao.findAll());
        this.addDropdownData("preparedByList", this.getPersistenceService().findAllBy("select distinct wo.workOrderPreparedBy from WorkOrder wo where wo.workOrderPreparedBy.employeeName is not null", new Object[0]));
        this.addDropdownData("schemeList", this.getPersistenceService().findAllBy("from org.egov.commons.Scheme sc where sc.isactive=true", new Object[0]));
        AjaxWorkProgressAction ajaxWorkProgressAction = new AjaxWorkProgressAction();
        this.populateSubSchemeList(ajaxWorkProgressAction, this.getScheme() != null);
        this.prepareMilestoneStatuses();
    }

    public void prepareMilestoneStatuses() {
        this.milestoneStatuses.put("Inprogress1to25", "between 0.01 and 25");
        this.milestoneStatuses.put("Inprogress26to50", "between 25.01 and 50");
        this.milestoneStatuses.put("Inprogress51to75", "between 50.01 and 75");
        this.milestoneStatuses.put("Inprogress76to99", "between 75.01 and 99.99");
        this.milestoneStatuses.put("Completed", "=100");
    }

    protected void populateSubSchemeList(AjaxWorkProgressAction ajaxWorkProgressAction, boolean schemePopulated) {
        if (schemePopulated) {
            ajaxWorkProgressAction.setPersistenceService(this.getPersistenceService());
            ajaxWorkProgressAction.setSchemeId(this.getScheme());
            ajaxWorkProgressAction.loadSubSchemes();
            this.addDropdownData("subSchemeList", ajaxWorkProgressAction.getSubSchemes());
        } else {
            this.addDropdownData("subSchemeList", Collections.emptyList());
        }
    }

    public List getMilestoneStatuses() {
        return new LinkedList(this.milestoneStatuses.keySet());
    }

    public String search() {
        return "search";
    }

    public List<EgwStatus> getWorkOrderStatuses() {
        return this.egwStatusHibernateDAO.getStatusByModule(WorkOrder.class.getSimpleName());
    }

    @SkipValidation
    public String searchDetails() {
        if (!DateUtils.compareDates((Date)this.toDate, (Date)this.fromDate)) {
            this.addFieldError("enddate", this.getText("greaterthan.endDate.fromDate"));
            return "search";
        }
        super.search();
        List objects = this.searchResult.getList();
        ArrayList workProgressRegisterList = (ArrayList)this.getWorkProgressRegisterList(objects);
        this.searchResult.getList().clear();
        this.searchResult.getList().addAll(workProgressRegisterList);
        return "search";
    }

    private List getWorkProgressRegisterList(List workPorgressRegisterList) {
        Iterator iter = workPorgressRegisterList.iterator();
        ArrayList<WorkProgressRegister> tempList = new ArrayList<WorkProgressRegister>();
        while (iter.hasNext()) {
            Map tenderDetail;
            WorkOrderEstimate workOrderEstimate = (WorkOrderEstimate)iter.next();
            WorkOrder workOrder = null;
            AbstractEstimate estimate = null;
            Milestone milestone = null;
            TrackMilestone trackMilestone = null;
            Set mbHeaders = null;
            workOrder = workOrderEstimate.getWorkOrder();
            estimate = workOrderEstimate.getEstimate();
            mbHeaders = workOrderEstimate.getMbHeaders();
            if (workOrderEstimate != null && workOrderEstimate.getMilestone() != null && workOrderEstimate.getMilestone().size() != 0) {
                for (Milestone tempMilestone : workOrderEstimate.getMilestone()) {
                    if (!tempMilestone.getStatus().getCode().equalsIgnoreCase("APPROVED")) continue;
                    milestone = tempMilestone;
                }
            }
            if (milestone != null && milestone.getTrackMilestone() != null && milestone.getTrackMilestone().size() != 0) {
                for (TrackMilestone temptrackMilestone : milestone.getTrackMilestone()) {
                    if (!temptrackMilestone.getStatus().getCode().equalsIgnoreCase("APPROVED")) continue;
                    trackMilestone = temptrackMilestone;
                }
            }
            if (workOrderEstimate == null) continue;
            WorkProgressRegister workProgress = new WorkProgressRegister();
            workProgress.setDept(estimate.getExecutingDepartment().getName());
            workProgress.setWard(estimate.getWard().getName());
            workProgress.setLocation(estimate.getLocation());
            workProgress.setProjectCode(estimate.getProjectCode().getCode());
            workProgress.setEstimateNo(estimate.getEstimateNumber());
            workProgress.setNameOfWork(estimate.getName());
            workProgress.setTypeOfWork(estimate.getParentCategory().getDescription());
            workProgress.setEstimateDate(DateUtils.getFormattedDate((Date)estimate.getEstimateDate(), (String)dateFormat));
            workProgress.setEstimateAmt(new BigDecimal(estimate.getWorkValue()));
            Date techSanctionDate = this.getTechSanctionDate(estimate);
            if (techSanctionDate != null) {
                workProgress.setTechSanctionDate(DateUtils.getFormattedDate((Date)techSanctionDate, (String)dateFormat));
            } else {
                workProgress.setTechSanctionDate(null);
            }
            workProgress.setAdminSanctionDate(DateUtils.getFormattedDate((Date)estimate.getState().getCreatedDate(), (String)dateFormat));
            workProgress.setFund(((FinancialDetail)estimate.getFinancialDetails().get(0)).getFund().getCode());
            workProgress.setFunction(((FinancialDetail)estimate.getFinancialDetails().get(0)).getFunction().getCode());
            if (((FinancialDetail)estimate.getFinancialDetails().get(0)).getBudgetGroup() != null) {
                workProgress.setBudgetHead(((FinancialDetail)estimate.getFinancialDetails().get(0)).getBudgetGroup().getName());
            } else {
                workProgress.setBudgetHead(BUDGET_HEAD_EMPTY_MSG);
            }
            workProgress.setApprInfo(workProgress.getFund() + " || " + workProgress.getFunction() + " || " + workProgress.getBudgetHead());
            int count = 0;
            if (estimate.getAbstractEstimateAppropriations() != null) {
                String apprDetails = null;
                for (AbstractEstimateAppropriation estimateApp : estimate.getAbstractEstimateAppropriations()) {
                    String finyearRange;
                    ++count;
                    if (estimateApp.getBudgetUsage() != null) {
                        if (estimateApp.getBudgetUsage().getConsumedAmount() == 0.0) continue;
                        finyearRange = this.finHibernateDao.getFinancialYearById(Long.valueOf(estimateApp.getBudgetUsage().getFinancialYearId().longValue())).getFinYearRange();
                        if (apprDetails != null) {
                            apprDetails = apprDetails + ", " + count + ")" + finyearRange + ", " + NumberUtil.formatNumber((BigDecimal)new BigDecimal(estimateApp.getBudgetUsage().getConsumedAmount()));
                            continue;
                        }
                        apprDetails = count + ")" + finyearRange + ", " + NumberUtil.formatNumber((BigDecimal)new BigDecimal(estimateApp.getBudgetUsage().getConsumedAmount()));
                        continue;
                    }
                    if (!estimateApp.getDepositWorksUsage().getConsumedAmount().equals(BigDecimal.ZERO)) continue;
                    finyearRange = this.finHibernateDao.getFinancialYearById(Long.valueOf(estimateApp.getDepositWorksUsage().getFinancialYear().getId())).getFinYearRange();
                    if (apprDetails != null) {
                        apprDetails = apprDetails + ", " + count + ")" + finyearRange + ", " + NumberUtil.formatNumber((BigDecimal)new BigDecimal(estimateApp.getBudgetUsage().getConsumedAmount()));
                        continue;
                    }
                    apprDetails = count + ")" + finyearRange + ", " + NumberUtil.formatNumber((BigDecimal)new BigDecimal(estimateApp.getBudgetUsage().getConsumedAmount()));
                }
                workProgress.setApprDetails(apprDetails);
            }
            if ((tenderDetail = this.getTenderDetails(estimate.getId())).get("tenderDate") != null) {
                workProgress.setTenderDate(DateUtils.getFormattedDate((Date)((Date)tenderDetail.get("tenderDate")), (String)dateFormat));
            }
            if (tenderDetail.get("tenderFinalizationDate") != null) {
                workProgress.setTenderFinalizationDate(DateUtils.getFormattedDate((Date)((Date)tenderDetail.get("tenderFinalizationDate")), (String)dateFormat));
            }
            if (tenderDetail.get("aggreementDate") != null) {
                workProgress.setTenderAgreementDate(DateUtils.getFormattedDate((Date)((Date)tenderDetail.get("aggreementDate")), (String)dateFormat));
            }
            if (mbHeaders != null) {
                Map paymentDetails = this.getPaymentDetail(mbHeaders);
                workProgress.setPaymentDetails((List)paymentDetails.get("paymentDetails"));
                workProgress.setTotalBillAmt((BigDecimal)paymentDetails.get("totalBillAmt"));
                workProgress.setTotalReleasedAmt((BigDecimal)paymentDetails.get("totalReleasedAmt"));
                workProgress.setTotalOutstandingAmt((BigDecimal)paymentDetails.get("totalOutstandingAmt"));
                if ((Boolean)paymentDetails.get("isFinalBillCreated") != null) {
                    workProgress.setIsFinalBillCreated((Boolean)paymentDetails.get("isFinalBillCreated"));
                }
            }
            workProgress.setWorkOrderValue(new BigDecimal(workOrder.getWorkOrderAmount()));
            if (workOrder != null) {
                OfflineStatus objStatusForWorkComncd = (OfflineStatus)this.worksStatusService.findByNamedQuery(STATUS_OBJECTID, new Object[]{workOrder.getId(), WO_OBJECT_TYPE, WORK_COMMENCED});
                OfflineStatus objStatusForSiteHandOver = (OfflineStatus)this.worksStatusService.findByNamedQuery(STATUS_OBJECTID, new Object[]{workOrder.getId(), WO_OBJECT_TYPE, "Site handed over"});
                if (objStatusForWorkComncd != null) {
                    workProgress.setWorkCommencementDate(DateUtils.getFormattedDate((Date)objStatusForWorkComncd.getStatusDate(), (String)dateFormat));
                }
                if (objStatusForSiteHandOver != null) {
                    workProgress.setSiteHandedOverDate(DateUtils.getFormattedDate((Date)objStatusForSiteHandOver.getStatusDate(), (String)dateFormat));
                }
            }
            workProgress.setContractPeriod(workOrder.getContractPeriod().toString());
            workProgress.setWorkOrderDate(DateUtils.getFormattedDate((Date)workOrder.getWorkOrderDate(), (String)dateFormat));
            if (trackMilestone != null && "APPROVED".equalsIgnoreCase(trackMilestone.getStatus().getCode())) {
                workProgress.setTrackMilestoneActivities(trackMilestone.getActivities());
                workProgress.setCompletedPercentage(trackMilestone.getTotalPercentage());
            } else if (milestone != null && "APPROVED".equalsIgnoreCase(milestone.getStatus().getCode())) {
                LinkedList<TrackMilestoneActivity> trackList = new LinkedList<TrackMilestoneActivity>();
                for (MilestoneActivity milestoneActivity : milestone.getActivities()) {
                    TrackMilestoneActivity trackMilestoneActivity = new TrackMilestoneActivity();
                    trackMilestoneActivity.setMilestoneActivity(milestoneActivity);
                    trackList.add(trackMilestoneActivity);
                }
                workProgress.setTrackMilestoneActivities(trackList);
            } else {
                workProgress.setTrackMilestoneActivities(Collections.EMPTY_LIST);
            }
            workProgress.setContractorName(workOrder.getContractor().getCode() + "-" + workOrder.getContractor().getName());
            workProgress.setProjectCode(estimate.getProjectCode().getCode());
            if (workProgress.getIsFinalBillCreated().booleanValue()) {
                workProgress.setProjectStatus("Completed");
            } else if ("END".equalsIgnoreCase(workOrder.getCurrentState().getValue()) && workOrder.getEgwStatus().getCode().equalsIgnoreCase("CANCELLED")) {
                workProgress.setProjectStatus("Cancelled");
            } else {
                workProgress.setProjectStatus("In Progress");
            }
            tempList.add(workProgress);
        }
        return tempList;
    }

    public Object getModel() {
        return null;
    }

    protected void populateCategoryList(AjaxEstimateAction ajaxEstimateAction, boolean categoryPopulated) {
        if (categoryPopulated) {
            ajaxEstimateAction.setCategory(this.parentCategory);
            ajaxEstimateAction.subcategories();
            this.addDropdownData("categoryList", ajaxEstimateAction.getSubCategories());
        } else {
            this.addDropdownData("categoryList", Collections.emptyList());
        }
    }

    private Date getTechSanctionDate(AbstractEstimate estimate) {
        for (StateHistory stateHistory : estimate.getCurrentState().getHistory()) {
            if (!stateHistory.getValue().equalsIgnoreCase("TECH_SANCTIONED")) continue;
            return stateHistory.getCreatedDate();
        }
        return null;
    }

    private Map getTenderDetails(Long estimateId) {
        String query = "select wpkg,tr from TenderResponse tr,WorksPackage wpkg left outer join wpkg.worksPackageDetails wpkgd where tr.tenderEstimate.worksPackage.id=wpkg.id and wpkgd.estimate.id=?";
        ArrayList<Long> paramList = new ArrayList<Long>();
        paramList.add(estimateId);
        List result = this.persistenceService.findAllBy("select wpkg,tr from TenderResponse tr,WorksPackage wpkg left outer join wpkg.worksPackageDetails wpkgd where tr.tenderEstimate.worksPackage.id=wpkg.id and wpkgd.estimate.id=?", paramList.toArray());
        Iterator iterator = result.iterator();
        HashMap<String, Date> tenderDates = new HashMap<String, Date>();
        while (iterator.hasNext()) {
            OfflineStatus objStatusForSite;
            TenderResponse tenderResponse;
            Object[] objects = (Object[])iterator.next();
            if (objects[0] != null) {
                WorksPackage worksPackage = (WorksPackage)objects[0];
                for (OfflineStatus status : worksPackage.getOfflineStatuses()) {
                    if (TENDER_NOTICE_STATUS.equalsIgnoreCase(status.getEgwStatus().getCode())) {
                        tenderDates.put("tenderDate", status.getCreatedDate());
                    }
                    if (!TENDER_FINALIZATION_STATUS.equalsIgnoreCase(status.getEgwStatus().getCode())) continue;
                    tenderDates.put("tenderFinalizationDate", status.getCreatedDate());
                }
            }
            if (objects[1] == null || (tenderResponse = (TenderResponse)objects[1]) == null || (objStatusForSite = (OfflineStatus)this.worksStatusService.findByNamedQuery(STATUS_OBJECTID, new Object[]{((TenderResponseContractors)tenderResponse.getTenderResponseContractors().get(0)).getId(), "TenderResponseContractors", TENDER_AGGREEMENT_ORDER})) == null) continue;
            tenderDates.put("aggreementDate", objStatusForSite.getStatusDate());
        }
        return tenderDates;
    }

    public Map<String, Object> getPaymentDetail(Set<MBHeader> mbHeaders) {
        BigDecimal totalBillAmount = BigDecimal.ZERO;
        BigDecimal totalReleasedAmt = BigDecimal.ZERO;
        BigDecimal totalOutstandingAmt = BigDecimal.ZERO;
        BigDecimal totalNetPayableAmt = BigDecimal.ZERO;
        HashMap<String, Object> result = new HashMap<String, Object>();
        LinkedList<PaymentDetail> paymentDetailList = new LinkedList<PaymentDetail>();
        for (MBHeader mbHeader : mbHeaders) {
            PaymentDetail paymentDetail = new PaymentDetail();
            ContractorBillRegister egBillRegister = mbHeader.getEgBillregister();
            BigDecimal netPayableAmt = BigDecimal.ZERO;
            if (egBillRegister == null || egBillRegister.getStatus() == null || !egBillRegister.getStatus().getCode().equalsIgnoreCase("APPROVED")) continue;
            paymentDetail.setBillAmount(egBillRegister.getBillamount());
            paymentDetail.setBillDate(DateUtils.getFormattedDate((Date)egBillRegister.getBilldate(), (String)dateFormat));
            paymentDetail.setBillNumber(egBillRegister.getBillnumber());
            paymentDetail.setBillType(egBillRegister.getBilltype());
            if (egBillRegister.getEgBillregistermis().getVoucherHeader() != null && egBillRegister.getEgBillregistermis().getVoucherHeader().getVoucherNumber() != null && !egBillRegister.getEgBillregistermis().getVoucherHeader().getVoucherNumber().equals("") && egBillRegister.getEgBillregistermis().getVoucherHeader().getStatus() != null && egBillRegister.getEgBillregistermis().getVoucherHeader().getStatus() == 0) {
                paymentDetail.setCjvNo(egBillRegister.getEgBillregistermis().getVoucherHeader().getVoucherNumber());
                logger.debug((Object)("Bill Number : " + egBillRegister.getBillnumber() + " --- CJVNo : " + egBillRegister.getEgBillregistermis().getVoucherHeader().getVoucherNumber()));
            }
            try {
                paymentDetail.setReleasedAmount(this.egovCommon.getPaymentAmount(egBillRegister.getId()));
                netPayableAmt = this.contractorBillService.getNetPayableAmountForGlCodeId(egBillRegister.getId());
            }
            catch (ApplicationException egovExp) {
                logger.error((Object)"Error: Getting payment for a contractor bill", (Throwable)egovExp);
                paymentDetail.setReleasedAmount(BigDecimal.ZERO);
            }
            paymentDetail.setOutstandingAmount(netPayableAmt.subtract(paymentDetail.getReleasedAmount()));
            totalNetPayableAmt = totalNetPayableAmt.add(netPayableAmt);
            totalBillAmount = totalBillAmount.add(paymentDetail.getBillAmount());
            totalReleasedAmt = totalReleasedAmt.add(paymentDetail.getReleasedAmount());
            if (egBillRegister.getBilltype().equalsIgnoreCase((String)this.contractorBillService.getBillType().get(1)) && egBillRegister.getEgBillregistermis().getVoucherHeader() != null && egBillRegister.getEgBillregistermis().getVoucherHeader().getVoucherNumber() != null && !egBillRegister.getEgBillregistermis().getVoucherHeader().getVoucherNumber().equals("") && egBillRegister.getEgBillregistermis().getVoucherHeader().getStatus() != null && egBillRegister.getEgBillregistermis().getVoucherHeader().getStatus() == 0) {
                result.put("isFinalBillCreated", Boolean.TRUE);
            } else {
                result.put("isFinalBillCreated", Boolean.FALSE);
            }
            paymentDetailList.add(paymentDetail);
        }
        totalOutstandingAmt = totalNetPayableAmt.subtract(totalReleasedAmt);
        result.put("paymentDetails", paymentDetailList);
        result.put("totalBillAmt", totalBillAmount);
        result.put("totalReleasedAmt", totalReleasedAmt);
        result.put("totalOutstandingAmt", totalOutstandingAmt);
        return result;
    }

    public Long getParentCategory() {
        return this.parentCategory;
    }

    public void setParentCategory(Long parentCategory) {
        this.parentCategory = parentCategory;
    }

    public Long getCategory() {
        return this.category;
    }

    public void setCategory(Long category) {
        this.category = category;
    }

    public String getWorkOrderStatus() {
        return this.workOrderStatus;
    }

    public void setWorkOrderStatus(String workOrderStatus) {
        this.workOrderStatus = workOrderStatus;
    }

    public String getMilestoneStatus() {
        return this.milestoneStatus;
    }

    public void setMilestoneStatus(String milestoneStatus) {
        this.milestoneStatus = milestoneStatus;
    }

    public Long getExpenditureType() {
        return this.expenditureType;
    }

    public void setExpenditureType(Long expenditureType) {
        this.expenditureType = expenditureType;
    }

    public Integer getFund() {
        return this.fund;
    }

    public void setFund(Integer fund) {
        this.fund = fund;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Long getExecDept() {
        return this.execDept;
    }

    public void setExecDept(Long execDept) {
        this.execDept = execDept;
    }

    public Integer getPreparedBy() {
        return this.preparedBy;
    }

    public void setPreparedBy(Integer preparedBy) {
        this.preparedBy = preparedBy;
    }

    public Integer getEngineerIncharge() {
        return this.engineerIncharge;
    }

    public void setEngineerIncharge(Integer engineerIncharge) {
        this.engineerIncharge = engineerIncharge;
    }

    public Integer getEngineerIncharge2() {
        return this.engineerIncharge2;
    }

    public void setEngineerIncharge2(Integer engineerIncharge2) {
        this.engineerIncharge2 = engineerIncharge2;
    }

    @SkipValidation
    public String viewWorkProgressRegister() {
        ReportOutput reportOutput;
        HashMap queryMap = this.getQueryForWorkProgressRegister();
        String finalQuery = (String)queryMap.get("finalQuery");
        ArrayList paramList = (ArrayList)queryMap.get("params");
        List workPorgressRegisterList = this.persistenceService.findAllBy(finalQuery, paramList.toArray());
        HashMap<String, String> reportParams = new HashMap<String, String>();
        reportParams.put("searchCriteria", this.searchCriteria);
        ReportRequest reportInput = new ReportRequest("workProgressRegister", (Collection)this.getWorkProgressRegisterList(workPorgressRegisterList), reportParams);
        if (PRINT_EXCEL.equalsIgnoreCase(this.exportType)) {
            reportInput.setReportFormat(ReportConstants.FileFormat.XLS);
        }
        if ((reportOutput = this.reportService.createReport(reportInput)) != null && reportOutput.getReportOutputData() != null) {
            this.workProgressRegisterStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
        }
        if (PRINT_PDF.equalsIgnoreCase(this.exportType)) {
            return PRINT_PDF;
        }
        return PRINT_EXCEL;
    }

    public HashMap<String, Object> getQueryForWorkProgressRegister() {
        StringBuffer query = new StringBuffer(500);
        ArrayList<Object> paramList = new ArrayList<Object>();
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        StringBuilder srchCrit = new StringBuilder(3000);
        StringBuffer orderQry = new StringBuffer(100);
        srchCrit.append("Report");
        query.append("from org.egov.works.models.workorder.WorkOrderEstimate as woe left outer join woe.milestone milestone left outer join milestone.trackMilestone trackMilestone ");
        query.append("where woe.workOrder.parent is null and woe.workOrder.egwStatus.code='APPROVED' ");
        query.append("and milestone.egwStatus.code='APPROVED' and trackMilestone.egwStatus.code='APPROVED' ");
        if (this.sourcePage == null || StringUtils.isEmpty((String)this.sourcePage)) {
            if (!this.workOrderStatus.equalsIgnoreCase("-1")) {
                srchCrit.append(" for Work Order Status " + this.workOrderStatus);
                if (this.workOrderStatus.equalsIgnoreCase("APPROVED")) {
                    query.append(" and woe.workOrder.egwStatus.code=?");
                    query.append(" and woe.workOrder.id not in (select objectId from org.egov.works.models.tender.OfflineStatus where objectType=?)");
                    paramList.add(this.workOrderStatus);
                    paramList.add(WorkOrder.class.getSimpleName());
                } else {
                    query.delete(0, query.length() - 1);
                    query.append("from org.egov.works.models.workorder.WorkOrderEstimate  as woe left outer join woe.milestone milestone left outer join milestone.trackMilestone trackMilestone,org.egov.works.models.tender.OfflineStatus st");
                    query.append(" where st.objectId=woe.workOrder.id and st.id=(select max(id) from org.egov.works.models.tender.OfflineStatus where objectId=woe.workOrder.id and objectType=?) and st.objectType=? and st.egwStatus.code=?");
                    query.append(" and woe.workOrder.parent is null and woe.workOrder.egwStatus.code='APPROVED' ");
                    query.append(" and milestone.egwStatus.code='APPROVED' and trackMilestone.egwStatus.code='APPROVED' ");
                    paramList.add(WorkOrder.class.getSimpleName());
                    paramList.add(WorkOrder.class.getSimpleName());
                    paramList.add(this.workOrderStatus);
                }
            }
            if (this.execDept != -1L) {
                Department dept = this.departmentService.getDepartmentById(this.execDept);
                srchCrit.append(" in " + dept.getName() + " Department ");
                query.append(" and woe.estimate.executingDepartment.id=?");
                paramList.add(this.execDept);
            }
            if (this.fromDate != null && this.toDate == null && this.getFieldErrors().isEmpty()) {
                srchCrit.append(" from " + DateUtils.getFormattedDate((Date)this.fromDate, (String)dateFormat) + " to current date ");
                query.append(" and woe.workOrder.workOrderDate >= ? ");
                paramList.add(this.fromDate);
            }
            if (this.fromDate == null && this.toDate != null && this.getFieldErrors().isEmpty()) {
                srchCrit.append(" as on " + DateUtils.getFormattedDate((Date)this.toDate, (String)dateFormat));
                query.append(" and woe.workOrder.workOrderDate <= ? ");
                paramList.add(this.toDate);
            }
            if (this.fromDate != null && this.toDate != null && this.getFieldErrors().isEmpty()) {
                srchCrit.append(" for date range " + DateUtils.getFormattedDate((Date)this.fromDate, (String)dateFormat) + " - " + DateUtils.getFormattedDate((Date)this.toDate, (String)dateFormat));
                query.append(" and woe.workOrder.workOrderDate between ? and ? ");
                paramList.add(this.fromDate);
                paramList.add(this.toDate);
            }
            if (this.contractorId != null) {
                Contractor contractor = (Contractor)this.getPersistenceService().find("from Contractor where id=?", new Object[]{this.contractorId});
                srchCrit.append(" for Contractor " + contractor.getCode() + "-" + contractor.getName());
                query.append("and woe.workOrder.contractor.id=? ");
                paramList.add(this.contractorId);
            }
            if (this.expenditureType != -1L) {
                NatureOfWork wtype = (NatureOfWork)this.getPersistenceService().find("from NatureOfWork where id=?", new Object[]{this.expenditureType});
                srchCrit.append(" with Nature of Work " + wtype.getName());
                query.append(" and woe.estimate.type.id=?");
                paramList.add(this.expenditureType);
            }
            if (this.fund != -1) {
                Fund f = (Fund)this.getPersistenceService().find("from Fund where id=?", new Object[]{this.fund});
                srchCrit.append(" under Fund " + f.getName());
                query.append(" and woe.estimate.financialDetails[0].fund.id=?");
                paramList.add(this.fund);
            }
            if (this.function != -1L) {
                CFunction fun = (CFunction)this.getPersistenceService().find("from CFunction where id=?", new Object[]{this.function});
                srchCrit.append(" for Function " + fun.getName());
                query.append(" and woe.estimate.financialDetails[0].function.id=?");
                paramList.add(this.function);
            }
            if (this.parentCategory != -1L) {
                EgwTypeOfWork tow = (EgwTypeOfWork)this.getPersistenceService().find("from EgwTypeOfWork etw where etw.parentid is null and id=?", new Object[]{this.parentCategory});
                srchCrit.append(" with Type of Work " + tow.getDescription());
                query.append(" and woe.estimate.parentCategory.id=?");
                paramList.add(this.parentCategory);
            }
            if (this.category != -1L) {
                EgwTypeOfWork subtow = (EgwTypeOfWork)this.getPersistenceService().find("from EgwTypeOfWork etw where id=? and parentid.id=?", new Object[]{this.category, this.parentCategory});
                srchCrit.append(" and Subtype of Work " + subtow.getDescription());
                query.append(" and woe.estimate.category.id=?");
                paramList.add(this.category);
            }
            if (this.preparedBy != -1) {
                PersonalInformation prepBy = (PersonalInformation)this.getPersistenceService().find("from PersonalInformation where id=?", new Object[]{this.preparedBy});
                srchCrit.append(" as Prepared by " + prepBy.getEmployeeName());
                query.append(" and woe.workOrder.workOrderPreparedBy.idPersonalInformation=?");
                paramList.add(this.preparedBy);
            }
            if (this.getScheme() != null && this.getScheme() != -1) {
                Scheme sch = (Scheme)this.getPersistenceService().find("from Scheme where isactive=true and id=?", new Object[]{this.getScheme()});
                srchCrit.append(" under Scheme " + sch.getName());
                query.append(" and woe.estimate.financialDetails[0].scheme.id=?");
                paramList.add(this.getScheme());
            }
            if (this.getSubScheme() != null && this.getSubScheme() != -1) {
                SubScheme subsch = (SubScheme)this.getPersistenceService().find("from SubScheme where id=?", new Object[]{this.getSubScheme()});
                srchCrit.append(" and Subscheme " + subsch.getName());
                query.append(" and woe.estimate.financialDetails[0].subScheme.id=?");
                paramList.add(this.getSubScheme());
            }
            if (this.budgetHead != -1L) {
                BudgetGroup bh = (BudgetGroup)this.getPersistenceService().find("from BudgetGroup where id=?", new Object[]{this.budgetHead});
                srchCrit.append(" with Budget Head " + bh.getName());
                query.append(" and woe.estimate.financialDetails[0].budgetGroup.id=?");
                paramList.add(this.budgetHead);
            }
            if (this.wardId != null) {
                Boundary wardObj = this.boundaryService.getBoundaryById(this.wardId);
                srchCrit.append(" under Jurisdiction " + wardObj.getName());
                query.append(" and woe.estimate.ward.id = ? ");
                paramList.add(this.wardId);
            }
            if (!this.milestoneStatus.equalsIgnoreCase("-1")) {
                srchCrit.append(" with Milestone Status " + this.milestoneStatus);
                query.append(" and trackMilestone.total " + (String)this.milestoneStatuses.get(this.milestoneStatus));
                query.append(" and trackMilestone.egwStatus.code=? ");
                paramList.add("APPROVED");
            }
            if (this.engineerIncharge != null && this.engineerIncharge != -1) {
                PersonalInformation engInc1 = (PersonalInformation)this.getPersistenceService().find("from PersonalInformation where id=?", new Object[]{this.engineerIncharge});
                srchCrit.append(" for Work Order Assigned to User1 " + engInc1.getEmployeeName());
                query.append(" and woe.workOrder.engineerIncharge.idPersonalInformation=?");
                paramList.add(this.engineerIncharge);
            }
            if (this.engineerIncharge2 != null && this.engineerIncharge2 != -1) {
                PersonalInformation engInc2 = (PersonalInformation)this.getPersistenceService().find("from PersonalInformation where id=?", new Object[]{this.engineerIncharge2});
                srchCrit.append(" for Work Order Assigned to User2 " + engInc2.getEmployeeName());
                query.append(" and woe.workOrder.engineerIncharge2.idPersonalInformation=?");
                paramList.add(this.engineerIncharge2);
            }
            this.searchCriteria = srchCrit.toString();
        }
        if (this.sourcePage != null && (this.sourcePage.equalsIgnoreCase("deptWiseReport") || this.sourcePage.equalsIgnoreCase("deptWiseReportForWP"))) {
            if (this.woId != null) {
                query.append(" and woe.workOrder.id=?");
                paramList.add(Long.valueOf(this.woId.toString()));
            }
            if (this.estId != null) {
                query.append(" and woe.estimate.id=?");
                paramList.add(Long.valueOf(this.estId.toString()));
            }
        }
        orderQry.append(" order by woe.id desc ");
        String countQuery = "select count(distinct woe.id) " + query.toString();
        String finalQuery = "select woe  " + query.append(orderQry).toString();
        queryMap.put("countQuery", countQuery);
        queryMap.put("finalQuery", finalQuery);
        queryMap.put("params", paramList);
        return queryMap;
    }

    public SearchQuery prepareQuery(String sortField, String sortOrder) {
        HashMap queryMap = this.getQueryForWorkProgressRegister();
        this.setPageSize(10);
        String finalQuery = (String)queryMap.get("finalQuery");
        String countQuery = (String)queryMap.get("countQuery");
        ArrayList paramList = (ArrayList)queryMap.get("params");
        return new SearchQueryHQL(finalQuery, countQuery, (List)paramList);
    }

    public void setWorkProgressList(List<WorkProgressRegister> workProgressList) {
        this.workProgressList = workProgressList;
    }

    public Long getFunction() {
        return this.function;
    }

    public void setFunction(Long function) {
        this.function = function;
    }

    public Long getBudgetHead() {
        return this.budgetHead;
    }

    public void setBudgetHead(Long budgetHead) {
        this.budgetHead = budgetHead;
    }

    public List<WorkProgressRegister> getWorkProgressList() {
        return this.workProgressList;
    }

    public void setContractorBillService(ContractorBillService contractorBillService) {
        this.contractorBillService = contractorBillService;
    }

    public void setEgovCommon(EgovCommon egovCommon) {
        this.egovCommon = egovCommon;
    }

    public String getExportType() {
        return this.exportType;
    }

    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    public InputStream getWorkProgressRegisterStream() {
        return this.workProgressRegisterStream;
    }

    public void setWorkProgressRegisterStream(InputStream workProgressRegisterStream) {
        this.workProgressRegisterStream = workProgressRegisterStream;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public Integer getWoId() {
        return this.woId;
    }

    public void setWoId(Integer woId) {
        this.woId = woId;
    }

    public String getSourcePage() {
        return this.sourcePage;
    }

    public void setSourcePage(String sourcePage) {
        this.sourcePage = sourcePage;
    }

    public Integer getScheme() {
        return this.scheme;
    }

    public void setScheme(Integer scheme) {
        this.scheme = scheme;
    }

    public Integer getSubScheme() {
        return this.subScheme;
    }

    public void setSubScheme(Integer subScheme) {
        this.subScheme = subScheme;
    }

    public PersistenceService<OfflineStatus, Long> getWorksStatusService() {
        return this.worksStatusService;
    }

    public void setWorksStatusService(PersistenceService<OfflineStatus, Long> worksStatusService) {
        this.worksStatusService = worksStatusService;
    }

    public Integer getEstId() {
        return this.estId;
    }

    public void setEstId(Integer estId) {
        this.estId = estId;
    }

    public String getContractorName() {
        return this.contractorName;
    }

    public void setContractorName(String contractorName) {
        this.contractorName = contractorName;
    }

    public Long getContractorId() {
        return this.contractorId;
    }

    public void setContractorId(Long contractorId) {
        this.contractorId = contractorId;
    }

    public String getSearchCriteria() {
        return this.searchCriteria;
    }

    public void setSearchCriteria(String searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    public Long getWardId() {
        return this.wardId;
    }

    public void setWardId(Long wardId) {
        this.wardId = wardId;
    }

    public String getWardName() {
        return this.wardName;
    }

    public void setWardName(String wardName) {
        this.wardName = wardName;
    }
}

