/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.masters;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.egov.works.models.masters.MarketRate;
import org.egov.works.models.masters.ScheduleOfRate;

public class AjaxScheduleOfRateAction
extends BaseFormAction
implements ServletResponseAware {
    private static final long serialVersionUID = -184734884001856149L;
    private static final Logger logger = Logger.getLogger(AjaxScheduleOfRateAction.class);
    private static final String codeNumberUniqueCheck = "codeNumberUniqueCheck";
    private PersistenceService<ScheduleOfRate, Long> scheduleOfRateService;
    private HttpServletResponse response;
    private static final String MARKETRATEASONDATE = "marketRateAsOnDate";
    private Date asOnDate;
    private Long scheduleId;
    private String scheduleIds;
    private double marketRateValue = 0.0;
    private double[] marketRateValues;
    private String estimatesExists;
    private String codeNo;
    private Long scheduleCategoryId;

    public double[] getMarketRateValues() {
        return this.marketRateValues;
    }

    public String getScheduleIds() {
        return this.scheduleIds;
    }

    public void setScheduleIds(String scheduleIds) {
        this.scheduleIds = scheduleIds;
    }

    public void setScheduleId(Long scheduleId) {
        this.scheduleId = scheduleId;
    }

    public Long getScheduleId() {
        return this.scheduleId;
    }

    public void setAsOnDate(Date asOnDate) {
        this.asOnDate = asOnDate;
    }

    public double getMarketRateValue() {
        return this.marketRateValue;
    }

    public String codeNumberUniqueCheck() {
        return codeNumberUniqueCheck;
    }

    public boolean getCodenoCheck() {
        ScheduleOfRate scheduleOfRate = null;
        boolean codeNoexistsOrNot = false;
        scheduleOfRate = (ScheduleOfRate)this.scheduleOfRateService.find("from ScheduleOfRate sor where sor.code=? and sor.scheduleCategory.id=?", new Object[]{this.codeNo, this.scheduleCategoryId});
        if (scheduleOfRate != null) {
            codeNoexistsOrNot = true;
        }
        return codeNoexistsOrNot;
    }

    public String getByResponseAware() {
        this.response.setContentType("text/xml");
        this.response.setHeader("Cache-Control", "no-cache");
        try {
            this.response.getWriter().write("From Action " + Calendar.getInstance().getTime());
        }
        catch (IOException ioex) {
            logger.info((Object)"Error while writing to response --from getByResponseAware()");
        }
        return null;
    }

    public String getByDirectResponse() {
        this.getResponse().setContentType("text/xml");
        this.getResponse().setHeader("Cache-Control", "no-cache");
        try {
            this.getResponse().getWriter().write("From Action " + Calendar.getInstance().getTime());
        }
        catch (IOException ioex) {
            logger.info((Object)"Error while writing to response --from getByResponseAware()");
        }
        return null;
    }

    public String getMarketValueAsOnDate() {
        String[] schId = this.scheduleIds.split("~");
        int count = 0;
        LinkedList<Long> params = new LinkedList<Long>();
        for (String element : schId) {
            params.add(Long.valueOf(element));
        }
        this.marketRateValues = new double[schId.length];
        List scheduleOfRatesList = this.scheduleOfRateService.findAllByNamedQuery("SCHEDULEOFRATES_BY_IDS", new Object[]{params});
        for (String element : schId) {
            for (ScheduleOfRate scheduleOfRate : scheduleOfRatesList) {
                if (!element.equals(scheduleOfRate.getId().toString())) continue;
                this.marketRateValue = 0.0;
                if (scheduleOfRate.hasValidMarketRateFor(this.asOnDate)) {
                    MarketRate marketRate = scheduleOfRate.getMarketRateOn(this.asOnDate);
                    this.marketRateValue = marketRate.getMarketRate().getValue();
                }
                this.marketRateValues[count] = this.marketRateValue;
                ++count;
            }
        }
        return MARKETRATEASONDATE;
    }

    public String checkIfEstimateExists() {
        List ids = this.persistenceService.findAllBy("select distinct act.abstractEstimate.id from Activity act where act.schedule.id = ? and act.abstractEstimate.rateContract.id is not null and act.abstractEstimate.egwStatus.code != 'CANCELLED'", new Object[]{this.scheduleId});
        this.estimatesExists = ids != null && !ids.isEmpty() ? "yes" : "no";
        return "checkEstimatesForSOR";
    }

    public Object getModel() {
        return null;
    }

    public void setCodeNo(String codeNo) {
        this.codeNo = codeNo;
    }

    public void setScheduleCategoryId(Long scheduleCategoryId) {
        this.scheduleCategoryId = scheduleCategoryId;
    }

    public void setScheduleOfRateService(PersistenceService<ScheduleOfRate, Long> scheduleOfRateService) {
        this.scheduleOfRateService = scheduleOfRateService;
    }

    protected HttpServletRequest getRequest() {
        return ServletActionContext.getRequest();
    }

    protected HttpServletResponse getResponse() {
        return ServletActionContext.getResponse();
    }

    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    public String getEstimatesExists() {
        return this.estimatesExists;
    }

    public void setEstimatesExists(String estimatesExists) {
        this.estimatesExists = estimatesExists;
    }
}

