/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.contractorBill;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.NumberToWord;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.bills.EgBilldetails;
import org.egov.pims.commons.DeptDesig;
import org.egov.pims.model.PersonalInformation;
import org.egov.pims.service.EmployeeServiceOld;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.models.contractorBill.AssetForBill;
import org.egov.works.models.contractorBill.DeductionTypeForBill;
import org.egov.works.models.contractorBill.StatutoryDeductionsForBill;
import org.egov.works.models.measurementbook.MBForCancelledBill;
import org.egov.works.models.measurementbook.MBHeader;
import org.egov.works.services.ContractorBillService;
import org.egov.works.services.WorksService;
import org.egov.works.services.contractoradvance.ContractorAdvanceService;
import org.egov.works.utils.AbstractPDFGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ContractorBillPDFGenerator
extends AbstractPDFGenerator {
    private static final Logger logger = Logger.getLogger(ContractorBillPDFGenerator.class);
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private EmployeeServiceOld employeeService;
    private final Map<String, String> pdfLabel;
    private final ContractorBillRegister egBillRegister;
    private final MBHeader mbHeader;
    private String deptName = "";
    private String contactorName = "";
    private String contractorAddress = "";
    private String billNumber = "";
    private String billGenNumber = "";
    private String billDate = "";
    private String billType = "";
    private String workDescription = "";
    private String workcommencedOn = "";
    private String workCompletedOn = "";
    private String estimateNumber = "";
    private String projectCode = "";
    public static final String newLine = "\n";
    private Long workOrderId;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    private final List<MBHeader> mbHeaderList = new ArrayList();
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy", Locale.US);
    private boolean flag = false;
    public static final String CONTRACTOR_PDF_ERROR = "egBillRegister.pdf.error";
    private final ContractorBillService contractorBillService;
    public static final String blankSpace = "   ";
    public static final String blankSpace8 = "        ";
    public static final String blankSpace15 = "               ";
    public static final String blankSpace20 = "                    ";
    public static final String tab2 = "\t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t\t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t";
    public static final String dateLabel = "contractorbill.pdf.date";
    private List<StatutoryDeductionsForBill> sortedStatutorySortedList;
    private List<DeductionTypeForBill> sortedStandardDeductionList;
    private List<EgBilldetails> customDeductionList;
    private List<AssetForBill> assetForBillList;
    private WorksService worksService;
    private BigDecimal advanceAdjustment = new BigDecimal(0);
    private List<BigDecimal> glcodeIdList;
    private static final String WORKS_NETPAYABLE_CODE = "WORKS_NETPAYABLE_CODE";
    private BigDecimal netPayableAmount = BigDecimal.ZERO;
    private ContractorAdvanceService contractorAdvanceService;

    public ContractorBillPDFGenerator(ContractorBillRegister egBillRegister, MBHeader mbHeader, OutputStream out, Map<String, String> pdfLabel, ContractorBillService contractorBillService) {
        super(out, "landscape");
        this.pdfLabel = pdfLabel;
        this.egBillRegister = egBillRegister;
        this.mbHeader = mbHeader;
        this.contractorBillService = contractorBillService;
    }

    public void generatePDF() throws ApplicationException {
        logger.debug((Object)"FA1---inside generate pdf ");
        this.generateDisplayData(this.mbHeader, this.egBillRegister);
        try {
            PdfPTable contractorBillMainTable = new PdfPTable(11);
            contractorBillMainTable.setWidthPercentage(100.0f);
            contractorBillMainTable.setWidths(new float[]{1.5f, 1.5f, 1.5f, 1.5f, 1.5f, 1.5f, 1.5f, 1.5f, 1.5f, 1.5f, 1.5f});
            contractorBillMainTable.getDefaultCell().setPadding(4.0f);
            contractorBillMainTable.getDefaultCell().setBorderWidth(1.0f);
            this.createHeaderRow(contractorBillMainTable);
            this.createDetailsRows(contractorBillMainTable);
            this.document.add((Element)contractorBillMainTable);
            this.document.add((Element)this.spacer());
            PdfPTable approvaldetailsTable = this.createApprovalDetailsTable(this.egBillRegister);
            if (approvaldetailsTable.getRows().size() != 1) {
                this.document.add((Element)this.makePara((Object)"Approval Details"));
                this.document.add((Element)this.spacer());
                this.document.add((Element)approvaldetailsTable);
                this.document.add((Element)this.spacer());
            }
            if (contractorBillMainTable != null && contractorBillMainTable.getRows().size() > 11) {
                this.document.newPage();
            }
            this.createFooter();
            this.document.newPage();
            this.createCertificate();
            this.document.close();
        }
        catch (DocumentException e) {
            throw new ApplicationRuntimeException(CONTRACTOR_PDF_ERROR, (Throwable)e);
        }
        catch (ApplicationException ex) {
            throw new ApplicationRuntimeException(CONTRACTOR_PDF_ERROR, (Throwable)ex);
        }
    }

    protected void createCertificate() throws DocumentException {
        Paragraph headerTextPara = new Paragraph(new Chunk((String)this.pdfLabel.get("contractorbill.pdf.contractorbill"), new Font(2, 12.0f, 1)));
        headerTextPara.setAlignment(1);
        this.document.add((Element)headerTextPara);
        Paragraph certificateheaderTextPara = new Paragraph(new Chunk((String)this.pdfLabel.get("contractorbill.pdf.certificate"), new Font(0, 14.0f, 1)));
        certificateheaderTextPara.setAlignment(1);
        this.document.add((Element)certificateheaderTextPara);
        this.document.add((Element)this.spacer());
        this.document.add((Element)this.spacer());
        this.document.add((Element)this.makePara(this.pdfLabel.get("contractorbill.pdf.certificatecontent1")));
        this.document.add((Element)this.spacer());
        this.document.add((Element)this.spacer());
        this.document.add((Element)this.rightPara((Object)((String)this.pdfLabel.get("contractorbill.pdf.juniorengineer") + "\t \t\t \t \t \t\t \t\t \t \t \t \t")));
        this.document.add((Element)this.spacer());
        this.document.add((Element)this.rightPara((Object)((String)this.pdfLabel.get(dateLabel) + "\t \t \t \t\t \t\t \t \t \t \t\t \t\t \t \t \t \t\t \t\t\t \t\t \t\t \t \t \t \t\t \t\t\t\t \t\t \t\t")));
        this.document.add((Element)this.spacer());
        this.document.add((Element)this.makePara(this.pdfLabel.get("contractorbill.pdf.certificatecontent2")));
        this.document.add((Element)this.spacer());
        this.document.add((Element)this.spacer());
        this.document.add((Element)this.rightPara((Object)((String)this.pdfLabel.get("contractorbill.pdf.exeasstengineer") + "\t \t")));
        this.document.add((Element)this.spacer());
        this.document.add((Element)this.rightPara((Object)((String)this.pdfLabel.get(dateLabel) + "\t \t \t \t\t \t\t \t \t \t \t\t \t\t \t \t \t \t\t \t\t\t \t \t \t\t \t\t \t \t \t \t\t \t\t \t \t \t \t\t \t\t\t \t \t\t\t \t\t \t \t \t \t\t \t\t \t \t \t \t\t \t\t \t \t \t \t\t \t\t")));
        this.document.add((Element)this.spacer());
        this.document.add((Element)this.makePara(this.pdfLabel.get("contractorbill.pdf.certificatecontent3")));
        this.document.add((Element)this.spacer());
        this.document.add((Element)this.makePara(this.pdfLabel.get("contractorbill.pdf.certificatecontent4")));
        this.document.add((Element)this.spacer());
        this.document.add((Element)this.makePara(this.pdfLabel.get("contractorbill.pdf.certificatecontent5")));
        this.document.add((Element)this.spacer());
        this.document.add((Element)this.spacer());
        this.document.add((Element)this.makePara(this.pdfLabel.get("contractorbill.pdf.certificatecontent6")));
        this.document.add((Element)this.spacer());
        this.document.add((Element)this.spacer());
        this.document.add((Element)this.makePara((Object)((String)this.pdfLabel.get("contractorbill.pdf.juniorengineer") + "\t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t " + tab2 + tab2 + "\t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t\t \t \t \t \t \t \t \t \t \t \t" + (String)this.pdfLabel.get("contractorbill.pdf.exeasstengineer"))));
        this.document.add((Element)this.spacer());
        this.document.add((Element)this.makePara((Object)((String)this.pdfLabel.get(dateLabel) + "\t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t" + tab2 + tab2 + "\t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t\t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t \t\t \t \t \t \t \t \t \t " + (String)this.pdfLabel.get(dateLabel))));
    }

    protected void createFooter() throws DocumentException {
        this.document.add((Element)this.makePara((Object)"Received( Rs---------------) Rupees-------------------------------------------------------------------------------------------\nonly as a final payment in settlement of all demands in( Vernacular)---------------------------------------------------\nWitness:-   1.\n                      2."));
        logger.debug((Object)"FC---inside generate pdf add document");
    }

    protected void createHeaderRow(PdfPTable contractorBillMainTable) throws DocumentException, ApplicationException {
        PdfPTable contractorBillLeftHeader = this.createContractorBillHeader((String)this.pdfLabel.get("contractorbill.pdf.leftheader"), 0);
        contractorBillLeftHeader.getDefaultCell().setBorderWidth(0.0f);
        PdfPCell contractorBillLeftHeaderCell = new PdfPCell(contractorBillLeftHeader);
        contractorBillLeftHeaderCell.setBorderWidth(0.0f);
        contractorBillLeftHeaderCell.setColspan(4);
        contractorBillMainTable.addCell(contractorBillLeftHeaderCell);
        PdfPTable contractorBillMainHeader = this.createContractorBillHeader((String)this.pdfLabel.get("contractorbill.pdf.mainheader"), 1);
        contractorBillMainHeader.getDefaultCell().setBorderWidth(0.0f);
        PdfPCell contractorBillMainHeaderCell = new PdfPCell(contractorBillMainHeader);
        contractorBillMainHeaderCell.setBorderWidth(0.0f);
        contractorBillMainHeaderCell.setColspan(3);
        contractorBillMainTable.addCell(contractorBillMainHeaderCell);
        PdfPTable contractorBillRightHeader = this.createContractorBillHeader((String)this.pdfLabel.get("contractorbill.pdf.rightheader"), 2);
        contractorBillMainHeader.getDefaultCell().setBorderWidth(0.0f);
        PdfPCell contractorBillRightHeaderCell = new PdfPCell(contractorBillRightHeader);
        contractorBillRightHeaderCell.setBorderWidth(0.0f);
        contractorBillRightHeaderCell.setColspan(4);
        contractorBillMainTable.addCell(contractorBillRightHeaderCell);
    }

    protected PdfPTable createContractorBillHeader(String title, int i) throws DocumentException, ApplicationException {
        PdfPTable contractorBillHeaderTable = new PdfPTable(3);
        contractorBillHeaderTable.getDefaultCell().setBorderWidth(0.0f);
        if (i == 0) {
            contractorBillHeaderTable.getDefaultCell().setHorizontalAlignment(0);
            contractorBillHeaderTable.getDefaultCell().setColspan(4);
            contractorBillHeaderTable.addCell(title);
        } else if (i == 1) {
            contractorBillHeaderTable.getDefaultCell().setHorizontalAlignment(1);
            Phrase headerTextPara = new Phrase(title, new Font(-1, 14.0f, 1));
            contractorBillHeaderTable.getDefaultCell().setColspan(3);
            contractorBillHeaderTable.addCell(headerTextPara);
        } else if (i == 2) {
            contractorBillHeaderTable.getDefaultCell().setHorizontalAlignment(2);
            contractorBillHeaderTable.getDefaultCell().setColspan(4);
            contractorBillHeaderTable.addCell(title + " " + this.deptName);
        }
        return contractorBillHeaderTable;
    }

    protected void createDetailsRows(PdfPTable contractorBillMainTable) throws DocumentException, ApplicationException {
        this.createContractorRow(contractorBillMainTable);
        this.createWorkDescRow(contractorBillMainTable);
        this.createDetailsForWorkOrder(contractorBillMainTable);
        this.createWorkValueLabel(contractorBillMainTable);
        this.createWorkValueData(contractorBillMainTable);
        this.createDeductionTypeLabel(contractorBillMainTable);
        this.createDeductionTypeData(contractorBillMainTable);
        this.createNetPayable(contractorBillMainTable);
    }

    protected void createDeductionTypeLabel(PdfPTable contractorBillMainTable) throws DocumentException, ApplicationException {
        contractorBillMainTable.getDefaultCell().setBorderWidth(1.0f);
        PdfPTable deductionTypeTable = this.createDeductionTypeLabelTable(contractorBillMainTable);
        deductionTypeTable.getDefaultCell().setBorderWidth(1.0f);
        PdfPCell deductionTypeCell = new PdfPCell(deductionTypeTable);
        deductionTypeCell.setColspan(11);
        contractorBillMainTable.addCell(deductionTypeCell);
    }

    protected PdfPTable createDeductionTypeLabelTable(PdfPTable contractorBillMainTable) throws DocumentException, ApplicationException {
        PdfPTable deductionTypeLabel = new PdfPTable(11);
        deductionTypeLabel.getDefaultCell().setBorderWidth(1.0f);
        deductionTypeLabel.getDefaultCell().setColspan(7);
        deductionTypeLabel.addCell((Phrase)this.makePara(this.pdfLabel.get("contractorbill.pdf.deductions")));
        deductionTypeLabel.getDefaultCell().setHorizontalAlignment(1);
        deductionTypeLabel.getDefaultCell().setColspan(1);
        deductionTypeLabel.addCell("");
        deductionTypeLabel.addCell("");
        deductionTypeLabel.addCell("");
        deductionTypeLabel.addCell("");
        return deductionTypeLabel;
    }

    protected void createDeductionTypeData(PdfPTable contractorBillMainTable) throws DocumentException, ApplicationException {
        contractorBillMainTable.getDefaultCell().setBorderWidth(1.0f);
        PdfPTable createDeductionTypeDataTable = this.createDeductionTypeDataTable(contractorBillMainTable);
        createDeductionTypeDataTable.getDefaultCell().setBorderWidth(1.0f);
        PdfPCell createWorkValueDataCell = new PdfPCell(createDeductionTypeDataTable);
        createWorkValueDataCell.setColspan(11);
        contractorBillMainTable.addCell(createWorkValueDataCell);
    }

    protected PdfPTable createDeductionTypeDataTable(PdfPTable contractorBillMainTable) throws DocumentException, ApplicationException {
        String[] resultAry;
        String resultAmt;
        PdfPTable createcreateDeductionTypeDataTable = new PdfPTable(11);
        createcreateDeductionTypeDataTable.getDefaultCell().setBorderWidth(1.0f);
        if (!this.sortedStatutorySortedList.isEmpty()) {
            for (StatutoryDeductionsForBill egBillPayeedetail : this.sortedStatutorySortedList) {
                BigDecimal totStatutoryAmt = this.getTotStatoryAmountForDeduction(egBillPayeedetail);
                String resultTotStatuAmt = this.getIntDecimalParts(totStatutoryAmt);
                String[] resultTotStatuAry = resultTotStatuAmt.split(":");
                createcreateDeductionTypeDataTable.getDefaultCell().setHorizontalAlignment(0);
                String resultAmt2 = this.getIntDecimalParts(egBillPayeedetail.getEgBillPayeeDtls().getCreditAmount());
                String[] resultAry2 = resultAmt2.split(":");
                createcreateDeductionTypeDataTable.getDefaultCell().setColspan(7);
                createcreateDeductionTypeDataTable.addCell(egBillPayeedetail.getEgBillPayeeDtls().getRecovery().getType());
                createcreateDeductionTypeDataTable.getDefaultCell().setHorizontalAlignment(2);
                createcreateDeductionTypeDataTable.getDefaultCell().setColspan(1);
                createcreateDeductionTypeDataTable.addCell(resultTotStatuAry[0]);
                createcreateDeductionTypeDataTable.addCell(resultTotStatuAry[1]);
                createcreateDeductionTypeDataTable.addCell(resultAry2[0]);
                createcreateDeductionTypeDataTable.addCell(resultAry2[1]);
            }
        }
        String type = "advanceAjustment";
        if ("advanceAjustment".equalsIgnoreCase("advanceAjustment")) {
            BigDecimal totAmt = this.getTotAmountForAdvanceAdjustment();
            String resultTotAmt = this.getIntDecimalParts(totAmt);
            String[] resultTotAry = resultTotAmt.split(":");
            createcreateDeductionTypeDataTable.getDefaultCell().setHorizontalAlignment(0);
            String resultAmt3 = this.getIntDecimalParts(this.advanceAdjustment);
            String[] resultAry3 = resultAmt3.split(":");
            createcreateDeductionTypeDataTable.getDefaultCell().setColspan(7);
            createcreateDeductionTypeDataTable.addCell("Advance adjustment ");
            createcreateDeductionTypeDataTable.getDefaultCell().setHorizontalAlignment(2);
            createcreateDeductionTypeDataTable.getDefaultCell().setColspan(1);
            createcreateDeductionTypeDataTable.addCell(resultTotAry[0]);
            createcreateDeductionTypeDataTable.addCell(resultTotAry[1]);
            createcreateDeductionTypeDataTable.addCell(resultAry3[0]);
            createcreateDeductionTypeDataTable.addCell(resultAry3[1]);
        }
        if (!this.sortedStandardDeductionList.isEmpty()) {
            for (DeductionTypeForBill deductionTypeForBill : this.sortedStandardDeductionList) {
                BigDecimal totStandardAmt = this.getTotStandardAmountForDeduction(deductionTypeForBill);
                String resultTotStandardAmt = this.getIntDecimalParts(totStandardAmt);
                String[] resultTotStandardAry = resultTotStandardAmt.split(":");
                createcreateDeductionTypeDataTable.getDefaultCell().setHorizontalAlignment(0);
                resultAmt = this.getIntDecimalParts(deductionTypeForBill.getCreditamount());
                resultAry = resultAmt.split(":");
                createcreateDeductionTypeDataTable.getDefaultCell().setColspan(7);
                createcreateDeductionTypeDataTable.addCell(deductionTypeForBill.getDeductionType());
                createcreateDeductionTypeDataTable.getDefaultCell().setHorizontalAlignment(2);
                createcreateDeductionTypeDataTable.getDefaultCell().setColspan(1);
                createcreateDeductionTypeDataTable.addCell(resultTotStandardAry[0]);
                createcreateDeductionTypeDataTable.addCell(resultTotStandardAry[1]);
                createcreateDeductionTypeDataTable.addCell(resultAry[0]);
                createcreateDeductionTypeDataTable.addCell(resultAry[1]);
            }
        }
        if (!this.customDeductionList.isEmpty()) {
            for (EgBilldetails egBilldetails : this.customDeductionList) {
                BigDecimal totCustomAmt = this.getTotStandardAmountForDeduction(egBilldetails);
                String resultTotCustomAmt = this.getIntDecimalParts(totCustomAmt);
                String[] resultTotCustomAry = resultTotCustomAmt.split(":");
                createcreateDeductionTypeDataTable.getDefaultCell().setHorizontalAlignment(0);
                resultAmt = this.getIntDecimalParts(egBilldetails.getCreditamount());
                resultAry = resultAmt.split(":");
                createcreateDeductionTypeDataTable.getDefaultCell().setColspan(7);
                createcreateDeductionTypeDataTable.addCell(this.chartOfAccountsHibernateDAO.findById((Number)Long.valueOf(egBilldetails.getGlcodeid().toString()), false).getName());
                createcreateDeductionTypeDataTable.getDefaultCell().setHorizontalAlignment(2);
                createcreateDeductionTypeDataTable.getDefaultCell().setColspan(1);
                createcreateDeductionTypeDataTable.addCell(resultTotCustomAry[0]);
                createcreateDeductionTypeDataTable.addCell(resultTotCustomAry[1]);
                createcreateDeductionTypeDataTable.addCell(resultAry[0]);
                createcreateDeductionTypeDataTable.addCell(resultAry[1]);
            }
        }
        return createcreateDeductionTypeDataTable;
    }

    protected void createNetPayable(PdfPTable contractorBillMainTable) throws DocumentException, ApplicationException {
        contractorBillMainTable.getDefaultCell().setBorderWidth(1.0f);
        PdfPTable createNetPayableTable = this.createNetPayableTable(contractorBillMainTable);
        createNetPayableTable.getDefaultCell().setBorderWidth(1.0f);
        PdfPCell createNetPayableCell = new PdfPCell(createNetPayableTable);
        createNetPayableCell.setColspan(11);
        contractorBillMainTable.addCell(createNetPayableCell);
    }

    protected PdfPTable createNetPayableTable(PdfPTable contractorBillMainTable) throws DocumentException, ApplicationException {
        String resultAmt = this.getIntDecimalParts(this.netPayableAmount);
        String[] resultAry = resultAmt.split(":");
        PdfPTable createNetPayableData = new PdfPTable(11);
        createNetPayableData.getDefaultCell().setBorderWidth(1.0f);
        createNetPayableData.getDefaultCell().setColspan(9);
        createNetPayableData.getDefaultCell().setHorizontalAlignment(0);
        createNetPayableData.addCell((Phrase)this.makePara((Object)((String)this.pdfLabel.get("contractorbill.pdf.netamount") + ":\t" + this.getNetPayAmtInWords()), 4));
        createNetPayableData.getDefaultCell().setHorizontalAlignment(2);
        createNetPayableData.getDefaultCell().setColspan(1);
        createNetPayableData.addCell(resultAry[0]);
        createNetPayableData.addCell(resultAry[1]);
        return createNetPayableData;
    }

    protected void createWorkValueData(PdfPTable contractorBillMainTable) throws DocumentException, ApplicationException {
        contractorBillMainTable.getDefaultCell().setBorderWidth(1.0f);
        PdfPTable createWorkValueDataTable = this.createWorkValueDataTable(contractorBillMainTable);
        createWorkValueDataTable.getDefaultCell().setBorderWidth(1.0f);
        PdfPCell createWorkValueDataCell = new PdfPCell(createWorkValueDataTable);
        createWorkValueDataCell.setColspan(11);
        contractorBillMainTable.addCell(createWorkValueDataCell);
    }

    protected PdfPTable createWorkValueDataTable(PdfPTable contractorBillMainTable) throws DocumentException, ApplicationException {
        PdfPTable createWorkValueData = new PdfPTable(11);
        createWorkValueData.getDefaultCell().setBorderWidth(1.0f);
        createWorkValueData.getDefaultCell().setColspan(7);
        createWorkValueData.addCell((Phrase)this.makePara(this.pdfLabel.get("contractorbill.pdf.valueofworkdone")));
        createWorkValueData.getDefaultCell().setHorizontalAlignment(2);
        createWorkValueData.getDefaultCell().setColspan(1);
        BigDecimal totalBillAmtUptBill = this.contractorBillService.getTotalValueWoForUptoBillDate(this.egBillRegister.getBilldate(), this.workOrderId, this.mbHeader.getWorkOrderEstimate().getId());
        if (totalBillAmtUptBill.compareTo(BigDecimal.ZERO) > 0) {
            String totalBillAmt = this.toCurrency(totalBillAmtUptBill.doubleValue());
            try {
                createWorkValueData.addCell((Phrase)this.rightPara((Object)(blankSpace + totalBillAmt.substring(0, totalBillAmt.indexOf(46)))));
                createWorkValueData.addCell((Phrase)this.centerPara((Object)(blankSpace + totalBillAmt.substring(totalBillAmt.indexOf(46) + 1, totalBillAmt.length()))));
            }
            catch (StringIndexOutOfBoundsException e) {
                logger.error((Object)("----totalBillAmt has no fractional part----" + e.getMessage()));
                createWorkValueData.addCell((Phrase)this.centerPara((Object)(blankSpace + totalBillAmt)));
                createWorkValueData.addCell("00");
            }
        } else {
            createWorkValueData.addCell(" ");
            createWorkValueData.addCell(" ");
        }
        BigDecimal billAmount = BigDecimal.ZERO;
        if (this.egBillRegister.getBillamount() != null) {
            billAmount = this.egBillRegister.getBillamount();
        }
        if (billAmount.compareTo(BigDecimal.ZERO) > 0) {
            String billAmt = this.toCurrency(billAmount.doubleValue());
            try {
                createWorkValueData.addCell((Phrase)this.centerPara((Object)(blankSpace + billAmt.substring(0, billAmt.indexOf(46)))));
                createWorkValueData.addCell((Phrase)this.centerPara((Object)(blankSpace + billAmt.substring(billAmt.indexOf(46) + 1, billAmt.length()))));
            }
            catch (StringIndexOutOfBoundsException e) {
                logger.error((Object)("---billAmt has no fractional part---" + e.getMessage()));
                createWorkValueData.addCell((Phrase)this.centerPara((Object)(blankSpace + billAmt)));
                createWorkValueData.addCell("");
            }
        } else {
            createWorkValueData.addCell(" ");
            createWorkValueData.addCell(" ");
        }
        return createWorkValueData;
    }

    protected void createWorkValueLabel(PdfPTable contractorBillMainTable) throws DocumentException, ApplicationException {
        contractorBillMainTable.getDefaultCell().setBorderWidth(1.0f);
        PdfPTable WorkValueLabelTable = this.createWorkValueLabelTable(contractorBillMainTable);
        WorkValueLabelTable.getDefaultCell().setBorderWidth(1.0f);
        PdfPCell WorkValueLabelCell = new PdfPCell(WorkValueLabelTable);
        WorkValueLabelCell.setColspan(11);
        contractorBillMainTable.addCell(WorkValueLabelCell);
    }

    protected PdfPTable createWorkValueLabelTable(PdfPTable contractorBillMainTable) throws DocumentException, ApplicationException {
        PdfPTable createWorkValueLabel = new PdfPTable(11);
        createWorkValueLabel.getDefaultCell().setBorderWidth(1.0f);
        createWorkValueLabel.getDefaultCell().setColspan(7);
        createWorkValueLabel.addCell(" ");
        createWorkValueLabel.getDefaultCell().setHorizontalAlignment(1);
        createWorkValueLabel.getDefaultCell().setColspan(2);
        createWorkValueLabel.addCell((Phrase)this.centerPara((Object)((String)this.pdfLabel.get("contractorbill.pdf.todate") + "\n Rs.       P.")));
        createWorkValueLabel.addCell((Phrase)this.centerPara((Object)((String)this.pdfLabel.get("contractorbill.pdf.lastbill") + "\n Rs.       P.")));
        return createWorkValueLabel;
    }

    protected void createDetailsForWorkOrder(PdfPTable contractorBillMainTable) throws DocumentException, ApplicationException {
        this.createDetailsForWorkOrderLabel(contractorBillMainTable);
        this.createDetailsForWorkOrderData(contractorBillMainTable);
    }

    protected void createDetailsForWorkOrderLabel(PdfPTable contractorBillMainTable) throws DocumentException, ApplicationException {
        contractorBillMainTable.getDefaultCell().setBorderWidth(1.0f);
        PdfPTable detailsForWorkOrderTable = this.createDetailsForWorkOrderLabelTable(contractorBillMainTable);
        detailsForWorkOrderTable.getDefaultCell().setBorderWidth(1.0f);
        PdfPCell detailsForWorkOrderCell = new PdfPCell(detailsForWorkOrderTable);
        detailsForWorkOrderCell.setColspan(11);
        contractorBillMainTable.addCell(detailsForWorkOrderCell);
    }

    protected void createDetailsForWorkOrderData(PdfPTable contractorBillMainTable) throws DocumentException, ApplicationException {
        contractorBillMainTable.getDefaultCell().setBorderWidth(1.0f);
        contractorBillMainTable.getDefaultCell().setHorizontalAlignment(0);
        if (!this.mbHeaderList.isEmpty()) {
            int listLen = 0;
            int mbLen = this.mbHeaderList.size();
            int assetLen = 0;
            listLen = this.flag && this.assetForBillList.size() > this.mbHeaderList.size() ? this.assetForBillList.size() : this.mbHeaderList.size();
            if (this.flag) {
                assetLen = this.assetForBillList.size();
            }
            for (int i = 0; i < listLen; ++i) {
                contractorBillMainTable.getDefaultCell().setColspan(2);
                if (i == 0) {
                    contractorBillMainTable.addCell((Phrase)this.centerPara((Object)this.projectCode));
                } else {
                    contractorBillMainTable.addCell("");
                }
                if (this.flag && i < assetLen) {
                    contractorBillMainTable.addCell(((AssetForBill)this.assetForBillList.get(i)).getAsset().getCode() + "-" + ((AssetForBill)this.assetForBillList.get(i)).getAsset().getName());
                } else {
                    contractorBillMainTable.addCell("");
                }
                contractorBillMainTable.getDefaultCell().setColspan(1);
                if (i < mbLen) {
                    String mbRefNo = "";
                    String mbFrmPgNo = "";
                    String mbToPgNo = "";
                    if (((MBHeader)this.mbHeaderList.get(i)).getMbRefNo() != null) {
                        mbRefNo = ((MBHeader)this.mbHeaderList.get(i)).getMbRefNo();
                    }
                    if (((MBHeader)this.mbHeaderList.get(i)).getFromPageNo() != null) {
                        mbFrmPgNo = ((MBHeader)this.mbHeaderList.get(i)).getFromPageNo().toString();
                    }
                    if (((MBHeader)this.mbHeaderList.get(i)).getToPageNo() != null) {
                        mbToPgNo = ((MBHeader)this.mbHeaderList.get(i)).getToPageNo().toString();
                    }
                    contractorBillMainTable.addCell((Phrase)this.centerPara((Object)("  " + mbRefNo)));
                    contractorBillMainTable.addCell((Phrase)this.centerPara((Object)(blankSpace + mbFrmPgNo)));
                    contractorBillMainTable.addCell((Phrase)this.centerPara((Object)(blankSpace + mbToPgNo)));
                } else {
                    contractorBillMainTable.addCell((Phrase)this.centerPara((Object)blankSpace));
                    contractorBillMainTable.addCell((Phrase)this.centerPara((Object)blankSpace));
                    contractorBillMainTable.addCell((Phrase)this.centerPara((Object)blankSpace));
                }
                contractorBillMainTable.getDefaultCell().setColspan(4);
                if (i == 0) {
                    contractorBillMainTable.addCell((Phrase)this.makePara((Object)((String)this.pdfLabel.get("contractorbill.pdf.estimateamt") + this.toCurrency(this.mbHeader.getWorkOrderEstimate().getEstimate().getWorkValueIncludingTaxes().getValue())), 0));
                    continue;
                }
                contractorBillMainTable.addCell("");
            }
        }
    }

    protected PdfPTable createDetailsForWorkOrderLabelTable(PdfPTable contractorBillMainTable) throws DocumentException, ApplicationException {
        PdfPTable detailsForWorkOrderLabel = new PdfPTable(11);
        detailsForWorkOrderLabel.getDefaultCell().setBorderWidth(1.0f);
        detailsForWorkOrderLabel.getDefaultCell().setHorizontalAlignment(1);
        detailsForWorkOrderLabel.getDefaultCell().setColspan(2);
        detailsForWorkOrderLabel.addCell((String)this.pdfLabel.get("contractorbill.pdf.projectcode"));
        detailsForWorkOrderLabel.addCell((String)this.pdfLabel.get("contractorbill.pdf.assetcode"));
        detailsForWorkOrderLabel.getDefaultCell().setColspan(1);
        detailsForWorkOrderLabel.addCell((String)this.pdfLabel.get("contractorbill.pdf.Mbno"));
        detailsForWorkOrderLabel.getDefaultCell().setColspan(2);
        detailsForWorkOrderLabel.getDefaultCell().setHorizontalAlignment(0);
        detailsForWorkOrderLabel.addCell(blankSpace15 + (String)this.pdfLabel.get("contractorbill.pdf.pages") + newLine + blankSpace8 + (String)this.pdfLabel.get("contractorbill.pdf.from") + blankSpace8 + (String)this.pdfLabel.get("contractorbill.pdf.to"));
        detailsForWorkOrderLabel.getDefaultCell().setHorizontalAlignment(0);
        detailsForWorkOrderLabel.getDefaultCell().setColspan(4);
        detailsForWorkOrderLabel.addCell((String)this.pdfLabel.get("contractorbill.pdf.estimateno") + " " + this.estimateNumber);
        return detailsForWorkOrderLabel;
    }

    protected void createWorkDescRow(PdfPTable contractorBillMainTable) throws DocumentException, ApplicationException {
        contractorBillMainTable.getDefaultCell().setBorderWidth(1.0f);
        PdfPTable workDescTable = this.createWorkDescTable(contractorBillMainTable);
        workDescTable.getDefaultCell().setBorderWidth(1.0f);
        PdfPCell workDescCell = new PdfPCell(workDescTable);
        workDescCell.setColspan(11);
        contractorBillMainTable.addCell(workDescCell);
    }

    protected PdfPTable createWorkDescTable(PdfPTable contractorBillMainTable) throws DocumentException, ApplicationException {
        PdfPTable workDescTable = new PdfPTable(11);
        workDescTable.getDefaultCell().setBorderWidth(1.0f);
        workDescTable.getDefaultCell().setHorizontalAlignment(0);
        workDescTable.getDefaultCell().setColspan(7);
        workDescTable.addCell((String)this.pdfLabel.get("contractorbill.pdf.workdescription") + newLine + this.workDescription + newLine);
        workDescTable.getDefaultCell().setHorizontalAlignment(0);
        workDescTable.getDefaultCell().setColspan(4);
        workDescTable.addCell((String)this.pdfLabel.get("contractorbill.pdf.workcommencedon") + this.workcommencedOn + newLine + (String)this.pdfLabel.get("contractorbill.pdf.workcompleteon") + this.workCompletedOn + newLine);
        return workDescTable;
    }

    protected void createContractorRow(PdfPTable contractorBillMainTable) throws DocumentException, ApplicationException {
        contractorBillMainTable.getDefaultCell().setBorderWidth(1.0f);
        PdfPTable contractorTable = this.createContractorTable(contractorBillMainTable);
        contractorTable.getDefaultCell().setBorderWidth(1.0f);
        PdfPCell contractorCell = new PdfPCell(contractorTable);
        contractorCell.setColspan(11);
        contractorBillMainTable.addCell(contractorCell);
    }

    protected PdfPTable createContractorTable(PdfPTable contractorBillMainTable) throws DocumentException, ApplicationException {
        PdfPTable contractorTable = new PdfPTable(11);
        contractorTable.getDefaultCell().setBorderWidth(1.0f);
        contractorTable.getDefaultCell().setHorizontalAlignment(0);
        contractorTable.getDefaultCell().setColspan(7);
        contractorTable.addCell((String)this.pdfLabel.get("contractorbill.pdf.contractoraddress") + newLine + this.contactorName + newLine + this.contractorAddress + newLine);
        contractorTable.getDefaultCell().setHorizontalAlignment(0);
        contractorTable.getDefaultCell().setColspan(4);
        contractorTable.addCell((String)this.pdfLabel.get("contractorbill.pdf.billno") + this.billGenNumber + newLine + (String)this.pdfLabel.get("contractorbill.pdf.dateofbill") + this.billDate + newLine + (String)this.pdfLabel.get("contractorbill.pdf.typeofbill") + this.billType + newLine);
        return contractorTable;
    }

    protected void generateDisplayData(MBHeader mbHeader, ContractorBillRegister egBillRegister) throws ApplicationException {
        this.assetForBillList = this.contractorBillService.getAssetForBill(egBillRegister.getId());
        if (!this.assetForBillList.isEmpty()) {
            this.flag = true;
        }
        List requiredStatutoryList = null;
        requiredStatutoryList = this.contractorBillService.getSortedDeductionsFromConfig("StatutoryDeductionKey");
        List currentStatutoryList = this.contractorBillService.getStatutoryListForBill(egBillRegister.getId());
        this.sortedStatutorySortedList = this.contractorBillService.getStatutoryDeductionSortedOrder(requiredStatutoryList, currentStatutoryList);
        this.advanceAdjustment = this.contractorBillService.getAdvanceAdjustmentAmountForBill(egBillRegister.getId(), mbHeader.getWorkOrderEstimate().getId());
        List requiredStandardList = this.contractorBillService.getSortedDeductionsFromConfig("StandardDeductionKey");
        this.getStandardDeductionList(egBillRegister.getId(), requiredStandardList);
        this.getCustomDeductionList(egBillRegister);
        if (mbHeader != null) {
            this.deptName = mbHeader.getWorkOrderEstimate().getEstimate().getUserDepartment().getName();
            this.contactorName = mbHeader.getWorkOrder().getContractor().getName();
            this.contractorAddress = mbHeader.getWorkOrder().getContractor().getCorrespondenceAddress() == null ? "" : mbHeader.getWorkOrder().getContractor().getCorrespondenceAddress();
            this.workDescription = mbHeader.getWorkOrderEstimate().getEstimate().getDescription();
            this.workcommencedOn = this.sdf.format(mbHeader.getWorkOrder().getCreatedDate());
            this.workOrderId = mbHeader.getWorkOrder().getId();
            if (egBillRegister.getBillstatus().equals("CANCELLED")) {
                for (MBForCancelledBill mbCancelBillObj : this.contractorBillService.getMbListForCancelBill(egBillRegister.getId())) {
                    if (this.mbHeaderList.contains(mbCancelBillObj.getMbHeader())) continue;
                    this.mbHeaderList.add(mbCancelBillObj.getMbHeader());
                }
            } else {
                for (MBHeader mbObj : this.contractorBillService.getMbListForBillAndWorkordrId(this.workOrderId, egBillRegister.getId())) {
                    if (this.mbHeaderList.contains(mbObj)) continue;
                    this.mbHeaderList.add(mbObj);
                }
            }
            this.estimateNumber = mbHeader.getWorkOrderEstimate().getEstimate().getEstimateNumber();
            if (mbHeader.getWorkOrder() != null && mbHeader.getWorkOrderEstimate().getEstimate() != null && mbHeader.getWorkOrderEstimate().getEstimate().getProjectCode() != null && mbHeader.getWorkOrderEstimate().getEstimate().getProjectCode().getCode() != null) {
                this.projectCode = mbHeader.getWorkOrderEstimate().getEstimate().getProjectCode().getCode();
            }
        }
        if (egBillRegister.getBillnumber() != null) {
            this.billGenNumber = egBillRegister.getBillnumber();
        }
        if (egBillRegister.getBillnumber() != null && egBillRegister.getBillSequenceNumber() != null) {
            this.billNumber = egBillRegister.getBillSequenceNumber().toString();
        }
        if (egBillRegister.getBilldate() != null) {
            this.billDate = this.sdf.format(egBillRegister.getBilldate());
        }
        if (egBillRegister.getBilltype() != null) {
            this.billType = "Running".equalsIgnoreCase(this.billType) ? this.billNumber + "-" + egBillRegister.getBilltype() : egBillRegister.getBilltype();
        }
        if (egBillRegister.getBilldate() != null) {
            this.billDate = this.sdf.format(egBillRegister.getBilldate());
        }
        if ("Final Bill".equalsIgnoreCase(egBillRegister.getBilltype())) {
            if (mbHeader != null && mbHeader.getWorkOrderEstimate() != null && mbHeader.getWorkOrderEstimate().getWorkCompletionDate() != null) {
                this.workCompletedOn = this.sdf.format(mbHeader.getWorkOrderEstimate().getWorkCompletionDate());
            }
        } else {
            this.workCompletedOn = "in progress";
        }
    }

    public void getStandardDeductionList(Long billId, List<String> requiredStandardList) {
        List currentStandardDeductionList = this.contractorBillService.getStandardDeductionForBill(billId);
        this.sortedStandardDeductionList = this.contractorBillService.getStandardDeductionSortedOrder(requiredStandardList, currentStandardDeductionList);
    }

    public void getCustomDeductionList(ContractorBillRegister egBillRegister) throws ApplicationException {
        this.customDeductionList = new ArrayList();
        this.glcodeIdList = new ArrayList();
        this.getStatutoryDeductionGlcode();
        this.getStandardDeductionGlcode();
        String advanceAdjstglCodeId = "";
        CChartOfAccounts advanceCOA = this.contractorAdvanceService.getContractorAdvanceAccountcodeForWOE(this.mbHeader.getWorkOrderEstimate().getId());
        if (advanceCOA != null) {
            advanceAdjstglCodeId = advanceCOA.getId().toString();
        }
        this.getGlCodeForNetPayable();
        if (StringUtils.isNotBlank((String)advanceAdjstglCodeId)) {
            this.glcodeIdList.add(new BigDecimal(advanceAdjstglCodeId));
        }
        this.customDeductionList = this.contractorBillService.getCustomDeductionListforglcodes(this.glcodeIdList, egBillRegister.getId());
    }

    public void getStatutoryDeductionGlcode() {
        if (!this.sortedStatutorySortedList.isEmpty()) {
            for (StatutoryDeductionsForBill bpd : this.sortedStatutorySortedList) {
                if (bpd == null || bpd.getEgBillPayeeDtls().getRecovery() == null || bpd.getEgBillPayeeDtls().getRecovery().getId() == null || bpd.getEgBillPayeeDtls().getRecovery().getChartofaccounts() == null || bpd.getEgBillPayeeDtls().getRecovery().getChartofaccounts().getId() == null) continue;
                this.glcodeIdList.add(new BigDecimal(bpd.getEgBillPayeeDtls().getRecovery().getChartofaccounts().getId()));
            }
        }
    }

    public void getStandardDeductionGlcode() {
        if (!this.sortedStandardDeductionList.isEmpty()) {
            for (DeductionTypeForBill deductionTypeForBill : this.sortedStandardDeductionList) {
                if (deductionTypeForBill.getCoa() == null || deductionTypeForBill.getCoa().getId() == null) continue;
                this.glcodeIdList.add(new BigDecimal(deductionTypeForBill.getCoa().getId()));
            }
        }
    }

    public void getGlCodeForNetPayable() throws NumberFormatException, ApplicationException {
        List coaPayableList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(this.worksService.getWorksConfigValue(WORKS_NETPAYABLE_CODE)));
        if (coaPayableList != null) {
            for (CChartOfAccounts coa : coaPayableList) {
                if (coa.getId() == null) continue;
                this.netPayableAmount = this.contractorBillService.getNetPayableAmountForGlCodeId(this.egBillRegister.getId());
                this.glcodeIdList.add(new BigDecimal(coa.getId()));
            }
        }
    }

    protected String getIntDecimalParts(BigDecimal totalAmount) {
        String result = "";
        String totalAmt = "";
        if (totalAmount == null) {
            totalAmt = "0:00";
        } else {
            totalAmt = this.toCurrency(totalAmount.doubleValue());
            String intPart = "0";
            String decimalPart = "0";
            try {
                intPart = totalAmt.substring(0, totalAmt.indexOf(46));
                decimalPart = totalAmt.substring(totalAmt.indexOf(46) + 1, totalAmt.length());
                result = intPart + ":" + decimalPart;
            }
            catch (StringIndexOutOfBoundsException e) {
                logger.error((Object)("---totalAmt has no fractional part---" + e.getMessage()));
                result = totalAmt + ":00";
            }
        }
        return result;
    }

    public String getNetPayAmtInWords() {
        String netPayAmtStr = "";
        try {
            netPayAmtStr = NumberToWord.convertToWord((String)this.toCurrency(this.netPayableAmount.doubleValue()));
        }
        catch (Exception e) {
            logger.debug((Object)("error -----" + e));
            netPayAmtStr = "";
        }
        return netPayAmtStr;
    }

    private PdfPTable createApprovalDetailsTable(ContractorBillRegister egBillRegister) throws DocumentException {
        try {
            PdfPTable approvaldetailsTable = new PdfPTable(5);
            approvaldetailsTable.setWidthPercentage(100.0f);
            approvaldetailsTable.setWidths(new float[]{2.0f, 1.0f, 1.0f, 1.5f, 2.0f});
            this.addRow(approvaldetailsTable, true, new Paragraph[]{this.makePara((Object)"Approval Step"), this.centerPara((Object)"Name"), this.centerPara((Object)"Designation"), this.centerPara((Object)"Approved on"), this.centerPara((Object)"Remarks")});
            List history = null;
            if (egBillRegister != null && egBillRegister.getCurrentState() != null && egBillRegister.getCurrentState().getHistory() != null) {
                history = egBillRegister.getStateHistory();
            }
            if (history != null) {
                Collections.reverse(history);
                for (StateHistory ad : history) {
                    this.displayHistory(ad, approvaldetailsTable);
                }
            }
            return approvaldetailsTable;
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Exception occured while getting approval details " + e);
        }
    }

    public void displayHistory(StateHistory ad, PdfPTable approvaldetailsTable) throws Exception {
        if (!ad.getValue().equals("NEW") && !ad.getValue().equals("END")) {
            String nextAction = "";
            if (ad.getNextAction() != null) {
                nextAction = ad.getNextAction();
            }
            String state = ad.getValue();
            if (!nextAction.equalsIgnoreCase("")) {
                state = ad.getValue() + " - " + nextAction;
            }
            Long positionId = null;
            String desgName = null;
            DeptDesig deptdesig = null;
            positionId = ad.getOwnerPosition().getId();
            deptdesig = ad.getOwnerPosition().getDeptDesig();
            desgName = deptdesig.getDesignation().getName();
            PersonalInformation emp = this.employeeService.getEmpForPositionAndDate(ad.getCreatedDate(), Integer.valueOf(Integer.parseInt(positionId.toString())));
            this.addRow(approvaldetailsTable, true, new Paragraph[]{this.makePara((Object)state), this.makePara((Object)emp.getEmployeeName()), this.makePara((Object)desgName), this.makePara((Object)this.getDateInFormat(ad.getCreatedDate().toString())), this.rightPara((Object)ad.getComments())});
        }
    }

    private String getDateInFormat(String date) throws DocumentException {
        String dateInFormat = null;
        try {
            dateInFormat = new SimpleDateFormat("dd-MMM-yyyy", Locale.ENGLISH).format(new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH).parse(date));
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Exception occured while parsing date := " + date + e);
        }
        return dateInFormat;
    }

    public BigDecimal getTotAmountForAdvanceAdjustment() {
        BigDecimal totalDeductionAmt = BigDecimal.ZERO;
        totalDeductionAmt = this.contractorBillService.getTotAmtForAdvanceAdjustment(this.egBillRegister.getBilldate(), this.workOrderId, this.mbHeader.getWorkOrderEstimate().getId());
        return totalDeductionAmt;
    }

    public BigDecimal getTotStatoryAmountForDeduction(StatutoryDeductionsForBill egBillPayeedetail) {
        BigDecimal totalStatoryAmount = BigDecimal.ZERO;
        totalStatoryAmount = this.contractorBillService.getTotAmtForStatutory(this.egBillRegister.getBilldate(), this.workOrderId, egBillPayeedetail, this.mbHeader.getWorkOrderEstimate().getId());
        return totalStatoryAmount;
    }

    public BigDecimal getTotStandardAmountForDeduction(DeductionTypeForBill deductionTypeForBill) {
        BigDecimal totStandardAmt = BigDecimal.ZERO;
        totStandardAmt = this.contractorBillService.getTotAmtForStandard(this.egBillRegister.getBilldate(), this.workOrderId, deductionTypeForBill, this.mbHeader.getWorkOrderEstimate().getId());
        return totStandardAmt;
    }

    public BigDecimal getTotStandardAmountForDeduction(EgBilldetails egBilldetails) {
        BigDecimal totCustomAmt = BigDecimal.ZERO;
        totCustomAmt = this.contractorBillService.getTotAmtForCustom(this.egBillRegister.getBilldate(), this.workOrderId, egBilldetails, this.mbHeader.getWorkOrderEstimate().getId());
        return totCustomAmt;
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public EmployeeServiceOld getEmployeeService() {
        return this.employeeService;
    }

    public void setEmployeeService(EmployeeServiceOld employeeService) {
        this.employeeService = employeeService;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public void setContractorAdvanceService(ContractorAdvanceService contractorAdvanceService) {
        this.contractorAdvanceService = contractorAdvanceService;
    }
}

