/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.reports;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.egov.commons.CFinancialYear;
import org.egov.commons.service.CFinancialYearService;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.DateUtils;
import org.egov.works.master.service.ContractorService;
import org.egov.works.master.service.NatureOfWorkService;
import org.egov.works.models.masters.Contractor;
import org.egov.works.reports.entity.ContractorWiseAbstractReport;
import org.egov.works.reports.entity.ContractorWiseAbstractSearchResult;
import org.egov.works.reports.service.WorkProgressRegisterService;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports"})
public class ContractorWiseAbstractReportPDFController {
    public static final String CONTRACTOWISEABSTRACTREPORT = "contractorWiseAbstractReport";
    @Autowired
    private ReportService reportService;
    @Autowired
    private WorkProgressRegisterService workProgressRegisterService;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private CFinancialYearService cFinancialYearService;
    @Autowired
    private NatureOfWorkService natureOfWorkService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private ContractorService contractorService;

    @RequestMapping(value={"/contractorwiseabstract/pdf"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generatePDFDepartmentWise(HttpServletRequest request, @RequestParam(value="financialYearId") Long financialYearId, @RequestParam(value="natureOfWork") Long natureOfWork, @RequestParam(value="workStatus") String workStatus, @RequestParam(value="ward") Long ward, @RequestParam(value="contractor") String contractor, @RequestParam(value="contentType") String contentType, HttpSession session) throws IOException {
        ContractorWiseAbstractReport contractorWiseAbstractReport = new ContractorWiseAbstractReport();
        contractorWiseAbstractReport.setFinancialYearId(financialYearId);
        contractorWiseAbstractReport.setNatureOfWork(natureOfWork);
        contractorWiseAbstractReport.setWorkStatus(workStatus);
        contractorWiseAbstractReport.setContractor(contractor);
        contractorWiseAbstractReport.setElectionWardId(ward);
        List contractorWiseAbstractList = this.workProgressRegisterService.searchContractorWiseAbstractReport(contractorWiseAbstractReport);
        return this.generateReport(contractorWiseAbstractList, request, session, contentType, contractorWiseAbstractReport);
    }

    private ResponseEntity<byte[]> generateReport(List<ContractorWiseAbstractSearchResult> contractorWiseAbstractList, HttpServletRequest request, HttpSession session, String contentType, ContractorWiseAbstractReport contractorWiseAbstractReport) {
        List contractor;
        HashMap<String, String> reportParams = new HashMap<String, String>();
        ReportRequest reportInput = null;
        ReportOutput reportOutput = null;
        reportParams.put("reportRunDate", DateUtils.getFormattedDateWithTimeStamp((DateTime)new DateTime()));
        ArrayList<ContractorWiseAbstractSearchResult> contractorSearchList = new ArrayList<ContractorWiseAbstractSearchResult>();
        for (ContractorWiseAbstractSearchResult searchResult : contractorWiseAbstractList) {
            ContractorWiseAbstractSearchResult contractorResult = new ContractorWiseAbstractSearchResult();
            if (searchResult == null) continue;
            if (searchResult.getElectionWard() != null && searchResult.getElectionWard().contains("{")) {
                contractorResult.setElectionWard(searchResult.getElectionWard().replace("{", "").replace("}", "").replaceAll("\"", ""));
            } else if (searchResult.getElectionWard() != null) {
                contractorResult.setElectionWard(searchResult.getElectionWard());
            } else {
                contractorResult.setElectionWard("NA");
            }
            if (searchResult.getContractorName() != null) {
                contractorResult.setContractorName(searchResult.getContractorName());
            } else {
                contractorResult.setContractorName("NA");
            }
            if (searchResult.getContractorCode() != null) {
                contractorResult.setContractorCode(searchResult.getContractorCode());
            } else {
                contractorResult.setContractorCode("NA");
            }
            if (searchResult.getContractorClass() != null) {
                contractorResult.setContractorClass(searchResult.getContractorClass());
            } else {
                contractorResult.setContractorClass("NA");
            }
            if (searchResult.getApprovedEstimates() != null) {
                contractorResult.setApprovedEstimates(searchResult.getApprovedEstimates());
            } else {
                contractorResult.setApprovedEstimates(Integer.valueOf(0));
            }
            if (searchResult.getApprovedAmount() != null) {
                contractorResult.setApprovedAmount(searchResult.getApprovedAmount().divide(new BigDecimal(10000000)).setScale(2, 6));
            } else {
                contractorResult.setApprovedAmount(new BigDecimal(0));
            }
            if (searchResult.getSiteNotHandedOverEstimates() != null) {
                contractorResult.setSiteNotHandedOverEstimates(searchResult.getSiteNotHandedOverEstimates());
            } else {
                contractorResult.setSiteNotHandedOverEstimates(Integer.valueOf(0));
            }
            if (searchResult.getSiteNotHandedOverAmount() != null) {
                contractorResult.setSiteNotHandedOverAmount(searchResult.getSiteNotHandedOverAmount().divide(new BigDecimal(10000000)).setScale(2, 6));
            } else {
                contractorResult.setSiteNotHandedOverAmount(new BigDecimal(0));
            }
            if (searchResult.getNotWorkCommencedEstimates() != null) {
                contractorResult.setNotWorkCommencedEstimates(searchResult.getNotWorkCommencedEstimates());
            } else {
                contractorResult.setNotWorkCommencedEstimates(Integer.valueOf(0));
            }
            if (searchResult.getNotWorkCommencedAmount() != null) {
                contractorResult.setNotWorkCommencedAmount(searchResult.getNotWorkCommencedAmount().divide(new BigDecimal(10000000)).setScale(2, 6));
            } else {
                contractorResult.setNotWorkCommencedAmount(new BigDecimal(0));
            }
            if (searchResult.getWorkCommencedEstimates() != null && searchResult.getLagecyWorkCommencedEstimates() != null) {
                contractorResult.setWorkCommencedEstimates(Integer.valueOf(searchResult.getWorkCommencedEstimates() + searchResult.getLagecyWorkCommencedEstimates()));
            } else if (searchResult.getWorkCommencedEstimates() != null) {
                contractorResult.setWorkCommencedEstimates(searchResult.getWorkCommencedEstimates());
            } else if (searchResult.getLagecyWorkCommencedEstimates() != null) {
                contractorResult.setWorkCommencedEstimates(searchResult.getLagecyWorkCommencedEstimates());
            } else {
                contractorResult.setWorkCommencedEstimates(Integer.valueOf(0));
            }
            if (searchResult.getWorkCommencedAmount() != null && searchResult.getLagecyWorkCommencedAmount() != null) {
                contractorResult.setWorkCommencedAmount(searchResult.getWorkCommencedAmount().add(searchResult.getLagecyWorkCommencedAmount()).divide(new BigDecimal(10000000)).setScale(2, 6));
            } else if (searchResult.getWorkCommencedAmount() != null) {
                contractorResult.setWorkCommencedAmount(searchResult.getWorkCommencedAmount().divide(new BigDecimal(10000000)).setScale(2, 6));
            } else if (searchResult.getLagecyWorkCommencedAmount() != null) {
                contractorResult.setWorkCommencedAmount(searchResult.getLagecyWorkCommencedAmount().divide(new BigDecimal(10000000)).setScale(2, 6));
            } else {
                contractorResult.setWorkCommencedAmount(new BigDecimal(0));
            }
            if (searchResult.getWorkCompletedEstimates() != null) {
                contractorResult.setWorkCompletedEstimates(searchResult.getWorkCompletedEstimates());
            } else {
                contractorResult.setWorkCompletedEstimates(Integer.valueOf(0));
            }
            if (searchResult.getWorkCompletedAmount() != null) {
                contractorResult.setWorkCompletedAmount(searchResult.getWorkCompletedAmount().divide(new BigDecimal(10000000)).setScale(2, 6));
            } else {
                contractorResult.setWorkCompletedAmount(new BigDecimal(0));
            }
            if (searchResult.getApprovedEstimates() != null && searchResult.getWorkCompletedEstimates() != null) {
                contractorResult.setBalanceWorkEstimates(Integer.valueOf(searchResult.getApprovedEstimates() - searchResult.getWorkCompletedEstimates()));
            } else if (searchResult.getApprovedEstimates() != null) {
                contractorResult.setBalanceWorkEstimates(searchResult.getApprovedEstimates());
            } else {
                contractorResult.setBalanceWorkEstimates(Integer.valueOf(0));
            }
            if (searchResult.getApprovedAmount() != null && searchResult.getWorkCompletedAmount() != null) {
                contractorResult.setBalanceWorkAmount(searchResult.getApprovedAmount().subtract(searchResult.getWorkCompletedAmount()).divide(new BigDecimal(10000000)).setScale(2, 6));
            } else if (searchResult.getApprovedAmount() != null) {
                contractorResult.setBalanceWorkAmount(searchResult.getApprovedAmount().divide(new BigDecimal(10000000)).setScale(2, 6));
            } else {
                contractorResult.setBalanceWorkAmount(new BigDecimal(0));
            }
            if (searchResult.getWorkCompletedAmount() == null) {
                searchResult.setWorkCompletedAmount(new BigDecimal(0));
            }
            if (searchResult.getLiableAmount() != null && searchResult.getApprovedAmount() != null && searchResult.getWorkCompletedAmount() != null) {
                contractorResult.setLiableAmount(searchResult.getApprovedAmount().subtract(searchResult.getLiableAmount().add(searchResult.getWorkCompletedAmount())).divide(new BigDecimal(10000000)).setScale(2, 6));
            } else {
                contractorResult.setLiableAmount(new BigDecimal(0));
            }
            contractorSearchList.add(contractorResult);
        }
        reportInput = new ReportRequest(CONTRACTOWISEABSTRACTREPORT, contractorSearchList, reportParams);
        StringBuilder subHeader = new StringBuilder();
        subHeader.append(this.messageSource.getMessage("msg.contractorwiseabstractestimate.report", null, null));
        if (contractorWiseAbstractReport.getFinancialYearId() != null) {
            CFinancialYear finyear = this.cFinancialYearService.findOne(contractorWiseAbstractReport.getFinancialYearId());
            subHeader.append(" ").append(this.messageSource.getMessage("msg.daterange", null, null)).append(DateUtils.getDefaultFormattedDate((Date)finyear.getStartingDate())).append(" - ").append(DateUtils.getDefaultFormattedDate((Date)finyear.getEndingDate())).append(",");
        }
        if (contractorWiseAbstractReport.getElectionWardId() != null) {
            subHeader.append(" ").append(this.messageSource.getMessage("msg.ward", null, null)).append(this.boundaryService.getBoundaryById(contractorWiseAbstractReport.getElectionWardId()).getBoundaryNum()).append(",");
        }
        if (contractorWiseAbstractReport.getNatureOfWork() != null) {
            subHeader.append(" ").append(this.messageSource.getMessage("msg.natureofwork", null, null)).append(" ").append(this.natureOfWorkService.findById(contractorWiseAbstractReport.getNatureOfWork()).getName()).append(",");
        }
        if (contractorWiseAbstractReport.getContractor() != null && (contractor = this.contractorService.getContractorsByCodeOrName(contractorWiseAbstractReport.getContractor())) != null) {
            subHeader.append(" ").append(this.messageSource.getMessage("msg.contractor", null, null)).append(" ").append(((Contractor)contractor.get(0)).getName()).append(" - ").append(((Contractor)contractor.get(0)).getCode()).append(",");
        }
        if (contractorWiseAbstractReport.getWorkStatus() != null) {
            subHeader.append(" ").append(this.messageSource.getMessage("msg.workstatus", null, null)).append(" ").append(contractorWiseAbstractReport.getWorkStatus()).append(",");
        }
        String subHeaderStr = "";
        subHeaderStr = subHeader.toString().endsWith(",") ? subHeader.toString().substring(0, subHeader.toString().length() - 1) : subHeader.toString();
        reportParams.put("reportTitle", subHeaderStr);
        reportParams.put("dataRunDate", this.workProgressRegisterService.getReportSchedulerRunDate() != null ? DateUtils.getFormattedDateWithTimeStamp((DateTime)new DateTime((Object)this.workProgressRegisterService.getReportSchedulerRunDate())) : "");
        HttpHeaders headers = new HttpHeaders();
        if (contentType.equalsIgnoreCase("pdf")) {
            reportInput.setReportFormat(ReportConstants.FileFormat.PDF);
            headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
            headers.add("content-disposition", "inline;filename=ContractorWiseAbstractReport.pdf");
        } else {
            reportInput.setReportFormat(ReportConstants.FileFormat.XLS);
            headers.setContentType(MediaType.parseMediaType((String)"application/vnd.ms-excel"));
            headers.add("content-disposition", "inline;filename=ContractorWiseAbstractReport.xls");
        }
        reportOutput = this.reportService.createReport(reportInput);
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

