/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.milestone;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.infra.exception.ApplicationException;
import org.egov.works.milestone.entity.Milestone;
import org.egov.works.milestone.entity.MilestoneActivity;
import org.egov.works.milestone.entity.TrackMilestone;
import org.egov.works.milestone.entity.TrackMilestoneActivity;
import org.egov.works.milestone.entity.enums.MilestoneActivityStatus;
import org.egov.works.milestone.service.MilestoneService;
import org.egov.works.web.adaptor.TrackMilestoneJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/milestone"})
public class TrackMilestoneController {
    @Autowired
    private MilestoneService milestoneService;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private TrackMilestoneJsonAdaptor trackMilestoneJsonAdaptor;

    @ModelAttribute
    public Milestone getMilestone(@PathVariable Long id) {
        Milestone milestone = this.milestoneService.getMilestoneById(id);
        return milestone;
    }

    @RequestMapping(value={"/track/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String showNewMilestoneForm(@PathVariable Long id) throws ApplicationException {
        Milestone milestone = this.getMilestone(id);
        String result = "" + this.toSearchMilestoneTemplateJson((Object)milestone);
        return result;
    }

    public Object toSearchMilestoneTemplateJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(Milestone.class, (Object)this.trackMilestoneJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/track/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public String create(@ModelAttribute(value="milestone") Milestone milestone, Model model, BindingResult errors, HttpServletRequest request, BindingResult resultBinder, HttpServletResponse response) throws ApplicationException, IOException {
        JsonObject jsonObject = new JsonObject();
        this.validateTrackMilestone(milestone, jsonObject);
        if (jsonObject.toString().length() > 2) {
            this.sendAJAXResponse(jsonObject.toString(), response);
            return "";
        }
        Milestone newMilestone = this.milestoneService.update(milestone);
        return this.messageSource.getMessage("msg.trackmilestone.create.success", (Object[])new String[]{newMilestone.getWorkOrderEstimate().getEstimate().getLineEstimateDetails().getEstimateNumber()}, null);
    }

    private void validateTrackMilestone(Milestone milestone, JsonObject jsonObject) {
        block0: for (TrackMilestone tm : milestone.getTrackMilestone()) {
            Integer count = 0;
            boolean flag = false;
            for (TrackMilestoneActivity tma : tm.getActivities()) {
                if (tma.getStatus().equals(MilestoneActivityStatus.NOT_YET_STARTED.name()) && tma.getCompletedPercentage() != 0.0) {
                    jsonObject.addProperty("completedPercentage_" + count, this.messageSource.getMessage("error.trackmilestone.notyetstarted.percentage.zero", (Object[])new String[0], null));
                    flag = true;
                }
                if (tma.getStatus().equals(MilestoneActivityStatus.COMPLETED.name()) && tma.getCompletedPercentage() != 100.0) {
                    jsonObject.addProperty("completedPercentage_" + count, this.messageSource.getMessage("error.trackmilestone.completed.percentage.hundred", (Object[])new String[0], null));
                    flag = true;
                }
                if (tma.getStatus().equals(MilestoneActivityStatus.COMPLETED.name()) && tma.getCompletionDate() == null) {
                    jsonObject.addProperty("completionDate_" + count, this.messageSource.getMessage("error.trackmilestone.completed.completiondate.mandatory", (Object[])new String[0], null));
                    flag = true;
                }
                if (tma.getCompletionDate() != null && tma.getCompletionDate().after(((MilestoneActivity)milestone.getActivities().get(count)).getScheduleEndDate()) && tma.getRemarks() == null) {
                    jsonObject.addProperty("reasonForDelay_" + count, this.messageSource.getMessage("error.trackmilestone.reasonfordelay.mandatory", (Object[])new String[0], null));
                    flag = true;
                }
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
                if (!flag) continue;
                continue block0;
            }
        }
    }

    protected void sendAJAXResponse(String msg, HttpServletResponse response) {
        try {
            PrintWriter httpResponseWriter = response.getWriter();
            IOUtils.write((String)msg, (Writer)httpResponseWriter);
            IOUtils.closeQuietly((Writer)httpResponseWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

