/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.milestone;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.exception.ApplicationException;
import org.egov.works.milestone.entity.Milestone;
import org.egov.works.milestone.service.MilestoneService;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.egov.works.workorder.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/milestone"})
public class CreateMilestoneController {
    @Autowired
    private MilestoneService milestoneService;
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;

    @RequestMapping(value={"/newform"}, method={RequestMethod.GET})
    public String showNewMilestoneForm(Model model, HttpServletRequest request) throws ApplicationException {
        Long workOrderEstimateId = Long.parseLong(request.getParameter("workOrderEstimateId"));
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateById(workOrderEstimateId);
        if (this.milestoneService.checkMilestoneCreated(workOrderEstimate.getWorkOrder().getId())) {
            String message = this.messageSource.getMessage("error.milestonecreated.validate", (Object[])new String[]{workOrderEstimate.getWorkOrder().getWorkOrderNumber()}, null);
            model.addAttribute("errorMessage", (Object)message);
            return "milestone-success";
        }
        model.addAttribute("workOrderEstimate", (Object)workOrderEstimate);
        model.addAttribute("milestone", (Object)new Milestone());
        return "newMilestone-form";
    }

    @RequestMapping(value={"/milestone-save"}, method={RequestMethod.POST})
    public String create(@ModelAttribute(value="milestone") Milestone milestone, Model model, BindingResult errors, HttpServletRequest request, BindingResult resultBinder) throws ApplicationException, IOException {
        Long workOrderEstimateId = Long.valueOf(request.getParameter("workOrderEstimateId"));
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateById(workOrderEstimateId);
        milestone.setWorkOrderEstimate(workOrderEstimate);
        Milestone newMilestone = this.milestoneService.create(milestone);
        model.addAttribute("milestone", (Object)newMilestone);
        model.addAttribute("message", (Object)this.messageSource.getMessage("msg.milestone.create.success", (Object[])new String[]{workOrderEstimate.getEstimate().getEstimateNumber()}, null));
        return "milestone-success";
    }
}

