/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.mb;

import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.mb.entity.MBDetails;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.mb.service.MBHeaderService;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/mb"})
public class ViewMBController {
    @Autowired
    private MBHeaderService mBHeaderService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private LineEstimateService lineEstimateService;

    @RequestMapping(value={"/view/{mbheaderId}"}, method={RequestMethod.GET})
    public String showSearchWorkOrder(@PathVariable String mbheaderId, Model model) {
        MBHeader mBHeader = this.mBHeaderService.getMBHeaderById(Long.valueOf(Long.parseLong(mbheaderId)));
        for (MBDetails mBDetail : mBHeader.getMbDetails()) {
            Double prevCumulativeAmount;
            if (mBDetail == null || (prevCumulativeAmount = this.mBHeaderService.getPreviousCumulativeQuantity(mBHeader.getId(), mBDetail.getWorkOrderActivity().getId())) == null) continue;
            mBDetail.setPrevCumlvQuantity(prevCumulativeAmount.doubleValue());
        }
        mBHeader.setDocumentDetails(this.worksUtils.findByObjectIdAndObjectType(mBHeader.getId(), "MBHeader"));
        model.addAttribute("mbHeader", (Object)mBHeader);
        model.addAttribute("nameOfWork", (Object)mBHeader.getWorkOrderEstimate().getEstimate().getName());
        model.addAttribute("loaNumber", (Object)mBHeader.getWorkOrderEstimate().getWorkOrder().getWorkOrderNumber());
        model.addAttribute("loaAmount", (Object)mBHeader.getWorkOrderEstimate().getWorkOrder().getWorkOrderAmount());
        model.addAttribute("documentDetails", (Object)mBHeader.getDocumentDetails());
        model.addAttribute("mode", (Object)"view");
        model.addAttribute("workflowHistory", (Object)this.lineEstimateService.getHistory(mBHeader.getState(), mBHeader.getStateHistory()));
        return "mbheader-view";
    }
}

