/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.mb;

import java.util.List;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.mb.entity.SearchRequestMBHeader;
import org.egov.works.mb.service.MBHeaderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class SearchMBHeaderController {
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private MBHeaderService mBHeaderService;
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private SecurityUtils securityUtils;

    @RequestMapping(value={"/mbheader/searchform"}, method={RequestMethod.GET})
    public String showSearchWorkOrder(@ModelAttribute SearchRequestMBHeader searchRequestMBHeader, Model model) {
        this.setDropDownValues(model);
        List departments = this.lineEstimateService.getUserDepartments(this.securityUtils.getCurrentUser());
        if (departments != null && !departments.isEmpty()) {
            searchRequestMBHeader.setDepartment(((Department)departments.get(0)).getId());
        }
        model.addAttribute("egwStatus", (Object)this.mBHeaderService.getMBHeaderStatus());
        model.addAttribute("searchRequestMBHeader", (Object)searchRequestMBHeader);
        return "mbheader-searchform";
    }

    private void setDropDownValues(Model model) {
        model.addAttribute("departments", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("createdUsers", (Object)this.mBHeaderService.getMBHeaderCreatedByUsers());
    }

    @RequestMapping(value={"/measurementbook/searchactivityform"}, method={RequestMethod.GET})
    public String showSearchWorkOrderActivity(@RequestParam(value="woeId") Long workOrderEstimateId, @RequestParam(value="workOrderNo") String workOrderNo, @RequestParam(value="mbHeaderId") String mbHeaderId, Model model) {
        model.addAttribute("workOrderEstimateId", (Object)workOrderEstimateId);
        model.addAttribute("workOrderNo", (Object)workOrderNo);
        model.addAttribute("mbHeaderId", (Object)mbHeaderId);
        return "workorderactivity-searchform";
    }

    @RequestMapping(value={"/measurementbook/searchreactivityform"}, method={RequestMethod.GET})
    public String showSearchREWorkOrderActivity(@RequestParam(value="woeId") Long workOrderEstimateId, @RequestParam(value="workOrderNo") String workOrderNo, @RequestParam(value="mbHeaderId") String mbHeaderId, @RequestParam(value="mbDate") String mbDate, Model model) {
        model.addAttribute("workOrderEstimateId", (Object)workOrderEstimateId);
        model.addAttribute("workOrderNo", (Object)workOrderNo);
        model.addAttribute("mbHeaderId", (Object)mbHeaderId);
        model.addAttribute("mbDate", (Object)mbDate);
        return "searchREWorkOrderActivity-form";
    }
}

