/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.mb;

import javax.servlet.http.HttpServletRequest;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationException;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.contractorbill.entity.enums.BillTypes;
import org.egov.works.contractorbill.service.ContractorBillRegisterService;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.mb.entity.SearchRequestCancelMB;
import org.egov.works.mb.service.MBHeaderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/measurementbook"})
public class CancelMBController {
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private MBHeaderService mbHeaderService;
    @Autowired
    private ContractorBillRegisterService contractorBillRegisterService;

    @RequestMapping(value={"/cancel/search"}, method={RequestMethod.GET})
    public String showSearchMBForm(@ModelAttribute SearchRequestCancelMB searchRequestCancelMB, Model model) throws ApplicationException {
        model.addAttribute("departments", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("searchRequestCancelMB", (Object)searchRequestCancelMB);
        return "searchmb-cancel";
    }

    @RequestMapping(value={"/cancel"}, method={RequestMethod.POST})
    public String cancelMB(HttpServletRequest request, Model model) throws ApplicationException {
        Long mbId = Long.parseLong(request.getParameter("id"));
        String cancellationReason = request.getParameter("cancellationReason");
        String cancellationRemarks = request.getParameter("cancellationRemarks");
        MBHeader mbHeader = this.mbHeaderService.getMBHeaderById(mbId);
        String message = "";
        ContractorBillRegister contractorBillRegister = this.contractorBillRegisterService.getContratorBillForWorkOrder(mbHeader.getWorkOrderEstimate(), ContractorBillRegister.BillStatus.CANCELLED.toString(), BillTypes.Final_Bill.toString());
        if (contractorBillRegister != null) {
            message = this.messageSource.getMessage("error.mb.bill.created", (Object[])new String[]{contractorBillRegister.getBillnumber()}, null);
            model.addAttribute("errorMessage", (Object)message);
            return "mb-success";
        }
        MBHeader latestMBHeader = this.mbHeaderService.getLatestMBHeader(mbHeader.getWorkOrderEstimate().getId());
        if (latestMBHeader != null && !mbHeader.getId().equals(latestMBHeader.getId())) {
            message = this.messageSource.getMessage("error.mb.not.latest", (Object[])new String[]{latestMBHeader.getMbRefNo(), latestMBHeader.getMbRefNo()}, null);
            model.addAttribute("errorMessage", (Object)message);
            return "mb-success";
        }
        message = this.messageSource.getMessage("msg.mbheader.cancelled", (Object[])new String[]{mbHeader.getMbRefNo()}, null);
        mbHeader.setCancellationReason(cancellationReason);
        mbHeader.setCancellationRemarks(cancellationRemarks);
        mbHeader = this.mbHeaderService.cancel(mbHeader);
        model.addAttribute("mbHeader", (Object)mbHeader);
        model.addAttribute("message", (Object)message);
        return "mb-success";
    }
}

