/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.mb;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.works.contractorportal.entity.ContractorMBHeader;
import org.egov.works.contractorportal.service.ContractorMBHeaderService;
import org.egov.works.letterofacceptance.service.WorkOrderActivityService;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.mb.entity.SearchRequestCancelMB;
import org.egov.works.mb.entity.SearchRequestMBHeader;
import org.egov.works.mb.service.MBHeaderService;
import org.egov.works.models.masters.Contractor;
import org.egov.works.web.adaptor.SearchMBHeaderJsonAdaptor;
import org.egov.works.web.adaptor.SearchMBToCancelJson;
import org.egov.works.web.adaptor.SearchWorkOrderActivityJsonAdaptor;
import org.egov.works.workorder.entity.WorkOrderActivity;
import org.egov.works.workorder.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AjaxMBController {
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;
    @Autowired
    private MBHeaderService mBHeaderService;
    @Autowired
    private SearchMBHeaderJsonAdaptor searchMBHeaderJsonAdaptor;
    @Autowired
    private WorkOrderActivityService workOrderActivityService;
    @Autowired
    private SearchWorkOrderActivityJsonAdaptor searchWorkOrderActivityJsonAdaptor;
    @Autowired
    private SearchMBToCancelJson searchMBToCancelJson;
    @Autowired
    private ContractorMBHeaderService contractorMBHeaderService;

    @RequestMapping(value={"/workorder/validatemb/{workOrderEstimateId}"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String validateWorkOrder(@PathVariable Long workOrderEstimateId, HttpServletRequest request, HttpServletResponse response) {
        JsonObject jsonObject = new JsonObject();
        this.mBHeaderService.validateMBInDrafts(workOrderEstimateId, jsonObject, null);
        this.mBHeaderService.validateMBInWorkFlow(workOrderEstimateId, jsonObject, null);
        if (jsonObject.toString().length() > 2) {
            this.sendAJAXResponse(jsonObject.toString(), response);
            return "";
        }
        return null;
    }

    protected void sendAJAXResponse(String msg, HttpServletResponse response) {
        try {
            PrintWriter httpResponseWriter = response.getWriter();
            IOUtils.write((String)msg, (Writer)httpResponseWriter);
            IOUtils.closeQuietly((Writer)httpResponseWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/mbheader/ajaxworkordernumbers"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findWorkOrderNumber(@RequestParam String code) {
        return this.workOrderEstimateService.getApprovedAndWorkCommencedWorkOrderNumbers(code);
    }

    @RequestMapping(value={"/mbheader/ajaxestimateNumbers"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findEstimateNumbersForWorkOrder(@RequestParam String code) {
        return this.workOrderEstimateService.getEstimateNumbersByApprovedAndWorkCommencedWorkOrders(code);
    }

    @RequestMapping(value={"/mbheader/ajaxcontractors"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Contractor> findContractorsForWorkOrder(@RequestParam String code) {
        return this.workOrderEstimateService.getContractorsByWorkOrderStatus(code);
    }

    @RequestMapping(value={"/mbheader/ajaxcontractormbheaders"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ContractorMBHeader> findContractorMBHeadersForWorkOrderEstimateId(@RequestParam String workOrderEstimateId) {
        return this.contractorMBHeaderService.getContractorMBHeaderByWorkOrderEstimateId(Long.valueOf(workOrderEstimateId));
    }

    @RequestMapping(value={"/mbheader/ajax-searchmbheader"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchMBHeaders(@ModelAttribute SearchRequestMBHeader searchRequestMBHeader) {
        List mBHeaderList = this.mBHeaderService.searchMBHeader(searchRequestMBHeader);
        String result = "{ \"data\":" + this.searchMBHeader((Object)mBHeaderList) + "}";
        return result;
    }

    public Object searchMBHeader(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(MBHeader.class, (Object)this.searchMBHeaderJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/measurementbook/ajax-searchactivities"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchWorkOrderActivities(HttpServletRequest request) {
        Long workOrderEstimateId = Long.parseLong(request.getParameter("workOrderEstimateId"));
        Long mbHeaderId = Long.parseLong(request.getParameter("id"));
        String description = request.getParameter("description");
        String itemCode = request.getParameter("itemCode");
        String sorType = request.getParameter("sorType");
        List workOrderActivities = this.workOrderActivityService.searchActivities(workOrderEstimateId, description, itemCode, sorType);
        ArrayList<WorkOrderActivity> activities = new ArrayList<WorkOrderActivity>();
        if (description != null && !description.equals("")) {
            for (WorkOrderActivity woa : workOrderActivities) {
                if ((woa.getActivity().getSchedule() == null || !woa.getActivity().getSchedule().getDescription().toLowerCase().contains(description.toLowerCase())) && (woa.getActivity().getNonSor() == null || !woa.getActivity().getNonSor().getDescription().toLowerCase().contains(description.toLowerCase()))) continue;
                activities.add(woa);
            }
        }
        if (!activities.isEmpty()) {
            workOrderActivities.clear();
            workOrderActivities.addAll(activities);
        }
        if (itemCode != null && !itemCode.equals("")) {
            activities.clear();
            for (WorkOrderActivity woa : workOrderActivities) {
                if (woa.getActivity().getSchedule() == null || !woa.getActivity().getSchedule().getCode().toLowerCase().contains(itemCode.toLowerCase())) continue;
                activities.add(woa);
            }
        }
        if (!activities.isEmpty()) {
            workOrderActivities.clear();
            workOrderActivities.addAll(activities);
        }
        for (WorkOrderActivity woa : workOrderActivities) {
            woa.setMbHeaderId(mbHeaderId);
        }
        String result = "{ \"data\":" + this.toSearchWorkOrderActivityResultJson((Object)workOrderActivities) + "}";
        return result;
    }

    @RequestMapping(value={"/measurementbook/ajax-searchreactivities"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchREWorkOrderActivities(HttpServletRequest request) {
        Long workOrderEstimateId = Long.parseLong(request.getParameter("workOrderEstimateId"));
        Long mbHeaderId = Long.parseLong(request.getParameter("id"));
        String description = request.getParameter("description");
        String itemCode = request.getParameter("itemCode");
        String nonTenderedType = request.getParameter("nonTenderedType");
        String mbDate = request.getParameter("mbDate");
        List workOrderActivities = this.workOrderActivityService.searchREActivities(workOrderEstimateId, description, itemCode, nonTenderedType, mbDate);
        for (WorkOrderActivity woa : workOrderActivities) {
            woa.setMbHeaderId(mbHeaderId);
        }
        String result = "{ \"data\":" + this.toSearchWorkOrderActivityResultJson((Object)workOrderActivities) + "}";
        return result;
    }

    public Object toSearchWorkOrderActivityResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(WorkOrderActivity.class, (Object)this.searchWorkOrderActivityJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/measurementbook/cancel/ajax-search"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchMBsToCancel(Model model, @ModelAttribute SearchRequestCancelMB searchRequestCancelMB) {
        List mbHeaders = this.mBHeaderService.searchMBsToCancel(searchRequestCancelMB);
        String result = "{ \"data\":" + this.toSearchMBsToCancelJson((Object)mbHeaders) + "}";
        return result;
    }

    public Object toSearchMBsToCancelJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(MBHeader.class, (Object)this.searchMBToCancelJson).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/measurementbook/ajaxloanumbers-mbtocancel"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findLOAsToCancelMB(@RequestParam String code) {
        return this.mBHeaderService.findLoaNumbersToCancelMB(code);
    }

    @RequestMapping(value={"/measurementbook/ajaxcontractors-mbtocancel"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findContractorsToCancelMB(@RequestParam String code) {
        return this.mBHeaderService.findContractorsToCancelMB(code);
    }

    @RequestMapping(value={"/measurementbook/ajaxworkidentificationnumbers-mbtocancel"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findWorkIdNumbersToCancelMB(@RequestParam String code) {
        return this.mBHeaderService.findWorkIdentificationNumbersToCancelMB(code);
    }

    @RequestMapping(value={"/measurementbook/ajaxvalidatelatestmb-mbtocancel/{mbHeaderId}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String validateIsLatestMB(@PathVariable Long mbHeaderId) {
        MBHeader mbHeader = this.mBHeaderService.getMBHeaderById(mbHeaderId);
        MBHeader latestMBHeader = this.mBHeaderService.getLatestMBHeader(mbHeader.getWorkOrderEstimate().getId());
        if (!mbHeader.getId().equals(latestMBHeader.getId())) {
            return latestMBHeader.getMbRefNo();
        }
        return "";
    }

    @RequestMapping(value={"/measurementbook/ajax-loadmbbasedonbilldate"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String loadMBBasedOnBillDate(@RequestParam Long workOrderEstimateId, @RequestParam Date billDate) {
        List mBHeaderList = this.mBHeaderService.getMBHeaderBasedOnBillDate(workOrderEstimateId, billDate);
        StringBuilder result = new StringBuilder(this.searchMBHeader((Object)mBHeaderList).toString());
        if (!mBHeaderList.isEmpty()) {
            return result.toString();
        }
        return "";
    }
}

