/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.masters;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.infra.exception.ApplicationException;
import org.egov.works.master.service.OverheadService;
import org.egov.works.models.masters.Overhead;
import org.egov.works.models.masters.OverheadRate;
import org.egov.works.services.WorksService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/masters"})
public class CreateOverheadController {
    @Autowired
    private WorksService worksService;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    @Autowired
    private OverheadService overheadService;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;

    @RequestMapping(value={"/overhead-newform"}, method={RequestMethod.GET})
    public String showNewForm(Model model) {
        Overhead overhead = new Overhead();
        overhead.setTempOverheadRateValues(overhead.getOverheadRates());
        this.setDropDownValues(model);
        model.addAttribute("overhead", (Object)overhead);
        return "overhead-form";
    }

    @RequestMapping(value={"/overhead-save"}, method={RequestMethod.POST})
    public String create(@ModelAttribute Overhead overhead, Model model, HttpServletRequest request, BindingResult resultBinder) throws ApplicationException, IOException {
        this.validateOverhead(overhead, resultBinder);
        String mode = request.getParameter("mode");
        if (mode.equalsIgnoreCase("edit") && overhead.getId() != null) {
            model.addAttribute("mode", (Object)"edit");
        }
        if (resultBinder.hasErrors()) {
            this.setDropDownValues(model);
            model.addAttribute("overhead", (Object)overhead);
            return "overhead-form";
        }
        this.overheadService.createOverheadValues(overhead);
        this.overheadService.create(overhead);
        Long overheadId = overhead.getId();
        return "redirect:/masters/overhead-success?overheadId=" + overheadId;
    }

    @RequestMapping(value={"/overhead-success"}, method={RequestMethod.GET})
    public String successView(Model model, HttpServletRequest request) {
        Long overheadId = Long.valueOf(request.getParameter("overheadId"));
        Overhead newOverhead = this.overheadService.getOverheadById(overheadId);
        model.addAttribute("overhead", (Object)newOverhead);
        String mode = request.getParameter("mode");
        if (mode != null && mode.equalsIgnoreCase("edit")) {
            model.addAttribute("mode", (Object)"edit");
        }
        model.addAttribute("success", (Object)this.messageSource.getMessage("msg.overhead.create.success", (Object[])new String[]{newOverhead.getName()}, null));
        model.addAttribute("modify", (Object)this.messageSource.getMessage("msg.overhead.modify.success", (Object[])new String[]{newOverhead.getName()}, null));
        return "overhead-success";
    }

    private void setDropDownValues(Model model) {
        if (this.worksService.getWorksConfigValue("OVERHEAD_PURPOSE") != null) {
            model.addAttribute("accounts", (Object)this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(this.worksService.getWorksConfigValue("OVERHEAD_PURPOSE"))));
        }
    }

    private void validateOverhead(Overhead overhead, BindingResult resultBinder) {
        String overheadName = overhead.getName();
        Overhead existingOverhead = this.overheadService.getOverheadByName(overheadName);
        Long overheadId = overhead.getId();
        if (existingOverhead != null && !existingOverhead.getId().equals(overheadId)) {
            resultBinder.reject("error.overheadname.exists", (Object[])new String[]{existingOverhead.getName()}, "error.overheadname.exists");
        }
        if (!overheadName.matches("[0-9a-zA-Z-& :,/.()@]+")) {
            resultBinder.reject("error.overheadname.invalid", "error.overheadname.invalid");
        }
        if (overhead.getTempOverheadRateValues() == null) {
            resultBinder.reject("error.overhead.altleastone.overheadrate.needed", (Object[])new String[]{""}, "error.overhead.altleastone.overheadrate.needed");
        }
        if (overhead.getName() == null) {
            resultBinder.reject("error.overhead.overheadname", (Object[])new String[]{""}, "error.overhead.overheadname");
        }
        if (overhead.getDescription() == null) {
            resultBinder.reject("error.overhead.overheaddescription", (Object[])new String[]{""}, "error.overhead.overheaddescription");
        }
        if (overhead.getAccountCode() == null) {
            resultBinder.reject("error.overhead.overheadaccountcode", (Object[])new String[]{""}, "error.overhead.overheadaccountcode");
        }
        for (OverheadRate overheadRates : overhead.getTempOverheadRateValues()) {
            if (overheadRates.getValidity().getEndDate() != null && overheadRates.getValidity().getStartDate().after(overheadRates.getValidity().getEndDate())) {
                resultBinder.reject("overhead.date.invalid", (Object[])new String[]{""}, "overhead.date.invalid");
                break;
            }
            if (!(overheadRates.getPercentage() != null && overheadRates.getPercentage() != 0.0 || overheadRates.getLumpsumAmount() != null && overheadRates.getLumpsumAmount() != 0.0)) {
                resultBinder.reject("overhead.overheadRates.invalid", (Object[])new String[]{""}, "overhead.overheadRates.invalid");
                break;
            }
            if (overheadRates.getPercentage() != null && overheadRates.getPercentage() > 0.0 && overheadRates.getLumpsumAmount() != null && overheadRates.getLumpsumAmount() > 0.0) {
                resultBinder.reject("overhead.lumpsumandpercentage.invalid", (Object[])new String[]{""}, "overhead.lumpsumandpercentage.invalid");
                break;
            }
            if (overheadRates.getPercentage() != null && overheadRates.getPercentage() > 0.0 && overheadRates.getLumpsumAmount() != null && overheadRates.getLumpsumAmount() <= 0.0) {
                resultBinder.reject("overhead.lumpsumandpercentage.invalid", (Object[])new String[]{""}, "overhead.lumpsumandpercentage.invalid");
                break;
            }
            if (overheadRates.getPercentage() != null && overheadRates.getPercentage() <= 0.0 && overheadRates.getLumpsumAmount() != null && overheadRates.getLumpsumAmount() > 0.0) {
                resultBinder.reject("overhead.lumpsumandpercentage.invalid", (Object[])new String[]{""}, "overhead.lumpsumandpercentage.invalid");
                break;
            }
            if (overheadRates.getPercentage() == null || !(overheadRates.getPercentage() < 0.0) && !(overheadRates.getPercentage() > 100.0)) continue;
            resultBinder.reject("overhead.percentage.invalid", (Object[])new String[]{""}, "overhead.percentage.invalid");
            break;
        }
    }
}

