/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.masters;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import org.egov.works.master.service.ScheduleCategoryService;
import org.egov.works.models.masters.ScheduleCategory;
import org.egov.works.models.masters.SearchRequestScheduleCategory;
import org.egov.works.web.adaptor.SearchScheduleCategoryJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/masters"})
public class AjaxScheduleCategoryController {
    @Autowired
    private ScheduleCategoryService scheduleCategoryService;
    @Autowired
    private SearchScheduleCategoryJsonAdaptor searchScheduleCategoryJsonAdaptor;

    @RequestMapping(value={"/ajaxsearch-schedulecategory"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxSearchOverheadToModify(Model model, @ModelAttribute SearchRequestScheduleCategory searchRequestScheduleCategory) {
        List searchResultList = this.scheduleCategoryService.searchScheduleCategory(searchRequestScheduleCategory);
        String result = "{ \"data\":" + this.toSearchScheduleCategoryResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchScheduleCategoryResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(ScheduleCategory.class, (Object)this.searchScheduleCategoryJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajax-schedulecategorynames"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findScheduleCategoryName(@RequestParam String categoryName) {
        return this.scheduleCategoryService.getCategoryNames(categoryName);
    }
}

