/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.masters;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import org.egov.works.master.service.OverheadService;
import org.egov.works.models.masters.Overhead;
import org.egov.works.models.masters.SearchRequestOverhead;
import org.egov.works.web.adaptor.SearchOverheadJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/masters"})
public class AjaxOverheadController {
    @Autowired
    private OverheadService overheadService;
    @Autowired
    private SearchOverheadJsonAdaptor searchOverheadJsonAdaptor;

    @RequestMapping(value={"/ajaxsearch-overhead"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxSearchOverheadToModify(Model model, @ModelAttribute SearchRequestOverhead searchRequestOverhead) {
        List searchResultList = this.overheadService.searchOverheadToModify(searchRequestOverhead);
        String result = "{ \"data\":" + this.toSearchOverheadResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchOverheadResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(Overhead.class, (Object)this.searchOverheadJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajax-searchoverheadname"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findOverheadName(@RequestParam String name) {
        return this.overheadService.findOverheadNameToSearchOverhead(name);
    }

    @RequestMapping(value={"/ajaxsearch-viewoverhead"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxSearchOverheadToView(Model model, @ModelAttribute SearchRequestOverhead searchRequestOverhead) {
        List searchResultList = this.overheadService.searchOverheadToView(searchRequestOverhead);
        String result = "{ \"data\":" + this.toSearchOverheadResultJson((Object)searchResultList) + "}";
        return result;
    }
}

