/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.contractorportal;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.works.contractorportal.service.ContractorMBHeaderService;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/contractorportal/mb"})
public class AjaxContractorMBController {
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;
    @Autowired
    private ContractorMBHeaderService contractorMBHeaderService;
    @Autowired
    private MessageSource messageSource;

    @RequestMapping(value={"/ajaxworkorder-mbheader"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findWorkOrderForMBHeader(@RequestParam String workOrderNo) {
        return this.workOrderEstimateService.findWorkOrderForMBHeader(workOrderNo);
    }

    @RequestMapping(value={"/ajax-sendotp"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String sendOTPForContractorMB(@RequestParam String workOrderNo) {
        WorkOrder workOrder = this.letterOfAcceptanceService.getApprovedWorkOrder(workOrderNo);
        String mobileNumber = workOrder.getContractor().getMobileNumber();
        String response = "";
        response = StringUtils.isNotBlank((CharSequence)mobileNumber) ? this.contractorMBHeaderService.sendOTPMessage(mobileNumber).toString() : this.messageSource.getMessage("msg.contractor.mobilenumber.not.exist", (Object[])new String[]{ApplicationThreadLocals.getMunicipalityName()}, null);
        return response;
    }

    @RequestMapping(value={"/ajax-validateotp"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public boolean validateOTPForContractorMB(@RequestParam String workOrderNo, @RequestParam String otp) {
        WorkOrder workOrder = this.letterOfAcceptanceService.getApprovedWorkOrder(workOrderNo);
        String mobileNumber = workOrder.getContractor().getMobileNumber();
        boolean success = false;
        if (StringUtils.isNotBlank((CharSequence)otp)) {
            success = this.contractorMBHeaderService.isValidOTP(otp, mobileNumber);
        }
        return success;
    }
}

