/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.contractorbill;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.utils.WebUtils;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.contractorbill.service.ContractorBillRegisterService;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/contractcertificate"})
public class ContractCertificatePDFController {
    @Autowired
    private ReportService reportService;
    @Autowired
    private ContractorBillRegisterService contractorBillRegisterService;
    public static final String CONTRACTCERTIFICATEPDF = "ContractCertificatePDF";
    private final Map<String, Object> reportParams = new HashMap();
    private ReportRequest reportInput = null;
    private ReportOutput reportOutput = null;

    @RequestMapping(value={"/contractcertificatePDF/{contractorBillId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateContractorBillPDF(HttpServletRequest request, @PathVariable(value="contractorBillId") Long id, HttpSession session) throws IOException {
        ContractorBillRegister contractorBillRegister = this.contractorBillRegisterService.getContractorBillById(id);
        return this.generateReport(contractorBillRegister, request, session);
    }

    private ResponseEntity<byte[]> generateReport(ContractorBillRegister contractorBillRegister, HttpServletRequest request, HttpSession session) {
        if (contractorBillRegister != null) {
            String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
            this.reportParams.put("cityLogo", url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo")));
            String cityName = ApplicationThreadLocals.getMunicipalityName();
            this.reportParams.put("cityName", cityName);
            this.reportParams.put("contractorBillRegister", contractorBillRegister);
            Date lastPartBillDate = this.contractorBillRegisterService.getLastPartBillDateForContractorBill(contractorBillRegister.getCreatedDate(), contractorBillRegister.getWorkOrderEstimate().getId());
            this.reportParams.put("lastPartBillDate", lastPartBillDate != null ? DateUtils.getDefaultFormattedDate((Date)lastPartBillDate) : "NA");
            this.reportParams.put("billDate", DateUtils.getDefaultFormattedDate((Date)contractorBillRegister.getBilldate()));
            this.reportParams.put("reportRunDate", DateUtils.getFormattedDateWithTimeStamp((DateTime)new DateTime()));
            List contractCertificateInfoList = this.contractorBillRegisterService.getContractCertificateDetails(contractorBillRegister, this.reportParams);
            this.reportInput = new ReportRequest(CONTRACTCERTIFICATEPDF, (Collection)contractCertificateInfoList, this.reportParams);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=ContractCertificate_" + contractorBillRegister.getBillnumber() + ".pdf");
        this.reportOutput = this.reportService.createReport(this.reportInput);
        return new ResponseEntity((Object)this.reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

