/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.abstractestimate;

import java.util.ArrayList;
import java.util.List;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.AbstractEstimateForLoaSearchRequest;
import org.egov.works.abstractestimate.entity.EstimateTechnicalSanction;
import org.egov.works.abstractestimate.entity.SearchAbstractEstimate;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.abstractestimate.service.MeasurementSheetService;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/abstractestimate"})
public class SearchAbstractEstimateController {
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private MeasurementSheetService measurementSheetService;

    @RequestMapping(value={"/searchform"}, method={RequestMethod.GET})
    public String searchForm(@ModelAttribute SearchAbstractEstimate searchAbstractEstimate, Model model) throws ApplicationException {
        this.setDropDownValues(model);
        List egwStatuses = this.egwStatusHibernateDAO.getStatusByModule("AbstractEstimate");
        ArrayList<EgwStatus> newEgwStatuses = new ArrayList<EgwStatus>();
        for (EgwStatus egwStatus : egwStatuses) {
            if (egwStatus.getCode().equalsIgnoreCase(AbstractEstimate.OfflineStatusesForAbstractEstimate.L1_TENDER_FINALIZED.toString()) || egwStatus.getCode().equalsIgnoreCase(AbstractEstimate.OfflineStatusesForAbstractEstimate.COMMERCIAL_EVALUATION_DONE.toString()) || egwStatus.getCode().equalsIgnoreCase(AbstractEstimate.OfflineStatusesForAbstractEstimate.TECHNICAL_EVALUATION_DONE.toString()) || egwStatus.getCode().equalsIgnoreCase(AbstractEstimate.OfflineStatusesForAbstractEstimate.TENDER_DOCUMENT_RELEASED.toString()) || egwStatus.getCode().equalsIgnoreCase(AbstractEstimate.OfflineStatusesForAbstractEstimate.TENDER_OPENED.toString()) || egwStatus.getCode().equalsIgnoreCase(AbstractEstimate.OfflineStatusesForAbstractEstimate.NOTICEINVITINGTENDERRELEASED.toString())) continue;
            newEgwStatuses.add(egwStatus);
        }
        model.addAttribute("abstractEstimateStatus", newEgwStatuses);
        model.addAttribute("searchAbstractEstimate", (Object)searchAbstractEstimate);
        return "abstractestimate-search";
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String viewAbstractEstimate(@PathVariable String id, Model model) throws ApplicationException {
        AbstractEstimate abstractEstimate = this.estimateService.getAbstractEstimateById(Long.valueOf(id));
        this.getEstimateDocuments(abstractEstimate);
        List values = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "SHOW_SERVICE_FIELDS");
        AppConfigValues value = (AppConfigValues)values.get(0);
        if (value.getValue().equalsIgnoreCase("Yes")) {
            model.addAttribute("isServiceVATRequired", (Object)true);
        } else {
            model.addAttribute("isServiceVATRequired", (Object)false);
        }
        List showDeductions = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "SHOW_DEDUCTION_GRID");
        AppConfigValues showDeduction = (AppConfigValues)showDeductions.get(0);
        if (showDeduction.getValue().equalsIgnoreCase("Yes")) {
            model.addAttribute("isEstimateDeductionGrid", (Object)true);
        } else {
            model.addAttribute("isEstimateDeductionGrid", (Object)false);
        }
        model.addAttribute("mode", (Object)"view");
        model.addAttribute("abstractEstimate", (Object)abstractEstimate);
        model.addAttribute("documentDetails", (Object)abstractEstimate.getDocumentDetails());
        model.addAttribute("workOrderEstimate", (Object)this.workOrderEstimateService.getWorkOrderEstimateByAbstractEstimateId(Long.valueOf(id)));
        model.addAttribute("paymentreleased", (Object)this.estimateService.getPaymentsReleasedForLineEstimate(abstractEstimate.getLineEstimateDetails()));
        model.addAttribute("adminsanctionbydesignation", (Object)this.worksUtils.getUserDesignation(abstractEstimate.getApprovedBy()));
        model.addAttribute("measurementsPresent", (Object)this.measurementSheetService.existsByEstimate(abstractEstimate.getId()));
        String techSanctionBy = "";
        if (!abstractEstimate.getEstimateTechnicalSanctions().isEmpty()) {
            techSanctionBy = this.worksUtils.getUserDesignation(((EstimateTechnicalSanction)abstractEstimate.getEstimateTechnicalSanctions().get(abstractEstimate.getEstimateTechnicalSanctions().size() - 1)).getTechnicalSanctionBy());
        }
        model.addAttribute("technicalsanctionbydesignation", (Object)techSanctionBy);
        model.addAttribute("workflowHistory", (Object)this.lineEstimateService.getHistory(abstractEstimate.getState(), abstractEstimate.getStateHistory()));
        return "abstractestimate-view";
    }

    @RequestMapping(value={"/searchabstractestimateforloa-form"}, method={RequestMethod.GET})
    public String searchAbstractEstimateForLOA(@ModelAttribute AbstractEstimateForLoaSearchRequest abstractEstimateForLoaSearchRequest, Model model) {
        this.setDropDownValues(model);
        List departments = this.lineEstimateService.getUserDepartments(this.securityUtils.getCurrentUser());
        ArrayList<Long> departmentIds = new ArrayList<Long>();
        if (departments != null) {
            for (Department department : departments) {
                departmentIds.add(department.getId());
            }
        }
        List abstractEstimateCreatedByUsers = this.estimateService.getAbstractEstimateCreatedByUsers(departmentIds);
        model.addAttribute("abstractEstimateForLoaSearchRequest", (Object)abstractEstimateForLoaSearchRequest);
        model.addAttribute("abstractEstimateCreatedByUsers", (Object)abstractEstimateCreatedByUsers);
        model.addAttribute("departments", (Object)departments);
        return "searchAbstractEstimateForLoa-search";
    }

    private void setDropDownValues(Model model) {
        model.addAttribute("departments", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("createdUsers", (Object)this.estimateService.getAbstractEstimateCreatedByUsers());
        model.addAttribute("abstractEstimateStatus", (Object)this.worksUtils.getStatusByModule("AbstractEstimate"));
    }

    private void getEstimateDocuments(AbstractEstimate abstractEstimate) {
        List documentDetailsList = new ArrayList();
        documentDetailsList = this.worksUtils.findByObjectIdAndObjectType(abstractEstimate.getId(), "AbstractEstimate");
        abstractEstimate.setDocumentDetails(documentDetailsList);
    }

    @RequestMapping(value={"/searchabstractestimateforofflinestatus-form"}, method={RequestMethod.GET})
    public String searchAbstractEstimateToSetOfflineStatus(@ModelAttribute AbstractEstimateForLoaSearchRequest abstractEstimateForLoaSearchRequest, Model model) {
        this.setDropDownValues(model);
        List egwStatuses = this.egwStatusHibernateDAO.getStatusByModule("AbstractEstimate");
        ArrayList<EgwStatus> newEgwStatuses = new ArrayList<EgwStatus>();
        for (EgwStatus egwStatus : egwStatuses) {
            if (egwStatus.getCode().equalsIgnoreCase("NEW") || egwStatus.getCode().equalsIgnoreCase("REJECTED") || egwStatus.getCode().equalsIgnoreCase("cancelled") || egwStatus.getCode().equalsIgnoreCase("CHECKED".toString()) || egwStatus.getCode().equalsIgnoreCase("CREATED") || egwStatus.getCode().equalsIgnoreCase("RESUBMITTED")) continue;
            newEgwStatuses.add(egwStatus);
        }
        List departments = this.lineEstimateService.getUserDepartments(this.securityUtils.getCurrentUser());
        ArrayList<Long> departmentIds = new ArrayList<Long>();
        if (departments != null) {
            for (Department department : departments) {
                departmentIds.add(department.getId());
            }
        }
        List abstractEstimateCreatedByUsers = this.estimateService.getAbstractEstimateCreatedByUsers(departmentIds);
        model.addAttribute("egwStatus", newEgwStatuses);
        model.addAttribute("abstractEstimateForLoaSearchRequest", (Object)abstractEstimateForLoaSearchRequest);
        model.addAttribute("abstractEstimateCreatedByUsers", (Object)abstractEstimateCreatedByUsers);
        return "searchAbstractEstimateForOfflineStatus-search";
    }
}

