/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.abstractestimate.service.ActivityService;
import org.egov.works.mb.service.MBHeaderService;
import org.egov.works.revisionestimate.entity.enums.RevisionType;
import org.egov.works.workorder.entity.WorkOrderActivity;
import org.egov.works.workorder.entity.WorkOrderMeasurementSheet;
import org.egov.works.workorder.service.WorkOrderMeasurementSheetService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchWorkOrderActivityJsonAdaptor
implements JsonSerializer<WorkOrderActivity> {
    @Autowired
    private MBHeaderService mbHeaderService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private WorkOrderMeasurementSheetService workOrderMeasurementSheetService;

    public JsonElement serialize(WorkOrderActivity workOrderActivity, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        if (workOrderActivity.getActivity().getSchedule() != null) {
            jsonObject.addProperty("description", workOrderActivity.getActivity().getSchedule().getDescription());
            jsonObject.addProperty("summary", workOrderActivity.getActivity().getSchedule().getSummary());
            jsonObject.addProperty("sorNonSorType", "SOR");
            jsonObject.addProperty("sorCode", workOrderActivity.getActivity().getSchedule().getCode());
            jsonObject.addProperty("categoryType", workOrderActivity.getActivity().getSchedule().getScheduleCategory().getCode());
        } else {
            if (workOrderActivity.getActivity().getNonSor() != null) {
                jsonObject.addProperty("description", workOrderActivity.getActivity().getNonSor().getDescription());
                jsonObject.addProperty("summary", workOrderActivity.getActivity().getNonSor().getDescription());
            } else {
                jsonObject.addProperty("description", "");
                jsonObject.addProperty("summary", "");
            }
            jsonObject.addProperty("sorNonSorType", "Non SOR");
            jsonObject.addProperty("sorCode", "");
            jsonObject.addProperty("categoryType", "");
        }
        if (workOrderActivity.getActivity().getUom() != null) {
            jsonObject.addProperty("uom", workOrderActivity.getActivity().getUom().getUom());
        } else {
            jsonObject.addProperty("uom", "");
        }
        Double quantity = workOrderActivity.getActivity().getQuantity();
        List cqActivities = this.activityService.findApprovedActivitiesByParentId(workOrderActivity.getActivity().getId());
        for (Activity act : cqActivities) {
            if (act.getRevisionType().equals((Object)RevisionType.ADDITIONAL_QUANTITY)) {
                quantity = quantity + act.getQuantity();
                continue;
            }
            quantity = quantity - act.getQuantity();
        }
        jsonObject.addProperty("approvedQuantity", (Number)quantity);
        jsonObject.addProperty("estimateRate", (Number)workOrderActivity.getActivity().getEstimateRate());
        jsonObject.addProperty("approvedRate", (Number)workOrderActivity.getApprovedRate());
        jsonObject.addProperty("approvedAmount", (Number)workOrderActivity.getApprovedAmount());
        jsonObject.addProperty("activityAmount", (Number)workOrderActivity.getActivity().getAmount().getValue());
        jsonObject.addProperty("unitRate", (Number)workOrderActivity.getActivity().getRate());
        jsonObject.addProperty("conversionFactor", (Number)workOrderActivity.getActivity().getConversionFactor());
        Double cumulativePreviousEntry = 0.0;
        cumulativePreviousEntry = this.mbHeaderService.getPreviousCumulativeQuantity(workOrderActivity.getMbHeaderId(), workOrderActivity.getId());
        if (cumulativePreviousEntry == null) {
            jsonObject.addProperty("cumulativePreviousEntry", (Number)0);
        } else {
            jsonObject.addProperty("cumulativePreviousEntry", (Number)cumulativePreviousEntry);
        }
        jsonObject.addProperty("id", (Number)workOrderActivity.getId());
        if (!workOrderActivity.getWorkOrderMeasurementSheets().isEmpty()) {
            JsonArray jsonArray = new JsonArray();
            for (WorkOrderMeasurementSheet woms : workOrderActivity.getWorkOrderMeasurementSheets()) {
                JsonObject child = new JsonObject();
                this.deriveMeasurementSheetQuantity(woms);
                child.addProperty("womsid", (Number)woms.getId());
                child.addProperty("slNo", (Number)woms.getMeasurementSheet().getSlNo());
                child.addProperty("remarks", woms.getMeasurementSheet().getRemarks());
                child.addProperty("no", (Number)woms.getNo());
                child.addProperty("length", (Number)woms.getLength());
                child.addProperty("width", (Number)woms.getWidth());
                child.addProperty("depthOrHeight", (Number)woms.getDepthOrHeight());
                child.addProperty("quantity", (Number)woms.getQuantity());
                child.addProperty("identifier", Character.valueOf(woms.getMeasurementSheet().getIdentifier()));
                Double mbmsCumulativePreviousEntry = this.mbHeaderService.getMeasurementsPreviousCumulativeQuantity(workOrderActivity.getMbHeaderId(), woms.getId());
                child.addProperty("mbmsPreviousEntry", (Number)(mbmsCumulativePreviousEntry != null ? mbmsCumulativePreviousEntry : 0.0));
                jsonArray.add((JsonElement)child);
            }
            jsonObject.add("woms", (JsonElement)jsonArray);
        } else {
            jsonObject.add("woms", (JsonElement)new JsonArray());
        }
        return jsonObject;
    }

    private void deriveMeasurementSheetQuantity(WorkOrderMeasurementSheet workOrderMeasurementSheet) {
        List remsList = new ArrayList();
        remsList = this.workOrderMeasurementSheetService.findByMeasurementSheetParentId(workOrderMeasurementSheet.getMeasurementSheet().getId());
        Double no = workOrderMeasurementSheet.getNo() == null ? 0.0 : workOrderMeasurementSheet.getNo().doubleValue();
        Double length = workOrderMeasurementSheet.getLength() == null ? 0.0 : workOrderMeasurementSheet.getLength().doubleValue();
        Double width = workOrderMeasurementSheet.getWidth() == null ? 0.0 : workOrderMeasurementSheet.getWidth().doubleValue();
        Double depthOrHeight = workOrderMeasurementSheet.getDepthOrHeight() == null ? 0.0 : workOrderMeasurementSheet.getDepthOrHeight().doubleValue();
        for (WorkOrderMeasurementSheet rems : remsList) {
            if (rems.getNo() != null) {
                no = no + rems.getNo().doubleValue();
            }
            if (rems.getLength() != null) {
                length = length + rems.getLength().doubleValue();
            }
            if (rems.getWidth() != null) {
                width = width + rems.getWidth().doubleValue();
            }
            if (rems.getDepthOrHeight() == null) continue;
            depthOrHeight = depthOrHeight + rems.getDepthOrHeight().doubleValue();
        }
        if (no != null && no != 0.0) {
            workOrderMeasurementSheet.setNo(new BigDecimal(no.toString()));
        }
        if (length != null && length != 0.0) {
            workOrderMeasurementSheet.setLength(new BigDecimal(length.toString()));
        }
        if (width != null && width != 0.0) {
            workOrderMeasurementSheet.setWidth(new BigDecimal(width.toString()));
        }
        if (depthOrHeight != null && depthOrHeight != 0.0) {
            workOrderMeasurementSheet.setDepthOrHeight(new BigDecimal(depthOrHeight.toString()));
        }
        workOrderMeasurementSheet.setQuantity(new BigDecimal((no == null || no == 0.0 ? 1.0 : no) * (length == null || length == 0.0 ? 1.0 : length) * (width == null || width == 0.0 ? 1.0 : width) * (depthOrHeight == null || depthOrHeight == 0.0 ? 1.0 : depthOrHeight)));
    }
}

