/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.works.milestone.entity.Milestone;
import org.springframework.stereotype.Component;

@Component
public class SearchMilestoneJsonAdaptor
implements JsonSerializer<Milestone> {
    public JsonElement serialize(Milestone milestone, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (milestone != null) {
            if (milestone.getWorkOrderEstimate().getWorkOrder().getEstimateNumber() != null) {
                jsonObject.addProperty("estimateNumber", milestone.getWorkOrderEstimate().getEstimate().getEstimateNumber());
                jsonObject.addProperty("workIdentificationNumber", milestone.getWorkOrderEstimate().getEstimate().getProjectCode().getCode());
                jsonObject.addProperty("nameOfWork", milestone.getWorkOrderEstimate().getEstimate().getName());
                jsonObject.addProperty("department", milestone.getWorkOrderEstimate().getEstimate().getExecutingDepartment().getName());
                if (milestone.getWorkOrderEstimate().getEstimate().getParentCategory() != null) {
                    jsonObject.addProperty("typeOfWork", milestone.getWorkOrderEstimate().getEstimate().getParentCategory().getDescription());
                }
                if (milestone.getWorkOrderEstimate().getEstimate().getCategory() != null) {
                    jsonObject.addProperty("subTypeOfWork", milestone.getWorkOrderEstimate().getEstimate().getCategory().getDescription());
                }
                if (milestone.getWorkOrderEstimate().getEstimate().getLineEstimateDetails() != null) {
                    jsonObject.addProperty("lineEstimateId", (Number)milestone.getWorkOrderEstimate().getEstimate().getLineEstimateDetails().getLineEstimate().getId());
                }
            } else {
                jsonObject.addProperty("estimateNumber", "");
                jsonObject.addProperty("workIdentificationNumber", "");
                jsonObject.addProperty("nameOfWork", "");
                jsonObject.addProperty("department", "");
                jsonObject.addProperty("typeOfWork", "");
                jsonObject.addProperty("subTypeOfWork", "");
                jsonObject.addProperty("lineEstimateId", "");
            }
            if (milestone.getWorkOrderEstimate().getWorkOrder() != null) {
                jsonObject.addProperty("agreementAmount", (Number)milestone.getWorkOrderEstimate().getWorkOrder().getWorkOrderAmount());
                jsonObject.addProperty("workOrderNumber", milestone.getWorkOrderEstimate().getWorkOrder().getWorkOrderNumber());
                jsonObject.addProperty("workOrderId", (Number)milestone.getWorkOrderEstimate().getWorkOrder().getId());
            } else {
                jsonObject.addProperty("agreementAmount", "");
                jsonObject.addProperty("workOrderNumber", "");
                jsonObject.addProperty("workOrderId", "");
            }
            if (milestone.getStatus() != null) {
                jsonObject.addProperty("status", milestone.getStatus().getCode());
            } else {
                jsonObject.addProperty("status", "");
            }
            jsonObject.addProperty("id", (Number)milestone.getId());
        }
        return jsonObject;
    }
}

