/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.List;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.mb.service.MBHeaderService;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchLetterOfAcceptanceToCreateContractorBillJson
implements JsonSerializer<WorkOrderEstimate> {
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;
    @Autowired
    private MBHeaderService mBHeaderService;

    public JsonElement serialize(WorkOrderEstimate workOrderEstimate, Type type, JsonSerializationContext jsc) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        JsonObject jsonObject = new JsonObject();
        if (workOrderEstimate != null) {
            if (workOrderEstimate.getWorkOrder().getWorkOrderNumber() != null) {
                jsonObject.addProperty("workOrderNumber", workOrderEstimate.getWorkOrder().getWorkOrderNumber());
            } else {
                jsonObject.addProperty("workOrderNumber", "");
            }
            if (workOrderEstimate.getWorkOrder().getWorkOrderDate() != null) {
                jsonObject.addProperty("workOrderDate", formatter.format(workOrderEstimate.getWorkOrder().getWorkOrderDate()));
            } else {
                jsonObject.addProperty("workOrderDate", "");
            }
            if (workOrderEstimate.getWorkOrder().getContractor() != null) {
                jsonObject.addProperty("contractor", workOrderEstimate.getWorkOrder().getContractor().getName());
                jsonObject.addProperty("contractorcode", workOrderEstimate.getWorkOrder().getContractor().getCode());
            } else {
                jsonObject.addProperty("contractor", "");
                jsonObject.addProperty("contractorcode", "");
            }
            if (workOrderEstimate.getEstimate().getEstimateNumber() != null) {
                jsonObject.addProperty("estimateNumber", workOrderEstimate.getEstimate().getEstimateNumber());
                jsonObject.addProperty("nameOfWork", workOrderEstimate.getEstimate().getName());
                jsonObject.addProperty("workIdentificationNumber", workOrderEstimate.getEstimate().getProjectCode().getCode());
            } else {
                jsonObject.addProperty("estimateNumber", "");
            }
            jsonObject.addProperty("isMileStoneCreated", Boolean.valueOf(this.letterOfAcceptanceService.checkIfMileStonesCreated(workOrderEstimate.getWorkOrder())));
            jsonObject.addProperty("workOrderAmount", (Number)workOrderEstimate.getWorkOrder().getWorkOrderAmount());
            jsonObject.addProperty("id", (Number)workOrderEstimate.getWorkOrder().getId());
            if (workOrderEstimate.getWorkOrder().getWorkOrderEstimates() != null) {
                List mbHeaders = this.mBHeaderService.getApprovedMBsForContractorBillByWorkOrderEstimateId(workOrderEstimate.getId());
                if (!mbHeaders.isEmpty()) {
                    String mbRefNumbers = "";
                    BigDecimal mbAmount = BigDecimal.ZERO;
                    for (MBHeader header : mbHeaders) {
                        mbRefNumbers = mbRefNumbers + header.getMbRefNo() + ",";
                        mbAmount = mbAmount.add(header.getMbAmount());
                    }
                    jsonObject.addProperty("mbRefNumbers", !mbRefNumbers.equalsIgnoreCase("") ? mbRefNumbers.substring(0, mbRefNumbers.length() - 1) : "");
                    jsonObject.addProperty("mbAmount", (Number)mbAmount.setScale(2, 6));
                } else {
                    jsonObject.addProperty("mbRefNumbers", "NA");
                    jsonObject.addProperty("mbAmount", "NA");
                }
            }
            if (workOrderEstimate.getEstimate() != null) {
                jsonObject.addProperty("aeId", (Number)workOrderEstimate.getEstimate().getId());
            }
            jsonObject.addProperty("woeId", (Number)workOrderEstimate.getId());
        }
        return jsonObject;
    }
}

