/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchLetterOfAcceptanceToCancelJson
implements JsonSerializer<WorkOrder> {
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;

    public JsonElement serialize(WorkOrder workOrder, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (workOrder != null) {
            if (workOrder.getWorkOrderNumber() != null) {
                jsonObject.addProperty("workOrderNumber", workOrder.getWorkOrderNumber());
            } else {
                jsonObject.addProperty("workOrderNumber", "");
            }
            if (workOrder.getWorkOrderDate() != null) {
                jsonObject.addProperty("workOrderDate", workOrder.getWorkOrderDate().toString());
            } else {
                jsonObject.addProperty("workOrderDate", "");
            }
            if (workOrder.getContractor() != null) {
                jsonObject.addProperty("contractor", workOrder.getContractor().getName());
                jsonObject.addProperty("contractorcode", workOrder.getContractor().getCode());
            } else {
                jsonObject.addProperty("contractor", "");
                jsonObject.addProperty("contractorcode", "");
            }
            if (!workOrder.getWorkOrderEstimates().isEmpty()) {
                WorkOrderEstimate woe = (WorkOrderEstimate)workOrder.getWorkOrderEstimates().get(0);
                jsonObject.addProperty("estimateNumber", woe.getEstimate().getEstimateNumber());
                jsonObject.addProperty("nameOfWork", woe.getEstimate().getName());
                jsonObject.addProperty("workIdentificationNumber", woe.getEstimate().getProjectCode().getCode());
            }
            jsonObject.addProperty("isMileStoneCreated", Boolean.valueOf(this.letterOfAcceptanceService.checkIfMileStonesCreated(workOrder)));
            jsonObject.addProperty("workOrderAmount", (Number)workOrder.getWorkOrderAmount());
            jsonObject.addProperty("id", (Number)workOrder.getId());
        }
        return jsonObject;
    }
}

