/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import org.egov.works.milestone.entity.Milestone;
import org.springframework.stereotype.Component;

@Component
public class SearchCancelMilestoneJsonAdaptor
implements JsonSerializer<Milestone> {
    public JsonElement serialize(Milestone milestone, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        if (milestone != null) {
            if (milestone.getWorkOrderEstimate().getEstimate() != null) {
                jsonObject.addProperty("workIdentificationNumber", milestone.getWorkOrderEstimate().getEstimate().getProjectCode().getCode());
            } else {
                jsonObject.addProperty("workIdentificationNumber", "");
            }
            if (milestone.getWorkOrderEstimate().getWorkOrder() != null) {
                jsonObject.addProperty("agreementAmount", (Number)milestone.getWorkOrderEstimate().getWorkOrder().getWorkOrderAmount());
                jsonObject.addProperty("workOrderNumber", milestone.getWorkOrderEstimate().getWorkOrder().getWorkOrderNumber());
                jsonObject.addProperty("workOrderDate", sdf.format(milestone.getWorkOrderEstimate().getWorkOrder().getWorkOrderDate()));
                jsonObject.addProperty("workOrderId", (Number)milestone.getWorkOrderEstimate().getWorkOrder().getId());
                jsonObject.addProperty("contractor", milestone.getWorkOrderEstimate().getWorkOrder().getContractor().getCode() + " - " + milestone.getWorkOrderEstimate().getWorkOrder().getContractor().getName());
            } else {
                jsonObject.addProperty("agreementAmount", "");
                jsonObject.addProperty("workOrderNumber", "");
                jsonObject.addProperty("workOrderDate", "");
                jsonObject.addProperty("workOrderId", "");
                jsonObject.addProperty("contractor", "");
            }
            if (milestone.getTrackMilestone().size() > 0) {
                jsonObject.addProperty("trackMilestone", Boolean.valueOf(true));
            } else {
                jsonObject.addProperty("trackMilestone", Boolean.valueOf(false));
            }
            jsonObject.addProperty("id", (Number)milestone.getId());
        }
        return jsonObject;
    }
}

