/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.abstractestimate.entity.MeasurementSheet;
import org.egov.works.abstractestimate.service.ActivityService;
import org.egov.works.abstractestimate.service.MeasurementSheetService;
import org.egov.works.letterofacceptance.service.WorkOrderActivityService;
import org.egov.works.mb.service.MBHeaderService;
import org.egov.works.revisionestimate.entity.enums.RevisionType;
import org.egov.works.workorder.entity.WorkOrderActivity;
import org.egov.works.workorder.entity.WorkOrderMeasurementSheet;
import org.egov.works.workorder.service.WorkOrderMeasurementSheetService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchActivityJsonAdaptor
implements JsonSerializer<Activity> {
    @Autowired
    private WorkOrderActivityService workOrderActivityService;
    @Autowired
    private MBHeaderService mbHeaderService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private WorkOrderMeasurementSheetService workOrderMeasurementSheetService;
    @Autowired
    private MeasurementSheetService measurementSheetService;

    public JsonElement serialize(Activity activity, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        WorkOrderActivity workOrderActivity = this.workOrderActivityService.getWorkOrderActivityByActivity(activity.getId());
        if (activity.getSchedule() != null) {
            jsonObject.addProperty("description", activity.getSchedule().getDescription());
            jsonObject.addProperty("summary", activity.getSchedule().getSummary());
            jsonObject.addProperty("sorNonSorType", "SOR");
            jsonObject.addProperty("sorCode", activity.getSchedule().getCode());
            jsonObject.addProperty("categoryType", activity.getSchedule().getScheduleCategory().getCode());
        } else {
            if (activity.getNonSor() != null) {
                jsonObject.addProperty("description", activity.getNonSor().getDescription());
                jsonObject.addProperty("summary", activity.getNonSor().getDescription());
            } else {
                jsonObject.addProperty("description", "");
                jsonObject.addProperty("summary", "");
            }
            jsonObject.addProperty("sorNonSorType", "Non SOR");
            jsonObject.addProperty("sorCode", "");
            jsonObject.addProperty("categoryType", "");
        }
        if (activity.getUom() != null) {
            jsonObject.addProperty("uom", activity.getUom().getUom());
        } else {
            jsonObject.addProperty("uom", "");
        }
        Double quantity = activity.getQuantity();
        List cqActivities = this.activityService.findApprovedActivitiesByParentId(activity.getId());
        for (Activity act : cqActivities) {
            if (act.getRevisionType().equals((Object)RevisionType.ADDITIONAL_QUANTITY)) {
                quantity = quantity + act.getQuantity();
                continue;
            }
            quantity = quantity - act.getQuantity();
        }
        jsonObject.addProperty("approvedQuantity", (Number)quantity);
        if (workOrderActivity != null) {
            this.deriveWorkOrderActivityQuantity(workOrderActivity);
            jsonObject.addProperty("estimateQuantity", (Number)workOrderActivity.getApprovedQuantity());
            Double consumedQuantity = this.mbHeaderService.getPreviousCumulativeQuantity(Long.valueOf(-1L), workOrderActivity.getId());
            jsonObject.addProperty("consumedQuantity", consumedQuantity == null ? "0" : consumedQuantity.toString());
        } else {
            jsonObject.addProperty("estimateQuantity", (Number)0);
            jsonObject.addProperty("consumedQuantity", (Number)0);
        }
        if (activity.getRate() > 0.0) {
            jsonObject.addProperty("rate", (Number)activity.getRate());
        } else {
            jsonObject.addProperty("rate", "");
        }
        jsonObject.addProperty("estimateRate", (Number)activity.getEstimateRate());
        jsonObject.addProperty("id", (Number)activity.getId());
        if (!activity.getMeasurementSheetList().isEmpty()) {
            JsonArray jsonArray = new JsonArray();
            for (MeasurementSheet ms : activity.getMeasurementSheetList()) {
                JsonObject child = new JsonObject();
                this.deriveMeasurementSheetQuantity(ms);
                child.addProperty("parent", (Number)ms.getId());
                child.addProperty("slNo", (Number)ms.getSlNo());
                child.addProperty("remarks", ms.getRemarks());
                child.addProperty("no", (Number)ms.getNo());
                child.addProperty("length", (Number)ms.getLength());
                child.addProperty("width", (Number)ms.getWidth());
                child.addProperty("depthOrHeight", (Number)ms.getDepthOrHeight());
                child.addProperty("quantity", (Number)ms.getQuantity());
                child.addProperty("identifier", Character.valueOf(ms.getIdentifier()));
                jsonArray.add((JsonElement)child);
            }
            jsonObject.add("ms", (JsonElement)jsonArray);
        } else {
            jsonObject.add("ms", (JsonElement)new JsonArray());
        }
        return jsonObject;
    }

    private void deriveWorkOrderActivityQuantity(WorkOrderActivity workOrderActivity) {
        if (!workOrderActivity.getWorkOrderMeasurementSheets().isEmpty()) {
            for (WorkOrderMeasurementSheet woms : workOrderActivity.getWorkOrderMeasurementSheets()) {
                List rewomsList = this.workOrderMeasurementSheetService.findByMeasurementSheetParentId(woms.getMeasurementSheet().getId());
                Double no = woms.getNo() == null ? 0.0 : woms.getNo().doubleValue();
                Double length = woms.getLength() == null ? 0.0 : woms.getLength().doubleValue();
                Double width = woms.getWidth() == null ? 0.0 : woms.getWidth().doubleValue();
                Double depthOrHeight = woms.getDepthOrHeight() == null ? 0.0 : woms.getDepthOrHeight().doubleValue();
                Double quantity = woms.getQuantity() == null ? 0.0 : woms.getQuantity().doubleValue();
                for (WorkOrderMeasurementSheet rems : rewomsList) {
                    if (rems.getNo() != null) {
                        no = no + rems.getNo().doubleValue();
                    }
                    if (rems.getLength() != null) {
                        length = length + rems.getLength().doubleValue();
                    }
                    if (rems.getWidth() != null) {
                        width = width + rems.getWidth().doubleValue();
                    }
                    if (rems.getDepthOrHeight() != null) {
                        depthOrHeight = depthOrHeight + rems.getDepthOrHeight().doubleValue();
                    }
                    quantity = quantity + rems.getQuantity().doubleValue();
                }
                if (no != null && no != 0.0) {
                    woms.setNo(new BigDecimal(no));
                }
                if (length != null && length != 0.0) {
                    woms.setLength(new BigDecimal(length));
                }
                if (width != null && width != 0.0) {
                    woms.setWidth(new BigDecimal(width));
                }
                if (depthOrHeight != null && depthOrHeight != 0.0) {
                    woms.setDepthOrHeight(new BigDecimal(depthOrHeight));
                }
                woms.setQuantity(new BigDecimal(quantity.toString()));
            }
        }
        Double qty = 0.0;
        for (WorkOrderMeasurementSheet woms : workOrderActivity.getWorkOrderMeasurementSheets()) {
            if (woms.getMeasurementSheet().getIdentifier() == 'A') {
                qty = qty + woms.getQuantity().doubleValue();
                continue;
            }
            qty = qty - woms.getQuantity().doubleValue();
        }
        if (!workOrderActivity.getWorkOrderMeasurementSheets().isEmpty()) {
            workOrderActivity.setApprovedQuantity(qty.doubleValue());
        }
    }

    private void deriveMeasurementSheetQuantity(MeasurementSheet measurementSheet) {
        List remsList = new ArrayList();
        remsList = this.measurementSheetService.findByParentId(measurementSheet.getId());
        Double no = measurementSheet.getNo() == null ? 0.0 : measurementSheet.getNo().doubleValue();
        Double length = measurementSheet.getLength() == null ? 0.0 : measurementSheet.getLength().doubleValue();
        Double width = measurementSheet.getWidth() == null ? 0.0 : measurementSheet.getWidth().doubleValue();
        Double depthOrHeight = measurementSheet.getDepthOrHeight() == null ? 0.0 : measurementSheet.getDepthOrHeight().doubleValue();
        Double quantity = measurementSheet.getQuantity() == null ? 0.0 : measurementSheet.getQuantity().doubleValue();
        for (MeasurementSheet rems : remsList) {
            if (rems.getNo() != null) {
                no = no + rems.getNo().doubleValue();
            }
            if (rems.getLength() != null) {
                length = length + rems.getLength().doubleValue();
            }
            if (rems.getWidth() != null) {
                width = width + rems.getWidth().doubleValue();
            }
            if (rems.getDepthOrHeight() != null) {
                depthOrHeight = depthOrHeight + rems.getDepthOrHeight().doubleValue();
            }
            quantity = quantity + rems.getQuantity().doubleValue();
        }
        if (no != null && no != 0.0) {
            measurementSheet.setNo(new BigDecimal(no));
        }
        if (length != null && length != 0.0) {
            measurementSheet.setLength(new BigDecimal(length));
        }
        if (width != null && width != 0.0) {
            measurementSheet.setWidth(new BigDecimal(width));
        }
        if (depthOrHeight != null && depthOrHeight != 0.0) {
            measurementSheet.setDepthOrHeight(new BigDecimal(depthOrHeight));
        }
        measurementSheet.setQuantity(new BigDecimal(quantity.toString()));
    }
}

