/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.service.MeasurementSheetService;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.mb.service.MBHeaderService;
import org.egov.works.models.tender.OfflineStatus;
import org.egov.works.offlinestatus.service.OfflineStatusService;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MeasurementBookJsonAdaptor
implements JsonSerializer<WorkOrderEstimate> {
    @Autowired
    private OfflineStatusService offlineStatusService;
    @Autowired
    private MBHeaderService mbHeaderService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private MeasurementSheetService measurementSheetService;
    @Autowired
    private WorksUtils worksUtils;

    public JsonElement serialize(WorkOrderEstimate workOrderEstimate, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        DecimalFormat df = new DecimalFormat("0.00");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        jsonObject.addProperty("showHistory", Boolean.valueOf(false));
        if (workOrderEstimate != null) {
            jsonObject.addProperty("workOrderEstimateId", (Number)workOrderEstimate.getId());
            if (workOrderEstimate.getEstimate() != null) {
                AbstractEstimate estimate = workOrderEstimate.getEstimate();
                jsonObject.addProperty("estimateNumber", estimate.getEstimateNumber());
                jsonObject.addProperty("estimateId", (Number)estimate.getId());
                jsonObject.addProperty("projectCode", estimate.getProjectCode().getCode());
                jsonObject.addProperty("nameOfWork", estimate.getName());
            } else {
                jsonObject.addProperty("estimateNumber", "");
                jsonObject.addProperty("estimateId", "");
                jsonObject.addProperty("projectCode", "");
                jsonObject.addProperty("nameOfWork", "");
            }
            if (workOrderEstimate.getWorkOrder() != null) {
                WorkOrder workOrder = workOrderEstimate.getWorkOrder();
                jsonObject.addProperty("workOrderNumber", workOrder.getWorkOrderNumber());
                jsonObject.addProperty("workOrderId", (Number)workOrder.getId());
                jsonObject.addProperty("workOrderAmount", df.format(workOrder.getWorkOrderAmount()));
                jsonObject.addProperty("contractorName", workOrder.getContractor().getName());
                jsonObject.addProperty("workOrderAssignedTo", workOrder.getEngineerIncharge().getName());
                jsonObject.addProperty("tenderFinalisedPercentage", (Number)workOrder.getTenderFinalizedPercentage());
                OfflineStatus offlineStatus = this.offlineStatusService.getOfflineStatusByObjectIdAndObjectTypeAndStatus(workOrder.getId(), "WorkOrder", WorkOrder.OfflineStatuses.WORK_COMMENCED.toString().toUpperCase());
                if (offlineStatus != null) {
                    jsonObject.addProperty("workCommencedDate", sdf.format(offlineStatus.getStatusDate()));
                } else {
                    jsonObject.addProperty("workCommencedDate", "");
                }
                Double totalMBAmountOfMBs = this.mbHeaderService.getTotalMBAmountOfMBs(null, workOrderEstimate.getId(), MBHeader.MeasurementBookStatus.CANCELLED.toString());
                if (totalMBAmountOfMBs != null) {
                    jsonObject.addProperty("totalMBAmountOfMBs", (Number)totalMBAmountOfMBs);
                } else {
                    jsonObject.addProperty("totalMBAmountOfMBs", "");
                }
            } else {
                jsonObject.addProperty("workOrderNumber", "");
                jsonObject.addProperty("workOrderId", "");
                jsonObject.addProperty("workOrderAmount", "");
                jsonObject.addProperty("contractorName", "");
                jsonObject.addProperty("workOrderAssignedTo", "");
                jsonObject.addProperty("tenderFinalisedPercentage", "");
                jsonObject.addProperty("workCommencedDate", "");
                jsonObject.addProperty("totalMBAmountOfMBs", "");
            }
            List values = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "MB_QUANTITY_TOLERANCE_LEVEL");
            AppConfigValues value = (AppConfigValues)values.get(0);
            jsonObject.addProperty("quantityTolerance", value.getValue());
            List previousMBHeaders = this.mbHeaderService.getPreviousMBHeaders(Long.valueOf(-1L), workOrderEstimate.getId());
            if (!previousMBHeaders.isEmpty()) {
                jsonObject.addProperty("previousMBDate", sdf.format(((MBHeader)previousMBHeaders.get(previousMBHeaders.size() - 1)).getMbDate()));
            } else {
                jsonObject.addProperty("previousMBDate", "");
            }
            jsonObject.addProperty("isMeasurementsExist", this.measurementSheetService.existsByEstimate(workOrderEstimate.getEstimate().getId()));
            jsonObject.addProperty("workOrderEstimateId", (Number)workOrderEstimate.getId());
            if (workOrderEstimate.getEstimate().getLineEstimateDetails() != null && workOrderEstimate.getEstimate().getLineEstimateDetails().getLineEstimate().isSpillOverFlag()) {
                SimpleDateFormat fmt = new SimpleDateFormat("dd-MM-yyyy");
                jsonObject.addProperty("cutOffDate", this.worksUtils.getCutOffDate() != null ? sdf.format(this.worksUtils.getCutOffDate()) : "");
                jsonObject.addProperty("cutOffDateDisplay", this.worksUtils.getCutOffDate() != null ? fmt.format(this.worksUtils.getCutOffDate()) : "");
            }
            jsonObject.addProperty("spillOverFlag", Boolean.valueOf(workOrderEstimate.getEstimate().getLineEstimateDetails().getLineEstimate().isSpillOverFlag()));
        }
        return jsonObject;
    }
}

