/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AbstractEstimateJsonAdaptor
implements JsonSerializer<AbstractEstimate> {
    final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    @Autowired
    private WorksUtils worksUtils;

    public JsonElement serialize(AbstractEstimate abstractEstimate, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (abstractEstimate != null) {
            if (abstractEstimate.getId() != null) {
                jsonObject.addProperty("id", (Number)abstractEstimate.getId());
            } else {
                jsonObject.addProperty("id", "");
            }
            if (abstractEstimate.getLineEstimateDetails() != null) {
                jsonObject.addProperty("leId", (Number)abstractEstimate.getLineEstimateDetails().getLineEstimate().getId());
            } else {
                jsonObject.addProperty("leId", "");
            }
            if (abstractEstimate.getEstimateNumber() != null) {
                jsonObject.addProperty("estimateNumber", abstractEstimate.getEstimateNumber());
            } else {
                jsonObject.addProperty("estimateNumber", "");
            }
            if (abstractEstimate.getLineEstimateDetails() != null && abstractEstimate.getLineEstimateDetails().getLineEstimate().getLineEstimateNumber() != null) {
                jsonObject.addProperty("lineestimateNumber", abstractEstimate.getLineEstimateDetails().getLineEstimate().getLineEstimateNumber());
            } else {
                jsonObject.addProperty("lineestimateNumber", "");
            }
            if (abstractEstimate.getEstimateNumber() != null && abstractEstimate.getEstimateDate() != null) {
                jsonObject.addProperty("estimateNumberAndDate", abstractEstimate.getEstimateNumber() + " - " + this.sdf.format(abstractEstimate.getEstimateDate()));
            } else {
                jsonObject.addProperty("estimateNumberAndDate", "");
            }
            if (abstractEstimate.getProjectCode() != null) {
                jsonObject.addProperty("workIdentificationNumber", abstractEstimate.getProjectCode().getCode());
            } else {
                jsonObject.addProperty("workIdentificationNumber", "");
            }
            if (abstractEstimate.getEstimateValue() != null) {
                jsonObject.addProperty("estimateAmount", abstractEstimate.getEstimateValue().setScale(2, 6).toString());
            } else {
                jsonObject.addProperty("estimateAmount", "");
            }
            if (abstractEstimate.getExecutingDepartment() != null) {
                jsonObject.addProperty("departmentName", abstractEstimate.getExecutingDepartment().getName());
            } else {
                jsonObject.addProperty("departmentName", "");
            }
            if (abstractEstimate.getWard() != null) {
                jsonObject.addProperty("ward", (Number)abstractEstimate.getWard().getBoundaryNum());
            } else {
                jsonObject.addProperty("ward", "");
            }
            if (abstractEstimate.getEgwStatus() != null) {
                jsonObject.addProperty("status", abstractEstimate.getEgwStatus().getDescription());
            } else {
                jsonObject.addProperty("status", "");
            }
            if (abstractEstimate.getState() != null) {
                if (abstractEstimate.getEgwStatus() != null && (abstractEstimate.getEgwStatus().getCode().equalsIgnoreCase("APPROVED") || abstractEstimate.getEgwStatus().getCode().equalsIgnoreCase("CANCELLED"))) {
                    jsonObject.addProperty("currentowner", "NA");
                } else {
                    jsonObject.addProperty("currentowner", this.worksUtils.getApproverName(abstractEstimate.getState().getOwnerPosition().getId()));
                }
            } else {
                jsonObject.addProperty("currentowner", "NA");
            }
            if (abstractEstimate.getName() != null) {
                jsonObject.addProperty("nameofwork", abstractEstimate.getName());
            } else {
                jsonObject.addProperty("nameofwork", "");
            }
        }
        return jsonObject;
    }
}

