/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.List;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.offlinestatus.service.OfflineStatusService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AbstractEstimateForOfflineStatusJsonAdaptor
implements JsonSerializer<AbstractEstimate> {
    @Autowired
    private OfflineStatusService offlineStatusService;

    public JsonElement serialize(AbstractEstimate abstractEstimate, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        if (abstractEstimate != null) {
            if (abstractEstimate.getEstimateNumber() != null) {
                jsonObject.addProperty("estimateNumber", abstractEstimate.getEstimateNumber());
            } else {
                jsonObject.addProperty("estimateNumber", "");
            }
            if (abstractEstimate.getEstimateDate() != null) {
                jsonObject.addProperty("estimateDate", formatter.format(abstractEstimate.getEstimateDate()));
            } else {
                jsonObject.addProperty("estimateDate", "");
            }
            if (abstractEstimate.getName() != null) {
                jsonObject.addProperty("nameOfWork", abstractEstimate.getName());
            } else {
                jsonObject.addProperty("nameOfWork", "");
            }
            if (abstractEstimate.getEstimateValue() != null) {
                jsonObject.addProperty("estimateAmount", (Number)abstractEstimate.getEstimateValue());
            } else {
                jsonObject.addProperty("estimateAmount", "");
            }
            if (abstractEstimate.getCreatedBy() != null) {
                jsonObject.addProperty("createdBy", abstractEstimate.getCreatedBy().getName());
            } else {
                jsonObject.addProperty("createdBy", "");
            }
            List offlinestatusses = this.offlineStatusService.getOfflineStatusByObjectIdAndType(abstractEstimate.getId(), "AbstractEstimate");
            jsonObject.addProperty("abstractEstimateId", (Number)abstractEstimate.getId());
            jsonObject.addProperty("statusSize", (Number)offlinestatusses.size());
        }
        return jsonObject;
    }
}

